/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.text.Collator;
import java.util.Locale;
import javax.swing.SwingUtilities;

public class CNaturalSort {
    public static boolean DEBUG = CMainFrame.DEBUG;
    public static boolean DEBUG_DIGITS;
    private static Object[][] m_aTable;
    private static char[] m_achFraction_Table;
    private static double[] m_adFraction_Table;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bDebugWebClient = false;
                if (bDebugWebClient) {
                    boolean bDebugCompareRight = true;
                    if (bDebugCompareRight) {
                        String[] asTest = new String[]{"\u00ae", "1"};
                        for (int nIdx = 0; nIdx < asTest.length; nIdx += 2) {
                            int nVal = CNaturalSort.Sort(true, asTest[nIdx], asTest[nIdx + 1], true);
                            System.out.println(asTest[nIdx] + " vs. " + asTest[nIdx + 1] + " = " + nVal);
                        }
                    } else {
                        String[] asTest = new String[]{Character.toString('\u00bc'), Character.toString('1'), Character.toString('\u00bd'), Character.toString('\u00be'), Character.toString('0'), Character.toString('\u215a')};
                        for (int nIdx = 0; nIdx < asTest.length; ++nIdx) {
                            double[] rdVals = new double[1];
                            boolean bIsFraction = CNaturalSort.nat_isfraction(asTest[nIdx].charAt(0), rdVals);
                            System.out.println(asTest[nIdx] + " IsFraction: " + bIsFraction + " Value: " + Double.toString(rdVals[0]));
                        }
                    }
                } else {
                    String s1 = "Folder 2,100";
                    String s2 = "Folder 10";
                    int nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "Folder 20";
                    s2 = "Folder 2,100";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "Folder 2";
                    s2 = "Folder 2,100";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "20 Books";
                    s2 = "1,000 Books";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "1,000 Books";
                    s2 = "20 Books";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "ABC - Copy (2)";
                    s2 = "ABC Copy";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "ABC Copy";
                    s2 = "ABC - Copy (2)";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "ABC - Copy (2)";
                    s2 = "ABC";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "1000 Books (2)";
                    s2 = "1,000 Books";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                    s1 = "1,000 Books";
                    s2 = "1000 Books (2)";
                    nOrder = CNaturalSort.Sort(true, s1, s2, true);
                    System.out.println(s1 + " vs. " + s2 + " = " + nOrder);
                }
            }
        });
    }

    public static int Sort(boolean bIsAscending, String sText1, String sText2, boolean bIgnoreCase) {
        int nRet = 0;
        if (sText1 != null && sText2 != null) {
            try {
                nRet = CNaturalSort.strnatcmp0(sText1, sText2, bIgnoreCase);
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                nRet = CNaturalSort.Compare(sText1, sText2, bIgnoreCase);
            }
        }
        if (!bIsAscending) {
            nRet *= -1;
        }
        return nRet;
    }

    private static char CharNext(int[] anIndices, String sStr) {
        char chNext = '\u0000';
        if (anIndices != null && anIndices.length == 2) {
            anIndices[0] = anIndices[1];
            if (sStr != null && anIndices[1] < sStr.length()) {
                chNext = sStr.charAt(anIndices[1]);
                anIndices[1] = anIndices[1] + 1;
            }
        }
        return chNext;
    }

    private static boolean nat_isdigit(char chTest) {
        boolean bIsDigit = false;
        if (chTest >= '0' && chTest <= '9') {
            bIsDigit = true;
        }
        return bIsDigit;
    }

    private static boolean nat_isfraction(char chChar, double[] rdValue) {
        boolean bIsFraction = false;
        if (chChar > '\u007f') {
            int nIndex = 0;
            char nCharValue = m_achFraction_Table[nIndex];
            nIndex = 0;
            while (nCharValue != '\u0000') {
                nCharValue = m_achFraction_Table[nIndex];
                if (nCharValue == chChar) {
                    rdValue[0] = 48.0 + m_adFraction_Table[nIndex];
                    bIsFraction = true;
                    break;
                }
                ++nIndex;
            }
        }
        return bIsFraction;
    }

    private static int skip_leading_zeros(String sTest, int nIndex) {
        int nStrMax = sTest.length() - 1;
        while (nIndex < nStrMax && sTest.charAt(nIndex) == '0' && CNaturalSort.nat_isdigit(sTest.charAt(nIndex + 1))) {
            ++nIndex;
        }
        return nIndex;
    }

    private static int compare_right(String a, int nIndexA, String b, int nIndexB) {
        int nRet = 0;
        int bias = 0;
        while (true) {
            char chA = '\u0000';
            char chB = '\u0000';
            if (nIndexA < a.length()) {
                chA = a.charAt(nIndexA);
            }
            if (nIndexB < b.length()) {
                chB = b.charAt(nIndexB);
            }
            if (!CNaturalSort.nat_isdigit(chA) && !CNaturalSort.nat_isdigit(chB)) {
                nRet = bias;
                break;
            }
            if (!CNaturalSort.nat_isdigit(chA)) {
                nRet = -1;
                break;
            }
            if (!CNaturalSort.nat_isdigit(chB)) {
                nRet = 1;
                break;
            }
            if (chA < chB) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (chA > chB) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (chA == '\u0000' && chB == '\u0000') {
                nRet = bias;
                break;
            }
            ++nIndexA;
            ++nIndexB;
        }
        return nRet;
    }

    public static String ASCIIize(String pszStr) {
        String sRet = pszStr;
        if (pszStr != null) {
            char chChar;
            StringBuilder sStr = new StringBuilder(pszStr);
            block0: for (int nNext = 0; nNext < sStr.length() && (chChar = sStr.charAt(nNext)) != '\u0000'; ++nNext) {
                if (chChar <= "~".charAt(0)) continue;
                int nFirst = 0;
                int nLast = m_aTable.length - 1;
                while (nFirst <= nLast) {
                    int nMid = (nFirst + nLast) / 2;
                    char chTableChar = (char)((Integer)m_aTable[nMid][0]).intValue();
                    if (chChar == chTableChar) {
                        sStr.deleteCharAt(nNext);
                        sStr.insert(nNext, (String)m_aTable[nMid][1]);
                        nNext += ((String)m_aTable[nMid][1]).length();
                        continue block0;
                    }
                    if (chChar > chTableChar) {
                        nFirst = nMid + 1;
                        continue;
                    }
                    if (chChar >= chTableChar) continue;
                    nLast = nMid - 1;
                }
            }
            sRet = sStr.toString();
        }
        return sRet;
    }

    static boolean IsAlphaNum(char chChar) {
        return chChar >= 'A' && chChar <= 'Z' || chChar >= 'a' && chChar <= 'z' || chChar >= '0' && chChar <= '9';
    }

    static boolean IsSymbol(char chChar) {
        return chChar >= '[' && chChar <= '`' || chChar >= '{' && chChar <= '\u00bf';
    }

    private static boolean IsPunctuation(char chChar) {
        return chChar != '\u0000' && chChar != '.' && !CNaturalSort.IsSymbol(chChar) && !CNaturalSort.IsAlphaNum(chChar) && chChar <= '~';
    }

    static boolean SymbolCheck(char chPotentialSymbol, char chPotentialAlphaNum) {
        return CNaturalSort.IsSymbol(chPotentialSymbol) && CNaturalSort.IsAlphaNum(chPotentialAlphaNum);
    }

    private static int strnatcmp0(String a, String b, boolean bIgnoreCase) {
        String sStrA = a;
        String sStrB = b;
        boolean pAStart = false;
        boolean pA = true;
        boolean pBStart = false;
        boolean pB = true;
        int[] anIndicesA = new int[]{0, 0};
        int[] anIndicesB = new int[]{0, 0};
        sStrA = CNaturalSort.ASCIIize(a);
        sStrB = CNaturalSort.ASCIIize(b);
        while (true) {
            char ca = CNaturalSort.CharNext(anIndicesA, sStrA);
            char cb = CNaturalSort.CharNext(anIndicesB, sStrB);
            while (CNaturalSort.IsPunctuation(ca) && anIndicesA[0] < sStrA.length() - 1) {
                ca = CNaturalSort.CharNext(anIndicesA, sStrA);
            }
            while (CNaturalSort.IsPunctuation(cb) && anIndicesB[0] < sStrB.length() - 1) {
                cb = CNaturalSort.CharNext(anIndicesB, sStrB);
            }
            anIndicesA[0] = CNaturalSort.skip_leading_zeros(sStrA, anIndicesA[0]);
            anIndicesA[1] = anIndicesA[0];
            ca = CNaturalSort.CharNext(anIndicesA, sStrA);
            anIndicesB[0] = CNaturalSort.skip_leading_zeros(sStrB, anIndicesB[0]);
            anIndicesB[1] = anIndicesB[0];
            cb = CNaturalSort.CharNext(anIndicesB, sStrB);
            boolean bIsNumberA = CNaturalSort.nat_isdigit(ca);
            boolean bIsNumberB = CNaturalSort.nat_isdigit(cb);
            if (bIsNumberA && bIsNumberB) {
                int nResult = CNaturalSort.compare_right(sStrA, anIndicesA[0], sStrB, anIndicesB[0]);
                if (nResult != 0) {
                    return nResult;
                }
            } else {
                double[] adValA = new double[1];
                double[] adValB = new double[1];
                bIsNumberA = CNaturalSort.nat_isfraction(ca, adValA);
                bIsNumberB = CNaturalSort.nat_isfraction(cb, adValB);
                double dValueA = adValA[0];
                double dValueB = adValB[0];
                if (bIsNumberA && bIsNumberB) {
                    if (dValueA < dValueB) {
                        return -1;
                    }
                    if (dValueA > dValueB) {
                        return 1;
                    }
                } else if (bIsNumberA && cb != '\u0000') {
                    if (dValueA < (double)cb) {
                        return -1;
                    }
                    if (dValueA > (double)cb) {
                        return 1;
                    }
                } else if (bIsNumberB && ca != '\u0000') {
                    if (dValueB < (double)ca) {
                        return 1;
                    }
                    if (dValueB > (double)ca) {
                        return -1;
                    }
                }
            }
            if (anIndicesA[0] + 1 >= sStrA.length() && anIndicesB[0] + 1 >= sStrB.length()) {
                return CNaturalSort.Compare(a, b, bIgnoreCase);
            }
            if (CNaturalSort.SymbolCheck(ca, cb)) {
                return -1;
            }
            if (CNaturalSort.SymbolCheck(cb, ca)) {
                return 1;
            }
            if (bIgnoreCase) {
                ca = Character.toUpperCase(ca);
                cb = Character.toUpperCase(cb);
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            anIndicesA[0] = anIndicesA[0] + 1;
            anIndicesB[0] = anIndicesB[0] + 1;
        }
    }

    private static int Compare(String sText1, String sText2, boolean bCompareNoCase) {
        int nRet = 0;
        if (sText1 != null && sText2 != null) {
            if (bCompareNoCase) {
                sText1 = sText1.toLowerCase();
                sText2 = sText2.toLowerCase();
            }
            String sLanguageCode = CNaturalSort.GetLanguageCode();
            String sCountryCode = CNaturalSort.GetCountryCode();
            Locale rUserLocale = new Locale(sLanguageCode, sCountryCode);
            Collator colr = Collator.getInstance(rUserLocale);
            nRet = colr.compare(sText1, sText2);
        }
        return nRet;
    }

    private static String GetLanguageCode() {
        String sLanguageCode = Locale.ENGLISH.getLanguage();
        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null) {
            sLanguageCode = CMainFrame.GET_APP().GetClientInfo().GetLanguageCode();
        }
        return sLanguageCode;
    }

    private static String GetCountryCode() {
        String sCountryCode = Locale.US.getCountry();
        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null) {
            sCountryCode = CMainFrame.GET_APP().GetClientInfo().GetCountryCode();
        }
        return sCountryCode;
    }

    /*
     * Opcode count of 16161 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DIGITS = false;
        m_aTable = new Object[][]{{170, "A"}, {178, "2"}, {179, "3"}, {185, "1"}, {186, "O"}, {192, "A"}, {193, "A"}, {194, "A"}, {195, "A"}, {196, "A"}, {197, "A"}, {198, "AE"}, {199, "C"}, {200, "E"}, {201, "E"}, {202, "E"}, {203, "E"}, {204, "I"}, {205, "I"}, {206, "I"}, {207, "I"}, {208, "D"}, {209, "N"}, {210, "O"}, {211, "O"}, {212, "O"}, {213, "O"}, {214, "O"}, {216, "O"}, {217, "U"}, {218, "U"}, {219, "U"}, {220, "U"}, {221, "Y"}, {223, "ss"}, {224, "A"}, {225, "a"}, {226, "a"}, {227, "a"}, {228, "a"}, {229, "a"}, {230, "ae"}, {231, "c"}, {232, "e"}, {233, "e"}, {234, "e"}, {235, "e"}, {236, "i"}, {237, "i"}, {238, "i"}, {239, "i"}, {240, "d"}, {241, "n"}, {242, "o"}, {243, "o"}, {244, "o"}, {245, "o"}, {246, "o"}, {248, "o"}, {249, "u"}, {250, "u"}, {251, "u"}, {252, "u"}, {253, "y"}, {255, "y"}, {256, "A"}, {257, "a"}, {258, "A"}, {259, "a"}, {260, "A"}, {261, "a"}, {262, "C"}, {263, "c"}, {264, "C"}, {265, "c"}, {266, "C"}, {267, "c"}, {268, "C"}, {269, "c"}, {270, "D"}, {271, "d"}, {272, "D"}, {273, "d"}, {274, "E"}, {275, "e"}, {276, "E"}, {277, "e"}, {278, "E"}, {279, "e"}, {280, "E"}, {281, "e"}, {282, "E"}, {283, "e"}, {284, "G"}, {285, "g"}, {286, "G"}, {287, "g"}, {288, "G"}, {289, "g"}, {290, "G"}, {291, "g"}, {292, "H"}, {293, "h"}, {294, "H"}, {295, "h"}, {296, "I"}, {297, "i"}, {298, "I"}, {299, "i"}, {300, "I"}, {301, "i"}, {302, "I"}, {303, "i"}, {304, "I"}, {305, "i"}, {306, "IJ"}, {307, "ij"}, {308, "j"}, {309, "j"}, {310, "K"}, {311, "k"}, {312, "K"}, {313, "L"}, {314, "l"}, {315, "L"}, {316, "l"}, {317, "L"}, {318, "L"}, {319, "L"}, {320, "l"}, {321, "L"}, {322, "l"}, {323, "N"}, {324, "n"}, {325, "N"}, {326, "n"}, {327, "N"}, {328, "n"}, {329, "n"}, {330, "N"}, {331, "n"}, {332, "O"}, {333, "o"}, {334, "O"}, {335, "o"}, {336, "O"}, {337, "o"}, {338, "OE"}, {339, "oe"}, {340, "R"}, {341, "r"}, {342, "R"}, {343, "r"}, {344, "R"}, {345, "r"}, {346, "S"}, {347, "s"}, {348, "S"}, {349, "s"}, {350, "S"}, {351, "s"}, {352, "S"}, {353, "s"}, {354, "T"}, {355, "t"}, {356, "T"}, {357, "t"}, {358, "T"}, {359, "t"}, {360, "T"}, {361, "U"}, {362, "u"}, {363, "U"}, {364, "u"}, {365, "U"}, {366, "u"}, {367, "U"}, {368, "u"}, {369, "U"}, {370, "u"}, {371, "U"}, {372, "W"}, {373, "w"}, {374, "Y"}, {375, "y"}, {376, "Y"}, {377, "Z"}, {378, "z"}, {379, "Z"}, {380, "z"}, {381, "Z"}, {382, "z"}, {383, "T"}, {384, "b"}, {385, "B"}, {386, "b"}, {387, "B"}, {388, "b"}, {389, "B"}, {390, "C"}, {391, "C"}, {392, "C"}, {393, "D"}, {394, "D"}, {395, "a"}, {396, "D"}, {397, "D"}, {398, "E"}, {399, "E"}, {400, "E"}, {401, "F"}, {402, "F"}, {403, "G"}, {404, "H"}, {405, "HZ"}, {406, "I"}, {407, "I"}, {408, "K"}, {409, "K"}, {410, "L"}, {411, "L"}, {412, "M"}, {413, "N"}, {414, "n"}, {415, "O"}, {416, "O"}, {417, "O"}, {418, "P"}, {419, "p"}, {420, "P"}, {421, "Q"}, {422, "R"}, {423, "S"}, {424, "s"}, {425, "S"}, {426, "S"}, {427, "T"}, {428, "T"}, {429, "T"}, {430, "T"}, {431, "U"}, {432, "u"}, {433, "U"}, {434, "V"}, {435, "Y"}, {436, "y"}, {437, "Z"}, {438, "z"}, {439, "Z"}, {440, "Z"}, {441, "z"}, {442, "Z"}, {443, "2"}, {444, "5"}, {445, "5"}, {447, "W"}, {451, "!"}, {452, "DZ"}, {453, "Dz"}, {454, "dz"}, {455, "LJ"}, {456, "Lj"}, {457, "lj"}, {458, "NJ"}, {459, "Nj"}, {460, "nj"}, {461, "A"}, {462, "a"}, {463, "I"}, {464, "i"}, {465, "O"}, {466, "o"}, {467, "U"}, {468, "u"}, {469, "U"}, {470, "u"}, {471, "U"}, {472, "u"}, {473, "U"}, {474, "u"}, {475, "U"}, {476, "u"}, {477, "E"}, {478, "A"}, {479, "a"}, {480, "A"}, {481, "a"}, {482, "AE"}, {483, "ae"}, {484, "G"}, {485, "g"}, {486, "G"}, {487, "g"}, {488, "K"}, {489, "k"}, {490, "O"}, {491, "o"}, {492, "O"}, {493, "z"}, {494, "Z"}, {495, "z"}, {496, "J"}, {497, "DZ"}, {498, "Dz"}, {499, "dz"}, {500, "G"}, {501, "g"}, {502, "I"}, {503, "V"}, {504, "N"}, {505, "n"}, {506, "A"}, {507, "a"}, {508, "AE"}, {509, "ae"}, {510, "O"}, {511, "o"}, {512, "A"}, {513, "a"}, {514, "A"}, {515, "a"}, {516, "E"}, {517, "e"}, {518, "E"}, {519, "e"}, {520, "I"}, {521, "i"}, {522, "I"}, {523, "i"}, {524, "O"}, {525, "o"}, {526, "O"}, {527, "o"}, {528, "R"}, {529, "r"}, {530, "R"}, {531, "r"}, {532, "U"}, {533, "u"}, {534, "U"}, {535, "u"}, {536, "S"}, {537, "s"}, {538, "T"}, {539, "t"}, {540, "E"}, {541, "e"}, {542, "H"}, {543, "h"}, {544, "N"}, {545, "D"}, {546, "O"}, {547, "o"}, {548, "Z"}, {549, "z"}, {550, "A"}, {551, "a"}, {552, "E"}, {553, "e"}, {554, "O"}, {555, "o"}, {556, "O"}, {557, "o"}, {558, "O"}, {559, "o"}, {560, "O"}, {561, "o"}, {562, "Y"}, {563, "y"}, {564, "L"}, {565, "n"}, {566, "t"}, {567, "J"}, {568, "db"}, {569, "qp"}, {570, "A"}, {571, "C"}, {572, "c"}, {573, "L"}, {574, "T"}, {575, "s"}, {576, "z"}, {577, "Z"}, {578, "z"}, {579, "B"}, {580, "U"}, {581, "V"}, {582, "E"}, {583, "e"}, {584, "J"}, {585, "j"}, {586, "Q"}, {587, "q"}, {588, "R"}, {589, "r"}, {590, "Y"}, {591, "y"}, {592, "a"}, {593, "a"}, {594, "a"}, {595, "b"}, {596, "c"}, {597, "c"}, {598, "d"}, {599, "d"}, {600, "e"}, {601, "e"}, {602, "e"}, {603, "e"}, {604, "e"}, {605, "e"}, {606, "e"}, {607, "f"}, {608, "G"}, {609, "g"}, {610, "g"}, {611, "G"}, {612, "g"}, {613, "h"}, {614, "H"}, {615, "h"}, {616, "i"}, {617, "i"}, {618, "i"}, {619, "i"}, {620, "l"}, {621, "L"}, {622, "L"}, {623, "M"}, {624, "M"}, {625, "M"}, {626, "N"}, {627, "N"}, {628, "N"}, {629, "O"}, {630, "OE"}, {631, "oe"}, {632, "P"}, {633, "r"}, {634, "R"}, {635, "r"}, {636, "R"}, {637, "R"}, {638, "R"}, {639, "R"}, {640, "R"}, {641, "R"}, {642, "S"}, {643, "S"}, {644, "S"}, {645, "S"}, {646, "S"}, {647, "S"}, {648, "T"}, {649, "U"}, {650, "U"}, {651, "V"}, {652, "v"}, {653, "w"}, {654, "y"}, {655, "z"}, {656, "Z"}, {657, "Z"}, {658, "Z"}, {659, "Z"}, {660, "Z"}, {661, "Z"}, {662, "Z"}, {663, "C"}, {666, "E"}, {667, "G"}, {668, "H"}, {669, "J"}, {670, "K"}, {671, "L"}, {672, "Q"}, {675, "DZ"}, {676, "Dz"}, {677, "dz"}, {678, "TS"}, {679, "Ts"}, {680, "ts"}, {681, "FN"}, {682, "ls"}, {683, "lz"}, {686, "H"}, {687, "h"}, {688, "H"}, {689, "h"}, {690, "j"}, {691, "r"}, {692, "r"}, {693, "r"}, {694, "r"}, {695, "w"}, {696, "y"}, {736, "g"}, {737, "l"}, {738, "s"}, {739, "x"}, {7424, "A"}, {7425, "AE"}, {7426, "ae"}, {7427, "B"}, {7428, "C"}, {7429, "D"}, {7430, "d"}, {7431, "E"}, {7432, "e"}, {7433, "K"}, {7434, "J"}, {7435, "K"}, {7436, "L"}, {7437, "M"}, {7438, "N"}, {7439, "O"}, {7440, "C"}, {7441, "O"}, {7442, "C"}, {7443, "O"}, {7444, "OE"}, {7445, "O"}, {7446, "O"}, {7447, "O"}, {7448, "P"}, {7449, "R"}, {7450, "R"}, {7451, "T"}, {7452, "U"}, {7453, "N"}, {7454, "N"}, {7455, "M"}, {7456, "V"}, {7457, "W"}, {7458, "Z"}, {7459, "Z"}, {7460, "Z"}, {7461, "A"}, {7468, "A"}, {7469, "AE"}, {7470, "B"}, {7471, "b"}, {7472, "D"}, {7473, "E"}, {7474, "E"}, {7475, "G"}, {7476, "H"}, {7477, "I"}, {7478, "J"}, {7479, "K"}, {7480, "L"}, {7481, "M"}, {7482, "N"}, {7483, "N"}, {7484, "O"}, {7485, "O"}, {7486, "P"}, {7487, "R"}, {7488, "T"}, {7489, "U"}, {7490, "W"}, {7491, "a"}, {7492, "a"}, {7493, "a"}, {7494, "ae"}, {7495, "b"}, {7496, "d"}, {7497, "e"}, {7498, "e"}, {7499, "e"}, {7500, "e"}, {7501, "g"}, {7502, "i"}, {7503, "k"}, {7504, "M"}, {7505, "N"}, {7506, "O"}, {7507, "C"}, {7508, "O"}, {7509, "O"}, {7510, "P"}, {7511, "T"}, {7512, "U"}, {7513, "N"}, {7514, "M"}, {7515, "V"}, {7516, "A"}, {7517, "S"}, {7518, "Y"}, {7519, "R"}, {7522, "I"}, {7523, "R"}, {7524, "U"}, {7525, "V"}, {7526, "S"}, {7527, "Y"}, {7531, "UE"}, {7532, "B"}, {7533, "D"}, {7534, "F"}, {7535, "M"}, {7536, "N"}, {7537, "P"}, {7538, "R"}, {7539, "r"}, {7540, "S"}, {7541, "T"}, {7542, "Z"}, {7545, "G"}, {7546, "th"}, {7547, "I"}, {7548, "I"}, {7549, "p"}, {7550, "u"}, {7551, "u"}, {7680, "A"}, {7681, "a"}, {7682, "B"}, {7683, "b"}, {7684, "B"}, {7685, "b"}, {7686, "B"}, {7687, "b"}, {7688, "C"}, {7689, "c"}, {7690, "D"}, {7691, "d"}, {7692, "D"}, {7693, "d"}, {7694, "D"}, {7695, "d"}, {7696, "D"}, {7697, "d"}, {7698, "D"}, {7699, "d"}, {7700, "E"}, {7701, "e"}, {7702, "E"}, {7703, "e"}, {7704, "E"}, {7705, "e"}, {7706, "E"}, {7707, "e"}, {7708, "E"}, {7709, "e"}, {7710, "F"}, {7711, "f"}, {7712, "G"}, {7713, "g"}, {7714, "H"}, {7715, "h"}, {7716, "H"}, {7717, "h"}, {7718, "H"}, {7719, "h"}, {7720, "H"}, {7721, "h"}, {7722, "H"}, {7723, "h"}, {7724, "I"}, {7725, "i"}, {7726, "I"}, {7727, "i"}, {7728, "K"}, {7729, "k"}, {7730, "K"}, {7731, "k"}, {7732, "K"}, {7733, "k"}, {7734, "L"}, {7735, "l"}, {7736, "L"}, {7737, "l"}, {7738, "L"}, {7739, "l"}, {7740, "L"}, {7741, "l"}, {7742, "M"}, {7743, "m"}, {7744, "M"}, {7745, "m"}, {7746, "M"}, {7747, "m"}, {7748, "N"}, {7749, "n"}, {7750, "N"}, {7751, "n"}, {7752, "N"}, {7753, "n"}, {7754, "N"}, {7755, "n"}, {7756, "O"}, {7757, "o"}, {7758, "O"}, {7759, "o"}, {7760, "O"}, {7761, "o"}, {7762, "O"}, {7763, "o"}, {7764, "P"}, {7765, "p"}, {7766, "P"}, {7767, "p"}, {7768, "R"}, {7769, "r"}, {7770, "R"}, {7771, "r"}, {7772, "R"}, {7773, "r"}, {7774, "R"}, {7775, "r"}, {7776, "S"}, {7777, "s"}, {7778, "S"}, {7779, "s"}, {7780, "S"}, {7781, "s"}, {7782, "S"}, {7783, "s"}, {7784, "S"}, {7785, "s"}, {7786, "T"}, {7787, "t"}, {7788, "T"}, {7789, "t"}, {7790, "T"}, {7791, "t"}, {7792, "T"}, {7793, "t"}, {7794, "U"}, {7795, "u"}, {7796, "U"}, {7797, "u"}, {7798, "U"}, {7799, "u"}, {7800, "U"}, {7801, "u"}, {7802, "U"}, {7803, "u"}, {7804, "V"}, {7805, "v"}, {7806, "V"}, {7807, "v"}, {7808, "W"}, {7809, "w"}, {7810, "W"}, {7811, "w"}, {7812, "W"}, {7813, "w"}, {7814, "W"}, {7815, "w"}, {7816, "W"}, {7817, "w"}, {7818, "X"}, {7819, "x"}, {7820, "X"}, {7821, "x"}, {7822, "Y"}, {7823, "y"}, {7824, "Z"}, {7825, "z"}, {7826, "Z"}, {7827, "z"}, {7828, "Z"}, {7829, "z"}, {7830, "h"}, {7831, "t"}, {7832, "w"}, {7833, "y"}, {7834, "a"}, {7835, "s"}, {7838, "s"}, {7839, "d"}, {7840, "A"}, {7841, "a"}, {7842, "A"}, {7843, "a"}, {7844, "A"}, {7845, "a"}, {7846, "A"}, {7847, "a"}, {7848, "A"}, {7849, "a"}, {7850, "A"}, {7851, "a"}, {7852, "A"}, {7853, "a"}, {7854, "A"}, {7855, "a"}, {7856, "A"}, {7857, "a"}, {7858, "A"}, {7859, "a"}, {7860, "A"}, {7861, "a"}, {7862, "A"}, {7863, "a"}, {7864, "E"}, {7865, "e"}, {7866, "E"}, {7867, "e"}, {7868, "E"}, {7869, "e"}, {7870, "E"}, {7871, "e"}, {7872, "E"}, {7873, "e"}, {7874, "E"}, {7875, "e"}, {7876, "E"}, {7877, "e"}, {7878, "E"}, {7879, "e"}, {7880, "I"}, {7881, "i"}, {7882, "I"}, {7883, "i"}, {7884, "O"}, {7885, "o"}, {7886, "O"}, {7887, "o"}, {7888, "O"}, {7889, "o"}, {7890, "O"}, {7891, "o"}, {7892, "O"}, {7893, "o"}, {7894, "O"}, {7895, "o"}, {7896, "O"}, {7897, "o"}, {7898, "O"}, {7899, "o"}, {7900, "O"}, {7901, "o"}, {7902, "O"}, {7903, "o"}, {7904, "O"}, {7905, "o"}, {7906, "O"}, {7907, "o"}, {7908, "U"}, {7909, "u"}, {7910, "U"}, {7911, "u"}, {7912, "U"}, {7913, "u"}, {7914, "U"}, {7915, "u"}, {7916, "U"}, {7917, "u"}, {7918, "U"}, {7919, "u"}, {7920, "U"}, {7921, "u"}, {7922, "Y"}, {7923, "y"}, {7924, "Y"}, {7925, "y"}, {7926, "Y"}, {7927, "y"}, {7928, "Y"}, {7929, "y"}, {8241, "0"}, {8252, "!!"}, {8253, "!?"}, {8263, "??"}, {8264, "?!"}, {8265, "!?"}, {8304, "0"}, {8308, "4"}, {8309, "5"}, {8310, "6"}, {8311, "7"}, {8312, "8"}, {8313, "9"}, {8320, "0"}, {8321, "1"}, {8322, "2"}, {8323, "3"}, {8324, "4"}, {8325, "5"}, {8326, "6"}, {8327, "7"}, {8328, "8"}, {8329, "9"}, {8336, "a"}, {8337, "e"}, {8338, "o"}, {8339, "x"}, {8340, "e"}, {8543, "1"}, {9312, "1"}, {9313, "2"}, {9314, "3"}, {9315, "4"}, {9316, "5"}, {9317, "6"}, {9318, "7"}, {9319, "8"}, {9320, "9"}, {9321, "10"}, {9322, "11"}, {9323, "12"}, {9324, "13"}, {9325, "14"}, {9326, "15"}, {9327, "16"}, {9328, "17"}, {9329, "18"}, {9330, "19"}, {9331, "20"}, {9332, "1"}, {9333, "2"}, {9334, "3"}, {9335, "4"}, {9336, "5"}, {9337, "6"}, {9338, "7"}, {9339, "8"}, {9340, "9"}, {9341, "10"}, {9342, "11"}, {9343, "12"}, {9344, "13"}, {9345, "14"}, {9346, "15"}, {9347, "16"}, {9348, "17"}, {9349, "18"}, {9350, "19"}, {9351, "20"}, {9352, "1."}, {9353, "2."}, {9354, "3."}, {9355, "4."}, {9356, "5."}, {9357, "6."}, {9358, "7."}, {9359, "8."}, {9360, "9."}, {9361, "10."}, {9362, "11."}, {9363, "12."}, {9364, "13."}, {9365, "14."}, {9366, "15."}, {9367, "16."}, {9368, "17."}, {9369, "18."}, {9370, "19."}, {9371, "20."}, {9372, "a"}, {9373, "b"}, {9374, "c"}, {9375, "d"}, {9376, "e"}, {9377, "f"}, {9378, "g"}, {9379, "h"}, {9380, "i"}, {9381, "j"}, {9382, "k"}, {9383, "l"}, {9384, "m"}, {9385, "n"}, {9386, "o"}, {9387, "p"}, {9388, "q"}, {9389, "r"}, {9390, "s"}, {9391, "t"}, {9392, "u"}, {9393, "v"}, {9394, "w"}, {9395, "x"}, {9396, "y"}, {9397, "z"}, {9398, "A"}, {9399, "B"}, {9400, "C"}, {9401, "D"}, {9402, "E"}, {9403, "F"}, {9404, "G"}, {9405, "H"}, {9406, "I"}, {9407, "J"}, {9408, "K"}, {9409, "L"}, {9410, "M"}, {9411, "N"}, {9412, "O"}, {9413, "P"}, {9414, "Q"}, {9415, "R"}, {9416, "S"}, {9417, "T"}, {9418, "U"}, {9419, "V"}, {9420, "W"}, {9421, "X"}, {9422, "Y"}, {9423, "Z"}, {9424, "a"}, {9425, "b"}, {9426, "c"}, {9427, "d"}, {9428, "e"}, {9429, "f"}, {9430, "g"}, {9431, "h"}, {9432, "i"}, {9433, "j"}, {9434, "k"}, {9435, "l"}, {9436, "m"}, {9437, "n"}, {9438, "o"}, {9439, "p"}, {9440, "q"}, {9441, "r"}, {9442, "s"}, {9443, "t"}, {9444, "u"}, {9445, "v"}, {9446, "w"}, {9447, "x"}, {9448, "y"}, {9449, "z"}, {9450, "0"}, {9451, "11"}, {9452, "12"}, {9453, "13"}, {9454, "14"}, {9455, "15"}, {9456, "16"}, {9457, "17"}, {9458, "18"}, {9459, "19"}, {9460, "20"}, {9461, "1"}, {9462, "2"}, {9463, "3"}, {9464, "4"}, {9465, "5"}, {9466, "6"}, {9467, "7"}, {9468, "8"}, {9469, "9"}, {9470, "10"}, {10102, "1"}, {10103, "2"}, {10104, "3"}, {10105, "4"}, {10106, "5"}, {10107, "6"}, {10108, "7"}, {10109, "8"}, {10110, "9"}, {10111, "10"}, {10112, "1"}, {10113, "2"}, {10114, "3"}, {10115, "4"}, {10116, "5"}, {10117, "6"}, {10118, "7"}, {10119, "8"}, {10120, "9"}, {10121, "0"}, {10122, "1"}, {10123, "2"}, {10124, "3"}, {10125, "4"}, {10126, "5"}, {10127, "6"}, {10128, "7"}, {10129, "8"}, {10130, "9"}, {10131, "10"}, {65296, "0"}, {65297, "1"}, {65298, "2"}, {65299, "3"}, {65300, "4"}, {65301, "5"}, {65302, "6"}, {65303, "7"}, {65304, "8"}, {65305, "9"}, {65313, "A"}, {65314, "B"}, {65315, "C"}, {65316, "D"}, {65317, "E"}, {65318, "F"}, {65319, "G"}, {65320, "H"}, {65321, "I"}, {65322, "J"}, {65323, "K"}, {65324, "L"}, {65325, "M"}, {65326, "N"}, {65327, "O"}, {65328, "P"}, {65329, "Q"}, {65330, "R"}, {65331, "S"}, {65332, "T"}, {65333, "U"}, {65334, "V"}, {65335, "W"}, {65336, "X"}, {65337, "Y"}, {65338, "Z"}, {65345, "a"}, {65346, "b"}, {65347, "c"}, {65348, "d"}, {65349, "e"}, {65350, "f"}, {65351, "g"}, {65352, "h"}, {65353, "i"}, {65354, "j"}, {65355, "k"}, {65356, "l"}, {65357, "m"}, {65358, "n"}, {65359, "o"}, {65360, "p"}, {65361, "q"}, {65362, "r"}, {65363, "s"}, {65364, "t"}, {65365, "u"}, {65366, "v"}, {65367, "w"}, {65368, "x"}, {65369, "y"}, {65370, "z"}, {0, null}};
        m_achFraction_Table = new char[]{'\u00bc', '\u00bd', '\u00be', '\u2153', '\u2154', '\u2155', '\u2156', '\u2157', '\u2158', '\u2159', '\u215a', '\u215b', '\u215c', '\u215d', '\u215e', '\u0000'};
        m_adFraction_Table = new double[]{0.25, 0.5, 0.75, 0.3333333333333333, 0.6666666666666666, 0.2, 0.4, 0.6, 0.8, 0.16666666666666666, 0.8333333333333334, 0.125, 0.375, 0.625, 0.875, 0.0};
    }
}

