/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui;

import com.rhinosoft.fvjv.strings.CString;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class CLanguageComboBox
extends JComboBox {
    private String[] m_asItems;

    public CLanguageComboBox() {
        this.InitVars();
    }

    private void InitVars() {
        this.LoadStrings();
        this.setModel(new DefaultComboBoxModel<String>(this.m_asItems));
        this.setEditable(false);
        this.setSelectedIndex(this.GetIndex(LANGUAGE.ENGLISH));
    }

    private void LoadStrings() {
        LANGUAGE[] aItems = LANGUAGE.values();
        this.m_asItems = new String[aItems.length];
        for (int nIdx = 0; nIdx < this.m_asItems.length; ++nIdx) {
            this.m_asItems[nIdx] = this.GetString(aItems[nIdx]);
        }
    }

    private String GetString(LANGUAGE objLanguage) {
        String sResource = CString.LoadString("IDS_LANG_ENGLISH");
        if (objLanguage != null) {
            sResource = objLanguage.GetStringRes();
        }
        return sResource;
    }

    private int GetIndex(LANGUAGE objLanguage) {
        int nIndex = -1;
        LANGUAGE[] aItems = LANGUAGE.values();
        for (int nIdx = 0; nIdx < aItems.length && nIndex == -1; ++nIdx) {
            if (aItems[nIdx] != objLanguage) continue;
            nIndex = nIdx;
        }
        return nIndex;
    }

    private LANGUAGE GetLanguage(int nIndex) {
        LANGUAGE nLang = LANGUAGE.ENGLISH;
        LANGUAGE[] aItems = LANGUAGE.values();
        if (nIndex >= 0 && nIndex < aItems.length) {
            nLang = aItems[nIndex];
        }
        return nLang;
    }

    public String GetLanguageCode() {
        return this.GetLanguageCode(this.GetLanguage(this.getSelectedIndex()));
    }

    private String GetLanguageCode(LANGUAGE objLanguage) {
        String sCode = "en";
        if (objLanguage != null) {
            sCode = objLanguage.GetLangCode();
        }
        return sCode;
    }

    public String GetCountryCode() {
        return this.GetCountryCode(this.GetLanguage(this.getSelectedIndex()));
    }

    private String GetCountryCode(LANGUAGE objLanguage) {
        String sCode = "US";
        if (objLanguage != null) {
            sCode = objLanguage.GetCountryCode();
        }
        return sCode;
    }

    public void SetSelectedLanguage(String sLanguageCode, String sCountryCode) {
        LANGUAGE objLanguage = this.GetLanguage(sLanguageCode, sCountryCode);
        this.setSelectedIndex(this.GetIndex(objLanguage));
    }

    private LANGUAGE GetLanguage(String sLanguageCode, String sCountryCode) {
        LANGUAGE rRetLangObj = LANGUAGE.ENGLISH;
        LANGUAGE[] aLangObjs = LANGUAGE.values();
        if (aLangObjs != null && aLangObjs.length > 0) {
            boolean bIsChinese = false;
            if (sLanguageCode != null && !sLanguageCode.isEmpty()) {
                if ((sLanguageCode = sLanguageCode.toLowerCase()).equals(LANGUAGE.CHINESE_SIMPLIFIED.GetLangCode())) {
                    bIsChinese = true;
                }
                boolean bFoundIt = false;
                for (int nIdx = 0; nIdx < aLangObjs.length; ++nIdx) {
                    LANGUAGE rNextLang = aLangObjs[nIdx];
                    if (rNextLang == null || !sLanguageCode.equals(rNextLang.GetLangCode())) continue;
                    rRetLangObj = rNextLang;
                    bFoundIt = true;
                    break;
                }
                if (!bFoundIt && sLanguageCode.equals("jp")) {
                    rRetLangObj = LANGUAGE.JAPANESE;
                }
            }
            if (bIsChinese && sCountryCode != null && !sCountryCode.isEmpty()) {
                sCountryCode = sCountryCode.toUpperCase();
                rRetLangObj = LANGUAGE.CHINESE_SIMPLIFIED;
                if (sCountryCode.equals(LANGUAGE.CHINESE_TRADITIONAL.GetCountryCode())) {
                    rRetLangObj = LANGUAGE.CHINESE_TRADITIONAL;
                }
            }
        }
        return rRetLangObj;
    }

    public static enum LANGUAGE {
        ENGLISH("en", "US", "IDS_LANG_ENGLISH"),
        GERMAN("de", "DE", "IDS_LANG_GERMAN"),
        ITALIAN("it", "IT", "IDS_LANG_ITALIAN"),
        FRENCH("fr", "FR", "IDS_LANG_FRENCH"),
        SPANISH("es", "ES", "IDS_LANG_SPANISH"),
        SERBIAN("sr", "SR", "IDS_LANG_SERBIAN"),
        RUSSIAN("ru", "RU", "IDS_LANG_RUSSIAN"),
        CHINESE_SIMPLIFIED("zh", "CN", "IDS_LANG_SIMPLIFIED_CHINESE"),
        CHINESE_TRADITIONAL("zh", "TW", "IDS_LANG_TRADITIONAL_CHINESE"),
        JAPANESE("ja", "JP", "IDS_LANG_JAPANESE");

        private String m_sLangCode;
        private String m_sCountryCode;
        private String m_sResource;

        private LANGUAGE(String sLangCode, String sCountryCode, String sResource) {
            this.m_sLangCode = sLangCode;
            this.m_sCountryCode = sCountryCode;
            this.m_sResource = sResource;
        }

        public final String GetLangCode() {
            return this.m_sLangCode;
        }

        public final String GetCountryCode() {
            return this.m_sCountryCode;
        }

        public final String GetResource() {
            return this.m_sResource;
        }

        public final String GetStringRes() {
            return CString.LoadString(this.m_sResource);
        }
    }
}

