/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui;

import com.rhinosoft.base.gui.images.CColorTintFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class CColorChooserBtn
extends JButton
implements ActionListener {
    private String m_sClrChooserTitle;
    private CColorIcon m_Icon;
    private Color m_clrDefault;
    private Color m_clrCurrent;

    public CColorChooserBtn(Color clrDefault, String sClrChooserTitle) {
        this._CColorChooserBtn(clrDefault, sClrChooserTitle);
    }

    private void _CColorChooserBtn(Color clrDefault, String sClrChooserTitle) {
        this.m_clrCurrent = this.m_clrDefault = clrDefault;
        this.m_sClrChooserTitle = sClrChooserTitle;
        this.m_Icon = new CColorIcon();
        this.setIcon(this.m_Icon);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Color clrPicked = JColorChooser.showDialog(this, this.m_sClrChooserTitle, this.m_clrCurrent);
        if (clrPicked != null) {
            this.SetCurColor(clrPicked);
        }
    }

    public void SetCurColor(Color clr) {
        this.m_clrCurrent = clr;
        this.repaint();
    }

    public Color GetCurColor() {
        return this.m_clrCurrent;
    }

    private class CColorIcon
    implements Icon {
        private CColorTintFilter m_clrFilter = new CColorTintFilter(Color.WHITE, 0.5f);

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Color clrPaint = Color.BLACK;
            if (!CColorChooserBtn.this.isEnabled()) {
                clrPaint = new Color(this.m_clrFilter.MixColor(clrPaint.getRGB()));
            }
            g2.setPaint(clrPaint);
            g2.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            clrPaint = CColorChooserBtn.this.m_clrCurrent;
            if (!CColorChooserBtn.this.isEnabled()) {
                clrPaint = new Color(this.m_clrFilter.MixColor(clrPaint.getRGB()));
            }
            g2.setPaint(clrPaint);
            g2.fillRect(x + 1, y + 1, this.getIconWidth() - 2, this.getIconHeight() - 2);
        }
    }
}

