/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files.WindowsLink;

import com.rhinosoft.base.files.WindowsLink.CFileLocationInfo;
import java.nio.ByteBuffer;

public class CNetworkVolume {
    private static final int SIZE_UNUSED = 3;
    public static final int OFFSET_LENGTH = 0;
    public static final int OFFSET_FLAGS = 4;
    public static final int OFFSET_NETWORK_SHARE_NAME = 8;
    public static final int OFFSET_FINAL_NAME = 12;
    public static final int OFFSET_UNKNOWN = 16;
    public static final int OFFSET_WIDE_NETWORK_SHARE_NAME = 20;
    public static final int OFFSET_WIDE_FINAL_NAME = 24;
    public static final int BIT_FLAGS_MAPPED_DRIVE = 0;
    public static final int BIT_FLAGS_UNC_PATH = 1;
    private byte[] m_aBuffer;
    private int m_dwLen;
    private boolean m_bMappedDrive;
    private boolean m_bUNCPath;
    private byte[] m_achUnused = new byte[3];
    private int m_dwNetworkShareNameOffset;
    private int m_dwFinalNameOffset;
    private int m_dwUnknown;
    private int m_dwWideNetworkShareNameOffset;
    private int m_dwWideFinalNameOffset;

    public boolean Parse(byte[] aBuf, int nOffset) {
        boolean bParsed = false;
        if (aBuf != null && nOffset + CNetworkVolume.sizeof() < aBuf.length) {
            if (this.m_aBuffer == null) {
                this.m_aBuffer = new byte[aBuf.length - nOffset];
            }
            System.arraycopy(aBuf, nOffset, this.m_aBuffer, 0, this.m_aBuffer.length);
            ByteBuffer ByteHelper = ByteBuffer.wrap(this.m_aBuffer);
            this.m_dwLen = Integer.reverseBytes(ByteHelper.getInt());
            int nFlags = Integer.reverseBytes(ByteHelper.getInt());
            this.m_bMappedDrive = (nFlags & 1) != 0;
            this.m_bUNCPath = (nFlags & 2) != 0;
            this.m_dwNetworkShareNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwFinalNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwUnknown = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwWideNetworkShareNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwWideFinalNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            bParsed = true;
        }
        return bParsed;
    }

    public static int sizeof() {
        int nNumOfBytes = 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        return nNumOfBytes += 4;
    }

    public int GetNetworkShareNameOffset() {
        return this.m_dwNetworkShareNameOffset;
    }

    public int GetFinalNameOffset() {
        return this.m_dwFinalNameOffset;
    }

    public int GetWideNetworkShareNameOffset() {
        return this.m_dwWideNetworkShareNameOffset;
    }

    public int GetWideFinalNameOffset() {
        return this.m_dwWideFinalNameOffset;
    }

    public String GetNetworkShareName() {
        return CFileLocationInfo.ParseString(this.m_aBuffer, this.GetNetworkShareNameOffset());
    }

    public String GetFinalName() {
        return CFileLocationInfo.ParseString(this.m_aBuffer, this.GetFinalNameOffset());
    }

    public String GetWideNetworkShareName() {
        return CFileLocationInfo.ParseWideString(this.m_aBuffer, this.GetWideNetworkShareNameOffset());
    }

    public String GetWideFinalName() {
        return CFileLocationInfo.ParseWideString(this.m_aBuffer, this.GetWideFinalNameOffset());
    }

    public boolean IsMappedDrive() {
        return this.m_bMappedDrive;
    }

    public boolean IsUNCPath() {
        return this.m_bUNCPath;
    }
}

