/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files.WindowsLink;

import com.rhinosoft.base.files.WindowsLink.CFileLocationInfo;
import java.nio.ByteBuffer;

public class CLocalVolume {
    public static final long LINK_LOCAL_UNKNOWN = 0L;
    public static final long LINK_LOCAL_NO_ROOT_DIR = 1L;
    public static final long LINK_LOCAL_REMOVABLE = 2L;
    public static final long LINK_LOCAL_FIXED = 3L;
    public static final long LINK_LOCAL_REMOTE = 4L;
    public static final long LINK_LOCAL_CD_ROM = 5L;
    public static final long LINK_LOCAL_RAM = 6L;
    public static final int OFFSET_LENGTH = 0;
    public static final int OFFSET_TYPE = 4;
    public static final int OFFSET_SERIAL_NUMBER = 8;
    public static final int OFFSET_VOLUME_NAME = 12;
    public static final int OFFSET_WIDE_VOLUME_NAME = 16;
    private byte[] m_aBuffer;
    private int m_dwLen;
    private int m_dwType;
    private int m_dwSerialNum;
    private int m_dwVolumeNameOffset;
    private int m_dwWideVolumeNameOffset;

    public boolean Parse(byte[] aBuf, int nOffset) {
        boolean bParsed = false;
        if (aBuf != null && nOffset + CLocalVolume.sizeof() < aBuf.length) {
            if (this.m_aBuffer == null) {
                this.m_aBuffer = new byte[aBuf.length - nOffset];
            }
            System.arraycopy(aBuf, nOffset, this.m_aBuffer, 0, this.m_aBuffer.length);
            ByteBuffer ByteHelper = ByteBuffer.wrap(this.m_aBuffer);
            this.m_dwLen = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwType = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwSerialNum = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwVolumeNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwWideVolumeNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            bParsed = true;
        }
        return bParsed;
    }

    public static int sizeof() {
        int nNumOfBytes = 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        return nNumOfBytes += 4;
    }

    public boolean HasWideStrings() {
        boolean bHasWideStrings = false;
        if (this.GetVolumeNameOffset() >= CLocalVolume.sizeof()) {
            bHasWideStrings = true;
        }
        return bHasWideStrings;
    }

    public int GetVolumeNameOffset() {
        return this.m_dwVolumeNameOffset;
    }

    public int GetWideVolumeNameOffset() {
        return this.m_dwWideVolumeNameOffset;
    }

    public String GetVolumeName() {
        return CFileLocationInfo.ParseString(this.m_aBuffer, this.GetVolumeNameOffset());
    }

    public String GetWideVolumeName() {
        return CFileLocationInfo.ParseWideString(this.m_aBuffer, this.GetWideVolumeNameOffset());
    }

    public int GetType() {
        return this.m_dwType;
    }

    public int GetSerialNum() {
        return this.m_dwSerialNum;
    }
}

