/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files.WindowsLink;

import com.rhinosoft.base.files.WindowsLink.CFileTime;
import java.nio.ByteBuffer;

public class CFileHeader {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_OFFSETS = false;
    private static final int SIZE_GUID = 16;
    private static final int SIZE_FLAGS_UNUSED = 3;
    private static final int SIZE_FILE_ATTRS_UNUSED = 2;
    private static final int SIZE_UNKNOWN = 2;
    public static final int OFFSET_VALUE = 0;
    public static final int OFFSET_GUID = 4;
    public static final int OFFSET_FLAGS = 20;
    public static final int OFFSET_FILE_ATTRS = 24;
    public static final int OFFSET_TIME_CREATION = 28;
    public static final int OFFSET_TIME_MODIFIED = 36;
    public static final int OFFSET_TIME_LAST_ACCESSED = 44;
    public static final int OFFSET_FILE_LEN = 52;
    public static final int OFFSET_ICON = 56;
    public static final int OFFSET_SHOW_WND = 60;
    public static final int OFFSET_HOT_KEY = 64;
    public static final int OFFSET_UNKNOWN = 68;
    public static final int BIT_FLAGS_SHELL_ID_LIST = 0;
    public static final int BIT_FLAGS_FILE_OR_DIR = 1;
    public static final int BIT_FLAGS_HAS_DESCRIPTION = 2;
    public static final int BIT_FLAGS_HAS_RELATIVE_PATH = 3;
    public static final int BIT_FLAGS_HAS_RELATIVE_PATHS = 4;
    public static final int BIT_FLAGS_HAS_PARAMS = 5;
    public static final int BIT_FLAGS_HAS_CUSTOM_ICON = 6;
    public static final int BIT_FILEATTRS_READ_ONLY = 0;
    public static final int BIT_FILEATTRS_HIDDEN = 1;
    public static final int BIT_FILEATTRS_SYSTEM_FILE = 2;
    public static final int BIT_FILEATTRS_VOLUME_LABEL = 3;
    public static final int BIT_FILEATTRS_DIRECTORY = 4;
    public static final int BIT_FILEATTRS_ARCHIVE = 5;
    public static final int BIT_FILEATTRS_ENCRYPTED = 6;
    public static final int BIT_FILEATTRS_NORMAL = 7;
    public static final int BIT_FILEATTRS_TEMPORARY = 8;
    public static final int BIT_FILEATTRS_SPARSE_FILE = 9;
    public static final int BIT_FILEATTRS_REPARSE_DATA = 10;
    public static final int BIT_FILEATTRS_COMPRESSED = 11;
    public static final int BIT_FILEATTRS_OFFLINE = 12;
    private byte[] m_MasterGUID;
    private int m_dwValue;
    private byte[] m_GUID = new byte[16];
    private boolean m_bHasShellIDList;
    private boolean m_bFileOrDir;
    private boolean m_bHasDescription;
    private boolean m_bHasRelativePath;
    private boolean m_bHasWorkingDir;
    private boolean m_bHasParams;
    private boolean m_bHasCustomIcon;
    private byte[] m_achFlagsUnused;
    private boolean m_bReadOnly;
    private boolean m_bHidden;
    private boolean m_bSystemFile;
    private boolean m_bVolumeLabel;
    private boolean m_bDirectory;
    private boolean m_bArchive;
    private boolean m_bEncrypted;
    private boolean m_bNormal;
    private boolean m_bTemporary;
    private boolean m_bSparseFile;
    private boolean m_bReparseData;
    private boolean m_bCompressed;
    private boolean m_bOffline;
    private byte[] m_achFileAttrsUnused;
    private CFileTime m_ftCreationTime;
    private CFileTime m_ftModificationTime;
    private CFileTime m_ftLastAccessTime;
    private int m_dwFileLength;
    private int m_dwIcon;
    private int m_dwShowWnd;
    private int m_dwHotKey;
    private int[] m_dwUnknown;

    public CFileHeader() {
        this.m_MasterGUID = new byte[16];
        this.m_MasterGUID[0] = 1;
        this.m_MasterGUID[1] = 20;
        this.m_MasterGUID[2] = 2;
        this.m_MasterGUID[3] = 0;
        this.m_MasterGUID[4] = 0;
        this.m_MasterGUID[5] = 0;
        this.m_MasterGUID[6] = 0;
        this.m_MasterGUID[7] = 0;
        this.m_MasterGUID[8] = -64;
        this.m_MasterGUID[9] = 0;
        this.m_MasterGUID[10] = 0;
        this.m_MasterGUID[11] = 0;
        this.m_MasterGUID[12] = 0;
        this.m_MasterGUID[13] = 0;
        this.m_MasterGUID[14] = 0;
        this.m_MasterGUID[15] = 70;
        this.m_achFlagsUnused = new byte[3];
        this.m_achFileAttrsUnused = new byte[2];
        this.m_dwUnknown = new int[2];
        this.m_ftCreationTime = new CFileTime();
        this.m_ftModificationTime = new CFileTime();
        this.m_ftLastAccessTime = new CFileTime();
    }

    public boolean Parse(byte[] aBuf) {
        boolean bParsed = false;
        if (aBuf.length >= CFileHeader.sizeof()) {
            ByteBuffer ByteHelper = ByteBuffer.wrap(aBuf);
            this.m_dwValue = Integer.reverseBytes(ByteHelper.getInt());
            ByteHelper.get(this.m_GUID, 0, this.m_GUID.length);
            if (this.m_dwValue == 76 && this.CheckGUID()) {
                int nFileAttrs;
                int nFlags;
                if (ByteHelper.position() != 20) {
                    ByteHelper.position(20);
                }
                this.m_bHasShellIDList = ((nFlags = Integer.reverseBytes(ByteHelper.getInt())) & 1) != 0;
                this.m_bFileOrDir = (nFlags & 2) != 0;
                this.m_bHasDescription = (nFlags & 4) != 0;
                this.m_bHasRelativePath = (nFlags & 8) != 0;
                this.m_bHasWorkingDir = (nFlags & 0x10) != 0;
                this.m_bHasParams = (nFlags & 0x20) != 0;
                boolean bl = this.m_bHasCustomIcon = (nFlags & 0x40) != 0;
                if (ByteHelper.position() != 24) {
                    ByteHelper.position(24);
                }
                this.m_bReadOnly = ((nFileAttrs = Integer.reverseBytes(ByteHelper.getInt())) & 1) != 0;
                this.m_bHidden = (nFileAttrs & 2) != 0;
                this.m_bSystemFile = (nFileAttrs & 4) != 0;
                this.m_bVolumeLabel = (nFileAttrs & 8) != 0;
                this.m_bDirectory = (nFileAttrs & 0x10) != 0;
                this.m_bArchive = (nFileAttrs & 0x20) != 0;
                this.m_bEncrypted = (nFileAttrs & 0x40) != 0;
                this.m_bNormal = (nFileAttrs & 0x80) != 0;
                this.m_bTemporary = (nFileAttrs & 0x100) != 0;
                this.m_bSparseFile = (nFileAttrs & 0x200) != 0;
                this.m_bReparseData = (nFileAttrs & 0x400) != 0;
                this.m_bCompressed = (nFileAttrs & 0x800) != 0;
                boolean bl2 = this.m_bOffline = (nFileAttrs & 0x1000) != 0;
                if (ByteHelper.position() != 28) {
                    ByteHelper.position(28);
                }
                this.m_ftCreationTime.m_dwLowDateTime = Integer.reverseBytes(ByteHelper.getInt());
                this.m_ftCreationTime.m_dwHighDateTime = Integer.reverseBytes(ByteHelper.getInt());
                if (ByteHelper.position() != 36) {
                    ByteHelper.position(36);
                }
                this.m_ftModificationTime.m_dwLowDateTime = Integer.reverseBytes(ByteHelper.getInt());
                this.m_ftModificationTime.m_dwHighDateTime = Integer.reverseBytes(ByteHelper.getInt());
                if (ByteHelper.position() != 44) {
                    ByteHelper.position(44);
                }
                this.m_ftLastAccessTime.m_dwLowDateTime = Integer.reverseBytes(ByteHelper.getInt());
                this.m_ftLastAccessTime.m_dwHighDateTime = Integer.reverseBytes(ByteHelper.getInt());
                if (ByteHelper.position() != 52) {
                    ByteHelper.position(52);
                }
                this.m_dwFileLength = Integer.reverseBytes(ByteHelper.getInt());
                if (ByteHelper.position() != 56) {
                    ByteHelper.position(56);
                }
                this.m_dwIcon = Integer.reverseBytes(ByteHelper.getInt());
                if (ByteHelper.position() != 60) {
                    ByteHelper.position(60);
                }
                this.m_dwShowWnd = Integer.reverseBytes(ByteHelper.getInt());
                if (ByteHelper.position() != 64) {
                    ByteHelper.position(64);
                }
                this.m_dwHotKey = Integer.reverseBytes(ByteHelper.getInt());
                bParsed = true;
            }
        }
        return bParsed;
    }

    public static int sizeof() {
        int nNumOfBytes = 4;
        nNumOfBytes += 16;
        ++nNumOfBytes;
        nNumOfBytes += 3;
        nNumOfBytes += 2;
        nNumOfBytes += 2;
        nNumOfBytes += CFileTime.sizeof();
        nNumOfBytes += CFileTime.sizeof();
        nNumOfBytes += CFileTime.sizeof();
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        return nNumOfBytes += 8;
    }

    private boolean CheckGUID() {
        boolean bIsMatch = true;
        if (this.m_GUID != null && this.m_MasterGUID != null && this.m_GUID.length == this.m_MasterGUID.length) {
            for (int nIdx = 0; nIdx < this.m_GUID.length && bIsMatch; ++nIdx) {
                if (this.m_MasterGUID[nIdx] == this.m_GUID[nIdx]) continue;
                bIsMatch = false;
            }
        } else {
            bIsMatch = false;
        }
        return bIsMatch;
    }

    public boolean HasShellIDList() {
        return this.m_bHasShellIDList;
    }

    public long GetCreationTime() {
        long lRet = 0L;
        if (this.m_ftCreationTime != null) {
            lRet = this.m_ftCreationTime.GetTime();
        }
        return lRet;
    }

    public long GetModificationTime() {
        long lRet = 0L;
        if (this.m_ftModificationTime != null) {
            lRet = this.m_ftModificationTime.GetTime();
        }
        return lRet;
    }

    public long GetLastAccessTime() {
        long lRet = 0L;
        if (this.m_ftLastAccessTime != null) {
            lRet = this.m_ftLastAccessTime.GetTime();
        }
        return lRet;
    }

    public boolean IsFileOrDir() {
        return this.m_bFileOrDir;
    }

    public boolean HasDescription() {
        return this.m_bHasDescription;
    }

    public boolean HasRelativePath() {
        return this.m_bHasRelativePath;
    }

    public boolean HasWorkingDir() {
        return this.m_bHasWorkingDir;
    }

    public boolean HasParams() {
        return this.m_bHasParams;
    }

    public boolean HasCustomIcon() {
        return this.m_bHasCustomIcon;
    }
}

