/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import java.io.File;
import java.io.Serializable;

public class CPath
implements Serializable {
    private String m_sPrevPath;
    private String m_sPath;
    private boolean m_bIsDir;
    private long m_lSize;
    private long m_lLastModified;
    private boolean m_bForThread;
    private boolean m_bIsLocal;
    private boolean m_bIsReadOnly;
    private boolean m_bIsLink;
    private String m_sLinkPath;

    public static void main(String[] args) {
        String[] asPaths = new String[]{"\\\\DALENOTEBOOK", "\\\\DALENOTEBOOK\\", "\\\\DALENOTEBOOK\\TEMP", "\\\\DALENOTEBOOK\\TEMP\\", "D:\\Temp", "D:\\Temp\\", "D:\\Temp\\Tester", "D:\\Temp\\Tester\\", "/", "/Users", "/Users/", "/Users/home", "/Users/home/", null};
        String[] asFileSeps = new String[]{"\\", "\\", "\\", "\\", "\\", "\\", "\\", "\\", "/", "/", "/", "/", "/", null};
        for (int nIdx = 0; nIdx < asPaths.length; ++nIdx) {
            String sPath = asPaths[nIdx];
            String sFileSep = asFileSeps[nIdx];
            System.out.printf("%s = %s\r\n", sPath, CPath.GetParentPath(sPath, sFileSep));
        }
    }

    protected CPath() {
        this.InitVars(null, false, false, -1L, -1L);
    }

    public CPath(String sPath, boolean bIsDir, boolean bIsLocal) {
        this.InitVars(sPath, bIsDir, bIsLocal, -1L, -1L);
    }

    public CPath(String sPath, boolean bIsDir, boolean bIsLocal, long lSize) {
        this.InitVars(sPath, bIsDir, bIsLocal, lSize, -1L);
    }

    public CPath(String sPath, boolean bIsDir, boolean bIsLocal, long lSize, long lLastModified) {
        this.InitVars(sPath, bIsDir, bIsLocal, lSize, lLastModified);
    }

    protected CPath(CPath rCopyFrom) {
        this.Copy(rCopyFrom);
    }

    protected String PrepPath(String sPath, boolean bIsDir, boolean bIsLocal) {
        if (sPath != null && bIsDir) {
            boolean bAddFileSep = true;
            if (!bIsLocal && sPath.equals("~")) {
                bAddFileSep = false;
            } else if (CPath.IsWindowsLink(sPath)) {
                bAddFileSep = false;
            }
            if (bAddFileSep) {
                Character chSep = Character.valueOf(File.separatorChar);
                if (!bIsLocal) {
                    chSep = Character.valueOf('/');
                }
                sPath = CString.EnsureLastChar(chSep, sPath);
            }
        }
        return sPath;
    }

    private void InitVars(String sPath, boolean bIsDir, boolean bIsLocal, long lSize, long lLastModified) {
        this.m_bIsDir = bIsDir;
        this.m_bIsLocal = bIsLocal;
        sPath = this.PrepPath(sPath, bIsDir, bIsLocal);
        this.SetPath(sPath);
        this.m_lSize = lSize;
        this.m_lLastModified = lLastModified;
        this.m_bForThread = false;
        this.m_bIsReadOnly = false;
        this.m_bIsLink = false;
    }

    private void Copy(CPath rCopyFrom) {
        if (rCopyFrom != null) {
            if (rCopyFrom.m_sPath != null) {
                this.m_sPath = rCopyFrom.m_sPath;
            }
            if (rCopyFrom.m_sPrevPath != null) {
                this.m_sPrevPath = rCopyFrom.m_sPrevPath;
            }
            this.m_bIsDir = rCopyFrom.m_bIsDir;
            this.m_lSize = rCopyFrom.m_lSize;
            this.m_lLastModified = rCopyFrom.m_lLastModified;
            this.m_bForThread = rCopyFrom.m_bForThread;
            this.m_bIsLocal = rCopyFrom.m_bIsLocal;
            this.m_bIsReadOnly = rCopyFrom.m_bIsReadOnly;
            this.m_bIsLink = rCopyFrom.m_bIsLink;
            if (rCopyFrom.m_sLinkPath != null) {
                this.m_sLinkPath = rCopyFrom.m_sLinkPath;
            }
        }
    }

    public CPath clone() {
        return new CPath(this);
    }

    public boolean SetPath(String sPath) {
        boolean bDirty = false;
        this.m_sPrevPath = this.m_sPath;
        if (this.m_sPath != null && !this.m_sPath.equals(sPath)) {
            this.m_sPath = sPath;
            bDirty = true;
        } else {
            this.m_sPath = sPath;
        }
        return bDirty;
    }

    public String GetPath() {
        return this.m_sPath;
    }

    public boolean SetIsDir(boolean bIsDir) {
        boolean bDirty = false;
        if (this.m_bIsDir != bIsDir) {
            this.m_bIsDir = bIsDir;
            bDirty = true;
        }
        return bDirty;
    }

    public boolean IsDir() {
        return this.m_bIsDir;
    }

    public long GetSize() {
        return this.m_lSize;
    }

    public boolean SetSize(long lSize) {
        boolean bDirty = false;
        if (this.m_lSize != lSize) {
            this.m_lSize = lSize;
            bDirty = true;
        }
        return bDirty;
    }

    public long GetLastModified() {
        return this.m_lLastModified;
    }

    public boolean SetLastModified(long lLastModified) {
        boolean bDirty = false;
        if (this.m_lLastModified != lLastModified) {
            this.m_lLastModified = lLastModified;
            bDirty = true;
        }
        return bDirty;
    }

    public boolean equals(Object rObj) {
        boolean bEqual = false;
        if (rObj instanceof CPath) {
            CPath rPath = (CPath)rObj;
            String sTest = rPath.GetPath();
            if (this.GetPath() != null && sTest != null && this.GetPath().equals(sTest) && this.IsDir() == rPath.IsDir()) {
                bEqual = true;
            }
        }
        return bEqual;
    }

    public String toString() {
        return String.format("%s\r\nIsDir: %s\r\nSize: %d\r\nLastModifed: %s", this.GetPath(), Boolean.toString(this.IsDir()), this.GetSize(), this.GetLastModified());
    }

    public static int GetMaxDepth(String sAbsPath, String sFileSep) {
        int nMaxDepth = 0;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            sAbsPath = CString.EnsureLastChar(Character.valueOf(sFileSep.charAt(0)), sAbsPath);
            int nCurIndex = 0;
            if (sAbsPath.charAt(0) == sFileSep.charAt(0) && sAbsPath.length() > 2 && sAbsPath.charAt(1) == sFileSep.charAt(0)) {
                nCurIndex = sAbsPath.indexOf(sFileSep, 2);
                ++nCurIndex;
                ++nMaxDepth;
            }
            while (nCurIndex < sAbsPath.length()) {
                int nNextIndex = sAbsPath.indexOf(sFileSep, nCurIndex);
                if (nNextIndex < 0 || nNextIndex > sAbsPath.length()) {
                    nNextIndex = sAbsPath.length();
                }
                nCurIndex = nNextIndex + 1;
                ++nMaxDepth;
            }
        }
        return nMaxDepth;
    }

    public static String GetParentPath(String sAbsPath, String sFileSep) {
        String sParentPath = null;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            String sTemp = CString.EnsureNotLastChar(Character.valueOf(sFileSep.charAt(0)), sAbsPath);
            int nCurIndex = sTemp.lastIndexOf(sFileSep);
            sParentPath = nCurIndex > -1 && nCurIndex < sTemp.length() ? (nCurIndex == 1 && sTemp.charAt(0) == sFileSep.charAt(0) ? sAbsPath : sTemp.substring(0, nCurIndex)) : sAbsPath;
        }
        if (sParentPath != null) {
            sParentPath = CString.EnsureLastChar(Character.valueOf(sFileSep.charAt(0)), sParentPath);
        }
        return sParentPath;
    }

    protected boolean UpdateParentData(CPath rPathFrom) {
        boolean bUpdated = false;
        if (rPathFrom != null) {
            if (this.SetPath(rPathFrom.GetPath())) {
                bUpdated = true;
            }
            if (this.SetIsDir(rPathFrom.IsDir())) {
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    protected boolean UpdateData(CPath rPathFrom) {
        boolean bUpdated = false;
        if (rPathFrom != null) {
            if (this.SetPath(rPathFrom.GetPath())) {
                bUpdated = true;
            }
            if (this.SetIsDir(rPathFrom.IsDir())) {
                bUpdated = true;
            }
            if (this.SetSize(rPathFrom.GetSize())) {
                bUpdated = true;
            }
            if (this.SetLastModified(rPathFrom.GetLastModified())) {
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    public String GetPrevPath() {
        return this.m_sPrevPath;
    }

    public boolean GetForThread() {
        return this.m_bForThread;
    }

    public void SetForThread(boolean bForThread) {
        this.m_bForThread = bForThread;
    }

    public boolean IsLocal() {
        return this.m_bIsLocal;
    }

    public void SetIsLocal(boolean bVal) {
        this.m_bIsLocal = bVal;
    }

    public boolean IsReadOnly() {
        return this.m_bIsReadOnly;
    }

    public boolean SetIsReadOnly(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsReadOnly != bVal) {
            this.m_bIsReadOnly = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected CClientInfo GetClientInfo() {
        CClientInfo rInfo = null;
        if (CMainFrame.GET_APP() != null) {
            rInfo = CMainFrame.GET_APP().GetClientInfo();
        }
        return rInfo;
    }

    private int OnTransferCopy(CBaseThread rtThread, Object objSource, String sAbsTargetDir, CPath[] afSourceFiles, boolean bIsMove) {
        int nRc = -1;
        if (rtThread != null && rtThread.PostCopyFiles(objSource, this.GetClientInfo(), this.GetCompressionType(), this.GetPath(), sAbsTargetDir, afSourceFiles, bIsMove)) {
            nRc = 2;
        }
        return nRc;
    }

    public int CopyFiles(CBaseThread rtThread, Object objSource, String sAbsTargetDir, CPath[] afSourceFiles, boolean bIsMove) {
        return this.OnTransferCopy(rtThread, objSource, sAbsTargetDir, afSourceFiles, bIsMove);
    }

    private int OnTransferUpload(CBaseThread rtThread, Object objSource, String sAbsTargetDir, CPath[] afSourceFiles, boolean bIsMove, boolean bIsSearch) {
        int nRc = -1;
        if (rtThread != null && rtThread.PostUploadFiles(objSource, this.GetClientInfo(), this.GetCompressionType(), this.GetPath(), sAbsTargetDir, afSourceFiles, bIsMove, bIsSearch)) {
            nRc = 2;
        }
        return nRc;
    }

    public int UploadFiles(CBaseThread rtThread, Object objSource, String sAbsTargetDir, CPath[] afSourceFiles, boolean bIsMove, boolean bIsSearch) {
        return this.OnTransferUpload(rtThread, objSource, sAbsTargetDir, afSourceFiles, bIsMove, bIsSearch);
    }

    protected int OnTransferDownload(CBaseThread rtThread, Object objSource, String sAbsTargetDir, CPath[] afSourceFiles, boolean bIsMove, boolean bOpenFiles, boolean bIsSearch) {
        int nRc = -1;
        if (rtThread != null && rtThread.PostDownloadFiles(objSource, this.GetClientInfo(), this.GetCompressionType(), this.GetPath(), sAbsTargetDir, afSourceFiles, bIsMove, bOpenFiles, bIsSearch)) {
            nRc = 2;
        }
        return nRc;
    }

    public int DownloadFiles(CBaseThread rtThread, Object objSource, String sAbsTargetDir, CPath[] afSourceFiles, boolean bIsMove, boolean bIsSearch) {
        return this.OnTransferDownload(rtThread, objSource, sAbsTargetDir, afSourceFiles, bIsMove, false, bIsSearch);
    }

    public boolean IsLink() {
        if (!this.m_bIsLink && CPath.IsWindowsLink(this.GetPath())) {
            this.m_bIsLink = true;
        }
        return this.m_bIsLink;
    }

    public boolean SetIsLink(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsLink != bVal) {
            this.m_bIsLink = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public static boolean IsWindowsLink(String sPath) {
        boolean bIsWindowsLink = false;
        if (CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsWindows() && sPath != null && !sPath.isEmpty() && (sPath = sPath.toLowerCase()).endsWith(".lnk")) {
            bIsWindowsLink = true;
        }
        return bIsWindowsLink;
    }

    public boolean SetLinkPath(String sPath) {
        boolean bDirty = false;
        if (this.m_sLinkPath != null && !this.m_sLinkPath.equals(sPath)) {
            this.m_sLinkPath = sPath;
            bDirty = true;
        } else {
            this.m_sLinkPath = sPath;
        }
        return bDirty;
    }

    public String GetLinkPath() {
        return this.m_sLinkPath;
    }

    public int GetCompressionType() {
        int nCompressionType = 0;
        if (CMainFrame.GET_APP() != null) {
            nCompressionType = CMainFrame.GET_APP().GetCompressionType();
        }
        return nCompressionType;
    }
}

