/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class CFileSystemUtils {
    public static final int REGISTRY_CODE_OK = 0;
    public static final int REGISTRY_CODE_INVALID_PARMS = 1;
    public static final int REGISTRY_CODE_DOES_NOT_EXIST = 2;
    private static boolean DEBUG = CMainFrame.DEBUG;
    private static final boolean DEBUG_TRACE_ROOTS;
    private static final boolean DEBUG_TRACE_VIRTUALS;
    private static final boolean DEBUG_JAVA_FILE_ICONS;
    private static final boolean DEBUG_TRACK_USE_SHELL_FOLDER = false;
    private static final boolean DEBUG_TRACK_FILE_TYPE = false;
    public static final String COMPUTER_ID = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
    public static final String NETWORK_ID = "::{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}";
    private static CFileSystemUtils m_FileSysUtils;
    private MediaTracker m_MediaTracker = new MediaTracker(new JPanel());
    private boolean m_bUseShellFolders = false;
    private File[] m_afRootDirs;

    public static void main(String[] asArgs) {
        String sPath = COMPUTER_ID;
        System.out.printf("File: %s\r\n", sPath);
        File fShellFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sPath);
        System.out.printf("ShellFile | Path: %s | DisplayName: %s\r\n", fShellFile.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fShellFile));
        sPath = NETWORK_ID;
        System.out.printf("File: %s\r\n", sPath);
        fShellFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sPath);
        System.out.printf("ShellFile | Path: %s | DisplayName: %s\r\n", fShellFile.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fShellFile));
        sPath = "::{645FF040-5081-101B-9F08-00AA002F954E}";
        System.out.printf("File: %s\r\n", sPath);
        fShellFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sPath);
        System.out.printf("ShellFile | Path: %s | DisplayName: %s\r\n", fShellFile.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fShellFile));
        sPath = "::{450D8FBA-AD25-11D0-98A8-0800361B1103}";
        System.out.printf("File: %s\r\n", sPath);
        fShellFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sPath);
        System.out.printf("ShellFile | Path: %s | DisplayName: %s\r\n", fShellFile.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fShellFile));
        sPath = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\\::{7007ACC7-3202-11D1-AAD2-00805FC1270E}";
        System.out.printf("File: %s\r\n", sPath);
        fShellFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sPath);
        System.out.printf("ShellFile | Path: %s | DisplayName: %s\r\n", fShellFile.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fShellFile));
        File[] afRootDirs = (File[])ShellFolder.get("fileChooserComboBoxFolders");
        for (int nIdx = 0; nIdx < afRootDirs.length; ++nIdx) {
            File fNext = afRootDirs[nIdx];
            if (fNext == null) continue;
            FileSystemView fsv = FileSystemView.getFileSystemView();
            System.out.printf("%s (%s)\r\n\tExists: %s\r\n\tType: %s\r\n\r\n", fsv.getSystemDisplayName(fNext), fNext.getAbsolutePath(), Boolean.toString(fNext.exists()), fsv.getSystemTypeDescription(fNext));
        }
    }

    public CFileSystemUtils() {
        this.InitVars();
    }

    public static void OnDestroy() {
        m_FileSysUtils = null;
    }

    public static CFileSystemUtils GetFileSysUtils(boolean bAllocNew) {
        if (m_FileSysUtils == null && bAllocNew) {
            m_FileSysUtils = new CFileSystemUtils();
        }
        return m_FileSysUtils;
    }

    public static CFileSystemUtils GetFileSysUtils() {
        return CFileSystemUtils.GetFileSysUtils(true);
    }

    private void InitVars() {
        this.InitUseShellFolders();
        this.InitRoots();
    }

    private void InitUseShellFolders() {
        File[] cbFolders;
        File[] afRoots;
        boolean bUseShellFolders = false;
        Boolean bFoundItInFileChooser = null;
        FileSystemView fsv = FileSystemView.getFileSystemView();
        JFileChooser rFileChooser = this.GetFileChooser(fsv);
        if (rFileChooser != null && (bFoundItInFileChooser = (Boolean)rFileChooser.getClientProperty("FileChooser.useShellFolder")) != null) {
            bUseShellFolders = bFoundItInFileChooser;
        }
        if (!bUseShellFolders && bFoundItInFileChooser == null && this.IsWindows() && (afRoots = fsv.getRoots()) != null && afRoots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null) {
            for (int nIdx = 0; nIdx < cbFolders.length; ++nIdx) {
                if (afRoots[0] != cbFolders[nIdx]) continue;
                bUseShellFolders = true;
                break;
            }
        }
        this.SetUseShellFolders(bUseShellFolders);
    }

    private void InitRoots() {
        File[] afRootDirs = null;
        afRootDirs = this.GetUseShellFolders() ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : FileSystemView.getFileSystemView().getRoots();
        this.SetRoots(afRootDirs);
    }

    private boolean GetUseShellFolders() {
        return this.m_bUseShellFolders;
    }

    private void SetUseShellFolders(boolean bUseShellFolders) {
        this.m_bUseShellFolders = bUseShellFolders;
    }

    public File[] GetRoots() {
        return this.m_afRootDirs;
    }

    private void SetRoots(File[] afRoots) {
        this.m_afRootDirs = afRoots;
    }

    public static Icon GetImage16(File fFile) {
        Icon icoRet = null;
        CFileSystemUtils fsu = CFileSystemUtils.GetFileSysUtils();
        if (fsu != null) {
            icoRet = fsu.GetJavaFileIcon(fFile, false);
        }
        return icoRet;
    }

    public static Icon GetImage32(File fFile) {
        Icon icoRet = CFileSystemUtils.GetImage16(fFile);
        CFileSystemUtils fsu = CFileSystemUtils.GetFileSysUtils();
        if (fsu != null) {
            icoRet = fsu.GetJavaFileIcon(fFile, true);
        }
        return icoRet;
    }

    public static String GetType(File fFile) {
        String sType = "";
        FileSystemView fsv = FileSystemView.getFileSystemView();
        if (fFile != null && fsv != null) {
            File fTemp;
            if (fsv.isDrive(fFile) && (fTemp = CFileSystemUtils.GetDrive(fFile.getAbsolutePath())) != null) {
                fFile = fTemp;
            }
            if (fFile.exists() && ((sType = fsv.getSystemTypeDescription(fFile)) == null || sType.isEmpty())) {
                String sExt;
                sType = !fFile.isDirectory() ? ((sExt = CString.GetFileExtension(fFile.getPath(), fFile.isDirectory(), false)) == null || sExt.isEmpty() ? CString.LoadString("IDS_FILE") : String.format(CString.LoadString("IDS_FMT_FILE"), sExt.toUpperCase())) : CString.LoadString("IDS_DIRECTORY");
            }
        }
        return sType;
    }

    public static File GetDrive(String sAbsPath) {
        File fDrive = null;
        File fFile = new File(sAbsPath);
        if (FileSystemView.getFileSystemView().isDrive(fFile)) {
            File[] afRoots = CFileSystemUtils.GetFileSysUtils().GetRoots();
            for (int nIdx = 0; nIdx < afRoots.length; ++nIdx) {
                File fRoot = afRoots[nIdx];
                if (!fFile.equals(fRoot)) continue;
                fDrive = fRoot;
                break;
            }
        }
        return fDrive;
    }

    public void DebugPrintFile(File fFile) {
        block4: {
            if (fFile != null) {
                System.out.println("--- File ---");
                System.out.println("Path = " + fFile.getAbsolutePath());
                System.out.println("Exists = " + Boolean.toString(fFile.exists()));
                System.out.println("IsAbsolute = " + Boolean.toString(fFile.isAbsolute()));
                System.out.println("IsDir = " + Boolean.toString(fFile.isDirectory()));
                System.out.println("IsFile = " + Boolean.toString(fFile.isFile()));
                System.out.println("IsHidden = " + Boolean.toString(fFile.isHidden()));
                FileSystemView fsv = FileSystemView.getFileSystemView();
                if (fsv != null) {
                    System.out.println("IsComputerNode = " + Boolean.toString(fsv.isComputerNode(fFile)));
                    System.out.println("IsDrive = " + Boolean.toString(fsv.isDrive(fFile)));
                    System.out.println("IsFileSystem = " + Boolean.toString(fsv.isFileSystem(fFile)));
                    System.out.println("IsFileSystemRoot = " + Boolean.toString(fsv.isFileSystemRoot(fFile)));
                    System.out.println("IsRoot = " + Boolean.toString(fsv.isRoot(fFile)));
                    System.out.println("Display name = " + fsv.getSystemDisplayName(fFile));
                }
                try {
                    System.out.println("Canonical Path = " + fFile.getCanonicalPath());
                }
                catch (Exception e) {
                    if (CMainFrame.GetDebugLogger() == null) break block4;
                    CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to get file's canonical path (%s)", e.getMessage()));
                }
            }
        }
    }

    public boolean IsMac() {
        boolean bIsMac = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("mac os x")) {
            bIsMac = true;
        }
        return bIsMac;
    }

    public boolean IsNIX() {
        boolean bIsNIX = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("linux")) {
            bIsNIX = true;
        }
        return bIsNIX;
    }

    public boolean IsWindows() {
        boolean bIsWindows = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("windows")) {
            bIsWindows = true;
        }
        return bIsWindows;
    }

    public static File GetTempFolder() {
        File fTempFolder = null;
        String sTempDir = System.getProperty("java.io.tmpdir");
        fTempFolder = new File(sTempDir);
        if (fTempFolder == null || !fTempFolder.exists()) {
            File fTemp;
            block4: {
                fTemp = null;
                try {
                    fTemp = File.createTempFile("Temp", ".txt");
                }
                catch (IOException ioe) {
                    if (CMainFrame.GetDebugLogger() == null) break block4;
                    CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to create temp file (%s)", ioe.getMessage()));
                }
            }
            if (fTemp != null && fTemp.exists()) {
                fTempFolder = fTemp.getParentFile();
                fTemp.deleteOnExit();
                fTemp.delete();
            }
        }
        return fTempFolder;
    }

    private String GetLastExistingDir(String sAbsPath, boolean bEnsureLastSlash) {
        String sRet = null;
        String sTest = sAbsPath;
        String[] asDirs = (sTest = CString.MakeForwardSlashes(sTest)).split("/");
        if (asDirs != null) {
            String sAbsNext = "";
            File fAbsNext = null;
            File fAbsPrev = null;
            for (int nIdx = 0; nIdx < asDirs.length; ++nIdx) {
                sAbsNext = sAbsNext + asDirs[nIdx];
                sAbsNext = CString.EnsureLastChar(Character.valueOf(File.separatorChar), sAbsNext);
                fAbsNext = new File(sAbsNext);
                if (!fAbsNext.exists()) {
                    if (fAbsPrev != null && fAbsPrev.exists()) break;
                    if (CMainFrame.GetDebugLogger() != null) {
                        CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, previous java.io.file is invalid");
                    }
                }
                fAbsPrev = fAbsNext;
            }
            if (sRet == null && fAbsPrev != null && fAbsPrev.exists()) {
                sRet = fAbsPrev.getAbsolutePath();
                if (bEnsureLastSlash) {
                    sRet = CString.EnsureLastCharIsAFileSeparator(sRet);
                }
            }
        }
        return sRet;
    }

    public boolean DeleteFile(File fFile) {
        boolean bDeleted = false;
        if (fFile != null && fFile.exists()) {
            if (fFile.isDirectory()) {
                File[] afFiles = fFile.listFiles();
                if (afFiles.length > 0) {
                    File fNext;
                    for (int nIdx = 0; nIdx < afFiles.length && (bDeleted = this.DeleteFile(fNext = afFiles[nIdx])); ++nIdx) {
                    }
                    afFiles = fFile.listFiles();
                }
                if (afFiles.length < 1) {
                    bDeleted = fFile.delete();
                }
            } else {
                bDeleted = fFile.delete();
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, invalid method parms");
        }
        return bDeleted;
    }

    public boolean IsThumbSupported(CPath rPath) {
        String sExt;
        boolean bIsSupported = false;
        if (rPath != null && !rPath.IsDir() && (sExt = CString.GetFileExtension(rPath.GetPath(), rPath.IsDir(), false)) != null) {
            String[] asSupportedExts = new String[]{"jpg", "jpeg", "png", "gif"};
            for (int nIdx = 0; nIdx < asSupportedExts.length; ++nIdx) {
                if (!sExt.equalsIgnoreCase(asSupportedExts[nIdx])) continue;
                bIsSupported = true;
            }
        }
        return bIsSupported;
    }

    public boolean IsMediaSupported(CPath rPath) {
        String sExt;
        boolean bIsSupported = false;
        if (rPath != null && !rPath.IsDir() && (sExt = CString.GetFileExtension(rPath.GetPath(), rPath.IsDir(), false)) != null) {
            String[] asSupportedExts = new String[]{"mp4", "avi", "mov", "mp3", "mpg", "mpeg"};
            for (int nIdx = 0; nIdx < asSupportedExts.length; ++nIdx) {
                if (!sExt.equalsIgnoreCase(asSupportedExts[nIdx])) continue;
                bIsSupported = true;
            }
        }
        return bIsSupported;
    }

    public boolean IsDST(Date dt) {
        boolean bIsDST = false;
        TimeZone tz = TimeZone.getDefault();
        bIsDST = tz.inDaylightTime(dt);
        return bIsDST;
    }

    public boolean UseDST() {
        TimeZone tz = TimeZone.getDefault();
        return tz.useDaylightTime();
    }

    public int GetDSTAmount() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getDSTSavings();
    }

    public Date AdjustToLocal(Date dtGMT, boolean bAdjustDST) {
        Date dtAdjusted = dtGMT;
        if (dtGMT != null) {
            dtAdjusted = new Date(dtGMT.getTime());
            if (dtAdjusted != null && dtAdjusted.getTime() > -1L) {
                int nAmt = this.GetDSTAmount();
                boolean bIsCurDST = this.IsDST(Calendar.getInstance().getTime());
                if (bAdjustDST) {
                    if (!this.IsDST(dtGMT)) {
                        if (bIsCurDST) {
                            dtAdjusted = new Date(dtGMT.getTime() + (long)nAmt);
                        }
                    } else if (!bIsCurDST) {
                        dtAdjusted = new Date(dtGMT.getTime() - (long)nAmt);
                    }
                }
            } else if (CMainFrame.GetDebugLogger() != null) {
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, invalid method parms");
            }
        }
        return dtAdjusted;
    }

    public void ShowURLInBrowser(String sURL) {
        block4: {
            try {
                Desktop.getDesktop().browse(new URL(sURL).toURI());
            }
            catch (IOException ioe) {
                System.err.println("Error in trying to show the URL (" + sURL + ") in the default browser.");
                if (CMainFrame.DEBUG) {
                    ioe.printStackTrace();
                }
            }
            catch (URISyntaxException UriSE) {
                System.err.println("Error in trying to show the URL (" + sURL + ") in the default browser.");
                if (!CMainFrame.DEBUG) break block4;
                UriSE.printStackTrace();
            }
        }
    }

    public void ClearContents(File fFile) {
        block7: {
            FileOutputStream rOutStream = null;
            if (fFile != null && fFile.exists()) {
                block6: {
                    try {
                        rOutStream = new FileOutputStream(fFile);
                    }
                    catch (IOException ioe) {
                        if (!CMainFrame.DEBUG) break block6;
                        System.out.println("ASSERT:  Failed to clear out the response list file.");
                        ioe.printStackTrace();
                    }
                }
                if (rOutStream != null) {
                    try {
                        rOutStream.close();
                    }
                    catch (IOException ioe) {
                        if (!CMainFrame.DEBUG) break block7;
                        System.out.println("ASSERT:  Failed to close the OutputStream.");
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    public File CreateAllDirs(String sAbsDir) {
        File fDir = new File(sAbsDir);
        File fParent = fDir.getParentFile();
        if (fParent == null || !fParent.exists()) {
            fParent = this.CreateAllDirs(fParent.getPath());
        }
        if (fParent != null && fParent.exists() && (fDir == null || !fDir.exists())) {
            File fNewFolder;
            block5: {
                fNewFolder = null;
                try {
                    fNewFolder = FileSystemView.getFileSystemView().createNewFolder(fParent);
                }
                catch (IOException ioe) {
                    if (!CBaseMainFrame.DEBUG) break block5;
                    ioe.printStackTrace();
                }
            }
            if (!fNewFolder.renameTo(fDir)) {
                fNewFolder.delete();
            }
        }
        return fDir;
    }

    public boolean IsRoot(String sAbsPath) {
        File[] afRoots;
        boolean bIsRoot = false;
        if (sAbsPath != null && (afRoots = this.GetRoots()) != null) {
            for (int nIdx = 0; nIdx < afRoots.length && !bIsRoot; ++nIdx) {
                boolean bIsMatch;
                File fNextRoot = afRoots[nIdx];
                if (fNextRoot == null) continue;
                if (DEBUG_TRACE_ROOTS) {
                    System.out.printf("RootFile | Path: %s | DisplayName: %s\r\n", fNextRoot.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fNextRoot));
                }
                File fTemp2 = new File(fNextRoot.getAbsolutePath());
                if (DEBUG_TRACE_ROOTS) {
                    System.out.printf("sAbsPath: %s | fNextRoot: %s | fTemp: %s\r\n", sAbsPath, fNextRoot.getAbsolutePath(), fTemp2.getAbsolutePath());
                }
                if (!(bIsMatch = fNextRoot.getAbsolutePath().endsWith(sAbsPath)) && fTemp2 != null && fTemp2.getAbsolutePath() != null) {
                    bIsMatch = fTemp2.getAbsolutePath().endsWith(sAbsPath);
                }
                if (!bIsMatch) continue;
                boolean bIsUserFolder = false;
                String sUserFolderType = null;
                File fTemp = new File(CMainFrame.GetDiskPathFVJV());
                if (fTemp != null && fTemp.exists()) {
                    sUserFolderType = FileSystemView.getFileSystemView().getSystemTypeDescription(fTemp);
                } else if (CMainFrame.DEBUG) {
                    System.out.println("ASSERT:  Programming error, file is null");
                }
                String sRootFolderType = FileSystemView.getFileSystemView().getSystemTypeDescription(fNextRoot);
                if (sUserFolderType != null && sRootFolderType != null && !sUserFolderType.isEmpty() && sUserFolderType.equals(sRootFolderType)) {
                    bIsUserFolder = true;
                }
                if (CPath.IsWindowsLink(sAbsPath) || bIsUserFolder) continue;
                bIsRoot = true;
            }
        }
        return bIsRoot;
    }

    public File GetRoot(String sAbsPath) {
        File[] afRoots;
        File fRet = null;
        if (sAbsPath != null && (afRoots = this.GetRoots()) != null) {
            for (int nIdx = 0; nIdx < afRoots.length && fRet == null; ++nIdx) {
                boolean bIsMatch;
                File fRoot = afRoots[nIdx];
                if (fRoot == null) continue;
                if (DEBUG_TRACE_ROOTS) {
                    System.out.printf("RootFile | Path: %s | DisplayName: %s\r\n", fRoot.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fRoot));
                }
                File fTemp2 = new File(fRoot.getAbsolutePath());
                if (DEBUG_TRACE_ROOTS) {
                    System.out.printf("sAbsPath: %s | fNextRoot: %s | fTemp: %s\r\n", sAbsPath, fRoot.getAbsolutePath(), fTemp2.getAbsolutePath());
                }
                if (!(bIsMatch = fRoot.getAbsolutePath().endsWith(sAbsPath)) && fTemp2 != null && fTemp2.getAbsolutePath() != null) {
                    bIsMatch = fTemp2.getAbsolutePath().endsWith(sAbsPath);
                }
                if (!bIsMatch) continue;
                fRet = fRoot;
            }
        }
        return fRet;
    }

    private synchronized File CheckSpecialFile(File fFile) {
        File fRet = null;
        if (fFile != null) {
            fRet = this.IsRoot(fFile.getAbsolutePath()) ? this.GetRoot(fFile.getAbsolutePath()) : fFile;
        }
        return fRet;
    }

    public File GetJavaFile(String sAbsPath) {
        File fRet = null;
        if (sAbsPath != null) {
            fRet = this.CheckSpecialFile(new File(sAbsPath));
        }
        return fRet;
    }

    public File GetCanonicalFile(File fFile) {
        File fCanonical = null;
        try {
            fCanonical = fFile.getCanonicalFile();
        }
        catch (IOException e) {
            fCanonical = fFile;
        }
        return fCanonical;
    }

    private File GetShellFile(File fFile) {
        File fShellFile;
        block2: {
            fShellFile = this.GetCanonicalFile(fFile);
            try {
                fShellFile = this.GetUseShellFolders() ? ShellFolder.getShellFolder(fShellFile) : fShellFile;
            }
            catch (FileNotFoundException fnfe) {
                if (CMainFrame.GetDebugLogger() == null) break block2;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to get shell folder (%s)", fnfe.getMessage()));
            }
        }
        return fShellFile;
    }

    public File GetFileFromDir(File fFromDir, String sAbsFilePath) {
        File fFoundFile = null;
        if (fFromDir != null && sAbsFilePath != null) {
            File[] faFiles;
            String sAbsTest = sAbsFilePath;
            sAbsTest = CString.MakeBackSlashes(sAbsTest);
            sAbsTest = CString.EnsureLastCharIsNotABackSlash(sAbsTest);
            for (File fNextFile : faFiles = fFromDir.listFiles()) {
                if (fNextFile == null) continue;
                String sAbsSubFilePath = fNextFile.getAbsolutePath();
                sAbsSubFilePath = CString.MakeBackSlashes(sAbsSubFilePath);
                if (!sAbsTest.equals(sAbsSubFilePath = CString.EnsureLastCharIsNotABackSlash(sAbsSubFilePath))) continue;
                fFoundFile = fNextFile;
                break;
            }
        }
        return fFoundFile;
    }

    public String GetParentPath(String sAbsDir) {
        String sAbsParent = null;
        if (sAbsDir != null && !sAbsDir.isEmpty()) {
            File fHomeDir;
            sAbsParent = CString.GetFilePath(sAbsDir, true);
            File fChild = new File(sAbsDir);
            FileSystemView fsv = FileSystemView.getFileSystemView();
            if (fsv != null && (fHomeDir = fsv.getHomeDirectory()) != null) {
                if (!fHomeDir.getAbsolutePath().equals(fChild.getAbsolutePath())) {
                    if (fsv.isDrive(fChild)) {
                        File fParent = this.GetJavaFile(COMPUTER_ID);
                        if (fParent != null) {
                            sAbsParent = fParent.getAbsolutePath();
                        }
                    } else if (this.IsRoot(sAbsDir)) {
                        sAbsParent = fHomeDir.getAbsolutePath();
                    }
                } else {
                    sAbsParent = null;
                }
            }
        }
        return sAbsParent;
    }

    public Image IconToImage(Icon icon) {
        Image rRet = null;
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                rRet = ((ImageIcon)icon).getImage();
            } else {
                BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g2 = image.createGraphics();
                icon.paintIcon(new JLabel(), g2, 0, 0);
                g2.dispose();
                rRet = image;
            }
        }
        return rRet;
    }

    private Icon GetJavaFileIcon(File fFile, boolean b32x32) {
        Icon icoRet = this.GetJavaFileIcon(fFile);
        if (fFile != null) {
            File fTemp;
            if (FileSystemView.getFileSystemView().isDrive(fFile) && (fTemp = CFileSystemUtils.GetDrive(fFile.getAbsolutePath())) != null) {
                fFile = fTemp;
            }
            if (fFile.exists()) {
                if (this.GetUseShellFolders()) {
                    if ((fFile = this.GetShellFile(fFile)) != null && fFile instanceof ShellFolder) {
                        ShellFolder fShellFile = (ShellFolder)fFile;
                        if (fShellFile.getIcon(true) != null) {
                            icoRet = new ImageIcon(fShellFile.getIcon(b32x32));
                        } else if (DEBUG_JAVA_FILE_ICONS) {
                            CMainFrame.Info("ASSERT:  Programming error, rShellFile.getIcon(true) = null");
                        }
                    }
                } else if (b32x32) {
                    icoRet = this.GetScaledIcon(icoRet, 32, 32);
                }
            }
        }
        return icoRet;
    }

    private Icon GetJavaFileIcon(File rFile) {
        Icon icoRet;
        block7: {
            icoRet = null;
            if (rFile != null && rFile.exists()) {
                if (this.IsMac()) {
                    JFileChooser FileChooser = this.GetFileChooser(null);
                    icoRet = FileChooser.getIcon(rFile);
                    FileChooser = null;
                } else {
                    Icon icoTemp = FileSystemView.getFileSystemView().getSystemIcon(rFile);
                    if (icoTemp != null) {
                        icoRet = icoTemp;
                        if (!(icoTemp instanceof Icon)) {
                            try {
                                BufferedImage bufferedImg = new BufferedImage(icoTemp.getIconWidth(), icoTemp.getIconHeight(), 2);
                                icoTemp.paintIcon(new JLabel(), bufferedImg.createGraphics(), 0, 0);
                                icoRet = new ImageIcon(bufferedImg);
                            }
                            catch (ClassCastException cce) {
                                if (!CMainFrame.DEBUG) break block7;
                                cce.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return icoRet;
    }

    private Icon GetScaledIcon(Icon icoFileIcon, int nWidth, int nHeight) {
        Icon icoRet = icoFileIcon;
        if (icoFileIcon != null && (icoFileIcon.getIconWidth() != nWidth || icoFileIcon.getIconHeight() != nHeight)) {
            Image rImage = this.IconToImage(icoFileIcon);
            this.m_MediaTracker.addImage(rImage, 1);
            this.m_MediaTracker.checkID(1, true);
            try {
                this.m_MediaTracker.waitForID(1);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!this.m_MediaTracker.isErrorAny()) {
                Image rScaledImage = CUtils.CreateScaledImage(null, rImage, nWidth, nHeight, CUtils.SCALE_OPTION.FIT_TO_TARGET);
                icoRet = new ImageIcon(rScaledImage);
            }
            this.m_MediaTracker.removeImage(rImage, 1);
        }
        return icoRet;
    }

    private JFileChooser GetFileChooser(FileSystemView rFSV) {
        JFileChooser rFileChooser;
        block4: {
            rFileChooser = null;
            try {
                rFileChooser = rFSV != null ? new JFileChooser(rFSV) : new JFileChooser();
            }
            catch (Exception rFileChooserException) {
                LookAndFeel rCurLookAndFeel = null;
                try {
                    rCurLookAndFeel = UIManager.getLookAndFeel();
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    rFileChooser = rFSV != null ? new JFileChooser(rFSV) : new JFileChooser();
                    UIManager.setLookAndFeel(rCurLookAndFeel);
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block4;
                    rFileChooserException.printStackTrace();
                }
            }
        }
        return rFileChooser;
    }

    public boolean Copy(File fFrom, File fTo) {
        return this.Copy(fFrom, fTo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Copy(File fFrom, File fTo, String[] asExclude) {
        boolean bCopied = false;
        if (fFrom != null && fFrom.exists() && fTo != null) {
            int nIdx;
            boolean bExcluded = false;
            if (asExclude != null) {
                String sTestPath = fFrom.getAbsolutePath();
                sTestPath = CString.EnsureLastCharIsNotASlash(sTestPath);
                for (nIdx = 0; nIdx < asExclude.length; ++nIdx) {
                    String sExcludedPath = asExclude[nIdx];
                    if (sExcludedPath == null || !(sExcludedPath = CString.EnsureLastCharIsNotASlash(sExcludedPath)).equals(sTestPath)) continue;
                    bExcluded = true;
                    break;
                }
            }
            if (!bExcluded) {
                block47: {
                    if (!fTo.exists()) {
                        try {
                            if (fFrom.isDirectory()) {
                                fTo.mkdir();
                            } else {
                                fTo.createNewFile();
                            }
                        }
                        catch (IOException ioe) {
                            if (CMainFrame.DEBUG) {
                                ioe.printStackTrace();
                            }
                        }
                        catch (SecurityException se) {
                            if (!CMainFrame.DEBUG) break block47;
                            se.printStackTrace();
                        }
                    }
                }
                if (fTo.exists()) {
                    if (fFrom.isDirectory()) {
                        bCopied = true;
                        File[] afChildren = fFrom.listFiles();
                        for (nIdx = 0; nIdx < afChildren.length; ++nIdx) {
                            File fToChild;
                            boolean bCopied1;
                            File fNextChild = afChildren[nIdx];
                            if (fNextChild == null || !fNextChild.exists()) continue;
                            StringBuilder sPath = new StringBuilder(fNextChild.getAbsolutePath());
                            sPath = sPath.delete(0, fFrom.getAbsolutePath().length());
                            if (fNextChild.isDirectory()) {
                                sPath = CString.EnsureLastCharIsAFileSeparator(sPath);
                                sPath = CString.EnsureNotFirstChar(Character.valueOf(File.separatorChar), sPath);
                            }
                            String sToChild = fTo.getAbsolutePath();
                            if (fNextChild.isDirectory()) {
                                sToChild = CString.EnsureLastCharIsAFileSeparator(sToChild);
                            }
                            if (bCopied1 = this.Copy(afChildren[nIdx], fToChild = new File(sToChild = sToChild + sPath), asExclude)) continue;
                            bCopied = false;
                        }
                    } else {
                        FileInputStream rInStream = null;
                        FileOutputStream rOutStream = null;
                        try {
                            long nTotalRead;
                            rInStream = new FileInputStream(fFrom);
                            rOutStream = new FileOutputStream(fTo);
                            byte[] aReadBuf = new byte[0x100000];
                            long nLen = fFrom.length();
                            int nRead = 0;
                            for (nTotalRead = 0L; nTotalRead < nLen; nTotalRead += (long)nRead) {
                                nRead = rInStream.read(aReadBuf);
                                rOutStream.write(aReadBuf, 0, nRead);
                            }
                            if (nTotalRead == nLen) {
                                bCopied = true;
                            }
                        }
                        catch (FileNotFoundException fnfe) {
                            if (CMainFrame.DEBUG) {
                                System.out.println(String.format("EXCEPTION:  We couldn't find the file that the Streams are trying to connect to. (%s)", fnfe.getMessage()));
                            }
                        }
                        catch (IOException ioe) {
                            if (CMainFrame.DEBUG) {
                                System.out.println(String.format("EXCEPTION:  EXCEPTION:  We couldn't read or write to the streams. (%s)", ioe.getMessage()));
                            }
                        }
                        finally {
                            if (rInStream != null) {
                                try {
                                    rInStream.close();
                                }
                                catch (IOException ioe) {
                                    ioe.printStackTrace();
                                }
                            }
                            if (rOutStream != null) {
                                try {
                                    rOutStream.close();
                                }
                                catch (IOException ioe) {
                                    ioe.printStackTrace();
                                }
                            }
                        }
                        fTo.setLastModified(fFrom.lastModified());
                        fTo.setWritable(fFrom.canWrite());
                        fTo.setReadable(fFrom.canRead());
                    }
                }
            } else {
                bCopied = true;
            }
        }
        return bCopied;
    }

    private Object[] ReadRegistry(HKEY rHKey, HKEY_TYPE rKeyType, String sKeyPath, String sKeyName) {
        String sValue;
        int nRetCode;
        block16: {
            nRetCode = 0;
            sValue = null;
            if (this.IsWindows() && rHKey != null && rKeyType != null && sKeyPath != null && !sKeyPath.isEmpty() && sKeyName != null && !sKeyName.isEmpty()) {
                String sAbsKeyPath = rHKey.GetHKey();
                sAbsKeyPath = CString.EnsureLastCharIsABackSlash(sAbsKeyPath);
                sAbsKeyPath = sAbsKeyPath + sKeyPath;
                sAbsKeyPath = CString.MakeBackSlashes(sAbsKeyPath);
                try {
                    String sOutput;
                    StringBuilder sbQueryResult;
                    block15: {
                        String sQuery = String.format("reg query \"%s\" /v \"%s\"", sAbsKeyPath, sKeyName);
                        Process rProcess = Runtime.getRuntime().exec(sQuery);
                        InputStream rInputStream = rProcess.getInputStream();
                        sbQueryResult = new StringBuilder();
                        try {
                            int nChar = -1;
                            while ((nChar = rInputStream.read()) != -1) {
                                sbQueryResult.append((char)nChar);
                            }
                        }
                        catch (IOException e) {
                            if (!DEBUG) break block15;
                            e.printStackTrace();
                        }
                    }
                    if ((sOutput = sbQueryResult.toString()) != null) {
                        if (!(sOutput = sOutput.trim()).isEmpty()) {
                            String sType;
                            if (DEBUG) {
                                System.out.println(sOutput);
                            }
                            if ((sType = rKeyType.GetType()) != null && !sType.isEmpty()) {
                                int nFound = sOutput.indexOf(sType);
                                if (nFound > -1) {
                                    sValue = sOutput.substring(nFound += sType.length());
                                    sValue = sValue.trim();
                                } else {
                                    nRetCode = 2;
                                }
                            } else {
                                nRetCode = 2;
                            }
                        } else {
                            nRetCode = 2;
                        }
                        break block16;
                    }
                    nRetCode = 2;
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    break block16;
                }
            }
            nRetCode = 1;
        }
        Object[] aRetVals = new Object[]{nRetCode, sValue};
        return aRetVals;
    }

    public final String ReadRegistry(HKEY rHKey, String sKeyPath, String sKeyName, String sDefValue) {
        String sRegistryValue = null;
        HKEY_TYPE[] aTypes = new HKEY_TYPE[]{HKEY_TYPE.REG_SZ, HKEY_TYPE.REG_MULTI_SZ, HKEY_TYPE.REG_EXPAND_SZ, HKEY_TYPE.REG_BINARY};
        for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
            Object[] aRetVals = this.ReadRegistry(rHKey, aTypes[nIdx], sKeyPath, sKeyName);
            if (aRetVals == null || aRetVals.length != 2) continue;
            try {
                Integer nRetCode = (Integer)aRetVals[0];
                if (nRetCode == null || nRetCode != 0) continue;
                sRegistryValue = (String)aRetVals[1];
                break;
            }
            catch (Exception e) {
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (sRegistryValue == null || sRegistryValue.isEmpty()) {
            sRegistryValue = sDefValue;
        }
        return sRegistryValue;
    }

    public final long ReadRegistry(HKEY rHKey, String sKeyPath, String sKeyName, long lDefValue) {
        long lValue;
        block7: {
            lValue = lDefValue;
            String sRegistryValue = null;
            HKEY_TYPE[] aTypes = new HKEY_TYPE[]{HKEY_TYPE.REG_DWORD, HKEY_TYPE.REG_QWORD};
            for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
                Object[] aRetVals = this.ReadRegistry(rHKey, aTypes[nIdx], sKeyPath, sKeyName);
                if (aRetVals == null || aRetVals.length != 2) continue;
                try {
                    Integer nRetCode = (Integer)aRetVals[0];
                    if (nRetCode == null || nRetCode != 0) continue;
                    sRegistryValue = (String)aRetVals[1];
                    break;
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    e.printStackTrace();
                }
            }
            if (sRegistryValue != null && !sRegistryValue.isEmpty()) {
                try {
                    Long lVal = Long.decode(sRegistryValue);
                    if (lVal != null) {
                        lValue = lVal;
                    }
                }
                catch (Exception e) {
                    lValue = lDefValue;
                    if (!DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
        return lValue;
    }

    public final Color ReadRegistryColor(HKEY rHKey, String sKeyPath, String sKeyName, Color rDefValue) {
        Color clrValue = rDefValue;
        String sRegistryValue = null;
        HKEY_TYPE rFoundType = null;
        HKEY_TYPE[] aTypes = new HKEY_TYPE[]{HKEY_TYPE.REG_BINARY, HKEY_TYPE.REG_DWORD, HKEY_TYPE.REG_QWORD};
        for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
            Object[] aRetVals = this.ReadRegistry(rHKey, aTypes[nIdx], sKeyPath, sKeyName);
            if (aRetVals == null || aRetVals.length != 2) continue;
            try {
                Integer nRetCode = (Integer)aRetVals[0];
                if (nRetCode == null || nRetCode != 0) continue;
                sRegistryValue = (String)aRetVals[1];
                rFoundType = aTypes[nIdx];
                break;
            }
            catch (Exception e) {
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (rFoundType != null && sRegistryValue != null && !sRegistryValue.isEmpty()) {
            int nBlue;
            int nGreen;
            int nRed;
            block11: {
                int nValue;
                block12: {
                    nRed = rDefValue.getRed();
                    nGreen = rDefValue.getGreen();
                    nBlue = rDefValue.getBlue();
                    nValue = rDefValue.getRed() | rDefValue.getGreen() << 8 | rDefValue.getBlue() << 16;
                    if (rFoundType == HKEY_TYPE.REG_BINARY) {
                        String sHex = sRegistryValue;
                        try {
                            nRed = Integer.parseInt(sHex.substring(0, 2), 16);
                            nGreen = Integer.parseInt(sHex.substring(2, 4), 16);
                            nBlue = Integer.parseInt(sHex.substring(4, 6), 16);
                        }
                        catch (Exception e) {
                            nRed = rDefValue.getRed();
                            nGreen = rDefValue.getGreen();
                            nBlue = rDefValue.getBlue();
                            if (DEBUG) {
                                e.printStackTrace();
                            }
                            break block11;
                        }
                    }
                    nValue = rDefValue.getRed() | rDefValue.getGreen() << 8 | rDefValue.getBlue() << 16;
                    try {
                        Integer nValObj = Integer.decode(sRegistryValue);
                        if (nValObj != null) {
                            nValue = nValObj;
                        }
                    }
                    catch (Exception e) {
                        nValue = rDefValue.getRed() | rDefValue.getGreen() << 8 | rDefValue.getBlue() << 16;
                        if (!DEBUG) break block12;
                        e.printStackTrace();
                    }
                }
                nRed = nValue & 0xFF;
                nGreen = (nValue & 0xFF00) >> 8;
                nBlue = (nValue & 0xFF0000) >> 16;
            }
            clrValue = new Color(nRed, nGreen, nBlue);
        }
        return clrValue;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_ROOTS = false;
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_VIRTUALS = false;
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_JAVA_FILE_ICONS = false;
    }

    public static enum HKEY_TYPE {
        REG_BINARY("REG_BINARY"),
        REG_DWORD("REG_DWORD"),
        REG_QWORD("REG_QWORD"),
        REG_SZ("REG_SZ"),
        REG_EXPAND_SZ("REG_EXPAND_SZ"),
        REG_MULTI_SZ("REG_MULTI_SZ");

        private String m_sType;

        private HKEY_TYPE(String sType) {
            this.m_sType = sType;
        }

        public final String GetType() {
            return this.m_sType;
        }
    }

    public static enum HKEY {
        HKEY_CURRENT_USER("HKCU"),
        HKEY_LOCAL_MACHINE("HKLM");

        private String m_sHKey;

        private HKEY(String sHKey) {
            this.m_sHKey = sHKey;
        }

        public final String GetHKey() {
            return this.m_sHKey;
        }
    }
}

