/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Color;

public class CConversionUtils {
    public static boolean IsValidInt(int nVal) {
        return nVal != Integer.MIN_VALUE;
    }

    public static int ConvertToInt(Object jValue) {
        int nVal;
        block5: {
            nVal = Integer.MIN_VALUE;
            try {
                if (jValue instanceof Integer) {
                    nVal = (Integer)jValue;
                } else if (jValue instanceof String) {
                    nVal = Integer.parseInt((String)jValue);
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block5;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to convert object to int (%s)", e.getMessage()));
            }
        }
        return nVal;
    }

    public static boolean IsValidLong(long nVal) {
        return nVal != Long.MIN_VALUE;
    }

    public static long ConvertToLong(Object rValue) {
        Long nVal;
        block5: {
            nVal = Long.MIN_VALUE;
            try {
                if (rValue instanceof Long) {
                    nVal = (long)((Long)rValue);
                } else if (rValue instanceof String) {
                    nVal = Long.parseLong((String)rValue);
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block5;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to convert object to Long (%s)", e.getMessage()));
            }
        }
        return nVal;
    }

    public static boolean IsValidFloat(float fVal) {
        return fVal != Float.NaN;
    }

    public static float ConvertToFloat(Object rValue) {
        Float fVal;
        block5: {
            fVal = Float.valueOf(Float.NaN);
            try {
                if (rValue instanceof Float) {
                    fVal = Float.valueOf(((Float)rValue).floatValue());
                } else if (rValue instanceof String) {
                    fVal = Float.valueOf(Float.parseFloat((String)rValue));
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block5;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to convert object to Float (%s)", e.getMessage()));
            }
        }
        return fVal.floatValue();
    }

    public static String ConvertToString(Object jValue) {
        String sVal = null;
        if (jValue instanceof String) {
            sVal = (String)jValue;
        } else if (jValue instanceof Integer) {
            sVal = Integer.toString((Integer)jValue);
        }
        return sVal;
    }

    public static Boolean ConvertToBool(Object jValue) {
        Boolean bVal;
        block5: {
            bVal = null;
            try {
                if (jValue instanceof Boolean) {
                    bVal = (Boolean)jValue;
                } else if (jValue instanceof String) {
                    bVal = Boolean.parseBoolean((String)jValue);
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block5;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to convert object to Bool (%s)", e.getMessage()));
            }
        }
        return bVal;
    }

    public static Color ConvertToColor(Object jValue) {
        Color clrVal;
        block7: {
            clrVal = null;
            try {
                if (jValue instanceof String) {
                    String sValue = (String)jValue;
                    String[] sClrs = sValue.split(",");
                    if (sClrs.length == 3) {
                        String sRed = sClrs[0];
                        String sGreen = sClrs[1];
                        String sBlue = sClrs[2];
                        int nRed = CConversionUtils.ConvertToInt(sRed.trim());
                        int nGreen = CConversionUtils.ConvertToInt(sGreen.trim());
                        int nBlue = CConversionUtils.ConvertToInt(sBlue.trim());
                        if (CConversionUtils.IsValidInt(nRed) && CConversionUtils.IsValidInt(nGreen) && CConversionUtils.IsValidInt(nBlue)) {
                            clrVal = new Color(nRed, nGreen, nBlue);
                        }
                    }
                } else if (jValue instanceof Color) {
                    clrVal = (Color)jValue;
                }
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() == null) break block7;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  failed to convert object to Color (%s)", e.getMessage()));
            }
        }
        return clrVal;
    }
}

