/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.TransferPanel;

import com.rhinosoft.TransferPanel.CTransferRow;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersExecute;
import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;

public class CTransferTableModel
extends AbstractTableModel
implements ActionListener {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final int MAX_COLS = 7;
    public static final int COL_THREAD_STATUS = 0;
    public static final int COL_NAME = 1;
    public static final int COL_STATUS = 2;
    public static final int COL_COMPLETION = 3;
    public static final int COL_OVERALL = 4;
    public static final int COL_PATH_FROM = 5;
    public static final int COL_PATH_TO = 6;
    public static final int TIMER_INITIAL_DELAY = 0;
    public static final int TIMER_DELAY = 250;
    private String[] m_asColHeaders;
    private Vector<CTransferRow> m_arRows = new Vector();
    private Timer m_Timer;

    public CTransferTableModel() {
        this.m_asColHeaders = new String[7];
        this.m_asColHeaders[0] = CString.LoadString("IDS_TABLE_HEADER_THREAD_STATUS");
        this.m_asColHeaders[1] = CString.LoadString("IDS_TABLE_HEADER_NAME");
        this.m_asColHeaders[2] = CString.LoadString("IDS_TABLE_HEADER_STATUS");
        this.m_asColHeaders[3] = CString.LoadString("IDS_TABLE_HEADER_COMPLETION");
        this.m_asColHeaders[4] = CString.LoadString("IDS_TABLE_HEADER_OVERALL");
        this.m_asColHeaders[5] = CString.LoadString("IDS_TABLE_HEADER_PATH_FROM");
        this.m_asColHeaders[6] = CString.LoadString("IDS_TABLE_HEADER_PATH_TO");
        this.m_Timer = new Timer(250, this);
        this.StartTimer(false);
    }

    public void finalize() throws Throwable {
        this.StopTimer();
        super.finalize();
    }

    private void StartTimer(boolean bRestart) {
        if (bRestart) {
            this.m_Timer.restart();
        } else if (!this.m_Timer.isRunning()) {
            this.m_Timer.start();
        }
    }

    private void StopTimer() {
        if (this.m_Timer.isRunning()) {
            this.m_Timer.stop();
        }
    }

    @Override
    public int getRowCount() {
        int nSize = -1;
        if (this.m_arRows != null) {
            nSize = this.m_arRows.size();
        }
        return nSize;
    }

    @Override
    public int getColumnCount() {
        int nSize = -1;
        if (this.m_asColHeaders != null) {
            nSize = this.m_asColHeaders.length;
        }
        return nSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.m_asColHeaders[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<String> cRetClass = String.class;
        return cRetClass;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public CTransferRow GetRowObj(int nRowIdx) {
        CTransferRow objRet = null;
        if (this.m_arRows != null && nRowIdx > -1 && nRowIdx < this.m_arRows.size()) {
            objRet = this.m_arRows.get(nRowIdx);
        }
        return objRet;
    }

    public CTransferRow GetRowObj(Thread tThread) {
        return this.GetRowObj(this.GetRowIdx(tThread));
    }

    public int GetRowIdx(Thread tThread) {
        int nRowIdx = -1;
        if (tThread != null && this.m_arRows != null) {
            for (int nIdx = 0; nIdx < this.m_arRows.size(); ++nIdx) {
                CTransferRow rNextRow;
                CTransferRow RowObj = this.m_arRows.get(nIdx);
                if (!(RowObj instanceof CTransferRow) || (rNextRow = RowObj) == null || rNextRow.GetThread() == null || rNextRow.GetThread().getId() != tThread.getId()) continue;
                nRowIdx = nIdx;
                break;
            }
        }
        return nRowIdx;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object objRet = null;
        CTransferRow rRow = this.GetRowObj(rowIndex);
        if (rRow != null) {
            if (columnIndex == 0) {
                objRet = rRow.GetThreadStatus();
            } else if (columnIndex == 1) {
                objRet = rRow.GetDisplayName();
            } else if (columnIndex == 2) {
                objRet = rRow.FormatStatusTxt();
            } else if (columnIndex == 3) {
                objRet = rRow.FormatCompletionTxt();
            } else if (columnIndex == 4) {
                objRet = rRow.FormatOverallTxt();
            } else if (columnIndex == 5) {
                objRet = rRow.GetFromPath();
            } else if (columnIndex == 6) {
                objRet = rRow.GetToPath();
            }
        }
        return objRet;
    }

    public void AddRow(CTransferRow rRowObj) {
        if (rRowObj != null) {
            CTransferRow rExists = this.GetRowObj(rRowObj.GetThread());
            if (rExists == null) {
                CTransferRow rCreateRow = rRowObj;
                if (this.m_arRows != null) {
                    this.m_arRows.add(rCreateRow);
                    int nAddedRow = this.m_arRows.size() - 1;
                    this.fireTableRowsInserted(nAddedRow, nAddedRow);
                } else if (DEBUG) {
                    throw new NullPointerException("ASSERT:  programming error, unexpected null ptr");
                }
            } else {
                rExists.SetThreadStatus(1);
            }
        } else if (DEBUG) {
            throw new NullPointerException("ASSERT:  programming error, unexpected null ptr");
        }
    }

    public void RemoveRows(int[] anRows) {
        if (anRows != null) {
            for (int nIdx = anRows.length - 1; nIdx >= 0; --nIdx) {
                int nRow = anRows[nIdx];
                CTransferRow rObj = this.GetRowObj(nRow);
                if (rObj instanceof CTransferRow) {
                    CTransferRow rRow = rObj;
                    this.RemoveRow(rRow.GetThread(), false);
                    continue;
                }
                if (CMainFrame.GetDebugLogger() == null) continue;
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, unexpect object type");
            }
            this.fireTableDataChanged();
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, anRows = null");
        }
    }

    public void RemoveRow(Thread tThread, boolean bFireEvent) {
        int nRowIdx;
        if (this.m_arRows != null && (nRowIdx = this.GetRowIdx(tThread)) > -1 && nRowIdx < this.getRowCount()) {
            CWorkerThread tWorkerThread;
            boolean bCanRemove = true;
            if (tThread != null && tThread instanceof CWorkerThread && (tWorkerThread = (CWorkerThread)tThread).IsProcessingJob()) {
                bCanRemove = false;
            }
            if (bCanRemove) {
                CTransferRow rRow = this.GetTransferRow(tThread.getId());
                if (rRow != null) {
                    rRow.Clear();
                }
                this.m_arRows.remove(nRowIdx);
                if (bFireEvent) {
                    this.fireTableRowsDeleted(nRowIdx, nRowIdx);
                }
            }
        }
    }

    public void AddTransferRow(CTransferRow rTransferRow) {
        if (rTransferRow != null) {
            this.AddRow(rTransferRow);
        }
    }

    public void OnTransferStats(CThreadMsgTransfer rThreadMsg) {
        if (rThreadMsg != null) {
            CTransferRow rRow = this.GetRowObj(rThreadMsg.GetThread());
            if (rRow != null) {
                rRow.SetThreadStatus(1);
                if (rRow.UpdateData(rThreadMsg)) {
                    // empty if block
                }
            }
            if ((rThreadMsg.GetStopAtNextItem() || rThreadMsg.GetStop()) && rRow != null) {
                rRow.SetThreadStatus(2);
            }
        }
    }

    public void OnTransferDone(CThreadMsgTransfer rThreadMsg) {
        if (rThreadMsg != null) {
            this.OnTransferStats(rThreadMsg);
            if (rThreadMsg.GetPathIndex() >= rThreadMsg.GetFromPathSize() - 1 && this.GetRemoveRowAfterTransfer()) {
                this.RemoveRow(rThreadMsg.GetThread(), true);
            }
        }
    }

    private boolean GetRemoveRowAfterTransfer() {
        IArchive rArchive;
        Boolean bVal;
        boolean bRemoveRow = false;
        if (CMainFrame.GET_APP() != null && (bVal = (rArchive = CMainFrame.GET_APP().GetArchive()).GetValueBool("TransferRemoveDone", false)) != null) {
            bRemoveRow = bVal;
        }
        return bRemoveRow;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.m_Timer) {
            for (int nIdx = 0; nIdx < this.getRowCount(); ++nIdx) {
                CTransferRow rRow = this.GetRowObj(nIdx);
                if (rRow == null || !rRow.HasChanged()) continue;
                this.fireTableRowsUpdated(nIdx, nIdx);
            }
        }
    }

    public void CancelTransfers(int[] anRows) {
        long[] alThreadIDs;
        if (anRows != null && (alThreadIDs = this.GetThreadIDs(anRows)) != null) {
            for (int nIdx = alThreadIDs.length - 1; nIdx >= 0; --nIdx) {
                long lThreadID = alThreadIDs[nIdx];
                CTransferRow rTransferRow = this.GetTransferRow(lThreadID);
                if (rTransferRow == null) continue;
                rTransferRow.CancelTransfer();
            }
        }
    }

    private long[] GetThreadIDs(int[] anRows) {
        long[] alThreadIDs = null;
        if (anRows != null) {
            alThreadIDs = new long[anRows.length];
            for (int nIdx = 0; nIdx < anRows.length; ++nIdx) {
                int nRow = anRows[nIdx];
                alThreadIDs[nIdx] = this.GetThreadID(nRow);
            }
        }
        return alThreadIDs;
    }

    private long GetThreadID(int nRow) {
        long lThreadID = -1L;
        CTransferRow rTransferRow = this.GetRowObj(nRow);
        if (rTransferRow != null && rTransferRow.GetThread() != null) {
            lThreadID = rTransferRow.GetThread().getId();
        }
        return lThreadID;
    }

    private CTransferRow GetTransferRow(long lThreadID) {
        CTransferRow rTransferRow = null;
        for (int nIdx = 0; nIdx < this.getRowCount() && rTransferRow == null; ++nIdx) {
            CTransferRow rRow = this.GetRowObj(nIdx);
            if (rRow == null || rRow.GetThread() == null || rRow.GetThread().getId() != lThreadID) continue;
            rTransferRow = rRow;
        }
        return rTransferRow;
    }

    public void ProcessNextItem(int[] anRows) {
        if (anRows != null) {
            for (int nIdx = 0; nIdx < anRows.length; ++nIdx) {
                int nRow = anRows[nIdx];
                CTransferRow rTransferRow = this.GetRowObj(nRow);
                if (rTransferRow == null) continue;
                rTransferRow.ProcessNextItem();
            }
        }
    }

    public void StopProcessing(int[] anRows) {
        if (anRows != null) {
            for (int nIdx = 0; nIdx < anRows.length; ++nIdx) {
                int nRow = anRows[nIdx];
                CTransferRow rTransferRow = this.GetRowObj(nRow);
                if (rTransferRow == null) continue;
                rTransferRow.StopProcessing();
            }
        }
    }

    public void ResumeProcessing(int[] anRows) {
        if (anRows != null) {
            for (int nIdx = 0; nIdx < anRows.length; ++nIdx) {
                int nRow = anRows[nIdx];
                CTransferRow rTransferRow = this.GetRowObj(nRow);
                if (rTransferRow == null) continue;
                rTransferRow.ResumeProcessing();
            }
        }
    }

    public void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 3005: {
                    CTransferRow rRow;
                    CThreadMsgTransfer rThreadMsg;
                    if (!(rEvent.GetEventObj() instanceof CThreadMsgTransfer) || (rThreadMsg = (CThreadMsgTransfer)rEvent.GetEventObj()).GetThread() == null || (rRow = this.GetRowObj(rThreadMsg.GetThread())) == null) break;
                    rRow.processEvent(event);
                    break;
                }
                case 3021: {
                    CTransferRow rRow;
                    CThreadMsgTransfer rThreadMsg;
                    if (!(rEvent.GetEventObj() instanceof CThreadMsgTransfer) || (rThreadMsg = (CThreadMsgTransfer)rEvent.GetEventObj()).GetThread() == null || (rRow = this.GetRowObj(rThreadMsg.GetThread())) == null) break;
                    rRow.processEvent(event);
                    break;
                }
                case 3020: 
                case 3022: {
                    CTransferRow rRow;
                    if (!(rEvent.GetEventObj() instanceof CThreadMsgTransfer)) break;
                    CThreadMsgTransfer rThreadMsg = (CThreadMsgTransfer)rEvent.GetEventObj();
                    if (rThreadMsg.GetThread() != null && (rRow = this.GetRowObj(rThreadMsg.GetThread())) != null) {
                        rRow.processEvent(event);
                    }
                    if (!this.GetRemoveRowAfterTransfer()) break;
                    this.RemoveRow(rThreadMsg.GetThread(), true);
                    break;
                }
                case 2902: {
                    CTransferRow rRow;
                    CThreadMsgTransfer rThreadMsg;
                    if (!(rEvent.GetEventObj() instanceof CThreadMsgTransfer) || (rThreadMsg = (CThreadMsgTransfer)rEvent.GetEventObj()).GetThread() == null || (rRow = this.GetRowObj(rThreadMsg.GetThread())) == null) break;
                    rRow.processEvent(event);
                    break;
                }
            }
        }
    }

    public void OnStopAtNextFile(int nRow) {
        CTransferRow rTransferRow = this.GetRowObj(nRow);
        if (rTransferRow != null) {
            rTransferRow.OnStopAtNextFile();
        }
    }

    public void OnRecvSkipItem(CThreadMsgTransfer rThreadMsg) {
        CTransferRow rRow = this.GetRowObj(rThreadMsg.GetThread());
        if (rRow != null) {
            this.OnTransferStats(rThreadMsg);
        }
    }

    public void UpdateTransferRowVisualMsg(CThreadMsgSyncFoldersExecute rThreadMsg) {
        CTransferRow rUpdateTo;
        if (rThreadMsg != null && (rUpdateTo = this.GetRowObj(rThreadMsg.GetThread())) != null) {
            rUpdateTo.SetVisualMsg(rThreadMsg);
        }
    }
}

