/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.TransferPanel;

import com.rhinosoft.FilePanel.CTableCellRenderer;
import com.rhinosoft.TransferPanel.CTransferRow;
import com.rhinosoft.TransferPanel.CTransferTableModel;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class CTransferTableCellRenderer
extends CTableCellRenderer {
    public CTransferTableCellRenderer(JTable rTable, CTableViewport rViewport) {
        super(rTable, rViewport);
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object objValue, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, objValue, bIsSelected, bHasFocus, nRow, nCol);
        TableModel jModel = rTable.getModel();
        if (jModel instanceof CTransferTableModel) {
            CTransferTableModel jFileModel = (CTransferTableModel)jModel;
            String sText = null;
            Icon icoIcon = null;
            int nAlignHorz = 2;
            CTransferRow rRow = jFileModel.GetRowObj(nRow);
            if (rRow != null) {
                String sTempPathFrom = null;
                CPath rTempPathFrom = rRow.GetFromPath();
                if (rTempPathFrom != null) {
                    if (rTempPathFrom instanceof CPath) {
                        CPath rPath = rTempPathFrom;
                        sTempPathFrom = rPath.GetPath();
                    } else if (rTempPathFrom instanceof String) {
                        sTempPathFrom = (String)((Object)rTempPathFrom);
                    }
                }
                if (sTempPathFrom != null && !sTempPathFrom.isEmpty()) {
                    int nModelCol;
                    CRemoteFile fTemp = CRemoteFile.CreateFile(sTempPathFrom, null);
                    Icon icoPathFrom = null;
                    if (CMainFrame.GET_APP() != null) {
                        icoPathFrom = CMainFrame.GET_APP().GetFileImage(false, false, fTemp.IsDrive(), fTemp.IsDirectory(), fTemp.GetAbsFileName());
                    }
                    if ((nModelCol = rTable.convertColumnIndexToModel(nCol)) == 0) {
                        sText = rRow.FmtThreadStatus();
                        icoIcon = rRow.GetIconTransferStatus();
                    } else if (nModelCol == 1) {
                        icoIcon = icoPathFrom;
                        sText = rRow.GetDisplayName();
                        CPath rPath = rRow.GetFromPath();
                        if (rPath != null && !rPath.IsDir()) {
                            int nIdx = rRow.GetPathIndex(true) + 1;
                            int nSize = rRow.GetFromPathSize(false);
                            sText = sText + "  " + String.format(CString.LoadString("IDS_FMT_IDX_OF_MAX"), CString.FormatNumberForThousands(nIdx), CString.FormatNumberForThousands(nSize));
                        }
                    } else if (nModelCol == 3 || nModelCol == 4 || nModelCol == 2) {
                        if (nModelCol == 3) {
                            if (CMainFrame.GET_APP() != null) {
                                if (rRow.IsDownload()) {
                                    icoIcon = CMainFrame.GET_APP().GetJarImage("FileDownload.png");
                                } else if (rRow.IsUpload()) {
                                    icoIcon = CMainFrame.GET_APP().GetJarImage("FileUpload.png");
                                }
                            }
                            sText = rRow.FormatCompletionTxt();
                        } else if (nModelCol == 4) {
                            long lRead = rRow.GetOverallRead();
                            long lTotal = rRow.GetOverallTotal();
                            if (rRow.GetOverrideIsDone(true)) {
                                lRead = 1L;
                                lTotal = 1L;
                            }
                            if (CMainFrame.GET_APP() != null) {
                                icoIcon = CMainFrame.GET_APP().GetPercentImage(lRead, lTotal);
                            }
                            sText = rRow.FormatOverallTxt();
                        } else {
                            long lRead = rRow.GetFileRead();
                            long lTotal = rRow.GetFileTotal();
                            if (rRow.GetOverrideIsDone(false)) {
                                lRead = 1L;
                                lTotal = 1L;
                            }
                            if (CMainFrame.GET_APP() != null) {
                                icoIcon = CMainFrame.GET_APP().GetPercentImage(lRead, lTotal);
                            }
                            sText = rRow.FormatStatusTxt();
                        }
                    } else if (nModelCol == 5) {
                        CPath rTempPath = rRow.GetFromPath();
                        if (rTempPath instanceof CPath) {
                            CPath rPath = rTempPath;
                            sText = rPath.GetPath();
                        } else if (rTempPath instanceof String) {
                            sText = (String)((Object)rTempPath);
                        }
                        icoIcon = icoPathFrom;
                    } else if (nModelCol == 6) {
                        CPath rTempPath = rRow.GetToPath();
                        if (rTempPath instanceof CPath) {
                            CPath rPath = rTempPath;
                            sText = rPath.GetPath();
                        } else if (rTempPath instanceof String) {
                            sText = (String)((Object)rTempPath);
                        }
                        icoIcon = icoPathFrom;
                    }
                } else if (CMainFrame.DEBUG && CMainFrame.GetDebugLogger() != null) {
                    CMainFrame.GetDebugLogger().Severe("rTempPathFrom == null");
                }
            }
            this.setText(sText);
            if (icoIcon != null) {
                this.setIcon(icoIcon);
            }
            this.setHorizontalAlignment(nAlignHorz);
        }
        return this;
    }
}

