/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.TransferPanel;

import com.rhinosoft.TransferPanel.CTransferRowEvent;
import com.rhinosoft.TransferPanel.ITransferRowListener;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersExecute;
import java.awt.AWTEvent;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CTransferRow {
    private static final boolean DEBUG = CMainFrame.DEBUG;
    private static final boolean DEBUG_SHOW_BYTES;
    public static final int TRANSFER_TYPE_UNKNOWN = 0;
    public static final int TRANSFER_TYPE_DOWNLOAD = 1;
    public static final int TRANSFER_TYPE_UPLOAD = 2;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_STOPPED = 3;
    public static final int STATUS_CANCELLED = 4;
    public static final int STATUS_ERROR = 5;
    public static final int STATUS_QUESTION = 6;
    public static final int STATUS_DONE = 7;
    private boolean m_bHasChanged;
    private CThreadMsgTransfer m_rVisualMsg;
    private CThreadMsgTransfer m_OriginalMsg;
    private int m_nThreadStatus;
    private Vector<ITransferRowListener> m_aTransferRowListeners;
    private int m_nNumOfThreads;

    public CTransferRow(CThreadMsgTransfer rVisualMsg, CThreadMsgTransfer rOriginalMsg) {
        this.InitVars(rVisualMsg, rOriginalMsg);
    }

    private void InitVars(CThreadMsgTransfer rVisualMsg, CThreadMsgTransfer rOriginalMsg) {
        this.m_nThreadStatus = 0;
        this.m_aTransferRowListeners = new Vector();
        this.SetVisualMsg(rVisualMsg);
        this.SetOriginalMsg(rOriginalMsg);
        this.m_nNumOfThreads = 4;
    }

    protected CThreadMsgTransfer GetVisualMsg() {
        return this.m_rVisualMsg;
    }

    protected void SetVisualMsg(CThreadMsgTransfer rThreadMsg) {
        this.m_rVisualMsg = rThreadMsg;
    }

    public CPath GetFromPath() {
        CPath rPath = null;
        if (this.GetVisualMsg() != null) {
            rPath = this.GetVisualMsg().GetFromPath(this.GetVisualMsg().GetPathIndex());
        }
        return rPath;
    }

    public CPath GetToPath() {
        CPath rPath = null;
        if (this.GetVisualMsg() != null) {
            rPath = this.GetVisualMsg().GetToPath(this.GetVisualMsg().GetPathIndex());
        }
        return rPath;
    }

    public String GetDisplayName() {
        String sRet = "";
        CPath rFromPath = this.GetFromPath();
        if (rFromPath != null) {
            sRet = CString.GetFileName(rFromPath.GetPath());
        }
        return sRet;
    }

    private String FormatPercentDone(long nRead, long nTotal, boolean bShowAccumulated, boolean bOverrideIsDone) {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (DEBUG_SHOW_BYTES) {
            sRet = String.format("%s of %s", nRead, nTotal);
        } else {
            String sTotal = CString.FormatNumOfBytesDouble(nTotal, true, 2);
            float fPercentDone = -1.0f;
            if (nTotal > 0L) {
                fPercentDone = (float)nRead * 100.0f / (float)nTotal;
            } else if (bOverrideIsDone) {
                fPercentDone = 100.0f;
            }
            if (fPercentDone > -1.0f) {
                String sPercentDone = CString.FormatFloat(fPercentDone, 2);
                sRet = bShowAccumulated ? String.format(CString.LoadString("IDS_FMT_PERCENT_DONE2"), sPercentDone, CString.FormatNumOfBytesDouble(nRead, true, 2), sTotal) : String.format(CString.LoadString("IDS_FMT_PERCENT_DONE"), sPercentDone, sTotal);
            }
        }
        return sRet;
    }

    public boolean GetOverrideIsDone(boolean bOverall) {
        boolean bOverrideIsDone = false;
        if (this.GetVisualMsg() != null) {
            if (bOverall) {
                int nIdx = this.GetPathIndex(true) + 1;
                int nSize = this.GetFromPathSize(false);
                if (this.GetOverallRead() == 0L && this.GetOverallTotal() == 0L && nIdx == nSize && this.GetVisualMsg().GetNumOfEmptyFiles() == nSize) {
                    bOverrideIsDone = true;
                }
            } else if (this.GetVisualMsg().IsEmptyFile()) {
                bOverrideIsDone = true;
            }
        }
        return bOverrideIsDone;
    }

    public String FormatStatusTxt() {
        boolean bShowAccumulated = true;
        return this.FormatPercentDone(this.GetFileRead(), this.GetFileTotal(), bShowAccumulated, this.GetOverrideIsDone(false));
    }

    public String FormatCompletionTxt() {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        long nRemainingBytes = this.GetOverallTotal() - this.GetOverallRead();
        if (this.GetResumeStartIndex() <= nRemainingBytes) {
            nRemainingBytes -= this.GetResumeStartIndex();
        }
        if (this.GetBytesPerSecond() > 0L) {
            String sBytesPerSecond = CString.FormatBytesPerSecond(this.GetBytesPerSecond(), 2);
            long nEstimatedCompletionTimeInMillis = nRemainingBytes / this.GetBytesPerSecond() * 1000L;
            String sEstComp = "00:00:00";
            if (nEstimatedCompletionTimeInMillis > 0L) {
                sEstComp = String.format("%02d:%02d:%02d", nEstimatedCompletionTimeInMillis / 3600000L, nEstimatedCompletionTimeInMillis / 60000L % 60L, nEstimatedCompletionTimeInMillis / 1000L % 60L);
            }
            sRet = String.format("%s (%s)", sEstComp, sBytesPerSecond);
        }
        return sRet;
    }

    public String FormatOverallTxt() {
        boolean bShowAccumulated = true;
        return this.FormatPercentDone(this.GetOverallRead(), this.GetOverallTotal(), bShowAccumulated, this.GetOverrideIsDone(true));
    }

    public int GetType() {
        int nRet = 0;
        if (this.GetVisualMsg() != null) {
            nRet = this.GetVisualMsg().IsDownload() ? 1 : 2;
        }
        return nRet;
    }

    public String FmtThreadStatus() {
        String sStatus = CString.LoadString("IDS_TRANSFER_RUNNING");
        switch (this.m_nThreadStatus) {
            case 4: {
                sStatus = CString.LoadString("IDS_TRANSFER_CANCELLED");
                break;
            }
            case 7: {
                sStatus = CString.LoadString("IDS_TRANSFER_COMPLETED");
                break;
            }
            case 5: {
                sStatus = CString.LoadString("IDS_TRANSFER_ERROR");
                break;
            }
            case 6: {
                sStatus = CString.LoadString("IDS_TRANSFER_CONFIRMING");
                break;
            }
            case 2: {
                sStatus = CString.LoadString("IDS_TRANSFER_PAUSED");
                break;
            }
            case 3: {
                sStatus = CString.LoadString("IDS_TRANSFER_STOPPED");
                break;
            }
            default: {
                sStatus = this.IsDownload() ? CString.LoadString("IDS_TRANSFER_DOWNLOADING") : CString.LoadString("IDS_TRANSFER_UPLOADING");
            }
        }
        return sStatus;
    }

    public ImageIcon GetIconTransferStatus() {
        ImageIcon icoImage = null;
        if (CMainFrame.GET_APP() != null) {
            icoImage = CMainFrame.GET_APP().GetJarImage("TransferRunning.png");
            switch (this.m_nThreadStatus) {
                case 4: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferCancelled.png");
                    break;
                }
                case 7: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferDone.png");
                    break;
                }
                case 5: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferError.png");
                    break;
                }
                case 6: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferQuestion.png");
                    break;
                }
                case 2: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferPaused.png");
                    break;
                }
                case 3: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferStop.png");
                    break;
                }
                default: {
                    icoImage = CMainFrame.GET_APP().GetJarImage("TransferRunning.png");
                }
            }
        }
        return icoImage;
    }

    public boolean SetThreadStatus(int nThreadStatus) {
        boolean bChanged = false;
        if (this.m_nThreadStatus != nThreadStatus) {
            this.m_nThreadStatus = nThreadStatus;
            bChanged = true;
            this.FireOnStatusChange();
        }
        return bChanged;
    }

    public int GetThreadStatus() {
        return this.m_nThreadStatus;
    }

    public long GetFileRead() {
        long lRet = 0L;
        if (this.GetVisualMsg() != null) {
            lRet = this.GetVisualMsg().GetFileRead();
        }
        return lRet;
    }

    public long GetFileTotal() {
        long lRet = 0L;
        if (this.GetVisualMsg() != null) {
            lRet = this.GetVisualMsg().GetFileTotal();
        }
        return lRet;
    }

    public long GetOverallRead() {
        long lRet = 0L;
        if (this.GetVisualMsg() != null) {
            lRet = this.GetVisualMsg().GetOverallRead();
        }
        return lRet;
    }

    public long GetOverallTotal() {
        long lRet = 0L;
        if (this.GetVisualMsg() != null) {
            lRet = this.GetVisualMsg().GetOverallTotal();
        }
        return lRet;
    }

    private long GetBytesPerSecond() {
        long lRet = 0L;
        if (this.GetVisualMsg() != null) {
            lRet = this.GetVisualMsg().GetBytesPerSecond();
        }
        return lRet;
    }

    public int GetPathIndex() {
        int nRet = 0;
        if (this.GetVisualMsg() != null) {
            nRet = this.GetVisualMsg().GetPathIndex();
        }
        return nRet;
    }

    public int GetPathIndex(boolean bRemoveDirs) {
        int nRet = 0;
        if (this.GetVisualMsg() != null) {
            nRet = this.GetVisualMsg().GetPathIndex(bRemoveDirs);
        }
        return nRet;
    }

    public int GetFromPathSize() {
        int nRet = 0;
        if (this.GetVisualMsg() != null) {
            nRet = this.GetVisualMsg().GetFromPathSize();
        }
        return nRet;
    }

    public int GetFromPathSize(boolean bRemoveDirs) {
        int nRet = 0;
        if (this.GetVisualMsg() != null) {
            nRet = this.GetVisualMsg().GetFromPathSize(bRemoveDirs);
        }
        return nRet;
    }

    public boolean IsDownload() {
        return this.GetType() == 1;
    }

    public boolean IsUpload() {
        return this.GetType() == 2;
    }

    public CWorkerThread GetThread() {
        CWorkerThread tThread = null;
        if (this.GetVisualMsg() != null && this.GetVisualMsg().GetThread() != null && this.GetVisualMsg().GetThread() instanceof CWorkerThread) {
            tThread = (CWorkerThread)this.GetVisualMsg().GetThread();
        }
        return tThread;
    }

    public boolean UpdateData(CThreadMsgTransfer rThreadMsg) {
        boolean bChanged = false;
        if (this.GetVisualMsg() != null && rThreadMsg != null) {
            if (this.GetVisualMsg() instanceof CThreadMsgSyncFoldersExecute && rThreadMsg instanceof CThreadMsgSyncFoldersExecute) {
                if (((CThreadMsgSyncFoldersExecute)this.GetVisualMsg()).Copy((CThreadMsgSyncFoldersExecute)rThreadMsg, true)) {
                    bChanged = true;
                }
            } else if (this.GetVisualMsg().Copy(rThreadMsg, true)) {
                bChanged = true;
            }
            bChanged = true;
        }
        this.SetHasChanged(bChanged);
        return bChanged;
    }

    public boolean HasChanged() {
        return this.m_bHasChanged;
    }

    public void SetHasChanged(boolean bHasChanged) {
        this.m_bHasChanged = bHasChanged;
    }

    private Vector<ITransferRowListener> GetTransferRowListeners() {
        return this.m_aTransferRowListeners;
    }

    public void AddTransferRowListener(ITransferRowListener rListener) {
        if (this.GetTransferRowListeners() != null) {
            this.GetTransferRowListeners().add(rListener);
        }
    }

    public void RemoveTransferRowListener(ITransferRowListener rListener) {
        if (this.GetTransferRowListeners() != null) {
            this.GetTransferRowListeners().remove(rListener);
        }
    }

    private void FireOnStatusChange() {
        CTransferRowEvent rEvent = new CTransferRowEvent(this);
        if (this.GetTransferRowListeners() != null) {
            for (ITransferRowListener rListener : this.GetTransferRowListeners()) {
                if (rListener == null) continue;
                rListener.OnChangeStatus(rEvent);
            }
        }
    }

    public void ProcessNextItem() {
        if (this.GetOriginalMsg() != null) {
            this.GetOriginalMsg().SetMoveToNextItem(true, true);
        }
    }

    public void StopProcessing() {
        if (this.GetOriginalMsg() != null) {
            this.GetOriginalMsg().Stop();
        }
    }

    public void ResumeProcessing() {
        if (this.GetThreadStatus() == 2 && this.GetOriginalMsg() != null) {
            this.GetOriginalMsg().OnResume();
        }
    }

    public void OnStopAtNextFile() {
        if (this.GetOriginalMsg() != null) {
            boolean bVal = this.GetOriginalMsg().GetStopAtNextItem();
            this.GetOriginalMsg().SetStopAtNextItem(!bVal);
        }
    }

    public boolean GetStopAtNextItem() {
        boolean bVal = false;
        if (this.GetOriginalMsg() != null) {
            bVal = this.GetOriginalMsg().GetStopAtNextItem();
        }
        return bVal;
    }

    public void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CThreadMsgTransfer rThreadMsg;
            CRhinoEvent rEvent = (CRhinoEvent)event;
            boolean bUpdateData = false;
            block0 : switch (event.getID()) {
                case 2902: {
                    bUpdateData = true;
                    this.SetThreadStatus(1);
                    break;
                }
                case 3005: {
                    if (!(rEvent.GetEventObj() instanceof CThreadMsgTransfer)) break;
                    rThreadMsg = (CThreadMsgTransfer)rEvent.GetEventObj();
                    bUpdateData = true;
                    int nErrorID = rThreadMsg.GetErrorID();
                    switch (nErrorID) {
                        case 41: {
                            this.SetThreadStatus(6);
                            break block0;
                        }
                        case 10: {
                            if (rThreadMsg.GetStopAtNextItem()) {
                                this.SetThreadStatus(3);
                                break block0;
                            }
                            this.SetThreadStatus(2);
                            break block0;
                        }
                    }
                    this.SetThreadStatus(5);
                    break;
                }
                case 3020: {
                    bUpdateData = true;
                    this.SetThreadStatus(4);
                    break;
                }
                case 3021: {
                    bUpdateData = true;
                    break;
                }
                case 3022: {
                    bUpdateData = true;
                    this.SetThreadStatus(7);
                    break;
                }
            }
            if (rEvent.GetEventObj() instanceof CThreadMsgTransfer) {
                rThreadMsg = (CThreadMsgTransfer)rEvent.GetEventObj();
                if (bUpdateData) {
                    this.UpdateData(rThreadMsg);
                }
            }
        }
    }

    protected CThreadMsgTransfer GetOriginalMsg() {
        return this.m_OriginalMsg;
    }

    private void SetOriginalMsg(CThreadMsgTransfer rMsg) {
        this.m_OriginalMsg = rMsg;
    }

    public void Clear() {
        if (this.GetThread() != null) {
            this.GetThread().Quit(true);
        }
        this.SetVisualMsg(null);
        this.SetOriginalMsg(null);
        if (this.m_aTransferRowListeners != null) {
            this.m_aTransferRowListeners.removeAllElements();
            this.m_aTransferRowListeners = null;
        }
    }

    public void CancelTransfer() {
        switch (this.GetThreadStatus()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.SetThreadStatus(4);
                break;
            }
            default: {
                if (this.GetThread() == null) break;
                this.GetThread().Cancel();
            }
        }
    }

    public long GetResumeStartIndex() {
        long lRet = 0L;
        if (this.GetVisualMsg() != null) {
            lRet = this.GetVisualMsg().GetResumeStartIndex();
        }
        return lRet;
    }

    public int GetNumOfThreads() {
        return this.m_nNumOfThreads;
    }

    public boolean SetNumOfThreads(int nNumOfThreads) {
        boolean bChanged = false;
        if (this.m_nNumOfThreads != nNumOfThreads) {
            bChanged = true;
            this.m_nNumOfThreads = nNumOfThreads;
        }
        return bChanged;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SHOW_BYTES = false;
    }
}

