/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CDashedBorder;
import com.rhinosoft.FilePanel.ICellRendererColumnWidths;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.base.gui.images.CFilterIcon;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class CTableCellRenderer
extends DefaultTableCellRenderer
implements ICellRendererColumnWidths {
    private static final int TRANSPARENCY_VALUE = 128;
    public static final String KEY_DROP_ROW = "DropRow";
    private JTable m_rTable;
    private JViewport m_rViewport;
    private boolean m_bHasFocusClrs = false;
    private CFilterIcon m_Icon = new CFilterIcon();

    public CTableCellRenderer(JTable rTable, JViewport rViewport) {
        this.m_rTable = rTable;
        this.m_rViewport = rViewport;
        if (rTable != null) {
            rTable.setShowGrid(false);
            rTable.setIntercellSpacing(new Dimension(0, 0));
            rTable.setRowHeight(17);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        this.UpdateHasFocusColor(bIsSelected, nCol, rTable, this);
        Font font = (Font)UIManager.get("List.font");
        if (font == null) {
            font = rTable.getFont();
        }
        rTable.setFont(font);
        Border rCellBorder = this.GetCellBorder(rTable, bIsSelected, nRow, nCol);
        this.setBorder(rCellBorder);
        return this;
    }

    @Override
    public int GetBorderWidthLeftRight() {
        Insets jInset;
        int nBorderWidth = 0;
        Border jBorder = this.getBorder();
        if (jBorder != null && (jInset = jBorder.getBorderInsets(this)) != null) {
            nBorderWidth += jInset.left + jInset.right;
        }
        return nBorderWidth;
    }

    @Override
    public int GetIconWidth() {
        int nIconWidth = 0;
        Icon icoImage = this.getIcon();
        if (icoImage != null) {
            nIconWidth = icoImage.getIconWidth();
        }
        return nIconWidth;
    }

    @Override
    public int GetIconTxtGap(boolean bTestForIcon) {
        int nGap = 0;
        if (bTestForIcon) {
            Icon icoImage = this.getIcon();
            if (icoImage != null) {
                nGap = this.getIconTextGap();
            }
        } else {
            nGap = this.getIconTextGap();
        }
        return nGap;
    }

    protected Border GetCellBorder(JTable jTable, boolean bIsSelected, int nRow, int nCol) {
        Border jCellBorder = null;
        int nLeadRow = -1;
        ListSelectionModel jSelModel = jTable.getSelectionModel();
        if (jSelModel != null) {
            nLeadRow = jSelModel.getLeadSelectionIndex();
        }
        int nTop = 1;
        int nBtm = 1;
        int nLeft = 0;
        int nRight = 0;
        if (nCol == 0) {
            nLeft = 1;
        } else if (nCol == jTable.getColumnCount() - 1) {
            nRight = 1;
        }
        jCellBorder = nRow == nLeadRow ? new CDashedBorder(nTop, nLeft, nBtm, nRight, Color.DARK_GRAY) : BorderFactory.createEmptyBorder(nTop, nLeft, nBtm, nRight);
        jCellBorder = BorderFactory.createCompoundBorder(jCellBorder, BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jCellBorder;
    }

    public Rectangle GetEditorRect(JTable rTable, int nViewCol, int nRow) {
        Rectangle rScreenCoords = new Rectangle(0, 0, 0, 0);
        if (rTable != null) {
            Icon rIcon;
            Insets rInsets;
            Point ptScreenLoc = new Point(0, 0);
            Rectangle rCellRect = rTable.getCellRect(nRow, nViewCol, true);
            ptScreenLoc.setLocation(rCellRect.x, rCellRect.y);
            SwingUtilities.convertPointToScreen(ptScreenLoc, rTable);
            rScreenCoords.x = ptScreenLoc.x;
            rScreenCoords.y = ptScreenLoc.y;
            rScreenCoords.width = rCellRect.width;
            rScreenCoords.height = rCellRect.height;
            int x2 = rScreenCoords.x;
            int nWidth2 = rScreenCoords.width;
            Border rBorder = this.getBorder();
            if (rBorder != null && (rInsets = rBorder.getBorderInsets(this)) != null) {
                x2 += rInsets.left;
                nWidth2 -= rInsets.left;
            }
            if ((rIcon = this.getIcon()) != null) {
                int nImageWidth = rIcon.getIconWidth();
                x2 += nImageWidth;
                nWidth2 -= nImageWidth;
            }
            int nImageGap = 1;
            rScreenCoords.x = x2 += nImageGap;
            if ((nWidth2 -= nImageGap) > 0) {
                rScreenCoords.width = nWidth2;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rList = null");
        }
        return rScreenCoords;
    }

    private CTableViewport GetTableViewport() {
        CTableViewport rRet = null;
        JViewport rViewport = this.GetViewport();
        if (rViewport instanceof CTableViewport) {
            rRet = (CTableViewport)rViewport;
        }
        return rRet;
    }

    private JViewport GetViewport() {
        if (this.m_rViewport == null && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, m_rViewport = null");
        }
        return this.m_rViewport;
    }

    private JTable GetTable() {
        return this.m_rTable;
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean GetHasFocusClrs() {
        return this.m_bHasFocusClrs;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, int nCol, JTable rTable, Component ... arComps) {
        Color clrTableFore = UIManager.getColor("Table.foreground");
        Color clrTableBack = UIManager.getColor("Table.background");
        Color clrTableForeSel = UIManager.getColor("Table.selectionForeground");
        Color clrTableBackSel = UIManager.getColor("Table.selectionBackground");
        Color clrFore = clrTableFore;
        Color clrBack = clrTableBack;
        if (bIsSelected) {
            clrFore = clrTableForeSel;
            clrBack = clrTableBackSel;
            if (!this.GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorUtils.IsADarkColor(clrFore) && !CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() < clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                } else if (CColorUtils.IsADarkColor(clrFore) && CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() > clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                }
            }
        } else if (this.GetViewport() instanceof CTableViewport) {
            CTableViewport rViewport = (CTableViewport)this.GetViewport();
            int nSortCol = this.GetTable().convertColumnIndexToModel(nCol);
            if (rViewport.GetModelCol() == nSortCol) {
                clrBack = rViewport.GetSortColor();
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackground(clrBack);
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.m_Icon != null && icon != null) {
            this.m_Icon.SetOriginal(icon);
            super.setIcon(this.m_Icon);
        } else {
            super.setIcon(null);
        }
    }

    protected void DullTheIcon(boolean bDullIt) {
        float fMixVal = 0.0f;
        if (bDullIt) {
            fMixVal = 0.5f;
        }
        this.SetMix(fMixVal);
    }

    protected void SetMix(float fMixVal) {
        this.m_Icon.SetMix(fMixVal, this);
    }
}

