/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFileModel;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.events.CMainEventQueue;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;

public class CSortMsg
extends CWorkerThreadID {
    public static boolean DEBUG = CMainFrame.DEBUG;
    public static boolean DEBUG_SORTING;
    private CFileModel m_rFileModel;

    public CSortMsg(Thread tThread, Object rSource) {
        super(tThread, 9644, rSource);
    }

    public void SetFileModel(CFileModel rFileModel) {
        this.m_rFileModel = rFileModel;
    }

    @Override
    public void ProcessEvent() {
        block7: {
            super.ProcessEvent();
            if (DEBUG_SORTING) {
                System.out.println("CSortMsg.ProcessEvent -->");
            }
            CRhinoEvent rShowWaitEvent = new CRhinoEvent(this.GetSource(), 9642);
            CMainEventQueue.PostEvent(rShowWaitEvent);
            if (this.m_rFileModel != null) {
                try {
                    Object[] aFiles = this.m_rFileModel.GetFilesAsArray();
                    if (aFiles != null && aFiles.length > 1) {
                        this.sort(aFiles, 0, aFiles.length - 1);
                    }
                    if (!this.GetCancel()) {
                        this.m_rFileModel.Sorted(aFiles);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
        CRhinoEvent rHideWaitEvent = new CRhinoEvent(this.GetSource(), 9643);
        CMainEventQueue.PostEvent(rHideWaitEvent);
        if (DEBUG_SORTING) {
            System.out.println("CSortMsg.ProcessEvent <--");
        }
    }

    private void sort(Object[] aFiles, int lo, int hi) throws Exception {
        if (DEBUG_SORTING) {
            System.out.println("CSortMsg.sort -->");
        }
        if (lo != hi && !this.GetCancel()) {
            int length = hi - lo + 1;
            int pivot = (lo + hi) / 2;
            this.sort(aFiles, lo, pivot);
            this.sort(aFiles, pivot + 1, hi);
            Object[] aWorking = new Object[length];
            for (int i = 0; i < length; ++i) {
                aWorking[i] = aFiles[lo + i];
            }
            int m1 = 0;
            int m2 = pivot - lo + 1;
            for (int i = 0; i < length && !this.GetCancel(); ++i) {
                if (m2 <= hi - lo) {
                    if (m1 <= pivot - lo) {
                        if (this.Compare(aWorking[m1], aWorking[m2]) > 0) {
                            aFiles[i + lo] = aWorking[m2++];
                            continue;
                        }
                        aFiles[i + lo] = aWorking[m1++];
                        continue;
                    }
                    aFiles[i + lo] = aWorking[m2++];
                    continue;
                }
                aFiles[i + lo] = aWorking[m1++];
            }
        }
        if (DEBUG_SORTING) {
            System.out.println("CSortMsg.sort <--");
        }
    }

    private int Compare(Object o1, Object o2) {
        int nRet = 0;
        if (o1 != null && o1 != null && o1 instanceof CFile && o2 instanceof CFile) {
            nRet = this.CompareFiles((CFile)o1, (CFile)o2);
        }
        return nRet;
    }

    public int CompareFiles(CFile f1, CFile f2) {
        int nRet = 0;
        if (this.m_rFileModel != null && this.m_rFileModel.GetComparator() != null) {
            nRet = this.m_rFileModel.GetComparator().compare(f1, f2);
        }
        return nRet;
    }

    static {
        if (CFileModel.DEBUG_SORTING) {
            // empty if block
        }
        DEBUG_SORTING = false;
    }
}

