/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFileModel;
import com.rhinosoft.FilePanel.CTableCellRenderer;
import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.gui.CDateFormatStringVerifier;
import com.rhinosoft.base.gui.CRhinoProperties;
import com.rhinosoft.fvjv.gui.dialogs.COptionsGeneral;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableModel;

public class CFileTableCellRenderer
extends CTableCellRenderer {
    public static final String KEY_DROP_ROW = "DropRow";
    private IArchive m_rArchive;

    public CFileTableCellRenderer(JTable rTable, JViewport rViewport, IArchive rArchive) {
        super(rTable, rViewport);
        this.m_rArchive = rArchive;
    }

    public static boolean IsDropDir(JTable rTable, int nRow, int nModelCol) {
        boolean bIsDropDir = false;
        if (rTable != null) {
            CFileModel rFileModel;
            CFile fRowFile;
            TableModel rModel;
            Object objDropVal = rTable.getClientProperty(KEY_DROP_ROW);
            int nDropVal = CConversionUtils.ConvertToInt(objDropVal);
            if (CConversionUtils.IsValidInt(nDropVal) && nDropVal == nRow && (rModel = rTable.getModel()) instanceof CFileModel && (fRowFile = (rFileModel = (CFileModel)rModel).GetFileAt(nDropVal)) != null && fRowFile.IsDirectory()) {
                bIsDropDir = true;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rTable = null");
        }
        return bIsDropDir;
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        if (CFileTableCellRenderer.IsDropDir(rTable, nRow, nCol)) {
            bIsSelected = true;
        }
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        if (rVal instanceof CFile) {
            CFile fFile = (CFile)rVal;
            String sText = null;
            Icon icoIcon = null;
            int nAlignHorz = 2;
            int nModelCol = rTable.convertColumnIndexToModel(nCol);
            if (nModelCol == 0) {
                icoIcon = fFile.GetIcon16();
                this.DullTheIcon(fFile.IsDisplayIconDull());
                sText = fFile.GetDisplayName();
                if (!bIsSelected) {
                    Color clrFore = fFile.GetDisplayColor(this.getForeground());
                    this.setForeground(clrFore);
                }
            } else if (nModelCol == 1) {
                nAlignHorz = 4;
                if (!fFile.IsDirectory()) {
                    sText = CFile.FormatFileSize(fFile.GetSize());
                }
            } else if (nModelCol == 2) {
                sText = fFile.GetType();
            } else if (nModelCol == 3) {
                sText = CFileTableCellRenderer.FmtDisplayDate(fFile.GetModifiedDate(), this.GetArchive(), false);
            } else if (nModelCol == 4) {
                sText = fFile.GetParentPath(true);
            }
            this.setText(sText);
            this.setIcon(icoIcon);
            this.setHorizontalAlignment(nAlignHorz);
        }
        return this;
    }

    public static String FmtDisplayDate(Date dtGMT, IArchive rArchive, boolean bSetToCST) {
        String sRet = "";
        if (dtGMT != null && dtGMT.getTime() > 0L) {
            boolean bShowDST = COptionsGeneral.GetDefaultShowDST();
            String sDateFmtString = CRhinoProperties.GetDefaultDatePattern();
            if (rArchive != null) {
                Boolean bVal = rArchive.GetValueBool("ShowDST", bShowDST);
                if (bVal != null) {
                    bShowDST = bVal;
                }
                if ((bVal = rArchive.GetValueBool("UseDateFormatString", false)) != null && bVal.booleanValue()) {
                    sDateFmtString = rArchive.GetValue("DateFormatString", CRhinoProperties.GetDefaultDatePattern());
                }
            }
            Date dtAdjusted = CFileSystemUtils.GetFileSysUtils().AdjustToLocal(dtGMT, bShowDST);
            sRet = CDateFormatStringVerifier.Format(sDateFmtString, dtAdjusted, bSetToCST);
        }
        return sRet;
    }

    @Override
    public Rectangle GetEditorRect(JTable rTable, int nViewCol, int nRow) {
        Rectangle rScreenCoords = new Rectangle(0, 0, 0, 0);
        if (rTable != null) {
            Icon rIcon;
            Insets rInsets;
            Point ptScreenLoc = new Point(0, 0);
            Rectangle rCellRect = rTable.getCellRect(nRow, nViewCol, true);
            ptScreenLoc.setLocation(rCellRect.x, rCellRect.y);
            SwingUtilities.convertPointToScreen(ptScreenLoc, rTable);
            rScreenCoords.x = ptScreenLoc.x;
            rScreenCoords.y = ptScreenLoc.y;
            rScreenCoords.width = rCellRect.width;
            rScreenCoords.height = rCellRect.height;
            int x2 = rScreenCoords.x;
            int nWidth2 = rScreenCoords.width;
            Border rBorder = this.getBorder();
            if (rBorder != null && (rInsets = rBorder.getBorderInsets(this)) != null) {
                x2 += rInsets.left;
                nWidth2 -= rInsets.left;
            }
            if ((rIcon = this.getIcon()) != null) {
                int nImageWidth = rIcon.getIconWidth();
                x2 += nImageWidth;
                nWidth2 -= nImageWidth;
            }
            int nImageGap = 1;
            rScreenCoords.x = x2 += nImageGap;
            if ((nWidth2 -= nImageGap) > 0) {
                rScreenCoords.width = nWidth2;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rList = null");
        }
        return rScreenCoords;
    }

    protected IArchive GetArchive() {
        return this.m_rArchive;
    }

    @Override
    public String toString() {
        String sText = this.getText() != null ? this.getText() : "";
        String sIcon = this.getIcon() != null ? "true" : "false";
        String sTxt = String.format("\nText: %s\nHasIcon: %s", sText, sIcon);
        return sTxt;
    }
}

