/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.FilePanel.CFileSelModel;
import com.rhinosoft.FilePanel.CFileTableSorter;
import com.rhinosoft.FilePanel.CSortMsg;
import com.rhinosoft.base.CSpeedTest;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class CFileModel
implements ListModel,
TableModel {
    private static boolean DEBUG = CMainFrame.DEBUG;
    private static boolean DEBUG_TRACE_METHODS;
    public static boolean DEBUG_SORTING;
    private JTable m_jTable;
    private JList m_jList;
    private CFileSelModel m_SelModel;
    private CFile m_fDisplayFile;
    private final Object m_Crit = new Object();
    private Vector<CFile> m_afFiles;
    private String[] m_saColHeaders;
    protected EventListenerList m_jListenerList;
    private boolean m_bIsFirstDisplayFileSet = false;
    private CSpeedTest m_SpeedTest = new CSpeedTest();
    private CWorkerThread m_SortThread;
    private CFileTableSorter m_Comparator;

    public CFileModel() {
        this.m_jListenerList = new EventListenerList();
        this.m_saColHeaders = new String[5];
        this.m_saColHeaders[0] = CString.LoadString("IDS_TABLE_HEADER_NAME");
        this.m_saColHeaders[1] = CString.LoadString("IDS_TABLE_HEADER_SIZE");
        this.m_saColHeaders[2] = CString.LoadString("IDS_TABLE_HEADER_TYPE");
        this.m_saColHeaders[3] = CString.LoadString("IDS_TABLE_HEADER_MODIFIED");
        this.m_saColHeaders[4] = CString.LoadString("IDS_TABLE_HEADER_PARENT_PATH");
        this.m_SortThread = new CWorkerThread(CMainFrame.GET_APP(), "Sort_Thread");
        this.m_SortThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int nSize = 0;
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_afFiles != null) {
                nSize = this.m_afFiles.size();
            }
        }
        return nSize;
    }

    @Override
    public int getRowCount() {
        return this.getSize();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.m_saColHeaders[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<String> cRetClass = String.class;
        return cRetClass;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementAt(int index) {
        CFile objRet = null;
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_afFiles != null && index > -1 && index < this.m_afFiles.size()) {
                objRet = this.m_afFiles.get(index);
            }
        }
        return objRet;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getElementAt(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addListDataListener(ListDataListener jListener) {
        this.m_jListenerList.add(ListDataListener.class, jListener);
    }

    @Override
    public void removeListDataListener(ListDataListener jListener) {
        this.m_jListenerList.remove(ListDataListener.class, jListener);
    }

    @Override
    public void addTableModelListener(TableModelListener jListener) {
        this.m_jListenerList.add(TableModelListener.class, jListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener jListener) {
        this.m_jListenerList.remove(TableModelListener.class, jListener);
    }

    public void fireTableDataChanged() {
        this.fireTableDataChanged(true);
    }

    protected void fireTableDataChanged(boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this));
        if (bFireListEvent) {
            this.fireContentsChanged(this.m_jList, 0, this.getSize(), false);
        }
    }

    public void fireTableStructureChanged() {
        this.fireTableStructureChanged(true);
    }

    private void fireTableStructureChanged(boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, -1));
        if (bFireListEvent) {
            this.fireContentsChanged(this.m_jList, 0, this.getSize(), false);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableRowsInserted(firstRow, lastRow, true);
    }

    private void fireTableRowsInserted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
        if (bFireListEvent) {
            this.fireIntervalAdded(this.m_jList, firstRow, lastRow, false);
        }
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableRowsUpdated(firstRow, lastRow, true);
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
        if (bFireListEvent) {
            this.fireContentsChanged(this.m_jList, firstRow, lastRow, false);
        }
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableRowsDeleted(firstRow, lastRow, true);
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
        if (bFireListEvent) {
            if (this.GetSelModel() != null) {
                this.GetSelModel().SkipUpdate();
            }
            this.fireIntervalRemoved(this.m_jList, firstRow, lastRow, false);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableCellUpdated(row, column, true);
    }

    private void fireTableCellUpdated(int row, int column, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
        if (bFireListEvent) {
            this.fireContentsChanged(this.m_jList, row, row, false);
        }
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.m_jListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.fireContentsChanged(source, index0, index1, true);
    }

    protected void fireContentsChanged(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 0, index0, index1));
        if (bFireTableEvent) {
            this.fireTableStructureChanged(false);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.fireIntervalAdded(source, index0, index1, true);
    }

    private void fireIntervalAdded(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 1, index0, index1));
        if (bFireTableEvent) {
            this.fireTableRowsInserted(index0, index1, false);
        }
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.fireIntervalRemoved(source, index0, index1, true);
    }

    private void fireIntervalRemoved(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 2, index0, index1));
        if (bFireTableEvent) {
            if (this.GetSelModel() != null) {
                this.GetSelModel().SkipUpdate();
            }
            this.fireTableRowsDeleted(index0, index1, false);
        }
    }

    private void fireListEvent(ListDataEvent jEvent) {
        Object[] listeners = this.m_jListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (jEvent.getType() == 0) {
                ((ListDataListener)listeners[i + 1]).contentsChanged(jEvent);
                continue;
            }
            if (jEvent.getType() == 1) {
                ((ListDataListener)listeners[i + 1]).intervalAdded(jEvent);
                continue;
            }
            if (jEvent.getType() != 2) continue;
            ((ListDataListener)listeners[i + 1]).intervalRemoved(jEvent);
        }
    }

    public void SetDisplayFile(CFile fDisplayFile, boolean bGetUpToDateFileList) {
        this.m_fDisplayFile = fDisplayFile;
        this.LoadRows(fDisplayFile, bGetUpToDateFileList);
        if (!this.m_bIsFirstDisplayFileSet) {
            this.m_bIsFirstDisplayFileSet = true;
        }
    }

    public CFile GetDisplayFile() {
        return this.m_fDisplayFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void LoadRows(CFile fDisplayFile, boolean bGetUpToDateFileList) {
        if (fDisplayFile != null) {
            Object object = this.m_Crit;
            synchronized (object) {
                this.m_afFiles = fDisplayFile.CloneFileList(bGetUpToDateFileList);
            }
            this.fireTableDataChanged();
        }
    }

    public void SetOwnerTable(JTable jTable) {
        this.m_jTable = jTable;
    }

    public void SetOwnerList(JList jList) {
        this.m_jList = jList;
    }

    public CFile GetFileAt(int nRow) {
        Object objRet = this.getElementAt(nRow);
        CFile fRet = null;
        if (objRet instanceof CFile) {
            fRet = (CFile)objRet;
        }
        return fRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetRowIndex(CFile fFile) {
        int nRow = -1;
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_afFiles != null) {
                for (int nIdx = 0; nIdx < this.m_afFiles.size(); ++nIdx) {
                    CFile fNext = this.m_afFiles.get(nIdx);
                    if (fNext == null) continue;
                    String sAbsFilePath = fFile.GetAbsFileName();
                    String sAbsNextPath = fNext.GetAbsFileName();
                    if (fNext != fFile && (sAbsFilePath == null || sAbsNextPath == null || !sAbsFilePath.equals(sAbsNextPath))) continue;
                    nRow = nIdx;
                    break;
                }
            }
        }
        return nRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetRowIndex(String sAbsPath) {
        int nRow = -1;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            Object object = this.m_Crit;
            synchronized (object) {
                if (this.m_afFiles != null) {
                    for (int nIdx = 0; nIdx < this.m_afFiles.size(); ++nIdx) {
                        CFile fNext = this.m_afFiles.get(nIdx);
                        if (fNext == null || !fNext.GetAbsFileName().equals(sAbsPath)) continue;
                        nRow = nIdx;
                        break;
                    }
                }
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, sAbsPath = null");
        }
        return nRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetRowIndexPrevPath(String sAbsPrevPath) {
        int nRow = -1;
        if (sAbsPrevPath != null && !sAbsPrevPath.isEmpty()) {
            Object object = this.m_Crit;
            synchronized (object) {
                if (this.m_afFiles != null) {
                    for (int nIdx = 0; nIdx < this.m_afFiles.size(); ++nIdx) {
                        CFile fNext = this.m_afFiles.get(nIdx);
                        if (fNext == null || fNext.GetPrevFileName() == null || !fNext.GetPrevFileName().equals(sAbsPrevPath)) continue;
                        nRow = nIdx;
                        break;
                    }
                }
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, sAbsPath = null");
        }
        return nRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Compare() {
        if (DEBUG_SORTING) {
            System.out.println("CFileModel.Compare -->");
        }
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_Comparator != null) {
                if (this.m_afFiles != null) {
                    Collections.sort(this.m_afFiles, this.m_Comparator);
                } else if (DEBUG_SORTING) {
                    CMainFrame.Info("ASSERT:  Programming error, m_afFiles = null");
                }
            } else if (CMainFrame.GetDebugLogger() != null) {
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, jComparator = null");
            }
        }
        if (DEBUG_SORTING) {
            System.out.println("CFileModel.Compare <--");
        }
    }

    public void Sort(CFileTableSorter jComparator) {
        if (DEBUG_SORTING) {
            System.out.println("CFileModel.Sort -->");
        }
        this.m_Comparator = jComparator;
        if (this.m_SortThread != null) {
            this.m_SortThread.CancelAllJobs();
            CSortMsg rMsg = new CSortMsg(this.m_SortThread, this);
            rMsg.SetFileModel(this);
            this.m_SortThread.PostMessage(rMsg);
        } else {
            this.Compare();
        }
        if (DEBUG_SORTING) {
            System.out.println("CFileModel.Sort <--");
        }
    }

    public CFileTableSorter GetComparator() {
        return this.m_Comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveRow(int nRowIdx) {
        if (this.IsValidRow(nRowIdx)) {
            Object object = this.m_Crit;
            synchronized (object) {
                this.m_afFiles.remove(nRowIdx);
            }
            this.fireIntervalRemoved(this, nRowIdx, nRowIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean RemoveAllRows() {
        boolean bRemovedAll = false;
        int nSize = this.getSize() - 1;
        if (this.m_afFiles != null) {
            Object object = this.m_Crit;
            synchronized (object) {
                this.m_afFiles.removeAllElements();
            }
            if (nSize > 0) {
                this.fireIntervalRemoved(this, 0, nSize);
            }
            bRemovedAll = true;
        }
        return bRemovedAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateRow(CFile fFile) {
        if (fFile != null && this.m_afFiles != null) {
            int nUpdateRow = -1;
            Object object = this.m_Crit;
            synchronized (object) {
                for (int nIdx = 0; nIdx < this.m_afFiles.size() && nUpdateRow < 0; ++nIdx) {
                    CFile fNext = this.m_afFiles.get(nIdx);
                    if (fNext == null || !fFile.equals(fNext)) continue;
                    nUpdateRow = nIdx;
                    this.m_afFiles.remove(nUpdateRow);
                    this.m_afFiles.insertElementAt(fFile, nUpdateRow);
                }
            }
            if (nUpdateRow > -1) {
                this.fireTableRowsUpdated(nUpdateRow, nUpdateRow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsValidRow(int nRow) {
        boolean bIsValid = false;
        Object object = this.m_Crit;
        synchronized (object) {
            if (nRow >= 0 && nRow < this.m_afFiles.size()) {
                bIsValid = true;
            }
        }
        return bIsValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AddRow(CFile fAddFile, boolean bUpdateGUI) {
        int nInserted = -1;
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_afFiles == null) {
                this.m_afFiles = new Vector();
            }
            if (this.m_afFiles != null) {
                if (fAddFile != null) {
                    this.m_afFiles.add(fAddFile);
                }
                nInserted = this.m_afFiles.size() - 1;
                if (bUpdateGUI) {
                    if (CMainFrame.DEBUG_TRACK_RECV_CHILD_FILES) {
                        this.m_SpeedTest.Start();
                    }
                    this.fireIntervalAdded(this, nInserted, nInserted);
                    if (CMainFrame.DEBUG_TRACK_RECV_CHILD_FILES) {
                        this.m_SpeedTest.Stop();
                        this.m_SpeedTest.PrintResults("Add file to UI | CFilePanel | fireIntervalAdded");
                    }
                }
            }
        }
        return nInserted;
    }

    public void SetSelModel(CFileSelModel rSelModel) {
        this.m_SelModel = rSelModel;
    }

    private CFileSelModel GetSelModel() {
        return this.m_SelModel;
    }

    public boolean IsFirstDisplayFileSet() {
        return this.m_bIsFirstDisplayFileSet;
    }

    public void UpdateRow(int nRow) {
        if (nRow >= 0 && nRow < this.getRowCount()) {
            this.fireTableRowsUpdated(nRow, nRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] GetFilesAsArray() {
        Object[] aFiles = null;
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_afFiles != null) {
                aFiles = this.m_afFiles.toArray();
            }
        }
        return aFiles;
    }

    public int GetSortDirection() {
        int nSortDir = 1;
        if (this.m_Comparator != null) {
            nSortDir = this.m_Comparator.GetSortDirection();
        }
        return nSortDir;
    }

    public int GetSortModelCol() {
        int nSortCol = 0;
        if (this.m_Comparator != null) {
            nSortCol = this.m_Comparator.GetSortModelCol();
        }
        return nSortCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Sorted(Object[] aSorted) {
        CFilePanel rPanel;
        if (this.m_afFiles != null) {
            Object object = this.m_Crit;
            synchronized (object) {
                this.m_afFiles.removeAllElements();
                for (int nIdx = 0; nIdx < aSorted.length; ++nIdx) {
                    this.m_afFiles.add((CFile)aSorted[nIdx]);
                }
            }
        }
        this.m_jTable.invalidate();
        this.m_jTable.repaint();
        this.m_jList.invalidate();
        this.m_jList.repaint();
        if (this.m_jTable != null && (rPanel = (CFilePanel)SwingUtilities.getAncestorOfClass(CFilePanel.class, this.m_jTable)) != null) {
            rPanel.LoadSelections();
        }
    }

    public void KillThreads() {
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().KillThread(this.m_SortThread);
        } else if (this.m_SortThread != null) {
            this.m_SortThread.Quit(true);
        }
    }

    public void StopSorting() {
        if (this.m_SortThread != null) {
            this.m_SortThread.CancelAllJobs();
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SORTING = false;
    }
}

