/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFileListCellRenderer;
import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.FilePanel.CThumbLabel;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.base.gui.tables.CTableUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class CFileListCellImageRenderer
extends JPanel
implements ListCellRenderer {
    private static final int TRANSPARENCY_VALUE = 128;
    private static final boolean DEBUG = CMainFrame.DEBUG;
    private static final int THUMB_CLR_OFFSET = 80;
    private int m_nViewMode;
    private CThumbLabel m_cImageLabel;
    private JLabel m_jTextLabel;
    private CFilePanel m_rFilePanel;
    private boolean m_bHasFocusClrs = false;

    public CFileListCellImageRenderer(int nViewMode, CFilePanel rFilePanel) {
        this.m_nViewMode = nViewMode;
        this.m_rFilePanel = rFilePanel;
        this.OnCreate();
    }

    private void OnCreate() {
        this.m_cImageLabel = new CThumbLabel();
        this.m_jTextLabel = new JLabel();
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_cImageLabel, "Center");
        this.add((Component)this.m_jTextLabel, "South");
        this.m_jTextLabel.setHorizontalAlignment(0);
        this.m_jTextLabel.setVerticalAlignment(3);
        this.m_jTextLabel.setAlignmentX(0.5f);
        this.m_jTextLabel.setAlignmentY(1.0f);
    }

    public Component getListCellRendererComponent(JList rList, Object rVal, int nIndex, boolean bIsSelected, boolean bHasFocus) {
        if (CFileListCellRenderer.IsDropLocDir(rList, nIndex)) {
            bIsSelected = true;
        }
        this.UpdateHasFocusColor(bIsSelected, rList, this, this.m_cImageLabel, this.m_jTextLabel);
        Border rCellBorder = this.GetCellBorder(bHasFocus);
        this.setBorder(rCellBorder);
        if (this.m_nViewMode == 0) {
            this.m_cImageLabel.setVerticalAlignment(1);
        } else {
            this.m_cImageLabel.setVerticalAlignment(0);
        }
        this.m_cImageLabel.setBorder(this.GetImageBorder(rList));
        if (rVal instanceof CFile) {
            CFile fFile = (CFile)rVal;
            Icon icoImage = fFile.GetIcon32();
            if (this.m_nViewMode == 4 && fFile.IsThumbSupported(true)) {
                int nThumbWidth = 100;
                int nThumbHeight = 100;
                if (this.GetFilePanel() != null) {
                    nThumbWidth = this.GetFilePanel().GetThumbWidth();
                    nThumbHeight = this.GetFilePanel().GetThumbHeight();
                }
                if ((icoImage = fFile.GetIconThumb(nThumbWidth, nThumbHeight)) == null) {
                    icoImage = fFile.GetIcon32();
                }
            }
            if (icoImage != null) {
                this.m_cImageLabel.setIcon(icoImage);
                this.m_cImageLabel.DullTheIcon(fFile.IsDisplayIconDull());
            }
            if (!bIsSelected) {
                Color clrFore = fFile.GetDisplayColor(this.getForeground());
                this.m_jTextLabel.setForeground(clrFore);
            }
            this.m_jTextLabel.setText(fFile.GetDisplayName());
        }
        return this;
    }

    public void SetView(int nViewMode) {
        this.m_nViewMode = nViewMode;
    }

    private Border GetCellBorder(boolean bHasFocus) {
        Insets rInsets;
        CompoundBorder rCellBorder = null;
        Border rFocusBorder = CTableUtils.GetFocusCellBorder();
        if (rFocusBorder != null && (rInsets = rFocusBorder.getBorderInsets(this)) != null) {
            Border rPaddingBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            rCellBorder = bHasFocus ? BorderFactory.createCompoundBorder(rFocusBorder, rPaddingBorder) : BorderFactory.createCompoundBorder(rPaddingBorder, BorderFactory.createEmptyBorder(rInsets.top, rInsets.left, rInsets.bottom, rInsets.right));
        }
        return rCellBorder;
    }

    public Insets GetTotalInsets() {
        Insets rTotal = new Insets(0, 0, 0, 0);
        Object[] aItems = new Object[6];
        aItems[0] = this.GetCellBorder(false);
        aItems[1] = this;
        if (this.m_cImageLabel != null) {
            aItems[2] = this.m_cImageLabel.getBorder();
            aItems[3] = this.m_cImageLabel;
        }
        if (this.m_jTextLabel != null) {
            aItems[4] = this.m_jTextLabel.getBorder();
            aItems[5] = this.m_jTextLabel;
        }
        for (int nIdx = 0; nIdx < aItems.length; nIdx += 2) {
            Component rComp;
            Border rBorder;
            Insets rInsets;
            Object rNext1 = aItems[nIdx];
            Object rNext2 = aItems[nIdx + 1];
            if (!(rNext1 instanceof Border) || !(rNext2 instanceof Component) || (rInsets = (rBorder = (Border)rNext1).getBorderInsets(rComp = (Component)rNext2)) == null) continue;
            rTotal.top += rInsets.top;
            rTotal.left += rInsets.left;
            rTotal.bottom += rInsets.bottom;
            rTotal.right += rInsets.right;
        }
        return rTotal;
    }

    public Rectangle GetEditorRect(JList rList, int nIndex) {
        Rectangle rScreenCoords = new Rectangle(0, 0, 0, 0);
        if (rList != null) {
            Insets rInsets;
            Point ptScreenLoc = new Point(0, 0);
            Rectangle rCellRect = rList.getCellBounds(nIndex, nIndex);
            if (rCellRect != null) {
                ptScreenLoc.setLocation(rCellRect.x, rCellRect.y);
            }
            SwingUtilities.convertPointToScreen(ptScreenLoc, rList);
            rScreenCoords.x = ptScreenLoc.x;
            rScreenCoords.y = ptScreenLoc.y;
            if (rCellRect != null) {
                rScreenCoords.width = rCellRect.width;
                rScreenCoords.height = rCellRect.height;
            }
            int y2 = rScreenCoords.y + rScreenCoords.height;
            int nHeight2 = 0;
            Border rBorder = this.getBorder();
            if (rBorder != null && (rInsets = rBorder.getBorderInsets(this)) != null) {
                y2 -= rInsets.bottom;
                nHeight2 += rInsets.bottom;
            }
            if (this.m_jTextLabel != null) {
                int nTxtHeight = this.m_jTextLabel.getHeight();
                y2 -= nTxtHeight;
                nHeight2 += nTxtHeight;
            }
            rScreenCoords.y = y2;
            if (nHeight2 > 0) {
                rScreenCoords.height = nHeight2;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rList = null");
        }
        return rScreenCoords;
    }

    private Border GetImageBorder(JList rList) {
        Border rRet = null;
        if (rList != null) {
            Color rClr = CTableUtils.GetSortColor(rList.getBackground(), 80);
            int nBorderWidth = 1;
            rRet = this.m_nViewMode == 4 ? BorderFactory.createLineBorder(rClr, nBorderWidth) : BorderFactory.createEmptyBorder(nBorderWidth, nBorderWidth, nBorderWidth, nBorderWidth);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rList = null");
        }
        return rRet;
    }

    protected CFilePanel GetFilePanel() {
        return this.m_rFilePanel;
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean GetHasFocusClrs() {
        return this.m_bHasFocusClrs;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, JList rList, Component ... arComps) {
        Color clrListFore = UIManager.getColor("List.foreground");
        Color clrListBack = UIManager.getColor("List.background");
        Color clrListForeSel = UIManager.getColor("List.selectionForeground");
        Color clrListBackSel = UIManager.getColor("List.selectionBackground");
        Color clrFore = clrListFore;
        Color clrBack = clrListBack;
        if (bIsSelected) {
            clrFore = clrListForeSel;
            clrBack = clrListBackSel;
            if (!this.GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorUtils.IsADarkColor(clrFore) && !CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrListFore.getRGB() < clrListForeSel.getRGB() ? clrListFore : clrListForeSel;
                } else if (CColorUtils.IsADarkColor(clrFore) && CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrListFore.getRGB() > clrListForeSel.getRGB() ? clrListFore : clrListForeSel;
                }
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackground(clrBack);
    }

    class CImageLabel
    extends JLabel {
        private boolean m_bShowHiddenIcon = false;
        private Color m_clrDull = new Color(240, 240, 240, 150);
        private Image m_imgOriginal;
        private Image m_imgNew;
        private MemoryImageSource m_MemImgSource;
        private int m_nWidth2;
        private int m_nHeight2;
        private int[] m_anOriginalPixelArray;
        private boolean m_bImageLoaded = false;

        public CImageLabel() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setAlignmentX(0.5f);
            this.setAlignmentY(0.5f);
        }

        public void ShowHiddenIcon(boolean bVal) {
            this.m_bShowHiddenIcon = bVal;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (CFileListCellImageRenderer.this.m_nViewMode == 0) {
                this.m_imgOriginal = ((ImageIcon)this.getIcon()).getImage();
                try {
                    PixelGrabber grabber = new PixelGrabber(this.m_imgOriginal, 0, 0, -1, -1, true);
                    if (grabber.grabPixels()) {
                        if (this.m_MemImgSource == null) {
                            this.m_nWidth2 = grabber.getWidth();
                            this.m_nHeight2 = grabber.getHeight();
                            this.m_anOriginalPixelArray = (int[])grabber.getPixels();
                            this.m_MemImgSource = new MemoryImageSource(this.m_nWidth2, this.m_nHeight2, this.m_anOriginalPixelArray, 0, this.m_nWidth2);
                            this.m_MemImgSource.setAnimated(true);
                            this.m_imgNew = this.createImage(this.m_MemImgSource);
                        }
                        if (this.m_imgNew != null) {
                            g.drawImage(this.m_imgNew, 0, 0, this);
                            if (!this.m_bImageLoaded) {
                                for (int x = 0; x < this.m_nWidth2; ++x) {
                                    for (int y = 0; y < this.m_nHeight2; ++y) {
                                        int nValue = this.m_anOriginalPixelArray[x * this.m_nHeight2 + y];
                                        int nAlpha = nValue >> 24 & 0xFF;
                                        int nSourceRed = nValue >> 16 & 0xFF;
                                        int nSourceGreen = nValue >> 8 & 0xFF;
                                        int nSourceBlue = nValue & 0xFF;
                                        nAlpha = 120;
                                        nValue = nAlpha << 24;
                                        nValue += nSourceRed << 16;
                                        nValue += nSourceGreen << 8;
                                        this.m_anOriginalPixelArray[x * this.m_nHeight2 + y] = nValue += nSourceBlue;
                                    }
                                    this.m_MemImgSource.newPixels();
                                }
                            }
                        } else {
                            System.err.println("Grabbing Failed");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    System.err.println("Pixel Grabbing Interrupted");
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_bShowHiddenIcon && this.getIcon() != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(this.m_clrDull);
                int nVertAlignment = this.getVerticalAlignment();
                int nHorzAlignment = this.getHorizontalAlignment();
                float fXAlignment = this.getAlignmentX();
                float fYAlignment = this.getAlignmentY();
                if (DEBUG) {
                    System.out.printf("HorzAlignment: %d  |  VertAlignment: %d  |  XAlignment: %.2f  |  YAlignment: %.2f\r\n", nHorzAlignment, nVertAlignment, Float.valueOf(fXAlignment), Float.valueOf(fYAlignment));
                }
            }
        }
    }
}

