/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CFileCellEditorDoc
extends PlainDocument
implements ActionListener {
    private static final int MAX_EXCLUDED_CHARS = 9;
    private static final int XCHAR_COLON = 0;
    private static final int XCHAR_STAR = 1;
    private static final int XCHAR_QUESTION_MARK = 2;
    private static final int XCHAR_DOUBLE_QUOTE = 3;
    private static final int XCHAR_LESS_THAN = 4;
    private static final int XCHAR_GREATER_THAN = 5;
    private static final int XCHAR_PIPE = 6;
    private static final int XCHAR_FORWARD_SLASH = 7;
    private static final int XCHAR_BACK_SLASH = 8;
    private StringBuilder m_sbToopTipMsg;
    private char[] m_chExcludedChars;
    private JTextField m_jEditorObj;
    private JToolTip m_jToolTipObj;
    private Popup m_rExcludePopupTip;
    private Timer m_rExcludePopupTimer;

    public CFileCellEditorDoc(JTextField jEditor) {
        this.m_jEditorObj = jEditor;
        this.m_jToolTipObj = new JToolTip();
        this.InitExcludedChars();
        this.InitToolTipMsg();
        this.m_jToolTipObj.setTipText(this.m_sbToopTipMsg.toString());
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str != null) {
            boolean bInsert;
            boolean bl = bInsert = !this.ContainsExcludedChar(str);
            if (bInsert) {
                super.insertString(offs, str, a);
            } else if (this.m_jEditorObj != null) {
                this.ShowExcludedToolTip();
            }
        }
    }

    private void ShowExcludedToolTip() {
        if (!this.m_jToolTipObj.isShowing() && this.m_jEditorObj != null && this.m_jEditorObj.isVisible()) {
            Point ptOnScreen = this.m_jEditorObj.getLocationOnScreen();
            int nXLoc = ptOnScreen.x;
            int nYLoc = ptOnScreen.y + (this.m_jEditorObj.getHeight() + 6);
            this.m_rExcludePopupTip = PopupFactory.getSharedInstance().getPopup(this.m_jEditorObj, this.m_jToolTipObj, nXLoc, nYLoc);
            this.m_rExcludePopupTip.show();
            this.InitExcludeTimer();
            this.StartExcludeTimer();
        }
    }

    private void InitExcludedChars() {
        this.m_chExcludedChars = new char[9];
        this.m_chExcludedChars[0] = 58;
        this.m_chExcludedChars[1] = 42;
        this.m_chExcludedChars[2] = 63;
        this.m_chExcludedChars[3] = 34;
        this.m_chExcludedChars[4] = 60;
        this.m_chExcludedChars[5] = 62;
        this.m_chExcludedChars[6] = 124;
        this.m_chExcludedChars[7] = 47;
        this.m_chExcludedChars[8] = 92;
    }

    private boolean IsExcludedChar(char chChar) {
        boolean bIsExcludedChar = false;
        for (int nIdx = 0; nIdx < this.m_chExcludedChars.length; ++nIdx) {
            if (this.m_chExcludedChars[nIdx] != chChar) continue;
            bIsExcludedChar = true;
            break;
        }
        return bIsExcludedChar;
    }

    private void InitToolTipMsg() {
        this.m_sbToopTipMsg = new StringBuilder("<HTML>A file name cannot contain any of the following characters:<br><center>");
        for (int nIdx = 0; nIdx < this.m_chExcludedChars.length; ++nIdx) {
            this.m_sbToopTipMsg.append(this.m_chExcludedChars[nIdx]);
            this.m_sbToopTipMsg.append(' ');
        }
        this.m_sbToopTipMsg.append("</center></HTML>");
    }

    private boolean ContainsExcludedChar(String sFileName) {
        boolean bFound = false;
        for (int nIdx = 0; nIdx < sFileName.length(); ++nIdx) {
            if (!this.IsExcludedChar(sFileName.charAt(nIdx))) continue;
            bFound = true;
            break;
        }
        return bFound;
    }

    public boolean IsValidFileName(String sFileName) {
        boolean bIsValid = false;
        if (sFileName.length() > 0) {
            bIsValid = !this.ContainsExcludedChar(sFileName);
        }
        return bIsValid;
    }

    public void updateUI() {
        if (this.m_jToolTipObj != null) {
            this.m_jToolTipObj.updateUI();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.GetExcludeTimer()) {
            this.StopExcludeTimer();
            if (this.GetExcludePopupTip() != null) {
                this.GetExcludePopupTip().hide();
            }
        }
    }

    private Popup GetExcludePopupTip() {
        return this.m_rExcludePopupTip;
    }

    private Timer GetExcludeTimer() {
        return this.m_rExcludePopupTimer;
    }

    private void InitExcludeTimer() {
        if (this.GetExcludeTimer() == null) {
            this.m_rExcludePopupTimer = new Timer(5000, this);
        }
    }

    private void StartExcludeTimer() {
        if (this.GetExcludeTimer() != null) {
            if (this.GetExcludeTimer().isRunning()) {
                this.GetExcludeTimer().restart();
            } else {
                this.GetExcludeTimer().start();
            }
        }
    }

    private void StopExcludeTimer() {
        if (this.GetExcludeTimer() != null) {
            this.GetExcludeTimer().stop();
        }
    }
}

