/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFileCellEditorDoc;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmRenameReadOnlyDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.text.Document;

public class CFileCellEditor
extends JTextField
implements ActionListener,
KeyListener,
FocusListener {
    private static final int MIN_WIDTH = 20;
    private static final int MIN_HEIGHT = 10;
    private static final int LAUNCH_EDITOR = 600;
    private JComponent m_cOwner;
    private Popup m_jPopupEditor;
    private boolean m_bPopupVisible = false;
    private Timer m_jEditorTimer;
    private boolean m_bConfirmationInProgress = false;
    private CFile m_fFile;
    private boolean m_bWarnOnReadOnly = true;
    private boolean m_bPending = false;
    private CBaseThread m_tThread;
    private long m_lMarker;

    public CFileCellEditor(JComponent rOwner, CBaseThread tThread) {
        this.m_cOwner = rOwner;
        this.m_tThread = tThread;
        Border EmptyLeftBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), EmptyLeftBorder));
        this.setDocument(new CFileCellEditorDoc(this));
        this.addActionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void ShowEditor(int nScreenXLoc, int nScreenYLoc, int nWidth, int nHeight, CFile fFile) {
        if (!this.isShowing()) {
            this.SetFile(fFile);
            String sOriginalName = this.GetOriginalName();
            this.setText(sOriginalName);
            Dimension dimMinSize = new Dimension(20, 10);
            this.setMinimumSize(dimMinSize);
            Dimension dimPrefSize = new Dimension(nWidth, nHeight);
            this.setPreferredSize(dimPrefSize);
            this.setBounds(0, 0, nWidth, nHeight);
            this.m_jPopupEditor = PopupFactory.getSharedInstance().getPopup(this.m_cOwner, this, nScreenXLoc, nScreenYLoc);
            this.ShowPopup();
            this.requestFocusInWindow();
        }
    }

    public boolean HideEditor(boolean bCommit) {
        boolean bHideEditor = true;
        if (bCommit) {
            bHideEditor = this.CommitFileName();
        }
        if (bHideEditor && this.m_bPopupVisible) {
            this.HidePopup();
        }
        return this.m_bPopupVisible;
    }

    protected boolean CommitFileName() {
        boolean bCommitted = true;
        if (!this.m_bPending) {
            CFileCellEditorDoc doc;
            this.m_bPending = true;
            if (this.isShowing() && (doc = (CFileCellEditorDoc)this.getDocument()) != null) {
                String sNewRelativeFileName = this.getText();
                if (doc.IsValidFileName(sNewRelativeFileName)) {
                    String sOriginalName = this.GetOriginalName();
                    if (sNewRelativeFileName != null && sNewRelativeFileName.length() > 0 && sOriginalName != null && sOriginalName.length() > 0 && !sOriginalName.equals(sNewRelativeFileName) && this.m_fFile != null) {
                        boolean bIsReadOnly = this.m_fFile.IsReadOnly();
                        if (this.m_bWarnOnReadOnly && bIsReadOnly) {
                            String sMsg = String.format(CString.LoadString("IDS_CONFIRM_RENAME_READ_ONLY_MSG"), sOriginalName, sNewRelativeFileName);
                            this.m_bConfirmationInProgress = true;
                            Frame rFrame = null;
                            if (this.m_cOwner != null) {
                                rFrame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.m_cOwner);
                            }
                            CConfirmRenameReadOnlyDlg dlg = new CConfirmRenameReadOnlyDlg(rFrame, true, -1L);
                            dlg.SetMainMsg(sMsg);
                            dlg.setVisible(true);
                            int nRc = dlg.GetExitCode();
                            this.m_bConfirmationInProgress = false;
                            if (nRc != 0) {
                                bCommitted = false;
                                this.setText(sOriginalName);
                                this.SelectText();
                            }
                        }
                        if (bCommitted) {
                            bCommitted = this.CommitNewFileName(sNewRelativeFileName);
                        }
                    }
                } else {
                    bCommitted = false;
                }
            }
            this.m_bPending = false;
        }
        return bCommitted;
    }

    protected void SetFile(CFile fFile) {
        this.m_fFile = fFile;
    }

    public void SetWarnOnReadOnly(boolean bWarnOnReadOnly) {
        this.m_bWarnOnReadOnly = bWarnOnReadOnly;
    }

    private String GetOriginalName() {
        String sName = "";
        if (this.m_fFile != null) {
            sName = CString.GetFileName(this.m_fFile.GetAbsFileName());
            if (CMainFrame.DEBUG && (sName == null || sName.isEmpty())) {
                System.out.println("ASSERT:  CFileCellEditor failed to get a valid string for its edit control");
            }
        }
        return sName;
    }

    protected boolean CommitNewFileName(String sNewRelativeFileName) {
        boolean bCommitted = false;
        if (this.m_fFile != null) {
            if (!this.m_fFile.IsLocal() || CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                sNewRelativeFileName = sNewRelativeFileName.trim();
            }
            String sAbsRenameTo = CString.ConvertRelativePath(this.m_fFile.GetParentPath(false), sNewRelativeFileName);
            if (this.m_cOwner != null && CMainFrame.GET_APP() != null) {
                this.m_fFile.Rename(this.GetThread(), this.m_cOwner, sNewRelativeFileName);
                bCommitted = true;
            }
        }
        return bCommitted;
    }

    private void SelectText() {
        boolean bExcludeExt = false;
        if (this.m_fFile != null) {
            bExcludeExt = this.m_fFile.IsDir();
        }
        this.SelectText(bExcludeExt);
    }

    private void SelectText(boolean bExcludeExt) {
        String sOriginalName = this.GetOriginalName();
        int nLastPeriod = CString.ReverseFind(Character.valueOf('.'), sOriginalName);
        if (!bExcludeExt && nLastPeriod > 0 && nLastPeriod < sOriginalName.length()) {
            this.select(0, nLastPeriod);
        } else {
            this.selectAll();
        }
    }

    public void SetOwner(JComponent cOwner) {
        this.m_cOwner = cOwner;
    }

    @Override
    public void focusGained(FocusEvent jEvent) {
        String sOriginalName = this.GetOriginalName();
        this.SelectText();
    }

    @Override
    public void focusLost(FocusEvent jEvent) {
        if (!this.m_bConfirmationInProgress) {
            this.HideEditor(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent jEvent) {
        this.HideEditor(true);
    }

    @Override
    public void keyTyped(KeyEvent jEvent) {
    }

    @Override
    public void keyPressed(KeyEvent jEvent) {
        int nKeyID = jEvent.getKeyCode();
        if (nKeyID == 10) {
            jEvent.consume();
            this.HideEditor(true);
        } else if (nKeyID == 27) {
            jEvent.consume();
            this.HideEditor(false);
        } else if (nKeyID == 38) {
            jEvent.setKeyCode(37);
        } else if (nKeyID == 40) {
            jEvent.setKeyCode(39);
        }
    }

    @Override
    public void keyReleased(KeyEvent jEvent) {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Document rDoc = this.getDocument();
        if (rDoc != null && rDoc instanceof CFileCellEditorDoc) {
            ((CFileCellEditorDoc)rDoc).updateUI();
        }
    }

    private CBaseThread GetThread() {
        return this.m_tThread;
    }

    private boolean ShowPopup() {
        boolean bShowing = false;
        if (this.m_jPopupEditor != null) {
            this.m_jPopupEditor.show();
            this.m_bPopupVisible = true;
        }
        return this.m_bPopupVisible;
    }

    private boolean HidePopup() {
        boolean bHidden = false;
        if (this.m_jPopupEditor != null) {
            this.m_jPopupEditor.hide();
            this.m_bPopupVisible = false;
        }
        return bHidden;
    }

    public void SetMarker(long lMarker) {
        this.m_lMarker = lMarker;
    }

    public long GetMarker() {
        return this.m_lMarker;
    }
}

