/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.fvjv.gui.events.dragdrop.ICompleteDragDrop;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CDragDropRightClickMenu
extends JPopupMenu
implements ActionListener {
    private boolean m_bIsSearch;
    private boolean m_bIsMove;
    private JMenuItem m_cCopyMenuItem;
    private JMenuItem m_cMoveMenuItem;
    private JMenuItem m_cCancelMenuItem;
    private ICompleteDragDrop m_cCompleteDragDrop;
    private CPath m_rDragSourceDir;
    private CPath[] m_arDragSourceFiles;
    private CPath m_rDropTargetDir;

    public CDragDropRightClickMenu(ICompleteDragDrop rCompleteDragDrop) {
        this.InitVars(rCompleteDragDrop);
    }

    private void InitVars(ICompleteDragDrop rCompleteDragDrop) {
        this.m_cCompleteDragDrop = rCompleteDragDrop;
        this.m_bIsSearch = false;
        this.m_bIsMove = false;
        this.m_rDragSourceDir = null;
        this.m_arDragSourceFiles = null;
        this.m_rDropTargetDir = null;
        this.m_cCopyMenuItem = new JMenuItem(CString.LoadString("IDS_DND_COPY_HERE"));
        this.m_cMoveMenuItem = new JMenuItem(CString.LoadString("IDS_DND_MOVE_HERE"));
        this.m_cCancelMenuItem = new JMenuItem(CString.LoadString("IDS_CANCEL"));
        this.m_cCopyMenuItem.addActionListener(this);
        this.m_cMoveMenuItem.addActionListener(this);
        this.m_cCancelMenuItem.addActionListener(this);
        this.add(this.m_cCopyMenuItem);
        this.add(this.m_cMoveMenuItem);
        this.addSeparator();
        this.add(this.m_cCancelMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent.getSource() == this.m_cCopyMenuItem) {
            if (this.GetCompleteDragDrop() != null) {
                this.GetCompleteDragDrop().CompleteDragDrop(this.GetDragSourceDir(), this.GetDropTargetDir(), this.GetDragSourceFiles(), false, this.IsSearch(), false, null);
            }
        } else if (rEvent.getSource() == this.m_cMoveMenuItem && this.GetCompleteDragDrop() != null) {
            this.GetCompleteDragDrop().CompleteDragDrop(this.GetDragSourceDir(), this.GetDropTargetDir(), this.GetDragSourceFiles(), true, this.IsSearch(), false, null);
        }
    }

    @Override
    public void setVisible(boolean bVisible) {
        this.FmtBoldText();
        this.PreventRemoteCopy();
        super.setVisible(bVisible);
    }

    private void FmtBoldText() {
        String sCopy = CString.LoadString("IDS_DND_COPY_HERE");
        String sMove = CString.LoadString("IDS_DND_MOVE_HERE");
        if (!this.IsMove()) {
            sCopy = String.format(CFilePanel.HTML_FMT_BOLD, sCopy);
        } else {
            sMove = String.format(CFilePanel.HTML_FMT_BOLD, sMove);
        }
        this.m_cCopyMenuItem.setText(sCopy);
        this.m_cMoveMenuItem.setText(sMove);
    }

    private boolean IsMove() {
        return this.m_bIsMove;
    }

    public void SetIsMove(boolean bIsMove) {
        this.m_bIsMove = bIsMove;
    }

    private boolean IsSearch() {
        return this.m_bIsSearch;
    }

    public void SetIsSearch(boolean bIsSearch) {
        this.m_bIsSearch = bIsSearch;
    }

    public ICompleteDragDrop GetCompleteDragDrop() {
        return this.m_cCompleteDragDrop;
    }

    public void SetDragSourceDir(CPath rDragSourceDir) {
        this.m_rDragSourceDir = rDragSourceDir;
    }

    public CPath GetDragSourceDir() {
        return this.m_rDragSourceDir;
    }

    public void SetDragSourceFiles(CPath[] arDragSourceFiles) {
        this.m_arDragSourceFiles = arDragSourceFiles;
    }

    public CPath[] GetDragSourceFiles() {
        return this.m_arDragSourceFiles;
    }

    public void SetDropTargetDir(CPath rDropTargetDir) {
        this.m_rDropTargetDir = rDropTargetDir;
    }

    public CPath GetDropTargetDir() {
        return this.m_rDropTargetDir;
    }

    private void PreventRemoteCopy() {
        if (this.m_rDragSourceDir != null && this.m_rDropTargetDir != null && !this.m_rDragSourceDir.IsLocal() && !this.m_rDropTargetDir.IsLocal() && this.m_cCopyMenuItem != null) {
            this.m_cCopyMenuItem.setVisible(false);
        }
    }
}

