/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.utils;

import com.rhinosoft.ui.CRhinoApp;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;

public class CDateFormatStringVerifier
extends InputVerifier
implements ActionListener,
KeyListener,
FocusListener {
    public static boolean DEBUG = CRhinoApp.DEBUG;
    public static final String KEY_PREV_FOREGROUND_CLR = "PrevForegroundClr";
    private static final int TIMER_DELAY = 2000;
    private boolean m_bUseTimer;
    private Timer m_Timer;
    private JComponent m_cTimerComp;
    private boolean m_bAllowTimerVerfication;

    public CDateFormatStringVerifier() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_bUseTimer = true;
        this.m_Timer = new Timer(2000, this);
        this.m_bAllowTimerVerfication = false;
    }

    protected void UseTimer(boolean bUseTimer) {
        this.m_bUseTimer = bUseTimer;
    }

    private void StartTimer(boolean bRestart) {
        if (this.m_bUseTimer) {
            if (bRestart) {
                this.m_Timer.restart();
            } else if (!this.m_Timer.isRunning()) {
                this.m_Timer.start();
            }
        }
        this.m_bAllowTimerVerfication = true;
    }

    private void StopTimer() {
        if (this.m_Timer.isRunning()) {
            this.m_Timer.stop();
        }
    }

    public void AddWatch(JTextField rComp) {
        if (rComp != null) {
            rComp.setInputVerifier(this);
            rComp.addActionListener(this);
            rComp.addKeyListener(this);
            rComp.addFocusListener(this);
        }
    }

    public static boolean IsValid(String sPattern) {
        boolean bIsValid = false;
        if (sPattern != null && !sPattern.isEmpty()) {
            FieldPosition rFieldPos;
            StringBuffer sBuf;
            Date dtCur;
            SimpleDateFormat rDateFormatter;
            block11: {
                rDateFormatter = new SimpleDateFormat();
                dtCur = new Date();
                sBuf = new StringBuffer();
                rFieldPos = new FieldPosition(0);
                if (rDateFormatter != null && dtCur != null && sBuf != null) {
                    try {
                        rDateFormatter.applyPattern(sPattern);
                        StringBuffer sResult = rDateFormatter.format(dtCur, sBuf, rFieldPos);
                        if (sResult != null) {
                            bIsValid = true;
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        if (DEBUG) {
                            iae.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block11;
                        e.printStackTrace();
                    }
                }
            }
            if (rDateFormatter != null) {
                rDateFormatter = null;
            }
            if (dtCur != null) {
                dtCur = null;
            }
            if (sBuf != null) {
                sBuf = null;
            }
            if (rFieldPos != null) {
                rFieldPos = null;
            }
        }
        return bIsValid;
    }

    public static String Format(String sPattern, Date dtDate, boolean bUseCST, String sDefPattern) {
        DateFormat dtFormatter = DateFormat.getInstance();
        Locale rLocale = new Locale("en", "US");
        if (bUseCST) {
            dtFormatter = DateFormat.getDateTimeInstance(3, 3, rLocale);
            dtFormatter.setTimeZone(TimeZone.getTimeZone("CST"));
        }
        String sRet = dtFormatter.format(dtDate);
        if (dtDate != null) {
            FieldPosition rFieldPos;
            StringBuffer sBuf;
            SimpleDateFormat rDateFormatter;
            block15: {
                rDateFormatter = new SimpleDateFormat();
                sBuf = new StringBuffer();
                rFieldPos = new FieldPosition(0);
                if (rDateFormatter != null && sBuf != null) {
                    if (CDateFormatStringVerifier.IsValid(sPattern)) {
                        if (bUseCST) {
                            rDateFormatter = new SimpleDateFormat(sPattern, rLocale);
                            rDateFormatter.setTimeZone(TimeZone.getTimeZone("CST"));
                        }
                        try {
                            rDateFormatter.applyPattern(sPattern);
                            StringBuffer sResult = rDateFormatter.format(dtDate, sBuf, rFieldPos);
                            if (sResult != null) {
                                sRet = sResult.toString();
                            }
                            break block15;
                        }
                        catch (IllegalArgumentException iae) {
                            if (DEBUG) {
                                iae.printStackTrace();
                            }
                            break block15;
                        }
                        catch (Exception e) {
                            if (DEBUG) {
                                e.printStackTrace();
                            }
                            break block15;
                        }
                    }
                    if (CDateFormatStringVerifier.IsValid(sDefPattern)) {
                        sRet = CDateFormatStringVerifier.Format(sDefPattern, dtDate, bUseCST, null);
                    }
                }
            }
            if (rDateFormatter != null) {
                rDateFormatter = null;
            }
            if (sBuf != null) {
                sBuf = null;
            }
            if (rFieldPos != null) {
                rFieldPos = null;
            }
        }
        return sRet;
    }

    protected void ChangeForeground(boolean bShowError, JComponent rComp) {
        Object objForeClr = rComp.getClientProperty(KEY_PREV_FOREGROUND_CLR);
        if (objForeClr == null) {
            Color clrFore = rComp.getForeground();
            rComp.putClientProperty(KEY_PREV_FOREGROUND_CLR, clrFore);
        }
        if (bShowError) {
            rComp.setForeground(Color.RED);
        } else if (objForeClr instanceof Color) {
            rComp.setForeground((Color)objForeClr);
        }
        rComp.repaint();
    }

    protected JComponent GetTimerComp() {
        return this.m_cTimerComp;
    }

    protected void SetTimerComp(JComponent rComp) {
        this.m_cTimerComp = rComp;
    }

    @Override
    public boolean verify(JComponent rComp) {
        this.m_bAllowTimerVerfication = false;
        boolean bIsValid = false;
        if (rComp instanceof JTextField) {
            JTextField rTxtField = (JTextField)rComp;
            bIsValid = CDateFormatStringVerifier.IsValid(rTxtField.getText());
        }
        if (!bIsValid) {
            this.ChangeForeground(!bIsValid, rComp);
            Toolkit.getDefaultToolkit().beep();
        }
        return bIsValid;
    }

    @Override
    public void actionPerformed(ActionEvent jEvent) {
        Object objSource = jEvent.getSource();
        if (objSource instanceof JTextField) {
            JTextField jTxtField = (JTextField)objSource;
            this.verify(jTxtField);
        } else if (objSource == this.m_Timer) {
            this.StopTimer();
            if (this.m_bAllowTimerVerfication) {
                this.m_bAllowTimerVerfication = false;
                this.verify(this.m_cTimerComp);
            }
            this.m_cTimerComp = null;
        }
    }

    @Override
    public void keyTyped(KeyEvent rEvent) {
        Object objSource = rEvent.getSource();
        if (objSource instanceof JComponent) {
            JComponent rComp = (JComponent)objSource;
            if (this.GetTimerComp() == null) {
                this.ChangeForeground(false, rComp);
            }
            this.SetTimerComp(rComp);
        }
    }

    @Override
    public void keyPressed(KeyEvent rEvent) {
        Object rObj = rEvent.getSource();
        if (rObj instanceof JComponent && this.m_Timer.isRunning()) {
            this.ChangeForeground(false, (JComponent)rObj);
        }
    }

    @Override
    public void keyReleased(KeyEvent jEvent) {
        this.StartTimer(true);
    }

    @Override
    public void focusGained(FocusEvent rEvent) {
    }

    @Override
    public void focusLost(FocusEvent rEvent) {
        this.StopTimer();
    }
}

