/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableProgressRenderer;
import com.rhinosoft.ui.transfer.CTransferNode;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class CTransferTreeTableProgressRenderer
extends CRhinoTreeTableProgressRenderer {
    public CTransferTreeTableProgressRenderer(CRhinoTreeTable rTreeTable, boolean bShowProgBar) {
        super(rTreeTable, bShowProgBar);
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setStringPainted(true);
            this.GetProgressBar().setVisible(false);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rValue, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, rValue, bIsSelected, bHasFocus, nRow, nCol);
        int nViewCol = nCol;
        nCol = rTable.convertColumnIndexToModel(nCol);
        String sText = "";
        ImageIcon icoIcon = null;
        if (rValue instanceof CTransferNode) {
            CTransferNode rTreeNode = (CTransferNode)rValue;
            if (rTreeNode.IsUpload() || rTreeNode.IsDownload()) {
                switch (nCol) {
                    case 2: {
                        icoIcon = rTreeNode.GetPercentImage();
                        sText = rTreeNode.FormatStatusTxt();
                        break;
                    }
                }
                if (this.GetProgressBar() != null) {
                    this.GetProgressBar().setString(sText);
                    this.GetProgressBar().setToolTipText(sText);
                }
                if (this.GetProgressIcon() != null) {
                    this.GetProgressIcon().setIcon(icoIcon);
                    this.GetProgressIcon().setText(sText);
                }
                boolean bShowProgBar = false;
                if (nCol == 2) {
                    bShowProgBar = true;
                }
                if (!this.GetShowProgBar()) {
                    bShowProgBar = false;
                }
                if (this.GetProgressIcon() != null) {
                    this.GetProgressIcon().setVisible(!bShowProgBar);
                }
                if (this.GetProgressBar() != null) {
                    this.GetProgressBar().setVisible(bShowProgBar);
                }
                this.UpdateProgBar(rTreeNode.GetFileRead(), rTreeNode.GetFileTotal());
            } else if (rTreeNode.IsDelete()) {
                if (this.GetProgressBar() != null) {
                    this.GetProgressBar().setString(sText);
                    this.GetProgressBar().setToolTipText(sText);
                }
                if (this.GetProgressIcon() != null) {
                    this.GetProgressIcon().setText(sText);
                }
                if (this.GetProgressIcon() != null) {
                    this.GetProgressIcon().setVisible(false);
                }
                if (this.GetProgressBar() != null) {
                    this.GetProgressBar().setVisible(false);
                }
            }
        }
        return this;
    }

    protected void UpdateProgBar(long lRead, long lTotal) {
        if (this.GetProgressBar() != null) {
            if (lTotal > 0L) {
                this.GetProgressBar().setIndeterminate(false);
                if (this.GetProgressBar().getMinimum() != 0) {
                    this.GetProgressBar().setMinimum(0);
                }
                if (this.GetProgressBar().getMaximum() != 100) {
                    this.GetProgressBar().setMaximum(100);
                }
                this.GetProgressBar().setValue((int)(lRead * 100L / lTotal));
            } else {
                this.GetProgressBar().setIndeterminate(true);
            }
        }
    }
}

