/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.attrs.CIntAttr;
import com.rhinosoft.attrs.CObjectAttr;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.dialogs.CConfirmMultiDeleteDlg;
import com.rhinosoft.dialogs.CConfirmRelistDlg;
import com.rhinosoft.dialogs.CRhinoOverwriteFileBtn;
import com.rhinosoft.dragdrop.CDndFile;
import com.rhinosoft.dragdrop.CDndMsg;
import com.rhinosoft.dragdrop.CFilesDragDropData;
import com.rhinosoft.dragdrop.CRhinoDragDropData;
import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAddUploadItemsMsg;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CDeleteMsg;
import com.rhinosoft.messages.CDialogShowMsg;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.messages.CSUSourceMsg;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.messages.CTransferMsg;
import com.rhinosoft.messages.CTransferStatsMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.messages.CUnknownMsg;
import com.rhinosoft.messages.CUpdateDynamicBtns;
import com.rhinosoft.messages.CUpdateTransferBtns;
import com.rhinosoft.messages.CUploadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableModel;
import com.rhinosoft.ui.transfer.CTransferNode;
import com.rhinosoft.ui.transfer.CTransferNodeDelete;
import com.rhinosoft.ui.transfer.CTransferNodeParentGroup;
import com.rhinosoft.ui.transfer.CTransferNodeRoot;
import com.rhinosoft.ui.transfer.CTransferNodeTransfer;
import com.rhinosoft.ui.transfer.CTransferThread;
import com.rhinosoft.ui.transfer.CTransferTreeTable;
import com.rhinosoft.ui.transfer.CTransferTreeTableProgressRenderer;
import com.rhinosoft.utils.CSpeedTest;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CTransferTreeTableModel
extends CRhinoTreeTableModel
implements ActionListener {
    public static boolean DEBUG_UNKNOWN_MSG;
    public static boolean DEBUG_REPAINT_IMMEDIATELY;
    public static boolean DEBUG_SHOW_EXTRA_COLS;
    public static boolean DEBUG_XFER_STATS_SIZE;
    public static boolean DEBUG_CHECK_NEXT_NODE;
    public static boolean DEBUG_ASSIGN_THREAD;
    public static boolean DEBUG_REMOVE_PARENTS;
    public static boolean DEBUG_WRONG_DLG_TYPE;
    public static boolean DEBUG_UPDATE_BTN_MSG;
    public static final int COL_OPERATION = 0;
    public static final int COL_NAME = 1;
    public static final int COL_STATUS = 2;
    public static final int COL_COMPLETION = 3;
    public static final int COL_PATH_SOURCE = 4;
    public static final int COL_PATH_TARGET = 5;
    public static int COL_MAX;
    public static final int COL_THREAD = 6;
    public static final int COL_SOURCE_LISTED = 7;
    public static final int COL_TARGET_LISTED = 8;
    public static final int COL_NUM_LISTED = 9;
    public static final int COL_NUM_PENDING = 10;
    public static final int COL_NUM_COMPLETE = 11;
    public static final int COL_NUM_CHILDREN = 12;
    public static final int COL_NUM_CHILD_DIRS = 13;
    public static final int COL_NUM_CHILD_FILES = 14;
    public static final int COL_CONFIRM_ERROR = 15;
    public static final int COL_CONFIRM_MERGE_FOLDER = 16;
    public static final int COL_CONFIRM_OVERWRITE = 17;
    public static final int COL_CONFIRM_DELETE_FOLDER = 18;
    public static final int COL_CONFIRM_DELETE_FILE = 19;
    public static final int COL_CONFIRM_MUTLI_DELETE = 20;
    public static final int COL_ENABLE_CONFIRM_DELETES_FOLDER = 21;
    public static final int COL_ENABLE_CONFIRM_DELETES_FILE = 22;
    public static final int COL_ENABLE_CONFIRM_OVERWRITES_UPLOAD_FILE = 23;
    public static final int COL_ENABLE_CONFIRM_OVERWRITES_DOWNLOAD_FILE = 24;
    public static final int COL_ENABLE_STOP = 25;
    public static final int COL_ENABLE_SKIP = 26;
    public static final int COL_ENABLE_PAUSE = 27;
    public static final int COL_ENABLE_RESUME = 28;
    public static final int COL_ENABLE_START = 29;
    public static final int COL_ENABLE_RESTART = 30;
    public static final int COL_ENABLE_CANCEL = 31;
    public static final int COL_ENABLE_REMOVE = 32;
    public static final int COL_ENABLE_REMOVE_ALL_COMPLETED = 33;
    public static final int COL_ENABLE_REMOVE_ALL_CANCELLED = 34;
    public static final int COL_ENABLE_REMOVE_ALL_SKIPPED = 35;
    public static final int COL_ENABLE_REMOVE_ALL_PAUSED = 36;
    public static final int COL_ENABLE_REMOVE_ALL_WAITING = 37;
    public static final int COL_ENABLE_REMOVE_ALL_STOPPED = 38;
    public static final int COL_MAX_DEBUG = 39;
    private static int m_nWorkerNameIdx;
    private CTransferNode m_TransferRootNode;
    private CConnectionAttrs m_ConnectionAttrs;
    private CBoolAttr m_rbAutoExpandNewTransfers;
    private CBoolAttr m_rbAutoStartNewTransfers;
    private CBoolAttr m_rbAutoRemoveCompletedTransfers;
    private CIntAttr m_rnNumOfTransferThreads;
    private final Object m_TransferThreadVectorCrit = new Object();
    private Vector<CTransferThread> m_aActiveThreads = new Vector();
    private Vector<CTransferThread> m_aDeleteThreads = new Vector();
    private Timer m_WatchDogTimer;
    private long m_lNumOfParentGroup_Unknown = 0L;
    private long m_lNumOfParentGroup_Delete = 0L;
    private long m_lNumOfParentGroup_Upload = 0L;
    private long m_lNumOfParentGroup_Download = 0L;
    private boolean m_bAllowDropData = false;

    public CTransferTreeTableModel(CTransferTreeTable rTreeTable) {
        super(rTreeTable);
        this._CTransferTreeTableModel();
    }

    private void _CTransferTreeTableModel() {
        this.m_TransferRootNode = new CTransferNodeRoot(this);
        this.SetRootNode(this.m_TransferRootNode);
        this.m_ConnectionAttrs = new CConnectionAttrs();
        this.m_aActiveThreads = new Vector();
        this.m_aDeleteThreads = new Vector();
        this.InitAttrs();
        this.UpdateNumOfTransferThreads();
        this.m_WatchDogTimer = new Timer(5000, this);
        this.StartWatchDogTimer(true);
    }

    private void InitAttrs() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.m_rnNumOfTransferThreads = CRhinoApp.GET_RHINO_APP().GetAttr_NumOfTransferThreads();
            this.m_rbAutoExpandNewTransfers = CRhinoApp.GET_RHINO_APP().GetAttr_AutoExpandNewTransfers();
            this.m_rbAutoStartNewTransfers = CRhinoApp.GET_RHINO_APP().GetAttr_AutoStartNewTransfers();
            this.m_rbAutoRemoveCompletedTransfers = CRhinoApp.GET_RHINO_APP().GetAttr_AutoRemoveCompletedTransfers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void OnDestroy() {
        Object object = this.m_TransferThreadVectorCrit;
        synchronized (object) {
            CTransferThread rNextThread;
            Iterator<CTransferThread> itr = this.m_aDeleteThreads.iterator();
            while (itr.hasNext()) {
                rNextThread = itr.next();
                if (rNextThread == null) continue;
                rNextThread.PostQuit();
                itr.remove();
            }
            itr = this.m_aActiveThreads.iterator();
            while (itr.hasNext()) {
                rNextThread = itr.next();
                if (rNextThread == null) continue;
                rNextThread.PostQuit();
                itr.remove();
            }
        }
        this.StopWatchDogTimer();
        super.OnDestroy();
    }

    @Override
    protected int GetColIndexTree() {
        return 1;
    }

    @Override
    protected void InitTableHeaders() {
        this.m_asColHeaders = new String[COL_MAX];
        this.m_asColHeaders[0] = CString.LoadString("IDS_TABLE_HEADER_THREAD_STATUS");
        this.m_asColHeaders[1] = CString.LoadString("IDS_TABLE_HEADER_NAME");
        this.m_asColHeaders[2] = CString.LoadString("IDS_TABLE_HEADER_STATUS");
        this.m_asColHeaders[3] = CString.LoadString("IDS_TABLE_HEADER_COMPLETION");
        this.m_asColHeaders[4] = CString.LoadString("IDS_TABLE_HEADER_PATH_FROM");
        this.m_asColHeaders[5] = CString.LoadString("IDS_TABLE_HEADER_PATH_TO");
        if (COL_MAX == 39) {
            this.m_asColHeaders[6] = "Thread ID";
            this.m_asColHeaders[7] = "Has Source Listing";
            this.m_asColHeaders[8] = "Has Target Listing";
            this.m_asColHeaders[9] = "Num Listed";
            this.m_asColHeaders[10] = "Num Pending";
            this.m_asColHeaders[11] = "Num Complete";
            this.m_asColHeaders[12] = "Num Children";
            this.m_asColHeaders[13] = "Num Dirs";
            this.m_asColHeaders[14] = "Num Files";
            this.m_asColHeaders[15] = "Confirm Error";
            this.m_asColHeaders[16] = "Confirm Merge Folder";
            this.m_asColHeaders[17] = "Confirm Overwrite";
            this.m_asColHeaders[18] = "Confirm Delete Folder";
            this.m_asColHeaders[19] = "Confirm Delete File";
            this.m_asColHeaders[20] = "Confirm Multi-Delete";
            this.m_asColHeaders[21] = "Enable ConfirmDeletesFolder";
            this.m_asColHeaders[22] = "Enable ConfirmDeletesFile";
            this.m_asColHeaders[23] = "Enable ConfirmOverwrites UploadFile";
            this.m_asColHeaders[24] = "Enable ConfirmOverwrites DownloadFile";
            this.m_asColHeaders[25] = "Enable Stop";
            this.m_asColHeaders[26] = "Enable Skip";
            this.m_asColHeaders[27] = "Enable Pause";
            this.m_asColHeaders[28] = "Enable Resume";
            this.m_asColHeaders[29] = "Enable Start";
            this.m_asColHeaders[30] = "Enable Restart";
            this.m_asColHeaders[31] = "Enable Cancel";
            this.m_asColHeaders[32] = "Enable Remove";
            this.m_asColHeaders[33] = "Enable RemoveAllCompleted";
            this.m_asColHeaders[34] = "Enable RemoveAllCancelled";
            this.m_asColHeaders[35] = "Enable RemoveAllSkipped";
            this.m_asColHeaders[36] = "Enable RemoveAllPaused";
            this.m_asColHeaders[37] = "Enable RemoveAllWaiting";
            this.m_asColHeaders[38] = "Enable RemoveAllStopped";
        }
    }

    @Override
    public Class<?> getColumnClass(int nColumnIndex) {
        Class<Object> rRet = super.getColumnClass(nColumnIndex);
        if (nColumnIndex == 2) {
            rRet = CTransferTreeTableProgressRenderer.class;
        }
        return rRet;
    }

    @Override
    public CTransferNode GetTreeNode(int nRow) {
        return (CTransferNode)super.GetTreeNode(nRow);
    }

    @Override
    public CTransferNode GetTreeNode(TreePath rTreePath) {
        return (CTransferNode)super.GetTreeNode(rTreePath);
    }

    protected void InitTransferItems(Object[] asAbsSourcePaths, Object[] asAbsTargetPaths, boolean bIsUpload, boolean bIgnoreNames) {
        if (asAbsSourcePaths != null && asAbsTargetPaths != null && asAbsSourcePaths.length > 0 && asAbsTargetPaths.length > 0) {
            if (asAbsSourcePaths.length == asAbsTargetPaths.length) {
                CTransferNode rParentGroupNode;
                CTransferNode.TYPE nType = CTransferNode.TYPE.DOWNLOAD;
                if (bIsUpload) {
                    nType = CTransferNode.TYPE.UPLOAD;
                }
                if ((rParentGroupNode = this.CreateTransferParentGroupNode(nType)) != null) {
                    for (int nIdx = 0; nIdx < asAbsSourcePaths.length; nIdx += 2) {
                        String sName;
                        String sAbsSourcePath = (String)asAbsSourcePaths[nIdx];
                        Boolean bSourceIsDir = (Boolean)asAbsSourcePaths[nIdx + 1];
                        String sAbsTargetPath = (String)asAbsTargetPaths[nIdx];
                        Boolean bTargetIsDir = (Boolean)asAbsTargetPaths[nIdx + 1];
                        if (!bIgnoreNames && (sName = CString.GetFileName(sAbsSourcePath)) != null && !sName.isEmpty()) {
                            sAbsTargetPath = !bIsUpload ? CString.EnsureLastCharIsAFileSeparator(sAbsTargetPath) : CString.EnsureLastCharIsAForwardSlash(sAbsTargetPath);
                            sAbsTargetPath = sAbsTargetPath + sName;
                        }
                        CTransferNodeTransfer rChildNode = new CTransferNodeTransfer(this, nType, this.m_ConnectionAttrs, sAbsSourcePath, bSourceIsDir, sAbsTargetPath, bTargetIsDir);
                        this.AddChild(rParentGroupNode, rChildNode, false, false);
                        if (bIsUpload) {
                            if (rChildNode.GetSource() != null && !rChildNode.GetSourceIsDir()) {
                                rChildNode.SetFileTotal(rChildNode.GetSource().GetSize(), true);
                                rChildNode.SetHasListing(true);
                            } else {
                                rChildNode.SetThreadStatus(CTransferNode.STATUS.PENDING, true);
                            }
                        } else {
                            rChildNode.SetThreadStatus(CTransferNode.STATUS.PENDING, true);
                        }
                        if (!this.GetAutoStartNewTransfers()) continue;
                        rChildNode.SetThreadStatus(CTransferNode.STATUS.PENDING, true);
                    }
                    if (this.GetTree() != null && this.GetAutoExpandNewTransfers()) {
                        this.GetTree().expandPath(rParentGroupNode.GetTreePath());
                    }
                }
                this.AssignThreads();
            } else if (DEBUG) {
                CDebugLog.ASSERT(CTransferTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, 'mismatch' between source and target paths");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
        }
    }

    protected void InitDeleteItems(boolean bIsSourceLocal, Object[] asAbsSourcePaths) {
        if (asAbsSourcePaths != null && asAbsSourcePaths.length > 0) {
            CTransferNode rParentGroupNode;
            Boolean bSourceIsDir;
            CBoolAttr rAttr;
            int nUserConfirmDlgResult = -5;
            boolean bUserWantsConfirmMultiDels = true;
            if (CRhinoApp.GET_RHINO_APP() != null && (rAttr = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmMultiDeletes()) != null) {
                bUserWantsConfirmMultiDels = rAttr.GetValue();
            }
            if (bUserWantsConfirmMultiDels) {
                boolean bFoundDir = false;
                boolean bFoundFile = false;
                for (int nIdx = 1; nIdx < asAbsSourcePaths.length; nIdx += 2) {
                    bSourceIsDir = (Boolean)asAbsSourcePaths[nIdx];
                    if (bSourceIsDir != null) {
                        if (bSourceIsDir.booleanValue()) {
                            bFoundDir = true;
                        } else {
                            bFoundFile = true;
                        }
                    }
                    if (bFoundDir && bFoundFile) break;
                }
                if (bFoundDir && bFoundFile) {
                    Container rCenterTo = null;
                    if (CRhinoApp.GET_RHINO_APP() != null) {
                        rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
                    }
                    CConfirmMultiDeleteDlg dlg = new CConfirmMultiDeleteDlg(CRhinoApp.GetParentWindow(rCenterTo), asAbsSourcePaths.length / 2);
                    dlg.setVisible(true);
                    nUserConfirmDlgResult = dlg.GetResult();
                }
            } else {
                nUserConfirmDlgResult = 0;
            }
            if ((nUserConfirmDlgResult == -5 || nUserConfirmDlgResult == 0) && (rParentGroupNode = this.CreateTransferParentGroupNode(CTransferNode.TYPE.DELETE)) != null) {
                for (int nIdx = 0; nIdx < asAbsSourcePaths.length; nIdx += 2) {
                    String sAbsSourcePath = (String)asAbsSourcePaths[nIdx];
                    bSourceIsDir = (Boolean)asAbsSourcePaths[nIdx + 1];
                    String sName = CString.GetFileName(sAbsSourcePath);
                    CTransferNodeDelete rChildNode = new CTransferNodeDelete(this, this.m_ConnectionAttrs, bIsSourceLocal, sAbsSourcePath, bSourceIsDir);
                    this.AddChild(rParentGroupNode, rChildNode, false);
                    if (nUserConfirmDlgResult != 0) continue;
                    rChildNode.SetDontAutoSetUserConfirmations(true);
                    CConfirmDlg.TYPE nType = CConfirmDlg.TYPE.DELETE_FILE;
                    if (bSourceIsDir.booleanValue()) {
                        nType = CConfirmDlg.TYPE.DELETE_FOLDER;
                    }
                    rChildNode.UpdateShowConfirmDlg(nType, false, nUserConfirmDlgResult);
                }
                if (this.GetTree() != null && this.GetAutoExpandNewTransfers()) {
                    this.GetTree().expandPath(rParentGroupNode.GetTreePath());
                }
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
        }
    }

    protected boolean AddChild(CRhinoTreeNode rParentNode, CRhinoTreeNode rChildNode, boolean bAppend, boolean bAssignThreads) {
        boolean bAdded = super.AddChild(rParentNode, rChildNode, bAppend);
        if (bAdded) {
            if (bAssignThreads) {
                this.SetThreadStatus((CTransferNode)rChildNode, CTransferNode.STATUS.PENDING);
                this.AssignThreads();
            } else {
                this.SetThreadStatus((CTransferNode)rChildNode, CTransferNode.STATUS.WAITING);
            }
        }
        return bAdded;
    }

    @Override
    protected boolean AddChild(CRhinoTreeNode rParentNode, CRhinoTreeNode rChildNode, boolean bAppend) {
        return this.AddChild(rParentNode, rChildNode, bAppend, true);
    }

    public CTransferNode CreateTransferParentGroupNode(CTransferNode.TYPE nType) {
        long lNumOfParentGroupNodes = 1L;
        if (nType == CTransferNode.TYPE.UPLOAD) {
            ++this.m_lNumOfParentGroup_Upload;
            lNumOfParentGroupNodes = this.m_lNumOfParentGroup_Upload;
        } else if (nType == CTransferNode.TYPE.DOWNLOAD) {
            ++this.m_lNumOfParentGroup_Download;
            lNumOfParentGroupNodes = this.m_lNumOfParentGroup_Download;
        } else if (nType == CTransferNode.TYPE.DELETE) {
            ++this.m_lNumOfParentGroup_Delete;
            lNumOfParentGroupNodes = this.m_lNumOfParentGroup_Delete;
        } else {
            ++this.m_lNumOfParentGroup_Unknown;
            lNumOfParentGroupNodes = this.m_lNumOfParentGroup_Unknown;
        }
        CTransferNodeParentGroup rParentNode = new CTransferNodeParentGroup(this, nType, lNumOfParentGroupNodes);
        if (rParentNode != null && this.GetRootNode() != null) {
            this.AddChild(this.GetRootNode(), rParentNode, true);
        }
        return rParentNode;
    }

    @Override
    public void SetRootNode(CRhinoTreeNode rRoot) {
        super.SetRootNode(rRoot);
        if (this.GetRootNode() != null) {
            this.GetRootNode().SetHasListing(true);
        }
    }

    @Override
    protected CTransferNode GetRootNode() {
        return this.m_TransferRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTransferThread GetNextAvailableThread() {
        CTransferThread rNextAvailableThread = null;
        Object object = this.m_TransferThreadVectorCrit;
        synchronized (object) {
            Iterator<CTransferThread> itr = this.m_aActiveThreads.iterator();
            while (itr.hasNext() && rNextAvailableThread == null) {
                CTransferThread rNextThread = itr.next();
                if (rNextThread == null) continue;
                if (DEBUG && rNextThread.GetDelete()) {
                    CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, a thread marked for deletion is not supposed to be in the active thread vector!");
                }
                if (rNextThread.IsProcessing()) continue;
                rNextAvailableThread = rNextThread;
            }
        }
        return rNextAvailableThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AssignThreads() {
        Object object = this.m_TransferThreadVectorCrit;
        synchronized (object) {
            for (CTransferThread rNextThread : this.m_aActiveThreads) {
                boolean bAssignThread;
                if (rNextThread == null) continue;
                if (DEBUG && rNextThread.GetDelete()) {
                    CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, a thread marked for deletion is not supposed to be in the active thread vector!");
                }
                if (!(bAssignThread = !rNextThread.IsProcessing() && rNextThread.GetTreeNode() == null)) continue;
                this.AssignThread(rNextThread);
            }
        }
    }

    private void AssignThread(CTransferThread rThread) {
        CTransferNode rNextTransferTreeNode;
        if (rThread == null || rThread.GetDelete()) {
            rThread = this.GetNextAvailableThread();
        }
        if (rThread != null && (rNextTransferTreeNode = this.GetNextTransferTreeNode()) != null) {
            rNextTransferTreeNode.AttachThread(rThread);
            rThread.SetTreeNode(rNextTransferTreeNode);
            if (DEBUG_ASSIGN_THREAD) {
                System.out.printf("Assigned tree node (%s) to a worker thread (%d)\r\n", rNextTransferTreeNode.GetDisplayText(), rThread.GetUniqueID());
            }
            rThread.PostTransferItem(rNextTransferTreeNode, this.m_ConnectionAttrs);
        }
    }

    private CTransferNode GetNextTransferTreeNode() {
        CTransferNode rNextTransferTreeNode = null;
        CTransferNode rRootNode = this.GetRootNode();
        if (rRootNode != null) {
            for (int nIdx = 0; nIdx < rRootNode.getChildCount() && rNextTransferTreeNode == null; ++nIdx) {
                CTransferNode rChild = (CTransferNode)rRootNode.getChildAt(nIdx);
                if (rChild.IsParentGroup()) {
                    CTransferNodeParentGroup rParentGroup = (CTransferNodeParentGroup)rChild;
                    boolean bHasListingForAllChildren = rParentGroup.GetHasListingForAllChildren();
                    rNextTransferTreeNode = this.GetNextTransferTreeNode(rParentGroup, bHasListingForAllChildren, null);
                    continue;
                }
                if (!DEBUG) continue;
                CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Next TreeNode under root is not a ParentGroup!");
            }
        }
        return rNextTransferTreeNode;
    }

    private CTransferNode GetNextTransferTreeNode(CTransferNode rNode, boolean bParentGroupHasEntireListing, CTransferNode rNodeNeedsTargetListed) {
        CTransferNode rNextTransferTreeNode = null;
        if (rNode != null) {
            if (rNode.IsDelete()) {
                if (rNode.getChildCount() > 0) {
                    for (int nIdx = 0; nIdx < rNode.getChildCount() && rNextTransferTreeNode == null; ++nIdx) {
                        CTransferNode rChild = (CTransferNode)rNode.getChildAt(nIdx);
                        rNextTransferTreeNode = this.GetNextTransferTreeNode(rChild, bParentGroupHasEntireListing, null);
                    }
                } else {
                    rNextTransferTreeNode = this.CheckForNextNode(rNode, rNodeNeedsTargetListed);
                }
            } else if (rNode.GetHasListing()) {
                if (rNode.GetSourceIsDir() || rNode.IsParentGroup()) {
                    if (!rNode.IsParentGroup() && rNode.GetHasListing() && !rNode.GetHasListingForTarget() && rNodeNeedsTargetListed == null) {
                        rNodeNeedsTargetListed = rNode;
                    }
                    if (rNode.getChildCount() > 0) {
                        for (int nIdx = 0; nIdx < rNode.getChildCount() && rNextTransferTreeNode == null; ++nIdx) {
                            CTransferNode rChild = (CTransferNode)rNode.getChildAt(nIdx);
                            rNextTransferTreeNode = this.GetNextTransferTreeNode(rChild, bParentGroupHasEntireListing, rNodeNeedsTargetListed);
                        }
                    } else {
                        rNextTransferTreeNode = this.CheckForNextNode(rNodeNeedsTargetListed, null);
                    }
                } else if (bParentGroupHasEntireListing) {
                    rNextTransferTreeNode = this.CheckForNextNode(rNode, rNodeNeedsTargetListed);
                }
            } else {
                rNextTransferTreeNode = this.CheckForNextNode(rNode, rNodeNeedsTargetListed);
            }
        }
        return rNextTransferTreeNode;
    }

    private CTransferNode CheckForNextNode(CTransferNode rNode, CTransferNode rNodeNeedsTargetListed) {
        CTransferNode rNextTransferTreeNode = null;
        if (rNode != null) {
            boolean bStopped = rNode.GetStop();
            if (!(rNode.IsThreadAttached() || rNode.IsThreadDone() || bStopped)) {
                if (DEBUG_CHECK_NEXT_NODE) {
                    System.out.println("(1) Get Listing for: " + rNode.GetDisplayText());
                }
                if (rNode.GetHasListing() && rNodeNeedsTargetListed != null) {
                    rNextTransferTreeNode = this.CheckForNextNode(rNodeNeedsTargetListed, null);
                } else if (!rNode.GetSourceIsDir() || rNode.GetChildCountListedDir() == rNode.GetChildCountDirs()) {
                    rNextTransferTreeNode = rNode;
                }
            }
        }
        return rNextTransferTreeNode;
    }

    public int GetNumOfTransferThreads() {
        int nNumOfThreads = 4;
        if (this.m_rnNumOfTransferThreads != null) {
            nNumOfThreads = this.m_rnNumOfTransferThreads.GetValueInt();
        }
        return nNumOfThreads;
    }

    public void SetNumOfTransferThreads(int nNumOfWorkers) {
        if (this.m_rnNumOfTransferThreads != null) {
            this.m_rnNumOfTransferThreads.SetValue(nNumOfWorkers);
        }
        this.UpdateNumOfTransferThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UpdateNumOfTransferThreads() {
        Object object = this.m_TransferThreadVectorCrit;
        synchronized (object) {
            if (this.m_aActiveThreads.size() > this.GetNumOfTransferThreads()) {
                for (int nIdx = this.m_aActiveThreads.size() - 1; nIdx >= this.GetNumOfTransferThreads(); --nIdx) {
                    CTransferThread rNextThread = this.m_aActiveThreads.get(nIdx);
                    if (rNextThread == null) continue;
                    rNextThread.SetDelete(true);
                    if (!this.m_aActiveThreads.remove(rNextThread)) continue;
                    this.m_aDeleteThreads.add(rNextThread);
                }
            } else if (this.m_aActiveThreads.size() < this.GetNumOfTransferThreads()) {
                int nNeeded = this.GetNumOfTransferThreads() - this.m_aActiveThreads.size();
                for (int nIdx = this.m_aDeleteThreads.size() - 1; nIdx >= 0 && nNeeded > 0; --nIdx) {
                    CTransferThread rNextThread = this.m_aDeleteThreads.get(nIdx);
                    if (rNextThread == null) continue;
                    rNextThread.SetDelete(false);
                    if (!this.m_aDeleteThreads.remove(rNextThread)) continue;
                    this.m_aActiveThreads.add(rNextThread);
                    --nNeeded;
                }
                while (nNeeded > 0) {
                    CTransferThread rNewThread = this.CreateTransferThread();
                    this.m_aActiveThreads.add(rNewThread);
                    --nNeeded;
                }
            }
        }
        this.AssignThreads();
    }

    protected CTransferThread CreateTransferThread() {
        CTransferThread rTransferThread = new CTransferThread();
        rTransferThread.SetThreadName(String.format("TransferWorker_%d", m_nWorkerNameIdx++));
        return rTransferThread;
    }

    public void InitConnection(String sHost, long lServerPort, long lHeaderPort, String sUserAgent, String sEncSessionID, boolean bIsCaseSensitiveOS) {
        this.m_ConnectionAttrs.SetHost(sHost);
        this.m_ConnectionAttrs.SetServerPort(lServerPort);
        this.m_ConnectionAttrs.SetHeaderPort(lHeaderPort);
        this.m_ConnectionAttrs.SetUserAgent(sUserAgent);
        this.m_ConnectionAttrs.SetEncSessionID(sEncSessionID);
        this.m_ConnectionAttrs.SetCaseSensitiveOS(bIsCaseSensitiveOS);
    }

    public void InitLocale(String sLanguageCode, String sCountryCode) {
        this.m_ConnectionAttrs.SetLocaleCodes(sLanguageCode, sCountryCode);
    }

    public String toStringConnectionInfo() {
        String sOut = String.format("Host: %s | ServerPort: %d | HeaderPort: %d | EncSessionID: %s\r\n", this.m_ConnectionAttrs.GetHost(), this.m_ConnectionAttrs.GetServerPort(), this.m_ConnectionAttrs.GetHeaderPort(), this.m_ConnectionAttrs.GetEncSessionID());
        return sOut;
    }

    public String toStringLocale() {
        String sOut = String.format("LanguageCode: %s | CountryCode: %s\r\n", this.m_ConnectionAttrs.GetLanguageCode(), this.m_ConnectionAttrs.GetCountryCode());
        return sOut;
    }

    protected CTransferNode GetTreeNode(long lAttrID) {
        CTransferNode rNode = null;
        CObjectAttr rObjAttr = (CObjectAttr)CAttr.FindGlobalAttr(lAttrID);
        if (rObjAttr != null && rObjAttr.GetObject() instanceof CTransferNode) {
            rNode = (CTransferNode)rObjAttr.GetObject();
        }
        return rNode;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg, false);
        boolean bRelayToNodes = false;
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3517: {
                    this.AssignThreads();
                    break;
                }
                case 4263: 
                case 4264: 
                case 4265: {
                    CUIMessage rUIMsg = (CUIMessage)rMsg;
                    CTransferNode rNode = this.GetTreeNode((Long)rUIMsg.GetSource());
                    if (rNode == null) break;
                    this.SetThreadStatus(rNode, CTransferNode.STATUS.RUNNING);
                    break;
                }
                case 4268: {
                    CTransferMsg rTransferMsg = (CTransferMsg)rMsg;
                    if (rTransferMsg.IsDirSource()) {
                        this.OnRecvListedDir(rTransferMsg);
                        break;
                    }
                    this.OnRecvListedFile(rTransferMsg);
                    break;
                }
                case 4269: {
                    long lNumOfChildren;
                    CFile rListDir;
                    CTransferMsg rTransferMsg = (CTransferMsg)rMsg;
                    CTransferNode rNode = this.GetTreeNode(rTransferMsg.GetUISourceAttrID());
                    if (rNode == null) break;
                    rNode.SetHasListingForTarget(true);
                    boolean bCanRemove_HasNoChildren = false;
                    if (rTransferMsg.IsDirSource() && (rListDir = rTransferMsg.GetSourceFile()) != null && (lNumOfChildren = (long)rListDir.GetNumOfChildFiles()) < 1L) {
                        rNode.SetThreadStatus(CTransferNode.STATUS.DONE_GREEN, false);
                        bCanRemove_HasNoChildren = true;
                    }
                    this.DetachThread(rNode);
                    this.RepaintRow(rNode);
                    this.CheckAllDone(rNode);
                    if (!bCanRemove_HasNoChildren || !this.GetAutoRemoveCompletedTransfers()) break;
                    this.RemoveNode(rNode, STATES_TO_REMOVE_ALL.COMPLETED, true);
                    break;
                }
                case 4202: {
                    this.OnRecvConfirm((CSUSourceMsg)rMsg);
                    break;
                }
                case 4201: {
                    CSUSourceMsg rSUSourceMsg = (CSUSourceMsg)rMsg;
                    if (rSUSourceMsg instanceof CThumbnailMsg) {
                        CThumbnailMsg rThumbMsg = (CThumbnailMsg)rSUSourceMsg;
                        this.OnRecvError_Thumb(rThumbMsg);
                    } else {
                        this.OnRecvError(rSUSourceMsg);
                    }
                    if (this.GetTreeTable() == null) break;
                    this.GetTreeTable().StartUpdateBtnTimer();
                    break;
                }
                case 5016: {
                    this.OnShowDialog((CDialogShowMsg)rMsg);
                    break;
                }
                case 4204: {
                    CSUSourceMsg rSourceMsg;
                    CTransferNode rNode;
                    CUnknownMsg rUnknownMsg;
                    if (DEBUG_UNKNOWN_MSG) {
                        JOptionPane.showMessageDialog(null, "ASSERT:  An unknown message has been received, please investigate!");
                    }
                    if ((rUnknownMsg = (CUnknownMsg)rMsg) == null || !(rUnknownMsg.GetSourceMsg() instanceof CSUSourceMsg) || (rNode = this.GetTreeNode((rSourceMsg = (CSUSourceMsg)rUnknownMsg.GetSourceMsg()).GetUISourceAttrID())) == null) break;
                    rNode.SetThreadStatus(CTransferNode.STATUS.CANCELLED, false);
                    this.DetachThread(rNode);
                    this.RepaintRow(rNode);
                    break;
                }
                case 4226: 
                case 4228: {
                    this.OnRecvTransfer((CTransferMsg)rMsg);
                    if (this.GetTreeTable() == null) break;
                    this.GetTreeTable().StartUpdateBtnTimer();
                    break;
                }
                case 4224: {
                    this.OnRecvDelete((CDeleteMsg)rMsg);
                    if (this.GetTreeTable() == null) break;
                    this.GetTreeTable().StartUpdateBtnTimer();
                    break;
                }
                case 4266: {
                    CTransferStatsMsg rStatsMsg = (CTransferStatsMsg)rMsg;
                    CTransferNode rNode = this.GetTreeNode(rStatsMsg.GetUITransferID());
                    if (rNode == null) break;
                    if (DEBUG_XFER_STATS_SIZE && rNode.GetFileTotal() != rStatsMsg.GetFileTotal()) {
                        CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Somehow, the file size has changed from the time it was listed to when we are transferring it!");
                    }
                    rNode.OnMessage(rMsg);
                    if (DEBUG_REPAINT_IMMEDIATELY) {
                        this.RepaintRow(rNode);
                    }
                    if (this.GetTreeTable() == null) break;
                    this.GetTreeTable().StartRefreshTimer();
                    break;
                }
                case 4270: {
                    CUIMessage rUIMsg = (CUIMessage)rMsg;
                    Object[] anItems = (Object[])rUIMsg.GetSource();
                    long lSourceAttrID = (Long)anItems[0];
                    String sAbsTargetPath = (String)anItems[1];
                    CTransferNode rNode = this.GetTreeNode(lSourceAttrID);
                    if (rNode == null) break;
                    rNode.SetTarget(sAbsTargetPath);
                    this.RepaintRow(rNode);
                    break;
                }
                case 3520: {
                    this.OnTransferShowInFolder();
                    break;
                }
                case 3519: {
                    this.OnTransferOpen(false);
                    break;
                }
                case 3500: {
                    this.OnTransferStopAtNextFile();
                    break;
                }
                case 5300: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferStopAtNextFile();
                    break;
                }
                case 3501: {
                    this.OnTransferSkip();
                    break;
                }
                case 5301: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferSkip();
                    break;
                }
                case 3502: {
                    this.OnTransferPause();
                    break;
                }
                case 5302: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferPause();
                    break;
                }
                case 3503: {
                    this.OnTransferResume();
                    break;
                }
                case 5303: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferResume();
                    break;
                }
                case 3504: {
                    this.OnTransferStart();
                    break;
                }
                case 5304: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferStart();
                    break;
                }
                case 3505: {
                    this.OnTransferRestart();
                    break;
                }
                case 5305: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferRestart();
                    break;
                }
                case 3506: {
                    this.OnTransferCancel();
                    break;
                }
                case 5306: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferCancel();
                    break;
                }
                case 3521: {
                    this.OnTransferCancelAll();
                    break;
                }
                case 5311: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferCancelAll();
                    break;
                }
                case 3507: {
                    this.OnTransferRemove();
                    break;
                }
                case 5307: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable()) break;
                    this.OnRecvTransferRemove();
                    break;
                }
                case 5308: {
                    Object[] aObjs;
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this.GetTreeTable() || (aObjs = (Object[])rUIMsg.GetAttachedObject()) == null) break;
                    try {
                        STATES_TO_REMOVE_ALL nState = (STATES_TO_REMOVE_ALL)((Object)aObjs[0]);
                        boolean bAssignThreads = (Boolean)aObjs[1];
                        this.OnRecvTransferRemoveAll(nState, bAssignThreads);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break;
                        CDebugLog.EXCEPTION(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.", true);
                    }
                    break;
                }
                case 3509: {
                    this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.COMPLETED);
                    break;
                }
                case 3510: {
                    this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.CANCELLED);
                    break;
                }
                case 3511: {
                    this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.SKIPPED);
                    break;
                }
                case 3512: {
                    this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.PAUSED);
                    break;
                }
                case 3513: {
                    this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.WAITING);
                    break;
                }
                case 3514: {
                    this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.STOPPED);
                    break;
                }
                case 3515: {
                    this.OnTransferRemoveAll();
                    break;
                }
                case 4239: {
                    CThumbnailMsg rThumbMsg = (CThumbnailMsg)rMsg;
                    this.OnRecvThumbnail(rThumbMsg);
                    break;
                }
            }
        }
    }

    private void OnRecvListedDir(CTransferMsg rTransferMsg) {
        CTransferNode rNode;
        if (rTransferMsg != null && CRhinoApp.GET_RHINO_APP() != null && (rNode = this.GetTreeNode(rTransferMsg.GetUISourceAttrID())) != null) {
            CFile rListDir = rTransferMsg.GetSourceFile();
            if (rListDir != null) {
                CTransferNodeParentGroup rGroup;
                long lNumOfChildren = rListDir.GetNumOfChildFiles();
                CTransferNode.STATUS nStatus = rNode.GetAfterListingStatus();
                if (!rNode.IsParentGroup() && !this.GetAutoStartNewTransfers()) {
                    nStatus = CTransferNode.STATUS.WAITING;
                }
                rNode.SetThreadStatus(nStatus, false);
                if (lNumOfChildren > 0L) {
                    boolean bIsUpload = rTransferMsg.IsUpload();
                    int nIdx = 0;
                    while ((long)nIdx < lNumOfChildren) {
                        CFile fChild = rListDir.GetFile(nIdx);
                        if (fChild != null) {
                            String sAbsSourcePath = fChild.GetAbsPath();
                            String sAbsTargetPath = rNode.GetTargetPath();
                            sAbsTargetPath = bIsUpload ? CString.EnsureLastCharIsAForwardSlash(sAbsTargetPath) : CString.EnsureLastCharIsAFileSeparator(sAbsTargetPath);
                            sAbsTargetPath = sAbsTargetPath + CString.GetFileName(sAbsSourcePath);
                            CTransferNode.TYPE nType = CTransferNode.TYPE.DOWNLOAD;
                            if (bIsUpload) {
                                nType = CTransferNode.TYPE.UPLOAD;
                            }
                            CTransferNodeTransfer rChildNode = new CTransferNodeTransfer(this, nType, this.m_ConnectionAttrs, fChild, sAbsTargetPath);
                            this.AddChild(rNode, rChildNode, false, false);
                            if (!rChildNode.GetSourceIsDir()) {
                                this.OnRecvListedFile(rChildNode, 0L, fChild.GetSize());
                            } else {
                                this.SetThreadStatus(rChildNode, CTransferNode.STATUS.PENDING);
                            }
                        }
                        ++nIdx;
                    }
                }
                if ((rGroup = rNode.GetParentGroup()) != null) {
                    CConfirmDlg.TYPE[] aTypes = CConfirmDlg.TYPE.values();
                    for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
                        CConfirmDlg.TYPE rType = aTypes[nIdx];
                        if (rType == null) continue;
                        boolean bShowConfirmDlg = rGroup.GetShowConfirmDlg(rType);
                        int nDlgResult = rGroup.GetConfirmDlgResult(rType);
                        if (rNode == rGroup) continue;
                        rNode.UpdateShowConfirmDlg(rType, bShowConfirmDlg, nDlgResult);
                    }
                    rNode.UpdateShowConfirmDlg(CConfirmDlg.TYPE.UNKNOWN, this.m_bAllowDropData, 0);
                }
                rNode.SetHasListing(true);
                rNode.SetIsManualStart(false);
                if (this.GetTree() != null && this.GetAutoExpandNewTransfers()) {
                    this.GetTree().expandPath(rNode.GetTreePath());
                }
            }
            this.DetachThread(rNode);
            this.RepaintRow(rNode);
        }
    }

    private void OnRecvListedFile(CTransferMsg rTransferMsg) {
        CTransferNode rNode;
        if (rTransferMsg != null && (rNode = this.GetTreeNode(rTransferMsg.GetUISourceAttrID())) != null) {
            CFile rListedFile = rTransferMsg.GetSourceFile();
            if (rListedFile != null) {
                rNode.InitSource(rListedFile);
            }
            this.OnRecvListedFile(rNode, rTransferMsg.GetFileRead(), rTransferMsg.GetFileTotal());
            this.DetachThread(rNode);
            this.RepaintRow(rNode);
        }
    }

    private void OnRecvListedFile(CTransferNode rNode, long lNumOfBytesRead, long lNumOfBytesTotal) {
        if (rNode != null) {
            rNode.SetHasListing(true);
            CTransferNode.STATUS nStatus = rNode.GetAfterListingStatus();
            if (!(rNode.IsParentGroup() || this.GetAutoStartNewTransfers() || rNode.IsManualStart())) {
                nStatus = CTransferNode.STATUS.WAITING;
            }
            rNode.SetThreadStatus(nStatus, false);
            rNode.SetIsManualStart(false);
            rNode.SetFileTotal(lNumOfBytesTotal, false);
            rNode.SetFileRead(lNumOfBytesRead, false);
            if (DEBUG && lNumOfBytesRead > 0L) {
                CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Error:  Just listed file, but you have read data from the stream?");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, null variable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTransferThread GetTransferThread(long lThreadID) {
        CTransferThread rThread = null;
        Object object = this.m_TransferThreadVectorCrit;
        synchronized (object) {
            Iterator<CTransferThread> itr = this.m_aActiveThreads.iterator();
            while (itr.hasNext() && rThread == null) {
                CTransferThread rNextThread = itr.next();
                if (rNextThread == null || rNextThread.GetUniqueID() != lThreadID) continue;
                rThread = rNextThread;
            }
        }
        return rThread;
    }

    private void StartWatchDogTimer(boolean bRestart) {
        if (!this.m_WatchDogTimer.isRunning()) {
            this.m_WatchDogTimer.start();
        } else if (bRestart) {
            this.m_WatchDogTimer.restart();
        }
    }

    private void StopWatchDogTimer() {
        if (this.m_WatchDogTimer.isRunning()) {
            this.m_WatchDogTimer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.m_WatchDogTimer) {
            this.OnCheckWatchDogs();
        }
    }

    protected void OnConfirmDlgResult(int nResult, CSUMsg rMsg, boolean bWaitingForThumb) {
        if (rMsg != null) {
            CConfirmDlg.TYPE nDlgType = rMsg.GetConfirmDlgType();
            switch (nDlgType) {
                case DELETE_FOLDER: 
                case DELETE_FILE: {
                    this.OnConfirmDeleteFile(nResult, rMsg, bWaitingForThumb);
                    break;
                }
                case DELETE_MULTI: {
                    this.OnConfirmMultiDelete(nResult, rMsg);
                    break;
                }
                case OVERWRITE_FILE: {
                    this.OnConfirmOverwriteFile(nResult, rMsg, bWaitingForThumb);
                    break;
                }
                case MERGE_FOLDER: {
                    this.OnConfirmMergeFolder(nResult, rMsg);
                    break;
                }
                case ERROR: {
                    this.OnConfirmError(nResult, rMsg);
                    break;
                }
            }
        }
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().StartUpdateBtnTimer();
        }
    }

    private void OnConfirmDeleteFile(int nResult, CSUMsg rMsg, boolean bWaitingForThumb) {
        if (rMsg != null) {
            rMsg.ResetMsgID();
            CTransferNode rNode = this.GetTreeNode(rMsg.GetUISourceAttrID());
            if (rNode != null) {
                rNode.UpdateShowConfirmDlg(rMsg.GetConfirmDlgType(), false, nResult);
                if (!bWaitingForThumb) {
                    switch (nResult) {
                        case 0: {
                            this.SetThreadStatus(rNode, CTransferNode.STATUS.PENDING);
                            CWorkerThread rThread = (CWorkerThread)CAttr.FindGlobalAttr(rMsg.GetThreadAttrID());
                            if (rThread == null) break;
                            rThread.NewMessage(rMsg);
                            break;
                        }
                        case 1: {
                            this.SetThreadStatus(rNode, CTransferNode.STATUS.SKIPPED);
                            this.DetachThread(rNode);
                            break;
                        }
                        default: {
                            this.SetThreadStatus(rNode, CTransferNode.STATUS.CANCELLED);
                            this.DetachThread(rNode);
                        }
                    }
                }
                this.RepaintRow(rNode);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Invalid argument.");
        }
    }

    private void OnConfirmMultiDelete(int nResult, CSUMsg rMsg) {
        if (rMsg != null) {
            rMsg.ResetMsgID();
            CTransferNode rNode = this.GetTreeNode(rMsg.GetUISourceAttrID());
            if (rNode != null) {
                rNode.UpdateShowConfirmDlg(rMsg.GetConfirmDlgType(), false, nResult);
                switch (nResult) {
                    case 0: {
                        this.SetThreadStatus(rNode, CTransferNode.STATUS.PENDING);
                        CWorkerThread rThread = (CWorkerThread)CAttr.FindGlobalAttr(rMsg.GetThreadAttrID());
                        if (rThread == null) break;
                        rThread.NewMessage(rMsg);
                        break;
                    }
                    case 1: {
                        this.SetThreadStatus(rNode, CTransferNode.STATUS.SKIPPED);
                        this.DetachThread(rNode);
                        break;
                    }
                    default: {
                        this.SetThreadStatus(rNode, CTransferNode.STATUS.CANCELLED);
                        this.DetachThread(rNode);
                    }
                }
                this.RepaintRow(rNode);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Invalid argument.");
        }
    }

    private void OnConfirmMergeFolder(int nResult, CSUMsg rMsg) {
        if (rMsg != null) {
            rMsg.ResetMsgID();
            CTransferNode rNode = this.GetTreeNode(rMsg.GetUISourceAttrID());
            if (rNode != null) {
                rNode.UpdateShowConfirmDlg(rMsg.GetConfirmDlgType(), false, nResult);
                switch (nResult) {
                    case 0: {
                        this.SetThreadStatus(rNode, CTransferNode.STATUS.PENDING);
                        CWorkerThread rThread = (CWorkerThread)CAttr.FindGlobalAttr(rMsg.GetThreadAttrID());
                        if (rThread == null) break;
                        rThread.NewMessage(rMsg);
                        break;
                    }
                    case 1: {
                        rNode.SetHasListing(true);
                        rNode.SetHasListingForTarget(true);
                        rNode.OnTransferSkip();
                        this.DetachThread(rNode);
                        break;
                    }
                    default: {
                        rNode.SetHasListing(true);
                        rNode.SetHasListingForTarget(true);
                        rNode.OnTransferCancel();
                        this.DetachThread(rNode);
                    }
                }
                this.RepaintRow(rNode);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Invalid argument.");
        }
    }

    private void OnConfirmOverwriteFile(int nResult, CSUMsg rMsg, boolean bWaitingForThumb) {
        block14: {
            block13: {
                CTransferNode rNode;
                block16: {
                    block15: {
                        if (rMsg == null) break block13;
                        rMsg.ResetMsgID();
                        rNode = this.GetTreeNode(rMsg.GetUISourceAttrID());
                        if (rNode == null) break block14;
                        rNode.UpdateShowConfirmDlg(rMsg.GetConfirmDlgType(), false, nResult);
                        rNode.SetDontAutoSetUserConfirmations(true);
                        rNode.SetIsResume(false);
                        if (bWaitingForThumb) break block15;
                        switch (nResult) {
                            case 0: 
                            case 4: 
                            case 5: {
                                CWorkerThread rThread;
                                if (nResult == 5) {
                                    if (rMsg instanceof CTransferMsg) {
                                        CTransferMsg rTransferMsg = (CTransferMsg)rMsg;
                                        rNode.SetTarget(rTransferMsg.GetAbsRenameTargetTo());
                                        rTransferMsg.SetTargetPath(rTransferMsg.GetAbsRenameTargetTo());
                                    }
                                } else if (nResult == 4) {
                                    if (rNode.GetFileRead() == rNode.GetFileTotal()) {
                                        rNode.SetFileRead(0L, true);
                                    } else {
                                        rNode.SetIsResume(true);
                                    }
                                }
                                this.SetThreadStatus(rNode, CTransferNode.STATUS.PENDING);
                                if (rNode.IsThreadAttached() && (rThread = (CWorkerThread)CAttr.FindGlobalAttr(rMsg.GetThreadAttrID())) != null) {
                                    rThread.NewMessage(rMsg);
                                    break;
                                }
                                break block16;
                            }
                            case 1: {
                                this.SetThreadStatus(rNode, CTransferNode.STATUS.SKIPPED);
                                this.DetachThread(rNode);
                                break;
                            }
                            default: {
                                this.SetThreadStatus(rNode, CTransferNode.STATUS.CANCELLED);
                                this.DetachThread(rNode);
                                break;
                            }
                        }
                        break block16;
                    }
                    if (DEBUG) {
                        CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Warning:  A thumbnail may be in transit, so when that comes in, then perform the user action (e.g., if you try to delete a file when SU is generating a thumb, you'll fail).");
                    }
                }
                this.RepaintRow(rNode);
                break block14;
            }
            if (DEBUG) {
                CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Invalid argument.");
            }
        }
    }

    private void OnConfirmError(int nResult, CSUMsg rMsg) {
        if (rMsg != null) {
            rMsg.ResetMsgID();
            CTransferNode rNode = this.GetTreeNode(rMsg.GetUISourceAttrID());
            if (rNode != null) {
                switch (nResult) {
                    case 0: {
                        if (rMsg.GetCancel()) {
                            this.DetachThread(rNode);
                            break;
                        }
                        this.SetThreadStatus(rNode, CTransferNode.STATUS.PENDING);
                        CWorkerThread rThread = (CWorkerThread)CAttr.FindGlobalAttr(rMsg.GetThreadAttrID());
                        if (rThread == null) break;
                        rThread.NewMessage(rMsg);
                        break;
                    }
                    case 1: {
                        rNode.OnTransferSkip();
                        this.DetachThread(rNode);
                        break;
                    }
                    default: {
                        rNode.OnTransferCancel();
                        this.DetachThread(rNode);
                    }
                }
                this.RepaintRow(rNode);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Invalid argument.");
        }
    }

    @Override
    protected void OnLoadAttrs() {
        super.OnLoadAttrs();
        IArchive rArchive = this.GetArchive();
        if (rArchive != null) {
            this.m_rnNumOfTransferThreads.Load(rArchive);
            this.m_rbAutoExpandNewTransfers.Load(rArchive);
            this.m_rbAutoStartNewTransfers.Load(rArchive);
            this.m_rbAutoRemoveCompletedTransfers.Load(rArchive);
        }
        this.UpdateNumOfTransferThreads();
    }

    @Override
    protected void OnSaveAttrs() {
        super.OnSaveAttrs();
        IArchive rArchive = this.GetArchive();
        if (rArchive != null) {
            this.m_rnNumOfTransferThreads.Save(rArchive);
            this.m_rbAutoExpandNewTransfers.Save(rArchive);
            this.m_rbAutoStartNewTransfers.Save(rArchive);
            this.m_rbAutoRemoveCompletedTransfers.Save(rArchive);
        }
    }

    private void OnTransferPause() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5302, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    private void OnRecvTransferPause() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null) continue;
                rNode.OnTransferPause();
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        this.AssignThreads();
    }

    private void OnTransferResume(CTransferNode rNode) {
        if (rNode != null && !rNode.IsDelete()) {
            if (rNode.GetSourceIsDir() || rNode.IsParentGroup()) {
                for (int nIdx = 0; nIdx < rNode.getChildCount(); ++nIdx) {
                    TreeNode rNext = rNode.getChildAt(nIdx);
                    if (!(rNext instanceof CTransferNode)) continue;
                    this.OnTransferResume((CTransferNode)rNext);
                }
            } else if ((rNode.GetFileRead() < rNode.GetFileTotal() || rNode.GetFileTotal() == 0L) && rNode.GetThreadStatus() != CTransferNode.STATUS.QUESTION && rNode.GetThreadStatus() != CTransferNode.STATUS.RUNNING) {
                this.OnConfirmOverwriteFile(4, rNode.GetTransferMsg(), false);
            }
        }
    }

    private void OnTransferResume() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5303, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    private void OnRecvTransferResume() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                this.OnTransferResume(rNode);
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        this.AssignThreads();
    }

    private void OnTransferStart() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5304, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    private void OnRecvTransferStart() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null) continue;
                rNode.OnTransferStart();
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        this.AssignThreads();
    }

    private void OnTransferRestart() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5305, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    private void OnRecvTransferRestart() {
        int[] anSelRows = null;
        if (this.GetTreeTable() != null) {
            anSelRows = this.GetTreeTable().getSelectedRows();
        }
        if (anSelRows != null) {
            CBoolAttr rAttr;
            boolean bConfirmRelist = true;
            if (CRhinoApp.GET_RHINO_APP() != null && (rAttr = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmTransferRelistDlg()) != null) {
                bConfirmRelist = rAttr.GetValue();
            }
            if (bConfirmRelist) {
                bConfirmRelist = false;
                for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                    int nRow = anSelRows[nIdx];
                    CTransferNode rNode = this.GetTreeNode(nRow);
                    if (rNode == null) continue;
                    if (rNode.IsParentGroup()) {
                        if (rNode.GetChildCountDirs() <= 1) continue;
                        bConfirmRelist = true;
                        continue;
                    }
                    if (!rNode.GetSourceIsDir()) continue;
                    bConfirmRelist = true;
                }
            }
            int nResult = 0;
            if (bConfirmRelist) {
                CConfirmRelistDlg rDlg = new CConfirmRelistDlg(CRhinoApp.GetParentWindow(this.GetTreeTable()));
                rDlg.setVisible(true);
                nResult = rDlg.GetResult();
            }
            if (nResult == 0) {
                for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                    int nRow = anSelRows[nIdx];
                    CTransferNode rNode = this.GetTreeNode(nRow);
                    if (rNode == null) continue;
                    rNode.OnTransferRestart();
                }
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
            this.AssignThreads();
        }
    }

    protected void SetThreadStatus(CTransferNode rNode, CTransferNode.STATUS nStatus) {
        if (rNode != null) {
            rNode.SetThreadStatus(nStatus, false);
            this.RepaintRow(rNode);
        }
    }

    protected void DetachThread(CTransferNode rDetachFrom) {
        if (rDetachFrom != null) {
            CTransferThread rThread = rDetachFrom.DetachThread();
            this.AssignThreads();
        }
    }

    private void OnTransferOpen(boolean bFromDoubleClick, boolean bIsShowInFolder) {
        Object[] arRetVals = new Object[2];
        if (this.IsValidOpenFileRow(arRetVals) && arRetVals != null) {
            Boolean bIsDir = (Boolean)arRetVals[0];
            String sAbsPath = (String)arRetVals[1];
            if (bIsDir != null && sAbsPath != null && !sAbsPath.isEmpty()) {
                boolean bAllowIt = true;
                if (bIsDir.booleanValue()) {
                    if (bFromDoubleClick) {
                        bAllowIt = false;
                    }
                } else if (bIsShowInFolder) {
                    sAbsPath = CString.GetParentPath(sAbsPath, true);
                }
                if (bAllowIt) {
                    CLocalFileSystem.GetLocalFileSystem().OpenFile(sAbsPath);
                }
            }
        }
        arRetVals = null;
    }

    protected void OnTransferShowInFolder() {
        this.OnTransferOpen(false, true);
    }

    protected void OnTransferOpen(boolean bFromDoubleClick) {
        this.OnTransferOpen(bFromDoubleClick, false);
    }

    protected void OnTransferStopAtNextFile() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5300, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnRecvTransferStopAtNextFile() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            Vector<CTransferNodeParentGroup> aParentGroups = new Vector<CTransferNodeParentGroup>();
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                CTransferNodeParentGroup rParentGroup;
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null || (rParentGroup = rNode.GetParentGroup()) == null || aParentGroups.contains(rParentGroup)) continue;
                aParentGroups.add(rParentGroup);
            }
            for (CTransferNodeParentGroup rParentGroup : aParentGroups) {
                if (rParentGroup == null) continue;
                rParentGroup.OnTransferStop();
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
    }

    protected void OnTransferSkip() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5301, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnRecvTransferSkip() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null) continue;
                rNode.OnTransferSkip();
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        this.AssignThreads();
    }

    protected void OnRecvTransferCancel() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null) continue;
                rNode.OnTransferCancel();
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        this.AssignThreads();
    }

    protected void OnTransferCancel() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5306, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnTransferCancelAll() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5311, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnRecvTransferCancelAll() {
        CTransferNode rRootNode = this.GetRootNode();
        for (int nIdx = 0; nIdx < rRootNode.getChildCount(); ++nIdx) {
            TreeNode rChildNode = rRootNode.getChildAt(nIdx);
            if (rChildNode == null || !(rChildNode instanceof CTransferNodeParentGroup)) continue;
            CTransferNodeParentGroup rParentGroupNode = (CTransferNodeParentGroup)rChildNode;
            rParentGroupNode.OnTransferCancel();
        }
        this.GetTreeTable().EndWaitCursor();
        this.GetTreeTable().StartUpdateBtnTimer();
    }

    protected void OnTransferRemove() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        CUIMessage rUIMsg = new CUIMessage(5307, this.GetTreeTable());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnRecvTransferRemove() {
        if (this.GetTreeTable() != null) {
            int[] anSelRows = this.GetTreeTable().getSelectedRows();
            for (int nIdx = anSelRows.length - 1; nIdx >= 0; --nIdx) {
                int nRow = anSelRows[nIdx];
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null) continue;
                rNode.OnTransferCancel();
                this.RemoveNode(rNode, STATES_TO_REMOVE_ALL.OVERRIDE);
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        this.AssignThreads();
    }

    private void RemoveNode(CTransferNode rRemoveNode, STATES_TO_REMOVE_ALL nStateToRemove) {
        this.RemoveNode(rRemoveNode, nStateToRemove, false);
    }

    private void RemoveNode(CTransferNode rRemoveNode, STATES_TO_REMOVE_ALL nStateToRemove, boolean bIsAutoRemove) {
        if (rRemoveNode != null) {
            CTransferNode rParentNode = rRemoveNode.GetParent();
            this.RemoveChildren(rParentNode, rRemoveNode, nStateToRemove, bIsAutoRemove);
            if (rParentNode != null) {
                this.RemoveParents(rParentNode.GetParent(), rParentNode, nStateToRemove, bIsAutoRemove);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    private void RemoveChildren(CTransferNode rParentNode, CTransferNode rChildNode, STATES_TO_REMOVE_ALL nStateToRemove, boolean bIsAutoRemove) {
        block18: {
            block16: {
                block17: {
                    if (rParentNode == null || rChildNode == null) break block16;
                    for (int nIdx = rChildNode.getChildCount() - 1; nIdx >= 0; --nIdx) {
                        CTransferNode rNextChild = (CTransferNode)rChildNode.getChildAt(nIdx);
                        if (rNextChild == null) continue;
                        this.RemoveChildren(rChildNode, rNextChild, nStateToRemove, bIsAutoRemove);
                    }
                    if (!rChildNode.IsParentGroup() || rChildNode.getChildCount() >= 1) break block17;
                    rChildNode.Remove(rParentNode, bIsAutoRemove);
                    break block18;
                }
                switch (nStateToRemove) {
                    case COMPLETED: {
                        if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.DONE_GREEN) {
                            rChildNode.Remove(rParentNode, bIsAutoRemove);
                            break;
                        }
                        break block18;
                    }
                    case CANCELLED: {
                        if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.CANCELLED) {
                            rChildNode.Remove(rParentNode, bIsAutoRemove);
                            break;
                        }
                        break block18;
                    }
                    case SKIPPED: {
                        if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.SKIPPED) {
                            rChildNode.Remove(rParentNode, bIsAutoRemove);
                            break;
                        }
                        break block18;
                    }
                    case PAUSED: {
                        if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.PAUSED) {
                            rChildNode.Remove(rParentNode, bIsAutoRemove);
                            break;
                        }
                        break block18;
                    }
                    case STOPPED: {
                        if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.STOPPED) {
                            rChildNode.Remove(rParentNode, bIsAutoRemove);
                            break;
                        }
                        break block18;
                    }
                    case WAITING: {
                        if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.WAITING) {
                            rChildNode.Remove(rParentNode, bIsAutoRemove);
                            break;
                        }
                        break block18;
                    }
                    default: {
                        rChildNode.Remove(rParentNode, bIsAutoRemove);
                        break;
                    }
                }
                break block18;
            }
            if (DEBUG) {
                CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
            }
        }
    }

    private void RemoveParents(CTransferNode rParentNode, CTransferNode rChildNode, STATES_TO_REMOVE_ALL nStateToRemove, boolean bIsAutoRemove) {
        if (rParentNode != null && rChildNode != null) {
            if (!rChildNode.isLeaf() && rChildNode.getChildCount() < 1 && !rChildNode.isRoot()) {
                if (nStateToRemove == STATES_TO_REMOVE_ALL.COMPLETED) {
                    if (rChildNode.GetThreadStatus() == CTransferNode.STATUS.DONE_GREEN) {
                        rChildNode.Remove(rParentNode, bIsAutoRemove);
                    }
                } else {
                    rChildNode.Remove(rParentNode, bIsAutoRemove);
                }
                this.RemoveParents(rParentNode.GetParent(), rParentNode, nStateToRemove, bIsAutoRemove);
            }
        } else if (DEBUG_REMOVE_PARENTS) {
            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    protected void OnTransferRemoveAll() {
        this.OnTransferRemoveAll(STATES_TO_REMOVE_ALL.OVERRIDE, false);
    }

    protected void OnTransferRemoveAll(STATES_TO_REMOVE_ALL nState) {
        this.OnTransferRemoveAll(nState, true);
    }

    protected void OnTransferRemoveAll(STATES_TO_REMOVE_ALL nState, boolean bAssignThreads) {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().BeginWaitCursor();
        }
        Object[] aObjs = new Object[]{nState, bAssignThreads};
        CUIMessage rUIMsg = new CUIMessage(5308, this.GetTreeTable(), (Object)aObjs);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnRecvTransferRemoveAll(STATES_TO_REMOVE_ALL nState, boolean bAssignThreads) {
        if (this.GetTreeTable() != null) {
            for (int nRow = this.GetTreeTable().getRowCount() - 1; nRow >= 0; --nRow) {
                CTransferNode rNode = this.GetTreeNode(nRow);
                if (rNode == null) continue;
                this.RemoveNode(rNode, nState);
            }
            this.GetTreeTable().EndWaitCursor();
            this.GetTreeTable().StartUpdateBtnTimer();
        }
        if (bAssignThreads) {
            this.AssignThreads();
        }
    }

    public boolean GetAutoExpandNewTransfers() {
        boolean bVal = true;
        if (this.m_rbAutoExpandNewTransfers != null) {
            bVal = this.m_rbAutoExpandNewTransfers.GetValue();
        }
        return bVal;
    }

    public boolean GetAutoStartNewTransfers() {
        boolean bVal = true;
        if (this.m_rbAutoStartNewTransfers != null) {
            bVal = this.m_rbAutoStartNewTransfers.GetValue();
        }
        return bVal;
    }

    public boolean GetAutoRemoveCompletedTransfers() {
        boolean bVal = false;
        if (this.m_rbAutoRemoveCompletedTransfers != null) {
            bVal = this.m_rbAutoRemoveCompletedTransfers.GetValue();
        }
        return bVal;
    }

    private void OnRecvConfirm(CSUSourceMsg rSourceMsg) {
        CTransferNode rNode;
        if (rSourceMsg != null && (rNode = this.GetTreeNode(rSourceMsg.GetUISourceAttrID())) != null) {
            CConfirmDlg.TYPE nType = rSourceMsg.GetConfirmDlgType();
            boolean bShowConfirmDlg = rNode.GetUserWantsConfirmDlg(nType);
            if (!bShowConfirmDlg) {
                int nResult = rNode.GetUserConfirmDlgResult(nType);
                this.OnConfirmDlgResult(nResult, rSourceMsg, false);
            } else {
                this.SetThreadStatus(rNode, CTransferNode.STATUS.QUESTION);
                Container rCenterTo = null;
                if (CRhinoApp.GET_RHINO_APP() != null) {
                    rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
                }
                rSourceMsg.OnConfirm(this.GetTreeTable(), rCenterTo);
            }
        }
    }

    private void OnRecvError(CSUSourceMsg rSourceMsg) {
        CTransferNode rNode;
        if (rSourceMsg != null && (rNode = this.GetTreeNode(rSourceMsg.GetUISourceAttrID())) != null) {
            boolean bIsCancelled = rSourceMsg.GetCancel();
            if (rNode.GetThreadStatus() == CTransferNode.STATUS.RUNNING) {
                if (bIsCancelled) {
                    this.SetThreadStatus(rNode, CTransferNode.STATUS.CANCELLED);
                } else {
                    this.SetThreadStatus(rNode, CTransferNode.STATUS.ERROR);
                }
                CConfirmDlg.TYPE nType = rSourceMsg.GetConfirmDlgType();
                boolean bShowConfirmDlg = rNode.GetShowConfirmDlg(nType);
                if (bShowConfirmDlg) {
                    Container rCenterTo = null;
                    if (CRhinoApp.GET_RHINO_APP() != null) {
                        rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
                    }
                    rSourceMsg.OnError(this.GetTreeTable(), rCenterTo);
                }
            }
            if (bIsCancelled) {
                rNode.DetachThread();
            }
        }
    }

    private void OnShowDialog(CDialogShowMsg rDlgMsg) {
        if (rDlgMsg != null && !rDlgMsg.IsConsumed()) {
            JDialog rDlg;
            Container rCenterTo = null;
            if (CRhinoApp.GET_RHINO_APP() != null) {
                rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
            }
            if ((rDlgMsg.GetSource() == rCenterTo || rDlgMsg.GetSource() == this.GetTreeTable()) && (rDlg = rDlgMsg.GetDialog()) != null) {
                if (rDlg instanceof CConfirmDlg) {
                    CConfirmDlg rConfirmDlg = (CConfirmDlg)rDlg;
                    CSUMsg rSourceMsg = rConfirmDlg.GetSUMsg();
                    if (rSourceMsg != null) {
                        CConfirmDlg.TYPE nType = rSourceMsg.GetConfirmDlgType();
                        CTransferNode rNode = this.GetTreeNode(rSourceMsg.GetUISourceAttrID());
                        if (rNode != null) {
                            CTransferNodeParentGroup rParentGroupNode = rNode.GetParentGroup();
                            if (rParentGroupNode != null) {
                                boolean bShowConfirmDlg = rNode.GetUserWantsConfirmDlg(nType);
                                int nResult = rNode.GetUserConfirmDlgResult(nType);
                                boolean bWaitingForThumb = false;
                                if (bShowConfirmDlg) {
                                    boolean bShowDoNotAskAgain = false;
                                    bShowDoNotAskAgain = rParentGroupNode.GetShowDoNotAskAgain();
                                    rConfirmDlg.SetVisible_DoNotAskAgain(bShowDoNotAskAgain);
                                    if (CRhinoApp.GET_RHINO_APP() != null) {
                                        CRhinoApp.GET_RHINO_APP().PostIncTransfersInProgress();
                                    }
                                    rDlgMsg.DoModal();
                                    if (CRhinoApp.GET_RHINO_APP() != null) {
                                        CRhinoApp.GET_RHINO_APP().PostDecTransfersInProgress();
                                    }
                                    nResult = rConfirmDlg.GetResult();
                                    boolean bDoNotAskAgain = rConfirmDlg.GetDoNotShowAgain();
                                    if (nResult == 0) {
                                        bWaitingForThumb = rConfirmDlg.GetWaitForThumb();
                                    }
                                    if (bDoNotAskAgain && rSourceMsg != null) {
                                        if (rConfirmDlg.GetType() == CConfirmDlg.TYPE.ERROR && bDoNotAskAgain && nResult == 0) {
                                            rNode.SetShowErrorConfirmDlg(true);
                                        } else {
                                            rParentGroupNode.UpdateShowConfirmDlg(rConfirmDlg.GetType(), false, nResult);
                                        }
                                    }
                                }
                                this.OnConfirmDlgResult(nResult, rSourceMsg, bWaitingForThumb);
                            } else if (DEBUG) {
                                CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "ParentGroupTreeNode is invalid.");
                            }
                        } else if (DEBUG) {
                            CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Could not find tree node.");
                        }
                    } else if (DEBUG) {
                        CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "No source message in the dialog.");
                    }
                } else if (DEBUG_WRONG_DLG_TYPE) {
                    CDebugLog.INFO(CTransferTreeTableModel.class.getName() + " failed to show the dialog.");
                }
            }
        }
    }

    private void OnRecvTransfer(CTransferMsg rTransferMsg) {
        if (rTransferMsg != null) {
            long lThreadAttrID = rTransferMsg.GetThreadAttrID();
            CTransferNode rNode = this.GetTreeNode(rTransferMsg.GetUISourceAttrID());
            if (rNode != null) {
                if (!(rNode.IsRoot() || rNode.IsParentGroup() || rNode.GetSourceIsDir())) {
                    rNode.SetHasListingForTarget(true);
                }
                this.SetThreadStatus(rNode, CTransferNode.STATUS.DONE_GREEN);
                this.DetachThread(rNode);
                this.CheckAllDone(rNode);
                if (!rTransferMsg.IsDirSource() && this.GetAutoRemoveCompletedTransfers() && rNode.GetThreadStatus() == CTransferNode.STATUS.DONE_GREEN) {
                    this.RemoveNode(rNode, STATES_TO_REMOVE_ALL.COMPLETED, true);
                }
            }
        }
    }

    private void OnRecvDelete(CDeleteMsg rDeleteMsg) {
        if (rDeleteMsg != null) {
            long lThreadAttrID = rDeleteMsg.GetThreadAttrID();
            CTransferNode rNode = this.GetTreeNode(rDeleteMsg.GetUISourceAttrID());
            if (rNode != null) {
                this.SetThreadStatus(rNode, CTransferNode.STATUS.DONE_GREEN);
                this.DetachThread(rNode);
                this.CheckAllDone(rNode);
                if (this.GetAutoRemoveCompletedTransfers() && rNode.GetThreadStatus() == CTransferNode.STATUS.DONE_GREEN) {
                    this.RemoveNode(rNode, STATES_TO_REMOVE_ALL.COMPLETED, true);
                }
            }
        }
    }

    public boolean CheckAllDone(CTransferNode rCurNode) {
        boolean bAffectsCurWorkingDir = false;
        if (rCurNode != null && !rCurNode.IsDownload()) {
            CSUSourceMsg rSourceMsg;
            boolean bAllDoneProcessingChildren;
            CTransferNodeParentGroup rParentGroup;
            String sWorkingDirPage = null;
            if (CRhinoApp.GET_RHINO_APP() != null) {
                sWorkingDirPage = CRhinoApp.GET_RHINO_APP().FetchCurWorkingDir(this);
            }
            if (this.GetTreeTable() != null && (rParentGroup = rCurNode.GetParentGroup()) != null && (bAllDoneProcessingChildren = rParentGroup.CheckNoMoreChildrenToProcess()) && sWorkingDirPage != null && !sWorkingDirPage.isEmpty() && rParentGroup.getChildCount() > 0 && (rSourceMsg = rCurNode.GetTransferMsg()) != null) {
                String sTargetDir = null;
                if (rSourceMsg instanceof CDeleteMsg) {
                    sTargetDir = ((CDeleteMsg)rSourceMsg).GetWorkingDir();
                } else if (rSourceMsg instanceof CUploadMsg) {
                    String sTargetPath;
                    CTransferNode rParent;
                    for (rParent = rCurNode; rParent != null && rParent != rParentGroup && rParent.GetParent() != rParentGroup; rParent = rParent.GetParent()) {
                    }
                    if (rParent != null && (sTargetPath = rParent.GetTargetPath()) != null && !sTargetPath.isEmpty()) {
                        sTargetDir = CString.GetParentPath(sTargetPath, false);
                    }
                }
                if (sTargetDir != null && !sTargetDir.isEmpty() && sTargetDir.equals(sWorkingDirPage)) {
                    bAffectsCurWorkingDir = true;
                }
            }
            if (bAffectsCurWorkingDir && CRhinoApp.GET_RHINO_APP() != null) {
                CRhinoApp.GET_RHINO_APP().PostTransferAllDoneInCurDir();
            }
        }
        return bAffectsCurWorkingDir;
    }

    @Override
    public void StartRefreshTimer() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().StartRefreshTimer();
        }
    }

    @Override
    public CUpdateTransferBtns CreateUpdateDynamicBtnMsg() {
        return new CUpdateTransferBtns(this.GetTreeTable());
    }

    @Override
    public boolean InitUpdateDynamicBtnMsg(CUpdateDynamicBtns rMsg1) {
        CSpeedTest sp = null;
        if (DEBUG_UPDATE_BTN_MSG) {
            sp = new CSpeedTest();
            sp.Start();
        }
        if (rMsg1 != null && rMsg1 instanceof CUpdateTransferBtns) {
            Object[] arRetVals;
            CUpdateTransferBtns rMsg = (CUpdateTransferBtns)rMsg1;
            rMsg.InitBtnStates(false, true);
            CTransferNode rRoot = this.GetRootNode();
            if (rRoot != null) {
                rMsg.SetEnabled_StopBtn(rRoot.GetEnableStop() > 0);
                rMsg.SetEnabled_SkipBtn(rRoot.GetEnableSkip() > 0);
                rMsg.SetEnabled_PauseBtn(rRoot.GetEnablePause() > 0);
                rMsg.SetEnabled_ResumeBtn(rRoot.GetEnableResume() > 0);
                rMsg.SetEnabled_StartBtn(rRoot.GetEnableStart() > 0);
                rMsg.SetEnabled_RestartBtn(rRoot.GetEnableRestart() > 0);
                rMsg.SetEnabled_CancelBtn(rRoot.GetEnableCancel() > 0);
                rMsg.SetEnabled_RemoveBtn(rRoot.GetEnableRemove() > 0);
                boolean bEnable = rRoot.GetEnableRemoveAllCompleted() > 0;
                rMsg.SetEnabled_RemoveAllCompletedBtn(bEnable);
                bEnable = rRoot.GetEnableRemoveAllWaiting() > 0;
                rMsg.SetEnabled_RemoveAllWaitingBtn(bEnable);
                bEnable = rRoot.GetEnableRemoveAllPaused() > 0;
                rMsg.SetEnabled_RemoveAllPausedBtn(bEnable);
                bEnable = rRoot.GetEnableRemoveAllStopped() > 0;
                rMsg.SetEnabled_RemoveAllStoppedBtn(bEnable);
                bEnable = rRoot.GetEnableRemoveAllCancelled() > 0;
                rMsg.SetEnabled_RemoveAllCancelledBtn(bEnable);
                bEnable = rRoot.GetEnableRemoveAllSkipped() > 0;
                rMsg.SetEnabled_RemoveAllSkippedBtn(bEnable);
                rMsg.SetEnabled_RemoveAllBtn(rRoot.getChildCount() > 0);
            }
            if (this.IsValidOpenFileRow(arRetVals = new Object[1])) {
                rMsg.SetEnabled_ShowInFolderBtn(true);
                Boolean rVal = (Boolean)arRetVals[0];
                if (rVal != null) {
                    boolean bIsDir = rVal;
                    rMsg.SetEnabled_OpenBtn(!bIsDir);
                }
            }
            if (CRhinoApp.GET_RHINO_APP() != null) {
                CBoolAttr rbConfirmDeletes_Folders = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmFolderDeletes();
                CBoolAttr rbConfirmDeletes_Files = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmFileDeletes();
                CBoolAttr rbConfirmOverwrite_UploadFile = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmUploadFileOverwrites();
                CBoolAttr rbConfirmOverwrite_DownloadFile = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmDownloadFileOverwrites();
                String sStartInfo = CString.LoadString("IDS_START_MENU");
                if (rbConfirmDeletes_Folders.GetValue() || rbConfirmDeletes_Files.GetValue() || rbConfirmOverwrite_UploadFile.GetValue() || rbConfirmOverwrite_DownloadFile.GetValue()) {
                    int nNumOfConfirmDeletes = 0;
                    int nNumOfConfirmOverwrites = 0;
                    for (int nIdx = 0; nIdx < rRoot.getChildCount(); ++nIdx) {
                        TreeNode rChild = rRoot.getChildAt(nIdx);
                        if (rChild == null || !(rChild instanceof CTransferNode)) continue;
                        CTransferNode rNextChild = (CTransferNode)rChild;
                        if (this.IsSelected(rNextChild)) {
                            if (rNextChild.IsDelete()) {
                                if (rNextChild.GetSourceIsDir()) {
                                    if (rbConfirmDeletes_Folders.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_FOLDER)) {
                                        ++nNumOfConfirmDeletes;
                                    }
                                } else if (rbConfirmDeletes_Files.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_FILE)) {
                                    ++nNumOfConfirmDeletes;
                                }
                            } else if (rNextChild.IsUpload()) {
                                if (rbConfirmOverwrite_UploadFile.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.OVERWRITE_FILE)) {
                                    ++nNumOfConfirmOverwrites;
                                }
                            } else if (rNextChild.IsDownload() && rbConfirmOverwrite_DownloadFile.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.OVERWRITE_FILE)) {
                                ++nNumOfConfirmOverwrites;
                            }
                        }
                        if (rbConfirmDeletes_Folders.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_FOLDER)) {
                            nNumOfConfirmDeletes += rNextChild.GetEnableConfirmDeleteFolders();
                        }
                        if (rbConfirmDeletes_Files.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_FILE)) {
                            nNumOfConfirmDeletes += rNextChild.GetEnableConfirmDeleteFiles();
                        }
                        if (rbConfirmOverwrite_UploadFile.GetValue() && rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.OVERWRITE_FILE)) {
                            nNumOfConfirmOverwrites += rNextChild.GetEnableConfirmOverwriteUploadFiles();
                        }
                        if (!rbConfirmOverwrite_DownloadFile.GetValue() || !rNextChild.GetShowConfirmDlg(CConfirmDlg.TYPE.OVERWRITE_FILE)) continue;
                        nNumOfConfirmOverwrites += rNextChild.GetEnableConfirmOverwriteDownloadFiles();
                    }
                    if (this.GetTreeTable() != null && this.GetTreeTable().getSelectedRowCount() > 0) {
                        sStartInfo = nNumOfConfirmOverwrites > 0 || nNumOfConfirmDeletes > 0 ? String.format(CString.LoadString("IDS_FMT_TRANSFER_START_DESC_UNCONFIRMED"), nNumOfConfirmOverwrites + nNumOfConfirmDeletes) : CString.LoadString("IDS_TRANSFER_START_DESC_CONFIRMED");
                    }
                }
                rMsg.SetStartBtnDesc(sStartInfo);
                sStartInfo = CString.LoadString("IDS_RESTART_MENU");
                if (!this.GetAutoStartNewTransfers()) {
                    sStartInfo = CString.LoadString("IDS_RELIST_MENU");
                }
                rMsg.SetRestartBtnDesc(sStartInfo);
            }
        }
        if (sp != null) {
            sp.Stop();
            sp.PrintResults("InitUpdateDynamicBtnMsg");
        }
        return super.InitUpdateDynamicBtnMsg(rMsg1);
    }

    @Override
    protected void OnDnDInitDragData(CDndMsg rDndMsg) {
    }

    @Override
    protected boolean OnDnDInitDropData(CDndMsg rDndMsg) {
        CRhinoDragDropData rData;
        boolean bCanImport = false;
        if (rDndMsg != null && (rData = rDndMsg.GetDragDropData()).GetType() == 1) {
            CFilesDragDropData rDragData = (CFilesDragDropData)rData;
            bCanImport = true;
            rDragData.SetCanImport(bCanImport);
            rDragData.SetShowDropLocation(false);
            rDragData.SetCursorState(1);
        }
        if (!this.GetAllowDropData()) {
            bCanImport = false;
        }
        return bCanImport;
    }

    @Override
    protected boolean OnDnDImportDropData(CDndMsg rDndMsg) {
        CRhinoDragDropData rData;
        boolean bImported = false;
        if (rDndMsg != null && (rData = rDndMsg.GetDragDropData()).GetType() == 1) {
            CDndFile rDragSourceDir;
            Point ptDropLoc;
            TransferHandler.DropLocation rDropLocation;
            CFilesDragDropData rDragData = (CFilesDragDropData)rData;
            TransferHandler.TransferSupport rTransferSupport = rDndMsg.GetTransferSupport();
            if (rTransferSupport != null && (rDropLocation = rTransferSupport.getDropLocation()) != null && (ptDropLoc = rDropLocation.getDropPoint()) != null && (rDragSourceDir = rDragData.GetDragSourceDir()) != null) {
                if (rDragSourceDir.IsLocal()) {
                    String sWorkingDir = null;
                    if (CRhinoApp.GET_RHINO_APP() != null) {
                        sWorkingDir = CRhinoApp.GET_RHINO_APP().FetchCurWorkingDir(this);
                    }
                    if (sWorkingDir != null && !sWorkingDir.isEmpty()) {
                        if (rDragData.GetFileCount() > 0) {
                            StringBuilder sbFileData = new StringBuilder();
                            Object[] arAbsSourcePaths = new Object[rDragData.GetFileCount() * 2];
                            int nIdx = 0;
                            int nIdx2 = 0;
                            while (nIdx < rDragData.GetFileCount()) {
                                CDndFile rUploadFile = rDragData.GetFile(nIdx);
                                if (rUploadFile != null) {
                                    String sAbsPath = rUploadFile.GetAbsPath();
                                    boolean bIsDir = rUploadFile.IsDir();
                                    arAbsSourcePaths[nIdx2] = sAbsPath;
                                    arAbsSourcePaths[nIdx2 + 1] = bIsDir;
                                    sbFileData.append(sAbsPath);
                                    sbFileData.append(',');
                                    if (bIsDir) {
                                        sbFileData.append("1");
                                    } else {
                                        sbFileData.append("0");
                                    }
                                    if (nIdx + 1 < rDragData.GetFileCount()) {
                                        sbFileData.append(',');
                                    }
                                }
                                ++nIdx;
                                nIdx2 += 2;
                            }
                            if (this.GetTreeTable() != null) {
                                if (CRhinoApp.GET_RHINO_APP() != null) {
                                    CAddUploadItemsMsg rMsg = new CAddUploadItemsMsg(sbFileData.toString(), sWorkingDir);
                                    CRhinoApp.GET_RHINO_APP().NewMessage(rMsg);
                                }
                                bImported = true;
                                rDragData.SetHasImportedData(bImported);
                            }
                        }
                    } else if (DEBUG) {
                        CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "We do not have a directory to upload to.");
                    }
                } else if (DEBUG) {
                    CDebugLog.ASSERT(CTransferTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We do not support remote drag data.");
                }
            }
        }
        return bImported;
    }

    @Override
    public CTransferTreeTable GetTreeTable() {
        return (CTransferTreeTable)super.GetTreeTable();
    }

    public boolean GetAllowDropData() {
        return this.m_bAllowDropData;
    }

    public void SetAllowDropData(boolean bAllowDropData) {
        this.m_bAllowDropData = bAllowDropData;
    }

    @Override
    public void OnKeyDelete() {
        this.OnTransferRemove();
    }

    protected void OnRecvThumbnail(CThumbnailMsg rThumbMsg) {
        CTransferNode rNode;
        if (CRhinoOverwriteFileBtn.DEBUG_AFTER_ACTION_THUMB) {
            CDebugLog.ENTERING(CTransferTreeTableModel.class.getName(), "OnRecvThumbnail");
        }
        if (rThumbMsg != null && (rNode = this.GetTreeNode(rThumbMsg.GetUISourceAttrID_AfterThumb())) != null) {
            rNode.OnRecvThumbnail(rThumbMsg);
        }
        if (CRhinoOverwriteFileBtn.DEBUG_AFTER_ACTION_THUMB) {
            CDebugLog.EXITING(CTransferTreeTableModel.class.getName(), "OnRecvThumbnail");
        }
    }

    private void OnRecvError_Thumb(CThumbnailMsg rThumbMsg) {
        if (CRhinoOverwriteFileBtn.DEBUG_AFTER_ACTION_THUMB) {
            CDebugLog.ENTERING(CTransferTreeTableModel.class.getName(), "OnRecvError_Thumb");
        }
        this.OnRecvThumbnail(rThumbMsg);
        if (CRhinoOverwriteFileBtn.DEBUG_AFTER_ACTION_THUMB) {
            CDebugLog.EXITING(CTransferTreeTableModel.class.getName(), "OnRecvError_Thumb");
        }
    }

    private boolean IsValidOpenFileRow(Object[] arRetVals) {
        CTransferNode rTransferNode;
        int nRow;
        int nSelRowCount;
        boolean bIsValid = false;
        if (this.GetTreeTable() != null && (nSelRowCount = this.GetTreeTable().getSelectedRowCount()) == 1 && this.IsValidRow(nRow = this.GetTreeTable().getSelectedRow()) && (rTransferNode = this.GetTreeNode(nRow)) != null) {
            if (rTransferNode.IsDownload() && rTransferNode.GetThreadStatus() == CTransferNode.STATUS.DONE_GREEN && !rTransferNode.IsParentGroup()) {
                bIsValid = true;
            }
            if (arRetVals != null) {
                if (arRetVals.length > 0) {
                    arRetVals[0] = rTransferNode.GetSourceIsDir();
                }
                if (arRetVals.length > 1) {
                    arRetVals[1] = rTransferNode.GetTargetPath();
                }
            }
        }
        return bIsValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OnCheckWatchDogs() {
        Object object = this.m_TransferThreadVectorCrit;
        synchronized (object) {
            for (CTransferThread rNextThread : this.m_aActiveThreads) {
                if (rNextThread == null || !rNextThread.IsWatchDogExpired()) continue;
                rNextThread.OnTriggeredWatchDog();
            }
        }
    }

    static {
        boolean bl = DEBUG_UNKNOWN_MSG = DEBUG;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_REPAINT_IMMEDIATELY = false;
        DEBUG_SHOW_EXTRA_COLS = CRhinoApp.DEBUG_SHOW_EXTRA_XFER_COLS;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_XFER_STATS_SIZE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_CHECK_NEXT_NODE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ASSIGN_THREAD = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_REMOVE_PARENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_WRONG_DLG_TYPE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPDATE_BTN_MSG = false;
        COL_MAX = 6;
        m_nWorkerNameIdx = 0;
        if (DEBUG_SHOW_EXTRA_COLS) {
            COL_MAX = 39;
        }
    }

    private static enum STATES_TO_REMOVE_ALL {
        OVERRIDE,
        COMPLETED,
        CANCELLED,
        SKIPPED,
        PAUSED,
        WAITING,
        STOPPED;

    }
}

