/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableCellRenderer;
import com.rhinosoft.ui.transfer.CTransferNode;
import com.rhinosoft.ui.transfer.CTransferTreeTable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;

public class CTransferTreeTableCellRenderer
extends CRhinoTreeTableCellRenderer {
    public static boolean DEBUG_DATA_UPDATES;

    public CTransferTreeTableCellRenderer(CTransferTreeTable rTreeTable) {
        super(rTreeTable);
    }

    @Override
    protected CTransferTreeTable GetTreeTable() {
        return (CTransferTreeTable)super.GetTreeTable();
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        if (DEBUG_DATA_UPDATES) {
            System.out.printf("CTransferTreeTableCellRenderer - Updated Row: %d | Col: %d\r\n", nRow, nCol);
        }
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        nCol = rTable.convertColumnIndexToModel(nCol);
        String sText = "";
        Icon icoIcon = null;
        int nAlignHorz = 2;
        if (rVal instanceof CTransferNode) {
            CTransferNode rTreeNode = (CTransferNode)rVal;
            switch (nCol) {
                case 0: {
                    sText = rTreeNode.FmtThreadStatus();
                    icoIcon = rTreeNode.GetIconTransferStatus();
                    break;
                }
                case 3: {
                    if (rTreeNode.IsDownload()) {
                        icoIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_FILE_DOWNLOAD_PNG.GetFileName());
                    } else if (rTreeNode.IsUpload()) {
                        icoIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_FILE_UPLOAD_PNG.GetFileName());
                    }
                    sText = rTreeNode.FormatCompletionTxt();
                    break;
                }
                case 4: {
                    if (!rTreeNode.IsParentGroup()) {
                        if (rTreeNode.GetSource() != null) {
                            sText = rTreeNode.GetSource().GetAbsPath();
                            icoIcon = rTreeNode.GetSource().GetIcon16();
                            break;
                        }
                        if (!DEBUG) break;
                        sText = "<ERROR: Source is null>";
                        break;
                    }
                    sText = rTreeNode.FmtProcessingSourcePaths();
                    break;
                }
                case 5: {
                    if (!rTreeNode.IsParentGroup() && !rTreeNode.IsDelete()) {
                        sText = rTreeNode.GetTargetPath();
                        if (rTreeNode.GetSource() == null) break;
                        icoIcon = rTreeNode.GetSource().GetIcon16();
                        break;
                    }
                    sText = rTreeNode.FmtProcessingTargetPaths();
                    break;
                }
                case 6: {
                    sText = "";
                    if (!rTreeNode.IsParentGroup()) {
                        long lThreadID;
                        if (rTreeNode.GetTransferThread() == null || (lThreadID = rTreeNode.GetTransferThread().GetUniqueID()) < 0L) break;
                        sText = Long.toString(lThreadID);
                        break;
                    }
                    sText = rTreeNode.FmtProcessingThreads();
                    break;
                }
                case 7: {
                    sText = Boolean.toString(rTreeNode.GetHasListing());
                    break;
                }
                case 8: {
                    sText = Boolean.toString(rTreeNode.GetHasListingForTarget());
                    break;
                }
                case 9: {
                    sText = Integer.toString(rTreeNode.GetChildCountListed());
                    break;
                }
                case 10: {
                    sText = Integer.toString(rTreeNode.GetChildCountPending());
                    break;
                }
                case 11: {
                    sText = Integer.toString(rTreeNode.GetChildCountComplete());
                    break;
                }
                case 12: {
                    sText = Integer.toString(rTreeNode.GetChildCountTotal());
                    break;
                }
                case 13: {
                    sText = Integer.toString(rTreeNode.GetChildCountDirs());
                    break;
                }
                case 14: {
                    sText = Integer.toString(rTreeNode.GetChildCountFiles());
                    break;
                }
                case 15: {
                    sText = Boolean.toString(rTreeNode.GetShowConfirmDlg(CConfirmDlg.TYPE.ERROR));
                    break;
                }
                case 16: {
                    sText = Boolean.toString(rTreeNode.GetShowConfirmDlg(CConfirmDlg.TYPE.MERGE_FOLDER));
                    break;
                }
                case 17: {
                    sText = Boolean.toString(rTreeNode.GetShowConfirmDlg(CConfirmDlg.TYPE.OVERWRITE_FILE));
                    break;
                }
                case 18: {
                    sText = Boolean.toString(rTreeNode.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_FOLDER));
                    break;
                }
                case 19: {
                    sText = Boolean.toString(rTreeNode.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_FILE));
                    break;
                }
                case 20: {
                    sText = Boolean.toString(rTreeNode.GetShowConfirmDlg(CConfirmDlg.TYPE.DELETE_MULTI));
                    break;
                }
                case 21: {
                    sText = Integer.toString(rTreeNode.GetEnableConfirmDeleteFolders());
                    break;
                }
                case 22: {
                    sText = Integer.toString(rTreeNode.GetEnableConfirmDeleteFiles());
                    break;
                }
                case 23: {
                    sText = Integer.toString(rTreeNode.GetEnableConfirmOverwriteUploadFiles());
                    break;
                }
                case 24: {
                    sText = Integer.toString(rTreeNode.GetEnableConfirmOverwriteDownloadFiles());
                    break;
                }
                case 25: {
                    sText = Integer.toString(rTreeNode.GetEnableStop());
                    break;
                }
                case 26: {
                    sText = Integer.toString(rTreeNode.GetEnableSkip());
                    break;
                }
                case 27: {
                    sText = Integer.toString(rTreeNode.GetEnablePause());
                    break;
                }
                case 28: {
                    sText = Integer.toString(rTreeNode.GetEnableResume());
                    break;
                }
                case 29: {
                    sText = Integer.toString(rTreeNode.GetEnableStart());
                    break;
                }
                case 30: {
                    sText = Integer.toString(rTreeNode.GetEnableRestart());
                    break;
                }
                case 31: {
                    sText = Integer.toString(rTreeNode.GetEnableCancel());
                    break;
                }
                case 32: {
                    sText = Integer.toString(rTreeNode.GetEnableRemove());
                    break;
                }
                case 33: {
                    sText = Integer.toString(rTreeNode.GetEnableRemoveAllCompleted());
                    break;
                }
                case 34: {
                    sText = Integer.toString(rTreeNode.GetEnableRemoveAllCancelled());
                    break;
                }
                case 35: {
                    sText = Integer.toString(rTreeNode.GetEnableRemoveAllSkipped());
                    break;
                }
                case 36: {
                    sText = Integer.toString(rTreeNode.GetEnableRemoveAllPaused());
                    break;
                }
                case 37: {
                    sText = Integer.toString(rTreeNode.GetEnableRemoveAllWaiting());
                    break;
                }
                case 38: {
                    sText = Integer.toString(rTreeNode.GetEnableRemoveAllStopped());
                    break;
                }
            }
        }
        this.setText(sText);
        this.setIcon(icoIcon);
        this.setHorizontalAlignment(nAlignHorz);
        return this;
    }

    static {
        if (CAttr.DEBUG) {
            // empty if block
        }
        DEBUG_DATA_UPDATES = false;
    }
}

