/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CFilePathAttr;
import com.rhinosoft.dialogs.CFileChooserTransfer;
import com.rhinosoft.dragdrop.CRhinoDragDropHandler;
import com.rhinosoft.dragdrop.CTransfersDragDropHandler;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAddDeleteItemsMsg;
import com.rhinosoft.messages.CAddDownloadItemsMsg;
import com.rhinosoft.messages.CAddUploadItemsMsg;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CConnectionInfoMsg;
import com.rhinosoft.messages.CDialogShowMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.messages.CUpdateDynamicBtns;
import com.rhinosoft.messages.CUpdateTransferBtns;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoAction;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.CTypeAhead;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import com.rhinosoft.ui.transfer.CTransferTreeTableCellRenderer;
import com.rhinosoft.ui.transfer.CTransferTreeTableModel;
import com.rhinosoft.ui.transfer.CTransferTreeTableProgressRenderer;
import com.rhinosoft.ui.transfer.CTransferTreeTableTreeNodeRenderer;
import com.rhinosoft.ui.transfer.CTransferTreeTableTreeRenderer;
import com.rhinosoft.ui.transfer.CTypeAhead_Transfer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.filechooser.FileSystemView;

public class CTransferTreeTable
extends CRhinoTreeTable {
    private static final boolean DEBUG_SHOW_ROOT;
    private CFilePathAttr m_TransferDownloadDir;
    private File m_fCurrentDownloadDir;
    private CFilePathAttr m_TransferUploadDir;
    private File m_fCurrentUploadDir;
    private CBoolAttr m_ShowProgBar;
    private CTransferTreeTableProgressRenderer m_TableCellRendererStatus;
    private JMenuItem m_cShowInFolderBtn;
    private JMenuItem m_cOpenFileBtn;
    private JMenuItem m_cStopAtNextFileBtn;
    private JMenuItem m_cSkipFileBtn;
    private JMenuItem m_cPauseBtn;
    private JMenuItem m_cStartBtn;
    private JMenuItem m_cResumeBtn;
    private JMenuItem m_cRestartBtn;
    private JMenuItem m_cCancelBtn;
    private JMenuItem m_cRemoveBtn;
    private JMenu m_cRemoveAllMenu;
    private JMenuItem m_cRemoveAllCompletedBtn;
    private JMenuItem m_cRemoveAllCancelledBtn;
    private JMenuItem m_cRemoveAllSkippedBtn;
    private JMenuItem m_cRemoveAllPausedBtn;
    private JMenuItem m_cRemoveAllWaitingBtn;
    private JMenuItem m_cRemoveAllStoppedBtn;
    private JMenuItem m_cRemoveAllBtn;
    private CUpdateTransferBtns m_rUpdateTransferBtnMsg = null;

    public CTransferTreeTable() {
        this._CTransferTreeTable();
    }

    private void _CTransferTreeTable() {
        this.setShowGrid(false);
        this.setShowHorizontalLines(true);
        this.setGridColor(Color.decode("#DFDFDF"));
        this.m_ShowProgBar = new CBoolAttr(false, false);
        this.InitProgressRenderers();
        if (this.GetTreeRenderer() != null && !DEBUG_SHOW_ROOT) {
            this.GetTreeRenderer().setRootVisible(false);
            this.GetTreeRenderer().setShowsRootHandles(true);
        }
        this.setIntercellSpacing(new Dimension(0, 1));
        this.InitAttrs();
        this.InitButtons();
    }

    private void InitAttrs() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.m_fCurrentUploadDir = FileSystemView.getFileSystemView().getDefaultDirectory();
            this.m_TransferUploadDir = new CFilePathAttr(this.m_fCurrentUploadDir.getAbsolutePath(), this.m_fCurrentUploadDir.getAbsolutePath(), "TransferUploadDir");
            this.m_fCurrentDownloadDir = FileSystemView.getFileSystemView().getDefaultDirectory();
            this.m_TransferDownloadDir = new CFilePathAttr(this.m_fCurrentDownloadDir.getAbsolutePath(), this.m_fCurrentDownloadDir.getAbsolutePath(), "TransferDownloadDir");
        }
    }

    @Override
    protected void OnCreate() {
        super.OnCreate();
    }

    @Override
    protected CTransferTreeTableModel CreateModel() {
        return new CTransferTreeTableModel(this);
    }

    @Override
    public CTransferTreeTableModel GetModel() {
        return (CTransferTreeTableModel)super.GetModel();
    }

    protected void InitProgressRenderers() {
        this.m_TableCellRendererStatus = this.CreateTableCellRendererStatus();
        this.setDefaultRenderer(CTransferTreeTableProgressRenderer.class, this.m_TableCellRendererStatus);
    }

    protected CTransferTreeTableProgressRenderer CreateTableCellRendererStatus() {
        return new CTransferTreeTableProgressRenderer(this, this.GetShowProgBar());
    }

    @Override
    protected CTransferTreeTableTreeRenderer CreateTreeRenderer() {
        return new CTransferTreeTableTreeRenderer(this.GetModel(), this, this.GetDefaultRowHeight());
    }

    @Override
    protected CTransferTreeTableTreeNodeRenderer CreateTreeNodeRenderer() {
        return new CTransferTreeTableTreeNodeRenderer(this.GetTreeRenderer(), this);
    }

    @Override
    protected CTransferTreeTableTreeNodeRenderer GetTreeNodeRenderer() {
        return (CTransferTreeTableTreeNodeRenderer)super.GetTreeNodeRenderer();
    }

    @Override
    protected CTransferTreeTableCellRenderer CreateTableCellRenderer() {
        return new CTransferTreeTableCellRenderer(this);
    }

    public void DeleteItems(boolean bSourceIsLocal, Object[] asAbsSourcePaths) {
        if (this.GetModel() != null) {
            this.GetModel().InitDeleteItems(bSourceIsLocal, asAbsSourcePaths);
        }
        this.EndWaitCursor();
    }

    protected void InitTransferItems(Object[] asAbsSourcePaths, Object[] asAbsTargetPaths, boolean bIsUpload, boolean bIgnoreNames) {
        if (this.GetModel() != null) {
            this.GetModel().InitTransferItems(asAbsSourcePaths, asAbsTargetPaths, bIsUpload, bIgnoreNames);
        }
    }

    public void DownloadItems(Object[] asAbsSourcePaths, String sAbsTargetDir) {
        if (asAbsSourcePaths != null && asAbsSourcePaths.length > 0 && sAbsTargetDir != null && !sAbsTargetDir.isEmpty()) {
            boolean bIgnoreNames = false;
            Object[] asAbsTargetPaths = new Object[asAbsSourcePaths.length];
            for (int nSourceIdx = 0; nSourceIdx < asAbsSourcePaths.length; nSourceIdx += 2) {
                asAbsTargetPaths[nSourceIdx] = sAbsTargetDir;
                Boolean bIsDir = (Boolean)asAbsSourcePaths[nSourceIdx + 1];
                File fTemp = new File(sAbsTargetDir);
                if (fTemp != null && fTemp.exists()) {
                    bIsDir = fTemp.isDirectory();
                }
                asAbsTargetPaths[nSourceIdx + 1] = bIsDir;
                if (bIsDir.booleanValue() || asAbsSourcePaths.length != 2) continue;
                bIgnoreNames = true;
            }
            this.InitTransferItems(asAbsSourcePaths, asAbsTargetPaths, false, bIgnoreNames);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
        }
    }

    public void DownloadItems(Object[] asAbsSourcePaths) {
        Container rCenterTo = this;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
        }
        CFileChooserTransfer fc = new CFileChooserTransfer((Component)rCenterTo, this.m_fCurrentDownloadDir, true, asAbsSourcePaths);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostAddDialogToQueue(this, fc, CString.LoadString("IDS_DOWNLOAD_BTN"));
        }
    }

    public void UploadItems(String sAbsTargetDir) {
        Container rCenterTo = this;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
        }
        CFileChooserTransfer fc = new CFileChooserTransfer(rCenterTo, this.m_fCurrentUploadDir, false);
        fc.SetAbsTargetDir(sAbsTargetDir);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostAddDialogToQueue(this, fc, CString.LoadString("IDS_UPLOAD_BTN"));
        }
    }

    public void UploadItems(Object[] asAbsSourcePaths, String sAbsTargetDir) {
        if (asAbsSourcePaths != null && asAbsSourcePaths.length > 0 && sAbsTargetDir != null && !sAbsTargetDir.isEmpty()) {
            Object[] asAbsTargetPaths = new Object[asAbsSourcePaths.length];
            for (int nSourceIdx = 0; nSourceIdx < asAbsSourcePaths.length; nSourceIdx += 2) {
                asAbsTargetPaths[nSourceIdx] = sAbsTargetDir;
                asAbsTargetPaths[nSourceIdx + 1] = asAbsSourcePaths[nSourceIdx + 1];
            }
            this.InitTransferItems(asAbsSourcePaths, asAbsTargetPaths, true, false);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
        }
    }

    public void InitConnection(String sHost, long lServerPort, long lHeaderPort, String sUserAgent, String sEncSessionID, boolean bIsCaseSensitiveOS) {
        if (this.GetModel() != null) {
            this.GetModel().InitConnection(sHost, lServerPort, lHeaderPort, sUserAgent, sEncSessionID, bIsCaseSensitiveOS);
        }
    }

    public void InitLocale(String sLanguageCode, String sCountryCode) {
        if (this.GetModel() != null) {
            this.GetModel().InitLocale(sLanguageCode, sCountryCode);
        }
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 5000: {
                    CConnectionInfoMsg rConnMsg = (CConnectionInfoMsg)rMsg;
                    this.InitConnection(rConnMsg.GetHost(), rConnMsg.GetServerPort(), rConnMsg.GetHeaderPort(), rConnMsg.GetUserAgent(), rConnMsg.GetEncSessionID(), rConnMsg.IsCaseSensitiveOS());
                    break;
                }
                case 5001: {
                    CConnectionInfoMsg rConnMsg = (CConnectionInfoMsg)rMsg;
                    this.InitLocale(rConnMsg.GetLanguageCode(), rConnMsg.GetCountryCode());
                    break;
                }
                case 5005: {
                    this.OnShowConnectionInfo();
                    break;
                }
                case 5006: {
                    this.OnShowLocale();
                    break;
                }
                case 5002: {
                    CAddDownloadItemsMsg rUIMsg = (CAddDownloadItemsMsg)rMsg;
                    if (rUIMsg.GetFetchDownloadPath()) {
                        this.DownloadItems(rUIMsg.GetSourcePaths());
                        break;
                    }
                    this.DownloadItems(rUIMsg.GetSourcePaths(), rUIMsg.GetAbsTargetPath());
                    break;
                }
                case 5003: {
                    CAddUploadItemsMsg rUIMsg = (CAddUploadItemsMsg)rMsg;
                    if (rUIMsg.GetFetchUploadPaths()) {
                        this.UploadItems(rUIMsg.GetAbsTargetPath());
                        break;
                    }
                    this.UploadItems(rUIMsg.GetSourcePaths(), rUIMsg.GetAbsTargetPath());
                    break;
                }
                case 5004: {
                    this.BeginWaitCursor();
                    CUIMessage rUIMsg = new CUIMessage(5310, this, (Object)rMsg);
                    if (CRhinoApp.GET_RHINO_APP() == null) break;
                    CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
                    break;
                }
                case 5310: {
                    CUIMessage rUIMsg;
                    if (!(rMsg instanceof CUIMessage) || (rUIMsg = (CUIMessage)rMsg).GetSource() != this) break;
                    CAddDeleteItemsMsg rDelItemsMsg = (CAddDeleteItemsMsg)rUIMsg.GetAttachedObject();
                    this.DeleteItems(rDelItemsMsg.GetSourceIsLocal(), rDelItemsMsg.GetSourcePaths());
                    break;
                }
                case 5016: {
                    this.OnShowDialog((CDialogShowMsg)rMsg);
                    break;
                }
                case 5309: {
                    if (!(rMsg instanceof CUIMessage)) break;
                    CUIMessage rUIMsg = (CUIMessage)rMsg;
                    if (rUIMsg.GetSource() == this) {
                        CFileChooserTransfer rFileChooserTransfer = (CFileChooserTransfer)rUIMsg.GetAttachedObject();
                        this.OnRecvTransferAdd(rFileChooserTransfer);
                        rFileChooserTransfer.Destroy();
                    }
                    rUIMsg.Destroy();
                    break;
                }
            }
        }
    }

    public void OnShowConnectionInfo() {
        String sOut = "Unavailable";
        if (this.GetModel() != null) {
            sOut = this.GetModel().toStringConnectionInfo();
        }
        JOptionPane.showMessageDialog(this, sOut);
        if (DEBUG) {
            System.out.printf(sOut, new Object[0]);
        }
    }

    public void OnShowLocale() {
        String sOut = "Unavailable";
        if (this.GetModel() != null) {
            sOut = this.GetModel().toStringLocale();
        }
        JOptionPane.showMessageDialog(this, sOut);
        if (DEBUG) {
            System.out.printf(sOut, new Object[0]);
        }
    }

    public void SetNumOfWorkers(int nNumOfWorkers) {
        if (this.GetModel() != null) {
            this.GetModel().SetNumOfTransferThreads(nNumOfWorkers);
        }
    }

    private boolean GetShowProgBar() {
        return this.m_ShowProgBar.GetValue();
    }

    @Override
    protected String GetKeyColIndex(int nModelCol) {
        String sKey = null;
        switch (nModelCol) {
            case 0: {
                sKey = "TransferColIndexOperation";
                break;
            }
            case 1: {
                sKey = "TransferColIndexName";
                break;
            }
            case 2: {
                sKey = "TransferColIndexStatus";
                break;
            }
            case 3: {
                sKey = "TransferColIndexCompletion";
                break;
            }
            case 4: {
                sKey = "TransferColIndexSource";
                break;
            }
            case 5: {
                sKey = "TransferColIndexTarget";
                break;
            }
            case 6: {
                sKey = "TransferColIndexThread";
                break;
            }
            case 7: {
                sKey = "TransferColIndexSourceListed";
                break;
            }
            case 8: {
                sKey = "TransferColIndexTargetListed";
                break;
            }
            case 9: {
                sKey = "TransferColIndexNumListed";
                break;
            }
            case 10: {
                sKey = "TransferColIndexNumPending";
                break;
            }
            case 11: {
                sKey = "TransferColIndexNumComplete";
                break;
            }
            case 12: {
                sKey = "TransferColIndexNumChildren";
                break;
            }
            case 13: {
                sKey = "TransferColIndexNumChildDirs";
                break;
            }
            case 14: {
                sKey = "TransferColIndexNumChildFiles";
                break;
            }
            case 15: {
                sKey = "TransferColIndexConfirmError";
                break;
            }
            case 16: {
                sKey = "TransferColIndexConfirmMergeFolder";
                break;
            }
            case 17: {
                sKey = "TransferColIndexConfirmOverwrite";
                break;
            }
            case 18: {
                sKey = "TransferColIndexConfirmDelFolder";
                break;
            }
            case 19: {
                sKey = "TransferColIndexConfirmDelFile";
                break;
            }
            case 20: {
                sKey = "TransferColIndexConfirmMultiDel";
                break;
            }
        }
        return sKey;
    }

    @Override
    protected String GetKeyColWidth(int nModelCol) {
        String sKey = null;
        switch (nModelCol) {
            case 0: {
                sKey = "TransferColWidthOperation";
                break;
            }
            case 1: {
                sKey = "TransferColWidthName";
                break;
            }
            case 2: {
                sKey = "TransferColWidthStatus";
                break;
            }
            case 3: {
                sKey = "TransferColWidthCompletion";
                break;
            }
            case 4: {
                sKey = "TransferColWidthSource";
                break;
            }
            case 5: {
                sKey = "TransferColWidthTarget";
                break;
            }
            case 6: {
                sKey = "TransferColWidthThread";
                break;
            }
            case 7: {
                sKey = "TransferColWidthSourceListed";
                break;
            }
            case 8: {
                sKey = "TransferColWidthTargetListed";
                break;
            }
            case 9: {
                sKey = "TransferColWidthNumListed";
                break;
            }
            case 10: {
                sKey = "TransferColWidthNumPending";
                break;
            }
            case 11: {
                sKey = "TransferColWidthNumComplete";
                break;
            }
            case 12: {
                sKey = "TransferColWidthNumChildren";
                break;
            }
            case 13: {
                sKey = "TransferColWidthNumChildDirs";
                break;
            }
            case 14: {
                sKey = "TransferColWidthNumChildFiles";
                break;
            }
            case 15: {
                sKey = "TransferColWidthConfirmError";
                break;
            }
            case 16: {
                sKey = "TransferColWidthConfirmMergeFolder";
                break;
            }
            case 17: {
                sKey = "TransferColWidthConfirmOverwrite";
                break;
            }
            case 18: {
                sKey = "TransferColWidthConfirmDelFolder";
                break;
            }
            case 19: {
                sKey = "TransferColWidthConfirmDelFile";
                break;
            }
            case 20: {
                sKey = "TransferColWidthConfirmMultiDel";
                break;
            }
        }
        return sKey;
    }

    @Override
    protected void LoadPopupMenu() {
        super.LoadPopupMenu();
        JPopupMenu rPopupMenu = this.GetPopupMenu();
        if (rPopupMenu != null) {
            rPopupMenu.add(this.m_cShowInFolderBtn);
            rPopupMenu.add(this.m_cOpenFileBtn);
            rPopupMenu.addSeparator();
            rPopupMenu.add(this.m_cStopAtNextFileBtn);
            rPopupMenu.add(this.m_cSkipFileBtn);
            rPopupMenu.addSeparator();
            rPopupMenu.add(this.m_cPauseBtn);
            rPopupMenu.add(this.m_cStartBtn);
            rPopupMenu.add(this.m_cResumeBtn);
            rPopupMenu.add(this.m_cRestartBtn);
            rPopupMenu.addSeparator();
            rPopupMenu.add(this.m_cCancelBtn);
            rPopupMenu.add(this.m_cRemoveBtn);
            rPopupMenu.add(this.m_cRemoveAllMenu);
        }
    }

    @Override
    protected void OnRecvCacheImage(String sFileName) {
        super.OnRecvCacheImage(sFileName);
        if ((IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_CANCELLED_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DELETE_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DONE_GREEN_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DONE_YELLOW_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DOWNLOADING_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_ERROR_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PAUSED_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_1_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_2_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_3_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_4_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_5_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_6_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_7_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_QUESTION_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_FOLDER_OPENED_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_CANCELLED.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_DONE.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_RESTART_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_RESUME_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_SKIPPED_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_START_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_STOPPED_PNG.GetFileName().equals(sFileName) || IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_UPLOADING_PNG.GetFileName().equals(sFileName)) && this.GetPopupMenu() != null) {
            for (int nIdx = 0; nIdx < this.GetPopupMenu().getComponentCount(); ++nIdx) {
                Component rComp = this.GetPopupMenu().getComponent(nIdx);
                if (rComp == null) continue;
                rComp.repaint();
            }
            this.GetPopupMenu().repaint();
        }
    }

    private void InitButtons() {
        this.m_cShowInFolderBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3520));
        this.m_cOpenFileBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3519));
        this.m_cStopAtNextFileBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3500));
        this.m_cSkipFileBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3501));
        this.m_cPauseBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3502));
        this.m_cResumeBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3503));
        this.m_cStartBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3504));
        this.m_cRestartBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3505));
        this.m_cCancelBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3506));
        this.m_cRemoveBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3507));
        this.m_cRemoveAllCompletedBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3509));
        this.m_cRemoveAllCancelledBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3510));
        this.m_cRemoveAllSkippedBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3511));
        this.m_cRemoveAllPausedBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3512));
        this.m_cRemoveAllWaitingBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3513));
        this.m_cRemoveAllStoppedBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3514));
        this.m_cRemoveAllBtn = new JMenuItem(CRhinoApp.GET_RHINO_APP().GetAction(3515));
        this.m_cRemoveAllMenu = new JMenu(CRhinoApp.GET_RHINO_APP().GetAction(3508));
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllCompletedBtn);
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllCancelledBtn);
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllSkippedBtn);
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllPausedBtn);
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllWaitingBtn);
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllStoppedBtn);
        this.m_cRemoveAllMenu.addSeparator();
        this.m_cRemoveAllMenu.add(this.m_cRemoveAllBtn);
    }

    @Override
    protected void OnUpdateDynamicBtns(CUpdateDynamicBtns rBtnMsg) {
        if (rBtnMsg != null && rBtnMsg instanceof CUpdateTransferBtns) {
            String sDesc;
            CRhinoAction rRhinoAction;
            this.m_rUpdateTransferBtnMsg = (CUpdateTransferBtns)rBtnMsg;
            this.m_cShowInFolderBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_ShowInFolderBtn());
            this.m_cShowInFolderBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_ShowInFolderBtn());
            this.m_cOpenFileBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_OpenBtn());
            this.m_cOpenFileBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_OpenBtn());
            this.m_cStopAtNextFileBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_StopBtn());
            this.m_cStopAtNextFileBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_StopBtn());
            this.m_cSkipFileBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_SkipBtn());
            this.m_cSkipFileBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_SkipBtn());
            this.m_cPauseBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_PauseBtn());
            this.m_cPauseBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_PauseBtn());
            this.m_cResumeBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_ResumeBtn());
            this.m_cResumeBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_ResumeBtn());
            this.m_cStartBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_StartBtn());
            this.m_cStartBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_StartBtn());
            Action rAction = this.m_cStartBtn.getAction();
            if (rAction instanceof CRhinoAction) {
                rRhinoAction = (CRhinoAction)rAction;
                sDesc = this.m_rUpdateTransferBtnMsg.GetStartBtnDesc();
                if (sDesc != null) {
                    rRhinoAction.SetName(sDesc);
                    rRhinoAction.SetShortDesc(sDesc);
                }
            }
            this.m_cRestartBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RestartBtn());
            this.m_cRestartBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RestartBtn());
            rAction = this.m_cRestartBtn.getAction();
            if (rAction instanceof CRhinoAction) {
                rRhinoAction = (CRhinoAction)rAction;
                sDesc = this.m_rUpdateTransferBtnMsg.GetRestartBtnDesc();
                if (sDesc != null) {
                    rRhinoAction.SetName(sDesc);
                    rRhinoAction.SetShortDesc(sDesc);
                }
            }
            this.m_cCancelBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_CancelBtn());
            this.m_cCancelBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_CancelBtn());
            this.m_cRemoveBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveBtn());
            this.m_cRemoveBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveBtn());
            this.m_cRemoveAllCompletedBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllCompletedBtn());
            this.m_cRemoveAllCompletedBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllCompletedBtn());
            this.m_cRemoveAllCancelledBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllCancelledBtn());
            this.m_cRemoveAllCancelledBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllCancelledBtn());
            this.m_cRemoveAllSkippedBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllSkippedBtn());
            this.m_cRemoveAllSkippedBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllSkippedBtn());
            this.m_cRemoveAllPausedBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllPausedBtn());
            this.m_cRemoveAllPausedBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllPausedBtn());
            this.m_cRemoveAllWaitingBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllWaitingBtn());
            this.m_cRemoveAllWaitingBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllWaitingBtn());
            this.m_cRemoveAllStoppedBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllStoppedBtn());
            this.m_cRemoveAllStoppedBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllStoppedBtn());
            this.m_cRemoveAllBtn.setEnabled(this.m_rUpdateTransferBtnMsg.GetEnabled_RemoveAllBtn());
            this.m_cRemoveAllBtn.setVisible(this.m_rUpdateTransferBtnMsg.IsVisible_RemoveAllBtn());
        }
    }

    @Override
    public void keyPressed(KeyEvent rEvent) {
        int nKeyCode = rEvent.getKeyCode();
        switch (nKeyCode) {
            case 127: {
                this.OnMessage(new CWorkerThreadMsg(3507));
                rEvent.consume();
                break;
            }
            case 10: {
                this.OnMessage(new CWorkerThreadMsg(3504));
                rEvent.consume();
                break;
            }
        }
        if (!rEvent.isConsumed()) {
            super.keyPressed(rEvent);
        }
    }

    @Override
    protected int GetTypeAheadCol() {
        return 1;
    }

    @Override
    protected CTypeAhead CreateTypeAhead() {
        return new CTypeAhead_Transfer();
    }

    @Override
    protected CRhinoDragDropHandler CreateDragDropHandler() {
        return new CTransfersDragDropHandler(this);
    }

    public void SetAllowDropData(boolean bAllowDropData) {
        if (this.GetModel() != null) {
            this.GetModel().SetAllowDropData(bAllowDropData);
        }
    }

    private void OnShowDialog(CDialogShowMsg rDlgMsg) {
        if (rDlgMsg != null && !rDlgMsg.IsConsumed()) {
            JFileChooser rFileChooser;
            Container rCenterTo = null;
            if (CRhinoApp.GET_RHINO_APP() != null) {
                rCenterTo = CRhinoApp.GET_RHINO_APP().GetMainWnd();
            }
            if ((rDlgMsg.GetSource() == rCenterTo || rDlgMsg.GetSource() == this) && (rFileChooser = rDlgMsg.GetFileChooser()) != null && rFileChooser instanceof CFileChooserTransfer) {
                final CFileChooserTransfer rFileChooserTransfer = (CFileChooserTransfer)rFileChooser;
                rDlgMsg.DoModal();
                int nRetVal = rDlgMsg.GetResult();
                if (nRetVal == 0) {
                    final CTransferTreeTable rTreeTable = this;
                    Timer rTimer = new Timer(250, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            CTransferTreeTable.this.BeginWaitCursor();
                            CUIMessage rUIMsg = new CUIMessage(5309, rTreeTable, (Object)rFileChooserTransfer);
                            if (CRhinoApp.GET_RHINO_APP() != null) {
                                CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
                            }
                        }
                    });
                    rTimer.setRepeats(false);
                    rTimer.start();
                }
            }
        }
    }

    private void OnRecvTransferAdd(CFileChooserTransfer rFileChooserTransfer) {
        if (rFileChooserTransfer != null) {
            if (rFileChooserTransfer.IsDownload()) {
                File fCurrentDownloadDir = rFileChooserTransfer.getSelectedFile();
                if (fCurrentDownloadDir != null) {
                    this.m_fCurrentDownloadDir = fCurrentDownloadDir.isDirectory() ? fCurrentDownloadDir : fCurrentDownloadDir.getParentFile();
                    this.DownloadItems(rFileChooserTransfer.GetAbsSourcePaths(), fCurrentDownloadDir.getAbsolutePath());
                }
            } else {
                this.m_fCurrentUploadDir = rFileChooserTransfer.getCurrentDirectory();
                File[] aSelFiles = rFileChooserTransfer.getSelectedFiles();
                if (aSelFiles.length > 0) {
                    Object[] asAbsSourcePaths = new Object[aSelFiles.length * 2];
                    int nIdx = 0;
                    for (File fNext : aSelFiles) {
                        asAbsSourcePaths[nIdx] = fNext.getAbsolutePath();
                        asAbsSourcePaths[nIdx + 1] = fNext.isDirectory();
                        nIdx += 2;
                    }
                    this.UploadItems(asAbsSourcePaths, rFileChooserTransfer.GetAbsTargetDir());
                }
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
        this.EndWaitCursor();
    }

    @Override
    protected void OnLeftDoubleClick(MouseEvent rEvent) {
        super.OnLeftDoubleClick(rEvent);
        if (!rEvent.isConsumed() && this.GetModel() != null) {
            this.GetModel().OnTransferOpen(true);
        }
    }

    @Override
    public void OnLoadAttrs() {
        super.OnLoadAttrs();
        IArchive rArchive = this.GetArchive();
        if (rArchive != null) {
            this.m_TransferUploadDir.Load(rArchive);
            File fTemp = new File(this.m_TransferUploadDir.GetValue());
            if (fTemp != null && fTemp.exists()) {
                this.m_fCurrentUploadDir = fTemp;
            }
            this.m_TransferDownloadDir.Load(rArchive);
            fTemp = new File(this.m_TransferDownloadDir.GetValue());
            if (fTemp != null && fTemp.exists()) {
                this.m_fCurrentDownloadDir = fTemp;
            }
        }
    }

    @Override
    public void OnSaveAttrs() {
        super.OnSaveAttrs();
        IArchive rArchive = this.GetArchive();
        if (rArchive != null) {
            if (this.m_fCurrentUploadDir != null && this.m_fCurrentUploadDir.exists()) {
                this.m_TransferUploadDir.SetValue(this.m_fCurrentUploadDir.getAbsolutePath());
            }
            this.m_TransferUploadDir.Save(rArchive);
            if (this.m_fCurrentDownloadDir != null && this.m_fCurrentDownloadDir.exists()) {
                this.m_TransferDownloadDir.SetValue(this.m_fCurrentDownloadDir.getAbsolutePath());
            }
            this.m_TransferDownloadDir.Save(rArchive);
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SHOW_ROOT = false;
    }
}

