/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.files.CFile;
import com.rhinosoft.messages.CDownloadMsg;
import com.rhinosoft.messages.CSUSourceMsg;
import com.rhinosoft.messages.CTransferMsg;
import com.rhinosoft.messages.CUploadMsg;
import com.rhinosoft.ui.transfer.CTransferNode;
import com.rhinosoft.ui.transfer.CTransferTreeTableModel;

public class CTransferNodeTransfer
extends CTransferNode {
    private static final boolean DEBUG_SHOW_BYTES;

    public CTransferNodeTransfer(CTransferTreeTableModel rModel, CTransferNode.TYPE nType, CConnectionAttrs rConnInfo, String sAbsSourcePath, boolean bSourceIsDir, String sAbsTargetPath, boolean bTargetIsDir) {
        super(rModel, nType);
        this._CTransferNodeTransfer();
        this.InitSource(this.IsUpload(), sAbsSourcePath, bSourceIsDir);
        this.InitTarget(sAbsTargetPath, bTargetIsDir);
        this.InitTransferMsg(rConnInfo);
    }

    public CTransferNodeTransfer(CTransferTreeTableModel rModel, CTransferNode.TYPE nType, CConnectionAttrs rConnInfo, CFile rSource, String sAbsTargetPath) {
        super(rModel, nType);
        this._CTransferNodeTransfer();
        this.InitSource(rSource);
        boolean bIsDir = false;
        if (rSource != null) {
            bIsDir = rSource.IsDirectory();
        }
        this.InitTarget(sAbsTargetPath, bIsDir);
        this.InitTransferMsg(rConnInfo);
    }

    private void _CTransferNodeTransfer() {
    }

    @Override
    protected CSUSourceMsg CreateTransferMsg(CConnectionAttrs rConnInfo) {
        CTransferMsg rMsg = null;
        rMsg = this.IsUpload() ? new CUploadMsg(rConnInfo.GetHost(), rConnInfo.GetServerPort(), rConnInfo.IsSecure(), rConnInfo.GetHeaderPort(), rConnInfo.GetUserAgent(), rConnInfo.GetEncSessionID(), this.GetAttrID(), this.GetSourcePath(), this.GetSourceIsDir(), this.GetTargetPath(), this.GetTargetIsDir()) : new CDownloadMsg(rConnInfo.GetHost(), rConnInfo.GetServerPort(), rConnInfo.IsSecure(), rConnInfo.GetHeaderPort(), rConnInfo.GetUserAgent(), rConnInfo.GetEncSessionID(), this.GetAttrID(), this.GetSourcePath(), this.GetSourceIsDir(), this.GetTargetPath(), this.GetTargetIsDir());
        return rMsg;
    }

    @Override
    public CSUSourceMsg InitTransferMsg(CConnectionAttrs rConnInfo) {
        CSUSourceMsg rMsg = super.InitTransferMsg(rConnInfo);
        if (rMsg instanceof CTransferMsg) {
            CTransferMsg rTransferMsg = (CTransferMsg)rMsg;
            rTransferMsg.SetTargetPath(this.GetTargetPath());
            rTransferMsg.SetTargetIsDir(this.GetTargetIsDir());
        }
        return rMsg;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SHOW_BYTES = false;
    }
}

