/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.transfer.CTransferNode;
import com.rhinosoft.ui.transfer.CTransferTreeTableModel;
import javax.swing.Icon;

public class CTransferNodeParentGroup
extends CTransferNode {
    public CTransferNodeParentGroup(CTransferTreeTableModel rModel, CTransferNode.TYPE nType, long lTransferItem) {
        super(rModel, nType);
        this._CTransferNodeParentGroup(lTransferItem);
    }

    private void _CTransferNodeParentGroup(long lTransferItem) {
        String sDisplayText = String.format(CString.LoadString("IDS_FMT_PARENT_GROUP_UNKNOWN"), lTransferItem);
        if (this.IsUpload()) {
            sDisplayText = String.format(CString.LoadString("IDS_FMT_PARENT_GROUP_UPLOAD"), lTransferItem);
        } else if (this.IsDownload()) {
            sDisplayText = String.format(CString.LoadString("IDS_FMT_PARENT_GROUP_DOWNLOAD"), lTransferItem);
        } else if (this.IsDelete()) {
            sDisplayText = String.format(CString.LoadString("IDS_FMT_PARENT_GROUP_DELETE"), lTransferItem);
        }
        this.SetDisplayText(sDisplayText);
        this.SetHasListing(true);
    }

    @Override
    public boolean IsParentGroup() {
        return true;
    }

    @Override
    public Icon GetDisplayIcon() {
        Icon icoIcon = super.GetDisplayIcon();
        if (this.IsUpload()) {
            icoIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_UPLOADING_PNG.GetFileName());
        } else if (this.IsDownload()) {
            icoIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DOWNLOADING_PNG.GetFileName());
        } else if (this.IsDelete()) {
            icoIcon = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DELETING_PNG.GetFileName());
        }
        return icoIcon;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean IsThreadDone() {
        return true;
    }
}

