/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.transfer;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.attrs.CIntAttr;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.dialogs.CRhinoOverwriteFileBtn;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.files.CRemoteFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CSUSourceMsg;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.messages.CTransferMsg;
import com.rhinosoft.messages.CTransferStatsMsg;
import com.rhinosoft.net.HTTP.SU.CSUConnection;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.trees.CFileTreeNode;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.transfer.CTransferNodeParentGroup;
import com.rhinosoft.ui.transfer.CTransferThread;
import com.rhinosoft.ui.transfer.CTransferTreeTableModel;
import java.io.File;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class CTransferNode
extends CFileTreeNode {
    public static boolean DEBUG = CAttr.DEBUG;
    private static boolean DEBUG_PERCENT_DONE_SHOW_BYTES;
    private static boolean DEBUG_PERCENT_DONE_PRINT;
    private static boolean DEBUG_REMOVE_CHILD;
    private static boolean DEBUG_PARENT_CHILD_COUNT_TOTAL;
    private static boolean DEBUG_ADD_CHILD_AS_XFER;
    private static boolean DEBUG_INIT_XFER_MSG;
    private static boolean DEBUG_FILE_READ;
    private static boolean DEBUG_THREAD_ATTACH;
    private static boolean DEBUG_REPAINT_ROOT;
    private static boolean DEBUG_STAT_MSGS;
    private static boolean DEBUG_STAT_MSGS_RATE;
    private static boolean DEBUG_ELAPSED;
    private static boolean DEBUG_ELAPSED_ENDED;
    private static boolean DEBUG_TRACK_BYTES_PER_SEC;
    private static boolean DEBUG_STATS_PARENT;
    public static final int THREAD_DETACHED = -1;
    public static final int IDX_ENABLE_CONFIRM_DELETE_FOLDERS = 0;
    public static final int IDX_ENABLE_CONFIRM_DELETE_FILES = 1;
    public static final int IDX_ENABLE_CONFIRM_OVERWRITE_UPLOAD_FILES = 2;
    public static final int IDX_ENABLE_CONFIRM_OVERWRITE_DOWNLOAD_FILES = 3;
    public static final int IDX_ENABLE_STOP = 4;
    public static final int IDX_ENABLE_SKIP = 5;
    public static final int IDX_ENABLE_PAUSE = 6;
    public static final int IDX_ENABLE_RESUME = 7;
    public static final int IDX_ENABLE_START = 8;
    public static final int IDX_ENABLE_RESTART = 9;
    public static final int IDX_ENABLE_CANCEL = 10;
    public static final int IDX_ENABLE_REMOVE = 11;
    public static final int IDX_ENABLE_REMOVE_ALL_COMPLETED = 12;
    public static final int IDX_ENABLE_REMOVE_ALL_CANCELLED = 13;
    public static final int IDX_ENABLE_REMOVE_ALL_SKIPPED = 14;
    public static final int IDX_ENABLE_REMOVE_ALL_PAUSED = 15;
    public static final int IDX_ENABLE_REMOVE_ALL_WAITING = 16;
    public static final int IDX_ENABLE_REMOVE_ALL_STOPPED = 17;
    public static final int IDX_ENABLE_MAX_SIZE = 18;
    private CConfirmations m_ConfirmDlg_Error = new CConfirmations(true, 2);
    private CConfirmations m_ConfirmDlg_MergeFolder = new CConfirmations(true, 2);
    private CConfirmations m_ConfirmDlg_Overwrite = new CConfirmations(true, 2);
    private CConfirmations m_ConfirmDlg_DeleteFolder = new CConfirmations(true, 2);
    private CConfirmations m_ConfirmDlg_DeleteFile = new CConfirmations(true, 2);
    private CConfirmations m_ConfirmDlg_MultiDelete = new CConfirmations(true, 2);
    private String m_sAbsTargetPath;
    private boolean m_bTargetIsDir = false;
    private STATUS m_nThreadStatus;
    private TYPE m_nType;
    private long m_lPrevFileRead = 0L;
    private long m_lFileRead = 0L;
    private long m_lFileTotal = 0L;
    private boolean m_bHasListing = false;
    private STATUS m_nAfterListingStatus = STATUS.PENDING;
    private boolean m_bHasListingForTarget = false;
    private long m_lStartTimeOverall = 0L;
    private long m_lEndTimeOverall = 0L;
    private long m_lEndTimeOverallMarker = 0L;
    private long m_lElapsedTime = 0L;
    private long m_lFileReadAccumulated = 0L;
    private long m_lResumeTime = 0L;
    private boolean m_bIsRecording = false;
    private long m_lStartTimePerCycle = 0L;
    private long m_lEndTimePerCycle = 0L;
    private long m_lElapsedTimePerCycle = 0L;
    private final Object m_ParentStatsCrit = new Object();
    private Vector<CTransferNode> m_aActiveChildTransfers;
    private ArrayList<CTransferNode> m_aPendingChildren;
    private int m_nChildCountComplete;
    private int m_nChildCountListed;
    private int m_nChildCountListedDir;
    private int m_nChildCountTotal;
    private int m_nChildCountDirs;
    private int m_nChildCountFiles;
    private CTransferTreeTableModel m_rTransferTreeTableModel;
    private CSUSourceMsg m_TransferMsg;
    private CTransferThread m_rTransferThread;
    private boolean m_bStop = false;
    private CBoolAttr m_rbConfirmUploadFileOverwrites;
    private CIntAttr m_rnOptionUploadFileOverwrites;
    private CBoolAttr m_rbConfirmDownloadFileOverwrites;
    private CIntAttr m_rnOptionDownloadFileOverwrites;
    private CBoolAttr m_rbConfirmUploadFolderOverwrites;
    private CIntAttr m_rnOptionUploadFolderOverwrites;
    private CBoolAttr m_rbConfirmDownloadFolderOverwrites;
    private CIntAttr m_rnOptionDownloadFolderOverwrites;
    private CBoolAttr m_rbConfirmFileDeletes;
    private CBoolAttr m_rbConfirmFolderDeletes;
    private boolean m_bDontAutoSetUserConfirmations = false;
    private boolean m_bIsManualStart = false;
    private boolean m_bIsResume = false;
    private int[] m_anEnableBtns = new int[18];

    protected CTransferNode(CTransferTreeTableModel rModel, TYPE nType) {
        this._CTransferNode(rModel, nType);
    }

    private void _CTransferNode(CTransferTreeTableModel rModel, TYPE nType) {
        this.m_nThreadStatus = STATUS.PENDING;
        this.m_nType = nType;
        this.m_bStop = false;
        this.m_bTargetIsDir = false;
        this.m_lPrevFileRead = 0L;
        this.m_lFileRead = 0L;
        this.m_lFileTotal = 0L;
        this.m_bHasListing = false;
        this.m_bHasListingForTarget = false;
        this.m_nChildCountComplete = 0;
        this.m_nChildCountListed = 0;
        this.m_nChildCountListedDir = 0;
        this.m_nChildCountTotal = 0;
        this.m_nChildCountDirs = 0;
        this.m_nChildCountFiles = 0;
        this.m_aPendingChildren = new ArrayList();
        this.m_aActiveChildTransfers = new Vector();
        this.m_rTransferTreeTableModel = rModel;
        this.m_bIsResume = false;
        this.InitGlobalAttrs();
    }

    @Override
    public void Destroy() {
        this.m_ConfirmDlg_Error = null;
        this.m_ConfirmDlg_MergeFolder = null;
        this.m_ConfirmDlg_Overwrite = null;
        this.m_ConfirmDlg_DeleteFolder = null;
        this.m_ConfirmDlg_DeleteFile = null;
        this.m_ConfirmDlg_MultiDelete = null;
        if (this.m_aActiveChildTransfers != null) {
            this.m_aActiveChildTransfers.clear();
        }
        this.m_aActiveChildTransfers = null;
        if (this.m_aPendingChildren != null) {
            this.m_aPendingChildren.clear();
        }
        this.m_aPendingChildren = null;
        this.m_rTransferTreeTableModel = null;
        if (this.m_TransferMsg != null) {
            this.m_TransferMsg.Destroy();
        }
        this.m_TransferMsg = null;
        this.m_rTransferThread = null;
        this.m_rbConfirmUploadFileOverwrites = null;
        this.m_rnOptionUploadFileOverwrites = null;
        this.m_rbConfirmDownloadFileOverwrites = null;
        this.m_rnOptionDownloadFileOverwrites = null;
        this.m_rbConfirmUploadFolderOverwrites = null;
        this.m_rnOptionUploadFolderOverwrites = null;
        this.m_rbConfirmDownloadFolderOverwrites = null;
        this.m_rnOptionDownloadFolderOverwrites = null;
        this.m_rbConfirmFileDeletes = null;
        this.m_rbConfirmFolderDeletes = null;
        this.m_anEnableBtns = null;
        super.Destroy();
    }

    @Override
    public void InitTreePath() {
        super.InitTreePath();
        this.InitConfirmationInfo();
    }

    private void InitConfirmationInfo() {
        if (!this.IsParentGroup() && this.GetParentGroup() != null && this.GetSourceIsDir()) {
            CConfirmDlg.TYPE[] aTypes = CConfirmDlg.TYPE.values();
            for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
                CConfirmDlg.TYPE rType = aTypes[nIdx];
                if (rType == null) continue;
                boolean bShow = this.GetParentGroup().GetShowConfirmDlg(rType);
                int nResult = this.GetParentGroup().GetConfirmDlgResult(rType);
                this.UpdateShowConfirmDlg(rType, bShow, nResult);
            }
        }
    }

    public final TYPE GetType() {
        return this.m_nType;
    }

    public final boolean IsUpload() {
        return this.m_nType == TYPE.UPLOAD;
    }

    public final boolean IsDownload() {
        return this.m_nType == TYPE.DOWNLOAD;
    }

    public final boolean IsDelete() {
        return this.m_nType == TYPE.DELETE;
    }

    protected void InitSource(boolean bIsLocal, String sAbsSourcePath, boolean bIsDir) {
        this.SetSource(this.CreateFile(bIsLocal, sAbsSourcePath, bIsDir));
    }

    protected void InitSource(CFile rCopyFrom) {
        CFile rFile = null;
        if (rCopyFrom != null) {
            if (rCopyFrom instanceof CRemoteFile) {
                rFile = new CRemoteFile(rCopyFrom.GetAbsPath(), rCopyFrom.IsDirectory());
            } else if (rCopyFrom instanceof CLocalFile) {
                rFile = new CLocalFile(new File(rCopyFrom.GetAbsPath()));
            }
        }
        if (rFile != null) {
            rFile.Copy(rCopyFrom);
        }
        this.SetSource(rFile);
    }

    private CFile CreateFile(boolean bIsLocal, String sAbsPath, boolean bIsDir) {
        CFile fFile = null;
        fFile = bIsLocal ? this.CreateLocalFile(sAbsPath, bIsDir) : this.CreateRemoteFile(sAbsPath, bIsDir);
        return fFile;
    }

    private CLocalFile CreateLocalFile(String sAbsPath, boolean bIsDir) {
        CLocalFile fRet = null;
        fRet = new CLocalFile(new File(sAbsPath));
        return fRet;
    }

    private CRemoteFile CreateRemoteFile(String sAbsPath, boolean bIsDir) {
        return new CRemoteFile(sAbsPath, bIsDir);
    }

    protected void InitTarget(String sAbsTargetPath, boolean bIsDir) {
        this.m_sAbsTargetPath = sAbsTargetPath;
        this.m_bTargetIsDir = bIsDir;
    }

    public void SetTarget(String sAbsTargetPath) {
        this.m_sAbsTargetPath = sAbsTargetPath;
        if (this.GetTransferMsg() != null && this.GetTransferMsg() instanceof CTransferMsg) {
            ((CTransferMsg)this.GetTransferMsg()).SetTargetPath(sAbsTargetPath);
        }
    }

    public boolean IsParentGroup() {
        return false;
    }

    private void SetTransferThread(CTransferThread rTransferThread) {
        CTransferThread rPrevThread = this.m_rTransferThread;
        this.m_rTransferThread = rTransferThread;
        if (rTransferThread != null) {
            rTransferThread.SetTreeNode(this);
            this.AddChildAsTransfer(this.GetParent(), this);
        }
        if (rPrevThread != null) {
            rPrevThread.SetTreeNode(null);
            this.RemoveChildAsTransfer(this.GetParent(), this);
        }
    }

    public CTransferThread GetTransferThread() {
        return this.m_rTransferThread;
    }

    public void AttachThread(CTransferThread rTransferThread) {
        if (DEBUG_THREAD_ATTACH) {
            System.out.printf("AttachThread(%s) to: %s\r\n", rTransferThread.GetThreadName(), this.GetSourcePath());
        }
        this.SetTransferThread(rTransferThread);
        this.SetAfterListingStatus(STATUS.PENDING);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostIncTransfersInProgress();
        }
    }

    public CTransferThread DetachThread() {
        CTransferThread rDetachedThread = this.GetTransferThread();
        if (DEBUG_THREAD_ATTACH) {
            System.out.printf("DetachThread(%s) from: %s\r\n", rDetachedThread.GetThreadName(), this.GetSourcePath());
        }
        this.SetTransferThread(null);
        this.SetAfterListingStatus(STATUS.PENDING);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostDecTransfersInProgress();
        }
        if (this.GetParent() != null) {
            this.GetParent().StopRecording();
        }
        return rDetachedThread;
    }

    public boolean IsThreadAttached() {
        boolean bThreadIsAttached = false;
        if (this.GetTransferThread() != null) {
            bThreadIsAttached = true;
        }
        return bThreadIsAttached;
    }

    public boolean IsThreadDone() {
        boolean bThreadIsDone = true;
        switch (this.m_nThreadStatus) {
            case PENDING: 
            case RUNNING: 
            case QUESTION: {
                bThreadIsDone = false;
                break;
            }
        }
        return bThreadIsDone;
    }

    public String GetTargetPath() {
        return this.m_sAbsTargetPath;
    }

    public boolean GetTargetIsDir() {
        return this.m_bTargetIsDir;
    }

    public String FmtThreadStatus() {
        String sStatus = CString.LoadString("IDS_TRANSFER_RUNNING");
        switch (this.m_nThreadStatus) {
            case PENDING: 
            case RUNNING: {
                if (this.m_nThreadStatus == STATUS.PENDING && !this.IsParentGroup() && !this.GetSourceIsDir()) {
                    sStatus = CString.LoadString("IDS_TRANSFER_PENDING");
                    break;
                }
                if (this.IsDelete()) {
                    sStatus = CString.LoadString("IDS_TRANSFER_DELETING");
                    break;
                }
                if (!this.GetHasListingForAllChildren()) {
                    sStatus = CString.LoadString("IDS_TRANSFER_LISTING");
                    break;
                }
                if (this.IsUpload()) {
                    if (this.IsResume()) {
                        sStatus = CString.LoadString("IDS_TRANSFER_UPLOADING_RESUMED");
                        break;
                    }
                    sStatus = CString.LoadString("IDS_TRANSFER_UPLOADING");
                    break;
                }
                if (!this.IsDownload()) break;
                if (this.IsResume()) {
                    sStatus = CString.LoadString("IDS_TRANSFER_DOWNLOADING_RESUMED");
                    break;
                }
                sStatus = CString.LoadString("IDS_TRANSFER_DOWNLOADING");
                break;
            }
            case DONE_GREEN: 
            case DONE_YELLOW: {
                sStatus = CString.LoadString("IDS_TRANSFER_COMPLETED");
                break;
            }
            case CANCELLED: {
                sStatus = CString.LoadString("IDS_TRANSFER_CANCELLED");
                break;
            }
            case SKIPPED: {
                sStatus = CString.LoadString("IDS_TRANSFER_SKIPPED");
                break;
            }
            case ERROR: {
                sStatus = CString.LoadString("IDS_TRANSFER_ERROR");
                break;
            }
            case QUESTION: {
                sStatus = CString.LoadString("IDS_TRANSFER_CONFIRMING");
                break;
            }
            case WAITING: {
                sStatus = CString.LoadString("IDS_TRANSFER_WAITING");
                break;
            }
            case PAUSED: {
                sStatus = CString.LoadString("IDS_TRANSFER_PAUSED");
                break;
            }
            case STOPPED: {
                sStatus = CString.LoadString("IDS_TRANSFER_STOPPED");
                break;
            }
        }
        return sStatus;
    }

    public ImageIcon GetIconTransferStatus() {
        ImageIcon icoImage = null;
        icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_PNG.GetFileName());
        switch (this.m_nThreadStatus) {
            case PENDING: 
            case RUNNING: {
                if (this.m_nThreadStatus == STATUS.PENDING && !this.IsParentGroup() && !this.GetSourceIsDir()) {
                    icoImage = this.GetPendingIcon();
                    break;
                }
                if (this.IsDelete()) {
                    icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DELETING_PNG.GetFileName());
                    break;
                }
                if (!this.GetHasListingForAllChildren()) {
                    icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_LISTING_PNG.GetFileName());
                    break;
                }
                if (this.IsUpload()) {
                    icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_UPLOADING_PNG.GetFileName());
                    break;
                }
                if (!this.IsDownload()) break;
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DOWNLOADING_PNG.GetFileName());
                break;
            }
            case CANCELLED: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_CANCELLED_PNG.GetFileName());
                break;
            }
            case SKIPPED: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_SKIPPED_PNG.GetFileName());
                break;
            }
            case DONE_GREEN: {
                icoImage = this.GetDoneIconGreen();
                break;
            }
            case DONE_YELLOW: {
                icoImage = this.GetDoneIconYellow();
                break;
            }
            case ERROR: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_ERROR_PNG.GetFileName());
                break;
            }
            case QUESTION: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_QUESTION_PNG.GetFileName());
                break;
            }
            case PAUSED: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PAUSED_PNG.GetFileName());
                break;
            }
            case WAITING: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_WAITING_PNG.GetFileName());
                break;
            }
            case STOPPED: {
                icoImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_STOPPED_PNG.GetFileName());
                break;
            }
        }
        return icoImage;
    }

    public boolean SetThreadStatus(STATUS nThreadStatus, boolean bRepaintRow) {
        return this.SetThreadStatus(nThreadStatus, bRepaintRow, true);
    }

    private boolean SetThreadStatus(STATUS nThreadStatus, boolean bRepaintRow, boolean bUpdateParentStatus) {
        boolean bChanged = false;
        if (this.m_nThreadStatus != nThreadStatus) {
            CTransferNode rParent;
            STATUS nPrevThreadStatus = this.m_nThreadStatus;
            this.m_nThreadStatus = nThreadStatus;
            if (this.m_nThreadStatus == STATUS.PENDING) {
                this.SetShowConfirmDlg(CConfirmDlg.TYPE.ERROR, true);
            }
            bChanged = true;
            if (this.GetModel() != null) {
                this.UpdateDynamicButtons(this.GetModel().GetRootNode(), nPrevThreadStatus, this.m_nThreadStatus);
            }
            if (this.m_nThreadStatus == STATUS.DONE_GREEN) {
                this.IncParentChildCountComplete(this.GetParent());
            } else if (nPrevThreadStatus == STATUS.DONE_GREEN) {
                this.DecParentChildCountComplete(this.GetParent());
            } else if (this.m_nThreadStatus == STATUS.STOPPED) {
                this.SetStop(true);
            } else if (nPrevThreadStatus == STATUS.STOPPED) {
                this.SetStop(false);
            }
            if (this.m_nThreadStatus == STATUS.PENDING || this.m_nThreadStatus == STATUS.QUESTION || this.m_nThreadStatus == STATUS.RUNNING || this.m_nThreadStatus == STATUS.ERROR) {
                this.AddPendingChild(this);
            } else {
                this.RemovePendingChild(this);
            }
            if (bUpdateParentStatus && (rParent = this.GetParent()) != null) {
                boolean bUpdate;
                boolean bl = bUpdate = !this.GetSourceIsDir() && !this.IsRoot() && !this.IsParentGroup();
                if (!bUpdate) {
                    if (!rParent.GetHasListingForAllChildren()) {
                        bUpdate = true;
                    } else if (this.GetSourceIsDir() && this.getChildCount() < 1) {
                        bUpdate = true;
                    }
                }
                if (bUpdate) {
                    this.UpdateParentStatus(rParent, true);
                }
            }
            if (bRepaintRow) {
                this.Repaint();
            }
        }
        return bChanged;
    }

    public STATUS GetThreadStatus() {
        return this.m_nThreadStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IncFileRead(long lNumOfBytes, boolean bRepaint) {
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            this.SetFileRead(this.GetFileRead() + lNumOfBytes, bRepaint);
            this.m_lFileReadAccumulated += lNumOfBytes;
            if (this.GetParent() != null) {
                this.GetParent().IncFileRead(lNumOfBytes, bRepaint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DecFileRead(long lNumOfBytes, boolean bRepaint, boolean bIsAutoRemove) {
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (!bIsAutoRemove) {
                this.SetFileRead(this.GetFileRead() - lNumOfBytes, bRepaint, bIsAutoRemove);
            }
            if (this.GetParent() != null) {
                this.GetParent().DecFileRead(lNumOfBytes, bRepaint, bIsAutoRemove);
            }
        }
    }

    public boolean SetFileRead(long lNumOfBytes, boolean bRepaint) {
        return this.SetFileRead(lNumOfBytes, bRepaint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SetFileRead(long lNumOfBytes, boolean bRepaint, boolean bIsAutoRemove) {
        boolean bChanged = false;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (this.m_lFileRead != lNumOfBytes && !this.IsRoot()) {
                CTransferNode rParent;
                this.m_lPrevFileRead = this.m_lFileRead;
                this.m_lFileRead = lNumOfBytes;
                bChanged = true;
                if (this.GetTransferMsg() != null) {
                    this.GetTransferMsg().SetFileRead(lNumOfBytes);
                }
                if (this.m_lFileRead == this.m_lFileTotal) {
                    if (DEBUG_FILE_READ) {
                        System.out.printf("%s has received all bytes.\r\n", this.GetDisplayText());
                    }
                } else if (this.m_lFileRead > this.m_lFileTotal && DEBUG) {
                    CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "File Read cannot be greater than File Total!");
                }
                if (!this.GetSourceIsDir() && !this.IsParentGroup() && (rParent = this.GetParent()) != null) {
                    if (this.m_lFileRead > this.m_lPrevFileRead) {
                        rParent.IncFileRead(this.m_lFileRead - this.m_lPrevFileRead, bRepaint);
                    } else {
                        rParent.DecFileRead(this.m_lPrevFileRead - this.m_lFileRead, bRepaint, bIsAutoRemove);
                    }
                }
                if (bRepaint) {
                    this.Repaint();
                }
            }
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long GetFileRead() {
        long lFileRead = 0L;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            lFileRead = this.m_lFileRead;
        }
        return lFileRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IncFileTotal(long lNumOfBytes, boolean bRepaint) {
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            this.SetFileTotal(this.GetFileTotal() + lNumOfBytes, bRepaint);
            if (this.GetParent() != null) {
                this.GetParent().IncFileTotal(lNumOfBytes, bRepaint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DecFileTotal(long lNumOfBytes, boolean bRepaint, boolean bIsAutoRemove) {
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (!bIsAutoRemove) {
                this.SetFileTotal(this.GetFileTotal() - lNumOfBytes, bRepaint, bIsAutoRemove);
            }
            if (this.GetParent() != null) {
                this.GetParent().DecFileTotal(lNumOfBytes, bRepaint, bIsAutoRemove);
            }
        }
    }

    public boolean SetFileTotal(long lNumOfBytes, boolean bRepaint) {
        return this.SetFileTotal(lNumOfBytes, bRepaint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SetFileTotal(long lNumOfBytes, boolean bRepaint, boolean bIsAutoRemove) {
        boolean bChanged = false;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (this.m_lFileTotal != lNumOfBytes && !this.IsRoot()) {
                CTransferNode rParent;
                long lPrevFileTotal = this.m_lFileTotal;
                this.m_lFileTotal = lNumOfBytes;
                bChanged = true;
                if (this.GetTransferMsg() != null) {
                    this.GetTransferMsg().SetFileTotal(lNumOfBytes);
                }
                if (!this.GetSourceIsDir() && !this.IsParentGroup() && (rParent = this.GetParent()) != null) {
                    if (this.m_lFileTotal > lPrevFileTotal) {
                        rParent.IncFileTotal(this.m_lFileTotal - lPrevFileTotal, bRepaint);
                    } else {
                        rParent.DecFileTotal(lPrevFileTotal - this.m_lFileTotal, bRepaint, bIsAutoRemove);
                    }
                }
                if (bRepaint) {
                    this.Repaint();
                }
            }
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long GetFileTotal() {
        long lFileTotal = 0L;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            lFileTotal = this.m_lFileTotal;
        }
        return lFileTotal;
    }

    private String FormatPercentDone(long lRead, long lTotal, boolean bShowAccumulated) {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (DEBUG_PERCENT_DONE_PRINT) {
            System.out.printf("%s -> %s of %s | Percent Done = %s\r\n", this.GetDisplayText(), lRead, lTotal, lTotal > 0L ? Float.toString((float)lRead * 100.0f / (float)lTotal) : "0");
        }
        if (DEBUG_PERCENT_DONE_SHOW_BYTES) {
            sRet = String.format("%s of %s", lRead, lTotal);
        } else if (lTotal > 0L) {
            String sTotal = CString.FormatNumOfBytesDouble(lTotal, true, 2);
            float fPercentDone = (float)lRead * 100.0f / (float)lTotal;
            String sPercentDone = CString.FormatFloat(fPercentDone, 2);
            sRet = bShowAccumulated ? String.format(CString.LoadString("IDS_FMT_PERCENT_DONE2"), sPercentDone, CString.FormatNumOfBytesDouble(lRead, true, 2), sTotal) : String.format(CString.LoadString("IDS_FMT_PERCENT_DONE"), sPercentDone, sTotal);
        } else if (lTotal == 0L && this.GetHasListing()) {
            String sTotal = CString.FormatNumOfBytesDouble(0L, true, 2);
            float fPercentDone = 0.0f;
            if (this.IsEmptyItemDone()) {
                fPercentDone = 100.0f;
            }
            String sPercentDone = CString.FormatFloat(fPercentDone, 2);
            sRet = bShowAccumulated ? String.format(CString.LoadString("IDS_FMT_PERCENT_DONE2"), sPercentDone, CString.FormatNumOfBytesDouble(lRead, true, 2), sTotal) : String.format(CString.LoadString("IDS_FMT_PERCENT_DONE"), sPercentDone, sTotal);
        }
        return sRet;
    }

    public String FormatStatusTxt() {
        boolean bShowAccumulated = true;
        return this.FormatPercentDone(this.GetFileRead(), this.GetFileTotal(), bShowAccumulated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String FormatCompletionTxt() {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (this.IsUpload() || this.IsDownload()) {
            long lFileTotal = this.GetFileTotal();
            long lFileRead = this.GetFileRead();
            long lRemainingBytes = lFileTotal - lFileRead;
            long lElapsedTime = this.GetElapsedTime();
            Object object = this.m_ParentStatsCrit;
            synchronized (object) {
                if (this.GetSourceIsDir() || this.IsParentGroup()) {
                    lFileRead = this.m_lFileReadAccumulated;
                    if (this.m_bIsRecording) {
                        lElapsedTime = this.m_lEndTimeOverall + (System.currentTimeMillis() - this.m_lResumeTime) - this.m_lStartTimeOverall;
                    }
                    if (DEBUG_STATS_PARENT) {
                        System.out.printf("(%s) | [IsRecording] = %s | [bytes total] = %d | [bytes read] = %d | [elapsed time] = %s\r\n", this.GetDisplayText(), Boolean.toString(this.m_bIsRecording), lFileTotal, lFileRead, this.FmtCompletionTime(lElapsedTime));
                    }
                }
            }
            long lBytesPerSec = CSUConnection.CalcBytesPerSecond(lElapsedTime, lFileRead);
            if (lRemainingBytes > 0L) {
                double dElapsedTime = 0.0;
                if (lBytesPerSec > 0L) {
                    dElapsedTime = (double)lRemainingBytes / (double)lBytesPerSec;
                }
                dElapsedTime = Math.ceil(dElapsedTime);
                lElapsedTime = (long)dElapsedTime * 1000L;
            } else {
                lElapsedTime = 0L;
            }
            if (lElapsedTime >= 0L && lBytesPerSec > 0L) {
                String sBytesPerSecond = this.FmtBytesPerSecond(lBytesPerSec);
                String sCompletionTime = this.FmtCompletionTime(lElapsedTime);
                sRet = String.format("%s (%s)", sCompletionTime, sBytesPerSecond);
            }
        } else if (this.IsDelete()) {
            sRet = "";
        }
        return sRet;
    }

    public ImageIcon GetPercentImage() {
        ImageIcon rIcoRet = null;
        rIcoRet = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_000_PNG.GetFileName());
        long lRead = this.GetFileRead();
        long lTotal = this.GetFileTotal();
        rIcoRet = !this.GetHasListing() ? CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_000_PNG.GetFileName()) : (this.IsEmptyItemDone() ? CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_100_PNG.GetFileName()) : CRhinoApp.GetPercentImage(lRead, lTotal));
        return rIcoRet;
    }

    private boolean IsEmptyItemDone() {
        boolean bIsEmptyDone = false;
        if (this.GetHasListing() && this.GetThreadStatus() == STATUS.DONE_GREEN) {
            long lTotal = this.GetFileTotal();
            if (this.IsParentGroup()) {
                if (this.GetHasListingForAllChildren() && lTotal == 0L) {
                    bIsEmptyDone = true;
                }
            } else if (this.GetHasListingForTarget() && lTotal == 0L) {
                bIsEmptyDone = true;
            }
        }
        return bIsEmptyDone;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 2102: {
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Status waiting...");
                    break;
                }
                case 4266: {
                    CTransferStatsMsg rStatsMsg = (CTransferStatsMsg)rMsg;
                    this.OnUpdateStats(rStatsMsg);
                    break;
                }
                default: {
                    super.OnMessage(rMsg);
                }
            }
        }
    }

    private String FmtBytesPerSecond(long lBytesPerSec) {
        return CString.FormatBytesPerSecond(lBytesPerSec, 2);
    }

    private String FmtCompletionTime(long lElapsedTimeInMillis) {
        String sCompletionTime = "00:00:00";
        if (lElapsedTimeInMillis > 0L) {
            long lHours = lElapsedTimeInMillis / 3600000L;
            long lMins = lElapsedTimeInMillis / 60000L % 60L;
            long lSecs = lElapsedTimeInMillis / 1000L % 60L;
            sCompletionTime = String.format("%02d:%02d:%02d", lHours, lMins, lSecs);
        }
        return sCompletionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OnUpdateStats(CTransferStatsMsg rStatsMsg) {
        if (DEBUG_ELAPSED_ENDED) {
            DEBUG_ELAPSED = false;
        }
        if (rStatsMsg != null) {
            long lNumOfBytesRead = rStatsMsg.GetFileRead();
            long lNumOfBytesTotal = rStatsMsg.GetFileTotal();
            long lStartPos = rStatsMsg.GetStartPos();
            long lStartTime = rStatsMsg.GetStartTime();
            long lEndTime = rStatsMsg.GetEndTime();
            switch (rStatsMsg.GetState()) {
                case STARTED: {
                    if (DEBUG_STAT_MSGS) {
                        DateFormat df = DateFormat.getTimeInstance(1);
                        String sDt = df.format(lStartTime);
                        System.out.printf("\r\nOnUpdateStats - (%d) STARTED_STREAM | StartTime: %d (%s) | StartPos: %d\r\n", Thread.currentThread().getId(), lStartTime, sDt, lStartPos);
                    }
                    if (DEBUG && this.GetFileTotal() != lNumOfBytesTotal) {
                        CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "The file size doesn't match the number of bytes expected - they really should match!");
                    }
                    if (lStartPos < 1L) {
                        this.SetStartTimeOverall(lStartTime);
                    } else {
                        this.SetStartTimePerCycle(lStartTime);
                    }
                    if (this.GetParent() == null) break;
                    this.GetParent().StartRecording();
                    break;
                }
                case PROCESSING: {
                    this.SetFileRead(lNumOfBytesRead, true);
                    this.SetEndTimePerCycle(lEndTime);
                    this.TrackStats("PROCESSING", lNumOfBytesRead, lNumOfBytesTotal);
                    break;
                }
                case ENDED: {
                    if (DEBUG_ELAPSED_ENDED) {
                        DEBUG_ELAPSED = true;
                    }
                    this.SetFileRead(lNumOfBytesRead, true);
                    this.SetEndTimePerCycle(lEndTime);
                    Object df = this.m_ParentStatsCrit;
                    synchronized (df) {
                        this.m_lEndTimeOverallMarker = this.m_lEndTimeOverall;
                    }
                    this.TrackStats("ENDED", lNumOfBytesRead, lNumOfBytesTotal);
                    if (DEBUG_STAT_MSGS) {
                        df = DateFormat.getTimeInstance(1);
                        String sDt = ((Format)df).format(lEndTime);
                        System.out.printf("OnUpdateStats - (%d) ENDED_STREAM | EndTime: %d (%s) | EndPos: %d\r\n", Thread.currentThread().getId(), lEndTime, sDt, lNumOfBytesRead);
                    }
                    if (this.GetParent() == null) break;
                    this.GetParent().StopRecording();
                    break;
                }
                default: {
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, unexpected case.");
                }
            }
        }
    }

    private void TrackStats(String sSection, long lNumOfBytesRead, long lNumOfBytesTotal) {
        if (DEBUG_TRACK_BYTES_PER_SEC && sSection != null) {
            long lElapsedTime = this.GetElapsedTime();
            System.out.printf("%s (%d) -->\r\n", sSection, Thread.currentThread().getId());
            System.out.printf("     [elapsed time] = %d\r\n", lElapsedTime);
            System.out.printf("     Total => [number of bytes] = %d\r\n", lNumOfBytesTotal);
            long lBytesPerSec = CSUConnection.CalcBytesPerSecond(lElapsedTime, lNumOfBytesRead);
            System.out.printf("     [bytes per second] = %s\r\n", this.FmtBytesPerSecond(lBytesPerSec));
            System.out.printf("     Read => [number of bytes] = %d | [completed in] = %s\r\n", lNumOfBytesRead, this.FmtCompletionTime(lElapsedTime));
            long lRemainingBytes = lNumOfBytesTotal - lNumOfBytesRead;
            double dETA = 0.0;
            if (lBytesPerSec > 0L) {
                dETA = lRemainingBytes / lBytesPerSec;
            }
            dETA = Math.ceil(dETA);
            long lProjectedElapsedTime = (long)dETA * 1000L;
            System.out.printf("     Remaining => [number of bytes] = %d | [eta] = %s\r\n", lRemainingBytes, this.FmtCompletionTime(lProjectedElapsedTime));
            System.out.printf("%s <--\r\n", sSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetStartTimeOverall(long lTimestamp) {
        boolean bChanged = false;
        this.SetStartTimePerCycle(lTimestamp);
        this.SetEndTimePerCycle(0L);
        this.SetElapsedTime(0L);
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (this.m_lStartTimeOverall != lTimestamp) {
                this.m_lStartTimeOverall = lTimestamp;
                this.m_lEndTimeOverallMarker = lTimestamp;
                this.SetEndTimeOverall(lTimestamp);
                bChanged = true;
                if (DEBUG_STAT_MSGS_RATE) {
                    System.out.println("SetStartTimeOverall: " + lTimestamp);
                }
            }
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void StartRecording() {
        if (!this.IsRoot()) {
            Object object = this.m_ParentStatsCrit;
            synchronized (object) {
                if (this.GetFileRead() == 0L) {
                    this.m_lStartTimeOverall = System.currentTimeMillis();
                    this.SetEndTimeOverall(this.m_lStartTimeOverall);
                    this.m_lResumeTime = this.m_lStartTimeOverall;
                    for (CTransferNode rNode = this; rNode != null && !rNode.IsRoot(); rNode = rNode.GetParent()) {
                        rNode.m_lFileReadAccumulated = 0L;
                    }
                    if (DEBUG_STATS_PARENT) {
                        System.out.printf("StartRecording (%s)\r\n", this.GetDisplayText());
                    }
                } else if (!this.m_bIsRecording) {
                    this.m_lResumeTime = System.currentTimeMillis();
                    if (DEBUG_STATS_PARENT) {
                        System.out.printf("StartRecording (%s)\r\n", this.GetDisplayText());
                    }
                }
                this.m_bIsRecording = true;
                if (this.GetParent() != null) {
                    this.GetParent().StartRecording();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void StopRecording() {
        if (!this.IsRoot()) {
            Object object = this.m_ParentStatsCrit;
            synchronized (object) {
                boolean bHasMoreItems;
                int nChildCountPending = this.GetChildCountPending();
                boolean bl = bHasMoreItems = nChildCountPending > 1;
                if (this.m_bIsRecording && !bHasMoreItems) {
                    this.SetEndTimeOverall(this.m_lEndTimeOverall + (System.currentTimeMillis() - this.m_lResumeTime));
                    this.m_lResumeTime = 0L;
                    if (DEBUG_STATS_PARENT) {
                        System.out.printf("StopRecording (%s) | [elapsed] = %s\r\n", this.GetDisplayText(), this.FmtCompletionTime(this.m_lEndTimeOverall - this.m_lStartTimeOverall));
                    }
                    this.m_bIsRecording = false;
                }
                if (this.GetParent() != null) {
                    this.GetParent().StopRecording();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long GetElapsedTime() {
        long lElapsedTime = 0L;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            lElapsedTime = this.m_lElapsedTime;
        }
        return lElapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SetElapsedTime(long lElapsedTime) {
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            this.m_lElapsedTime = lElapsedTime;
        }
    }

    private void InitElapsedTime() {
        this.SetElapsedTime(this.m_lEndTimeOverall - this.m_lStartTimeOverall);
    }

    private boolean SetStartTimePerCycle(long lTimestamp) {
        boolean bChanged = false;
        if (this.m_lStartTimePerCycle != lTimestamp) {
            this.m_lStartTimePerCycle = lTimestamp;
            bChanged = true;
            if (DEBUG_STAT_MSGS_RATE) {
                System.out.println("SetStartTimePerCycle: " + lTimestamp);
            }
        }
        return bChanged;
    }

    private boolean SetEndTimePerCycle(long lTimestamp) {
        boolean bChanged = false;
        if (this.m_lEndTimePerCycle != lTimestamp) {
            this.m_lEndTimePerCycle = lTimestamp;
            bChanged = true;
            if (DEBUG_STAT_MSGS_RATE) {
                System.out.println("SetEndTimePerCycle: " + lTimestamp);
            }
            if (this.m_lEndTimePerCycle >= this.m_lStartTimePerCycle) {
                long lElapsedTimePerCycle = this.m_lEndTimePerCycle - this.m_lStartTimePerCycle;
                this.SetElapsedTimePerCycle(lElapsedTimePerCycle);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, how did the times get messed up?");
            }
        }
        return bChanged;
    }

    private boolean SetElapsedTimePerCycle(long lElapsedTime) {
        boolean bChanged = false;
        if (this.m_lElapsedTimePerCycle != lElapsedTime) {
            this.m_lElapsedTimePerCycle = lElapsedTime;
            bChanged = true;
            long lEndTimeOverall = this.m_lEndTimeOverallMarker + this.m_lElapsedTimePerCycle;
            this.SetEndTimeOverall(lEndTimeOverall);
            if (DEBUG_ELAPSED) {
                System.out.printf("(%d) Elapsed Time (per cycle):  %d millis | %d seconds\r\n", Thread.currentThread().getId(), this.m_lElapsedTimePerCycle, this.m_lElapsedTimePerCycle / 1000L);
            }
        }
        return bChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetEndTimeOverall(long lTimestamp) {
        boolean bChanged = false;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (this.m_lEndTimeOverall != lTimestamp) {
                bChanged = true;
                this.m_lEndTimeOverall = lTimestamp;
                this.InitElapsedTime();
                if (DEBUG_ELAPSED) {
                    long lElapsedTime = this.m_lEndTimeOverall - this.m_lStartTimeOverall;
                    System.out.printf("(%d) Elapsed Time (overall):  %d millis | %d seconds\r\n", Thread.currentThread().getId(), lElapsedTime, lElapsedTime / 1000L);
                }
            }
        }
        return bChanged;
    }

    @Override
    public CTransferNode GetParent() {
        CTransferNode rParent = null;
        CFileTreeNode rTemp = super.GetParent();
        if (rTemp instanceof CTransferNode) {
            rParent = (CTransferNode)rTemp;
        }
        return rParent;
    }

    public CTransferNodeParentGroup GetParentGroup() {
        CTransferNodeParentGroup rParentGroup = null;
        if (this.IsParentGroup()) {
            rParentGroup = (CTransferNodeParentGroup)this;
        }
        if (rParentGroup == null) {
            for (CTransferNode rParent = this.GetParent(); rParent != null && rParentGroup == null; rParent = rParent.GetParent()) {
                if (!rParent.IsParentGroup()) continue;
                rParentGroup = (CTransferNodeParentGroup)rParent;
            }
        }
        return rParentGroup;
    }

    private void AddChildAsTransfer(CTransferNode rParent, CTransferNode rChildTransferNode) {
        if (rParent != null) {
            rParent.AddChildTransfer(rChildTransferNode);
            this.AddChildAsTransfer(rParent.GetParent(), rChildTransferNode);
        } else if (DEBUG_ADD_CHILD_AS_XFER) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error: Invalid args.");
        }
    }

    private void RemoveChildAsTransfer(CTransferNode rParent, CTransferNode rChildTransferNode) {
        if (rParent != null) {
            rParent.RemoveChildTransfer(rChildTransferNode);
            this.RemoveChildAsTransfer(rParent.GetParent(), rChildTransferNode);
        } else if (DEBUG_REMOVE_CHILD) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error: Invalid args.");
        }
    }

    private void AddChildTransfer(CTransferNode rNode) {
        this.m_aActiveChildTransfers.add(rNode);
    }

    private void RemoveChildTransfer(CTransferNode rNode) {
        this.m_aActiveChildTransfers.remove(rNode);
    }

    private void Repaint() {
        if (this.GetModel() != null) {
            if (CTransferTreeTableModel.DEBUG_REPAINT_IMMEDIATELY) {
                this.GetModel().RepaintRow(this);
            }
            this.GetModel().StartRefreshTimer();
        }
    }

    public CTransferTreeTableModel GetModel() {
        return this.m_rTransferTreeTableModel;
    }

    protected int GetActiveChildCount() {
        return this.m_aActiveChildTransfers.size();
    }

    public void SetHasListingForTarget(boolean bHasListing) {
        CSUSourceMsg rMsg;
        boolean bPrevHasListingForTarget = this.m_bHasListingForTarget;
        this.m_bHasListingForTarget = bHasListing;
        if (!bHasListing && (rMsg = this.GetTransferMsg()) != null && rMsg instanceof CTransferMsg) {
            ((CTransferMsg)rMsg).ResetTarget();
        }
    }

    public boolean GetHasListingForTarget() {
        return this.m_bHasListingForTarget;
    }

    public void SetHasListing(boolean bHasListing) {
        boolean bPrevHasListing = this.m_bHasListing;
        this.m_bHasListing = bHasListing;
        if (bHasListing) {
            if (!bPrevHasListing) {
                this.IncParentChildCountListed(this.GetParent(), this.GetSourceIsDir());
            }
        } else {
            this.SetHasListingForTarget(false);
            if (bPrevHasListing) {
                this.DecParentChildCountListed(this.GetParent(), this.GetSourceIsDir());
            }
            if (this.GetTransferMsg() != null) {
                this.GetTransferMsg().Reset();
            }
        }
        if (this.GetSource() != null) {
            this.GetSource().SetHasListing(bHasListing);
        }
    }

    public boolean GetHasListing() {
        return this.m_bHasListing;
    }

    private void IncChildCountTotal(boolean bIsDir) {
        if (!this.IsRoot()) {
            ++this.m_nChildCountTotal;
            if (bIsDir) {
                ++this.m_nChildCountDirs;
            } else {
                ++this.m_nChildCountFiles;
            }
        }
    }

    public void IncParentChildCountTotal(CTransferNode rParent, boolean bIsDir) {
        if (rParent != null) {
            rParent.IncChildCountTotal(bIsDir);
            if (rParent.GetParent() != null) {
                this.IncParentChildCountTotal(rParent.GetParent(), bIsDir);
            }
        } else if (DEBUG_PARENT_CHILD_COUNT_TOTAL) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error: Invalid args.");
        }
    }

    private void DecChildCountTotal(boolean bIsDir) {
        if (!this.IsRoot()) {
            --this.m_nChildCountTotal;
            if (bIsDir) {
                --this.m_nChildCountDirs;
            } else {
                --this.m_nChildCountFiles;
            }
        }
    }

    public void DecParentChildCountTotal(CTransferNode rParent, boolean bIsDir) {
        if (rParent != null) {
            rParent.DecChildCountTotal(bIsDir);
            if (rParent.GetParent() != null) {
                this.DecParentChildCountTotal(rParent.GetParent(), bIsDir);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error: Invalid args.");
        }
    }

    public int GetChildCountTotal() {
        return this.m_nChildCountTotal;
    }

    public int GetChildCountDirs() {
        return this.m_nChildCountDirs;
    }

    public int GetChildCountFiles() {
        return this.m_nChildCountFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetChildCountPending() {
        int nPending = 0;
        Object object = this.m_ParentStatsCrit;
        synchronized (object) {
            if (this.m_aPendingChildren != null) {
                nPending = this.m_aPendingChildren.size();
            }
        }
        return nPending;
    }

    public int GetChildCountComplete() {
        return this.m_nChildCountComplete;
    }

    public int GetChildCountListed() {
        return this.m_nChildCountListed;
    }

    public int GetChildCountListedDir() {
        return this.m_nChildCountListedDir;
    }

    private void IncChildCountListed(boolean bIsDir) {
        if (!this.IsRoot()) {
            ++this.m_nChildCountListed;
            if (bIsDir) {
                ++this.m_nChildCountListedDir;
            }
        }
    }

    private void IncParentChildCountListed(CTransferNode rParent, boolean bIsDir) {
        if (rParent != null) {
            rParent.IncChildCountListed(bIsDir);
            if (rParent.GetParent() != null) {
                this.IncParentChildCountListed(rParent.GetParent(), bIsDir);
            }
        }
    }

    private void DecChildCountListed(boolean bIsDir) {
        if (!this.IsRoot()) {
            --this.m_nChildCountListed;
            if (bIsDir) {
                --this.m_nChildCountListedDir;
            }
        }
    }

    private void DecParentChildCountListed(CTransferNode rParent, boolean bIsDir) {
        if (rParent != null) {
            rParent.DecChildCountListed(bIsDir);
            if (rParent.GetParent() != null) {
                this.DecParentChildCountListed(rParent.GetParent(), bIsDir);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error: Invalid args.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddPendingChild(CTransferNode rChildNode) {
        if (rChildNode != null && !rChildNode.IsParentGroup()) {
            Object object = this.m_ParentStatsCrit;
            synchronized (object) {
                if (!this.IsRoot()) {
                    if (!this.m_aPendingChildren.contains(rChildNode)) {
                        this.m_aPendingChildren.add(rChildNode);
                    }
                    if (rChildNode.GetParent() != null) {
                        this.GetParent().AddPendingChild(rChildNode);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RemovePendingChild(CTransferNode rChildNode) {
        if (rChildNode != null) {
            Object object = this.m_ParentStatsCrit;
            synchronized (object) {
                if (!this.IsRoot()) {
                    if (this.m_aPendingChildren.contains(rChildNode)) {
                        this.m_aPendingChildren.remove(rChildNode);
                    }
                    if (rChildNode.GetParent() != null) {
                        this.GetParent().RemovePendingChild(rChildNode);
                    }
                }
            }
        }
    }

    private void IncChildCountComplete() {
        if (!this.IsRoot()) {
            ++this.m_nChildCountComplete;
        }
    }

    private void IncParentChildCountComplete(CTransferNode rParent) {
        if (rParent != null) {
            rParent.IncChildCountComplete();
            if (rParent.GetParent() != null) {
                this.IncParentChildCountComplete(rParent.GetParent());
            }
        }
    }

    private void DecChildCountComplete() {
        if (!this.IsRoot()) {
            --this.m_nChildCountComplete;
        }
    }

    private void DecParentChildCountComplete(CTransferNode rParent) {
        if (rParent != null) {
            rParent.DecChildCountComplete();
            if (rParent.GetParent() != null) {
                this.DecParentChildCountComplete(rParent.GetParent());
            }
        }
    }

    protected ImageIcon GetPendingIcon() {
        ImageIcon rImage = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PENDING_PNG.GetFileName());
        return rImage;
    }

    public ImageIcon GetDoneIconGreen() {
        return CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DONE_GREEN_PNG.GetFileName());
    }

    public ImageIcon GetDoneIconYellow() {
        return CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DONE_YELLOW_PNG.GetFileName());
    }

    public boolean GetUserWantsConfirmDlg(CConfirmDlg.TYPE nDlgType) {
        boolean bUserWantsConfirmation = true;
        if (this.GetParentGroup() != null) {
            bUserWantsConfirmation = this.GetParentGroup().GetShowConfirmDlg(nDlgType);
        }
        if (!bUserWantsConfirmation) {
            bUserWantsConfirmation = this.GetShowConfirmDlg(nDlgType);
        }
        if (!this.GetGlobalShowConfirmDlg()) {
            bUserWantsConfirmation = false;
        }
        if (nDlgType == CConfirmDlg.TYPE.ERROR) {
            bUserWantsConfirmation = this.GetShowConfirmDlg(CConfirmDlg.TYPE.ERROR);
        }
        return bUserWantsConfirmation;
    }

    public int GetUserConfirmDlgResult(CConfirmDlg.TYPE nDlgType) {
        int nUserConfirmationResult = -5;
        if (this.GetParentGroup() != null) {
            nUserConfirmationResult = this.GetParentGroup().GetConfirmDlgResult(nDlgType);
        }
        if (nUserConfirmationResult == -5) {
            nUserConfirmationResult = this.GetConfirmDlgResult(nDlgType);
        }
        if (!this.GetGlobalShowConfirmDlg()) {
            nUserConfirmationResult = this.GetGlobalConfirmDlgResult();
        }
        if (nDlgType == CConfirmDlg.TYPE.ERROR) {
            nUserConfirmationResult = this.GetConfirmDlgResult(CConfirmDlg.TYPE.ERROR);
        }
        return nUserConfirmationResult;
    }

    protected CSUSourceMsg CreateTransferMsg(CConnectionAttrs rConnInfo) {
        return null;
    }

    public CSUSourceMsg InitTransferMsg(CConnectionAttrs rConnInfo) {
        if (this.GetTransferMsg() == null && rConnInfo != null) {
            this.SetTransferMsg(this.CreateTransferMsg(rConnInfo));
        } else if (DEBUG_INIT_XFER_MSG) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.  Note: This could be our root!");
        }
        CSUSourceMsg rTransferMsg = this.GetTransferMsg();
        if (rTransferMsg != null) {
            if (this.IsUpload()) {
                rTransferMsg.SetMsgID(4225);
            } else if (this.IsDownload()) {
                rTransferMsg.SetMsgID(4227);
            } else if (this.IsDelete()) {
                rTransferMsg.SetMsgID(4223);
            }
            rTransferMsg.SetCancel(false);
            boolean bUserWantsConfirmation = this.GetUserWantsConfirmDlg(rTransferMsg.GetConfirmDlgType());
            if (!this.GetDontAutoSetUserConfirmations()) {
                rTransferMsg.SetUserWantsConfirmDlg(bUserWantsConfirmation);
            }
            int nUserConfirmDlgResult = this.GetUserConfirmDlgResult(rTransferMsg.GetConfirmDlgType());
            if (!this.GetDontAutoSetUserConfirmations()) {
                rTransferMsg.SetUserConfirmDlgResult(nUserConfirmDlgResult);
            }
            this.SetDontAutoSetUserConfirmations(false);
            rTransferMsg.SetHost(rConnInfo.GetHost());
            rTransferMsg.SetServerPort(rConnInfo.GetServerPort());
            rTransferMsg.SetHeaderPort(rConnInfo.GetHeaderPort());
            rTransferMsg.SetUserAgent(rConnInfo.GetUserAgent());
            rTransferMsg.SetEncSessionID(rConnInfo.GetEncSessionID());
            rTransferMsg.SetUISourceAttrID(this.GetAttrID());
            rTransferMsg.SetSourcePath(this.GetSourcePath());
            rTransferMsg.SetSourceIsDir(this.GetSourceIsDir());
            if (this.GetHasListing() && this.GetSource() != null && !this.GetSource().IsDirectory() && !this.GetSource().IsDrive() && this.GetSource().HasListing()) {
                rTransferMsg.SetSource(this.GetSource());
            }
        }
        return rTransferMsg;
    }

    protected void SetTransferMsg(CSUSourceMsg rTransferMsg) {
        if (this.m_TransferMsg != rTransferMsg) {
            if (this.m_TransferMsg != null) {
                this.m_TransferMsg.Destroy();
            }
            this.m_TransferMsg = rTransferMsg;
        }
    }

    public CSUSourceMsg GetTransferMsg() {
        return this.m_TransferMsg;
    }

    public String FmtProcessingSourcePaths() {
        String sRet = "";
        String sNextPath = "";
        Iterator<CTransferNode> itr = this.m_aActiveChildTransfers.iterator();
        while (itr.hasNext()) {
            CTransferNode rNode = itr.next();
            if (rNode == null) continue;
            sNextPath = rNode.GetSourcePath();
            if (sNextPath != null) {
                sRet = sRet + sNextPath;
            } else if (DEBUG) {
                CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, why is rNode.GetSourcePath null?");
            }
            if (!itr.hasNext()) continue;
            sRet = sRet + ";";
        }
        return sRet;
    }

    public String FmtProcessingTargetPaths() {
        String sRet = "";
        if (this.IsUpload() || this.IsDownload()) {
            Iterator<CTransferNode> itr = this.m_aActiveChildTransfers.iterator();
            while (itr.hasNext()) {
                CTransferNode rNode = itr.next();
                if (rNode == null) continue;
                sRet = sRet + rNode.GetTargetPath();
                if (!itr.hasNext()) continue;
                sRet = sRet + ";";
            }
        }
        return sRet;
    }

    public String FmtProcessingThreads() {
        String sRet = "";
        Iterator<CTransferNode> itr = this.m_aActiveChildTransfers.iterator();
        while (itr.hasNext()) {
            CTransferNode rNode = itr.next();
            if (rNode == null || rNode.GetTransferThread() == null) continue;
            sRet = sRet + Long.toString(rNode.GetTransferThread().GetUniqueID());
            if (!itr.hasNext()) continue;
            sRet = sRet + ";";
        }
        return sRet;
    }

    protected void SetStop(boolean bStop) {
        this.m_bStop = bStop;
    }

    public boolean GetStop() {
        return this.m_bStop;
    }

    public void SetVisible_DoNotAskAgain(boolean bShowDoNotAskAgain) {
        if (this.GetTransferMsg() != null) {
            this.GetTransferMsg().SetVisible_DoNotAskAgain(bShowDoNotAskAgain);
        }
    }

    public boolean GetHasListingForAllChildren() {
        boolean bHasListingForAllChildren = false;
        if (this.GetHasListing()) {
            if (this.GetChildCountListed() == this.GetChildCountTotal()) {
                bHasListingForAllChildren = true;
                if (this.GetSourceIsDir() && !this.IsRoot() && !this.IsParentGroup() && !this.GetHasListingForTarget()) {
                    bHasListingForAllChildren = false;
                }
            } else if (DEBUG && this.GetChildCountListed() > this.GetChildCountTotal()) {
                CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  ChildCountListed is greater than ChildCountTotal.");
            }
        }
        return bHasListingForAllChildren;
    }

    public boolean GetShowDoNotAskAgain() {
        boolean bShowDoNotAskAgain;
        boolean bl = bShowDoNotAskAgain = this.getChildCount() > 1;
        if (!bShowDoNotAskAgain && !this.IsDelete()) {
            for (int nIdx = 0; nIdx < this.getChildCount() && !bShowDoNotAskAgain; ++nIdx) {
                CTransferNode rChild = (CTransferNode)this.getChildAt(nIdx);
                if (rChild == null || !rChild.GetSourceIsDir()) continue;
                bShowDoNotAskAgain = true;
            }
        }
        return bShowDoNotAskAgain;
    }

    public boolean GetGlobalShowConfirmDlg() {
        boolean bRet = true;
        switch (this.GetType()) {
            case DELETE: {
                if (this.GetSourceIsDir()) {
                    bRet = this.GetShowConfirmDlg_DeleteFolder_Global();
                    break;
                }
                bRet = this.GetShowConfirmDlg_DeleteFile_Global();
                break;
            }
            case DOWNLOAD: {
                if (this.GetSourceIsDir()) {
                    bRet = this.GetShowConfirmDlg_DownloadFolder_Global();
                    break;
                }
                bRet = this.GetShowConfirmDlg_DownloadFile_Global();
                break;
            }
            case UPLOAD: {
                if (this.GetSourceIsDir()) {
                    bRet = this.GetShowConfirmDlg_UploadFolder_Global();
                    break;
                }
                bRet = this.GetShowConfirmDlg_UploadFile_Global();
                break;
            }
        }
        return bRet;
    }

    public int GetGlobalConfirmDlgResult() {
        int nRet = 2;
        switch (this.GetType()) {
            case DELETE: {
                if (this.GetSourceIsDir()) {
                    nRet = this.GetConfirmDlgResult_DeleteFolder_Global();
                    break;
                }
                nRet = this.GetConfirmDlgResult_DeleteFile_Global();
                break;
            }
            case DOWNLOAD: {
                if (this.GetSourceIsDir()) {
                    nRet = this.GetConfirmDlgResult_DownloadFolder_Global();
                    break;
                }
                nRet = this.GetConfirmDlgResult_DownloadFile_Global();
                break;
            }
            case UPLOAD: {
                if (this.GetSourceIsDir()) {
                    nRet = this.GetConfirmDlgResult_UploadFolder_Global();
                    break;
                }
                nRet = this.GetConfirmDlgResult_UploadFile_Global();
                break;
            }
        }
        return nRet;
    }

    protected void InitGlobalAttrs() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.m_rbConfirmUploadFileOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmUploadFileOverwrites();
            this.m_rnOptionUploadFileOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_OptionUploadFileOverwrites();
            this.m_rbConfirmDownloadFileOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmDownloadFileOverwrites();
            this.m_rnOptionDownloadFileOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_OptionDownloadFileOverwrites();
            this.m_rbConfirmUploadFolderOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmUploadFolderOverwrites();
            this.m_rnOptionUploadFolderOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_OptionUploadFolderOverwrites();
            this.m_rbConfirmDownloadFolderOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmDownloadFolderOverwrites();
            this.m_rnOptionDownloadFolderOverwrites = CRhinoApp.GET_RHINO_APP().GetAttr_OptionDownloadFolderOverwrites();
            this.m_rbConfirmFileDeletes = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmFileDeletes();
            this.m_rbConfirmFolderDeletes = CRhinoApp.GET_RHINO_APP().GetAttr_ConfirmFolderDeletes();
        }
    }

    public boolean GetShowConfirmDlg_DeleteFolder_Global() {
        return this.m_rbConfirmFolderDeletes.GetValue();
    }

    public boolean GetShowConfirmDlg_DeleteFile_Global() {
        return this.m_rbConfirmFileDeletes.GetValue();
    }

    public boolean GetShowConfirmDlg_UploadFile_Global() {
        return this.m_rbConfirmUploadFileOverwrites.GetValue();
    }

    public boolean GetShowConfirmDlg_DownloadFile_Global() {
        return this.m_rbConfirmDownloadFileOverwrites.GetValue();
    }

    public boolean GetShowConfirmDlg_UploadFolder_Global() {
        return this.m_rbConfirmUploadFolderOverwrites.GetValue();
    }

    public boolean GetShowConfirmDlg_DownloadFolder_Global() {
        return this.m_rbConfirmDownloadFolderOverwrites.GetValue();
    }

    public int GetConfirmDlgResult_DeleteFolder_Global() {
        return 0;
    }

    public int GetConfirmDlgResult_DeleteFile_Global() {
        return 0;
    }

    public int GetConfirmDlgResult_UploadFolder_Global() {
        return this.m_rnOptionUploadFolderOverwrites.GetValueInt();
    }

    public int GetConfirmDlgResult_UploadFile_Global() {
        return this.m_rnOptionUploadFileOverwrites.GetValueInt();
    }

    public int GetConfirmDlgResult_DownloadFolder_Global() {
        return this.m_rnOptionDownloadFolderOverwrites.GetValueInt();
    }

    public int GetConfirmDlgResult_DownloadFile_Global() {
        return this.m_rnOptionDownloadFileOverwrites.GetValueInt();
    }

    protected void OnTransferStart(CTransferNode rNextNode) {
        if (rNextNode != null) {
            if (rNextNode.IsParentGroup()) {
                if (rNextNode.getChildCount() > 0) {
                    for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                        CTransferNode rChild = (CTransferNode)rNextNode.getChildAt(nIdx);
                        this.OnTransferStart(rChild);
                    }
                }
            } else {
                if (rNextNode.getChildCount() > 0) {
                    for (int nIdx = rNextNode.getChildCount() - 1; nIdx >= 0; --nIdx) {
                        TreeNode rChild = rNextNode.getChildAt(nIdx);
                        if (!(rChild instanceof CTransferNode)) continue;
                        CTransferNode rChildXfer = (CTransferNode)rChild;
                        this.OnTransferStart(rChildXfer);
                    }
                }
                if (rNextNode.GetThreadStatus() != STATUS.QUESTION && rNextNode.GetThreadStatus() != STATUS.RUNNING) {
                    if (rNextNode.GetFileRead() == rNextNode.GetFileTotal()) {
                        rNextNode.SetFileRead(0L, true);
                    }
                    rNextNode.SetIsResume(false);
                    if (!rNextNode.GetSourceIsDir()) {
                        rNextNode.SetHasListingForTarget(false);
                        rNextNode.SetIsManualStart(true);
                        String sTargetDir = CString.GetParentPath(rNextNode.GetTargetPath(), true);
                        String sTargetName = CString.GetFileName(rNextNode.GetSourcePath());
                        rNextNode.SetTarget(sTargetDir + sTargetName);
                        rNextNode.CheckResetShowConfirmDlg();
                        rNextNode.SetThreadStatus(STATUS.PENDING, true);
                    } else if (!rNextNode.GetHasListing() || !rNextNode.GetHasListingForTarget()) {
                        rNextNode.SetThreadStatus(STATUS.PENDING, true);
                    } else if (rNextNode.GetHasListingForTarget() && rNextNode.GetChildCountTotal() < 1) {
                        rNextNode.SetHasListingForTarget(false);
                        rNextNode.SetThreadStatus(STATUS.PENDING, true);
                    }
                }
            }
        }
    }

    public void OnTransferStart() {
        this.OnTransferStart(this);
    }

    protected void OnTransferRestart(CTransferNode rNextNode, boolean bStartedAtParentGroup) {
        if (rNextNode != null) {
            rNextNode.ResetShowConfirmDlgs(true);
            if (rNextNode.IsParentGroup()) {
                if (rNextNode.getChildCount() > 0) {
                    if (rNextNode.GetChildCountDirs() < 1) {
                        bStartedAtParentGroup = false;
                    }
                    for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                        CTransferNode rChild = (CTransferNode)rNextNode.getChildAt(nIdx);
                        this.OnTransferRestart(rChild, bStartedAtParentGroup);
                    }
                }
            } else {
                if (rNextNode.getChildCount() > 0) {
                    for (int nIdx = rNextNode.getChildCount() - 1; nIdx >= 0; --nIdx) {
                        TreeNode rChild = rNextNode.getChildAt(nIdx);
                        if (!(rChild instanceof CTransferNode)) continue;
                        CTransferNode rChildXfer = (CTransferNode)rChild;
                        this.OnTransferRestart(rChildXfer, bStartedAtParentGroup);
                        rChildXfer.Remove(rNextNode);
                    }
                }
                if (rNextNode.GetThreadStatus() != STATUS.QUESTION && rNextNode.GetThreadStatus() != STATUS.RUNNING) {
                    String sTargetDir = CString.GetParentPath(rNextNode.GetTargetPath(), true);
                    String sTargetName = CString.GetFileName(rNextNode.GetSourcePath());
                    rNextNode.SetHasListing(false);
                    rNextNode.SetIsResume(false);
                    boolean bStartAfterSourceListing = true;
                    if (this.GetModel() != null && !this.GetModel().GetAutoStartNewTransfers()) {
                        bStartAfterSourceListing = false;
                    }
                    rNextNode.SetIsManualStart(bStartAfterSourceListing);
                    rNextNode.SetFileRead(0L, true);
                    rNextNode.SetFileTotal(0L, true);
                    rNextNode.SetTarget(sTargetDir + sTargetName);
                    STATUS nStatus = STATUS.PENDING;
                    rNextNode.SetThreadStatus(nStatus, false);
                }
            }
        }
    }

    public void OnTransferRestart() {
        this.OnTransferRestart(this, this.IsParentGroup());
    }

    protected void OnTransferPause(CTransferNode rNextNode) {
        if (rNextNode != null) {
            CSUSourceMsg rTransferMsg;
            if (rNextNode.getChildCount() > 0) {
                for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                    TreeNode rChild = rNextNode.getChildAt(nIdx);
                    if (!(rChild instanceof CTransferNode)) continue;
                    this.OnTransferPause((CTransferNode)rChild);
                }
            }
            if ((rTransferMsg = rNextNode.GetTransferMsg()) != null && (rNextNode.GetThreadStatus() == STATUS.PENDING || rNextNode.GetThreadStatus() == STATUS.RUNNING || rNextNode.GetThreadStatus() == STATUS.PAUSED || rNextNode.GetThreadStatus() == STATUS.STOPPED || rNextNode.GetThreadStatus() == STATUS.SKIPPED)) {
                if (rNextNode.IsThreadAttached()) {
                    rNextNode.SetAfterListingStatus(STATUS.PAUSED);
                }
                rNextNode.SetThreadStatus(STATUS.PAUSED, false);
                this.CancelWorkOrder(rNextNode);
            }
        }
    }

    public void OnTransferPause() {
        this.OnTransferPause(this);
    }

    protected void OnTransferStop(CTransferNode rNextNode) {
        if (rNextNode != null) {
            if (rNextNode.getChildCount() > 0) {
                for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                    TreeNode rChild = rNextNode.getChildAt(nIdx);
                    if (!(rChild instanceof CTransferNode)) continue;
                    this.OnTransferStop((CTransferNode)rChild);
                }
            }
            if (rNextNode.IsThreadAttached()) {
                rNextNode.SetAfterListingStatus(STATUS.STOPPED);
            } else if (!rNextNode.IsParentGroup() && !rNextNode.GetSourceIsDir() && rNextNode.GetThreadStatus() != STATUS.DONE_GREEN) {
                rNextNode.SetThreadStatus(STATUS.STOPPED, true);
            }
        }
    }

    public void OnTransferStop() {
        this.OnTransferStop(this);
    }

    protected void OnTransferSkip(CTransferNode rNextNode) {
        if (rNextNode != null) {
            CSUSourceMsg rTransferMsg;
            if (rNextNode.getChildCount() > 0) {
                for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                    TreeNode rChild = rNextNode.getChildAt(nIdx);
                    if (!(rChild instanceof CTransferNode)) continue;
                    this.OnTransferSkip((CTransferNode)rChild);
                }
            }
            if ((rTransferMsg = rNextNode.GetTransferMsg()) != null && (rNextNode.GetThreadStatus() == STATUS.PENDING || rNextNode.GetThreadStatus() == STATUS.ERROR || rNextNode.GetThreadStatus() == STATUS.RUNNING || rNextNode.GetThreadStatus() == STATUS.PAUSED || rNextNode.GetThreadStatus() == STATUS.STOPPED || rNextNode.GetThreadStatus() == STATUS.SKIPPED)) {
                if (rNextNode.IsThreadAttached()) {
                    rNextNode.SetAfterListingStatus(STATUS.SKIPPED);
                }
                rNextNode.SetThreadStatus(STATUS.SKIPPED, true);
                this.CancelWorkOrder(rNextNode);
            }
        }
    }

    public void OnTransferSkip() {
        this.OnTransferSkip(this);
    }

    protected void OnTransferCancel(CTransferNode rNextNode) {
        if (rNextNode != null) {
            CSUSourceMsg rTransferMsg;
            if (rNextNode.getChildCount() > 0) {
                for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                    TreeNode rChild = rNextNode.getChildAt(nIdx);
                    if (!(rChild instanceof CTransferNode)) continue;
                    this.OnTransferCancel((CTransferNode)rChild);
                }
            }
            if ((rTransferMsg = rNextNode.GetTransferMsg()) != null && (rNextNode.GetThreadStatus() == STATUS.PENDING || rNextNode.GetThreadStatus() == STATUS.ERROR || rNextNode.GetThreadStatus() == STATUS.RUNNING || rNextNode.GetThreadStatus() == STATUS.PAUSED || rNextNode.GetThreadStatus() == STATUS.STOPPED || rNextNode.GetThreadStatus() == STATUS.SKIPPED)) {
                if (rNextNode.IsThreadAttached()) {
                    rNextNode.SetAfterListingStatus(STATUS.CANCELLED);
                }
                rNextNode.SetThreadStatus(STATUS.CANCELLED, true);
                this.CancelWorkOrder(rNextNode);
            }
        }
    }

    public void OnTransferCancel() {
        this.OnTransferCancel(this);
    }

    @Override
    public boolean Add(CRhinoTreeNode rParent, boolean bAppend) {
        boolean bAdded = super.Add(rParent, bAppend);
        if (rParent != null) {
            int nInsertIndex = rParent.getChildCount();
            if (!bAppend) {
                nInsertIndex = this.GetInsertIndex(rParent, this);
            }
            if (this.GetModel() != null) {
                this.GetModel().insertNodeInto(this, rParent, nInsertIndex);
            }
            this.IncParentChildCountTotal((CTransferNode)rParent, this.GetSourceIsDir());
            bAdded = true;
        }
        return bAdded;
    }

    @Override
    public boolean Remove(CRhinoTreeNode rParent) {
        return this.Remove(rParent, false);
    }

    public boolean Remove(CRhinoTreeNode rParent, boolean bIsAutoRemove) {
        boolean bRemoved = super.Remove(rParent);
        if (rParent != null) {
            CTransferNode rParentNode = null;
            if (rParent instanceof CTransferNode) {
                rParentNode = (CTransferNode)rParent;
                this.SetHasListing(false);
                if (!this.GetSourceIsDir()) {
                    this.SetFileRead(0L, false, bIsAutoRemove);
                    this.SetFileTotal(0L, false, bIsAutoRemove);
                }
                this.SetThreadStatus(STATUS.CANCELLED, true, false);
                this.DecParentChildCountTotal(rParentNode, this.GetSourceIsDir());
            }
            this.SetTransferMsg(null);
            this.DetachThread();
            if (this.GetModel() != null) {
                this.DecRemoveAllButtons(this.GetModel().GetRootNode(), this.m_nThreadStatus);
                this.GetModel().removeNodeFromParent(this);
            }
            this.UpdateParentStatus(rParentNode, true);
            bRemoved = true;
        }
        return bRemoved;
    }

    private boolean GetDontAutoSetUserConfirmations() {
        return this.m_bDontAutoSetUserConfirmations;
    }

    public void SetDontAutoSetUserConfirmations(boolean bDontAutoSetUserConfirmations) {
        this.m_bDontAutoSetUserConfirmations = bDontAutoSetUserConfirmations;
    }

    private void UpdateParentStatus(CTransferNode rParent, boolean bRepaintRow) {
        if (rParent != null) {
            rParent.UpdateParentStatus(bRepaintRow);
            this.UpdateParentStatus(rParent.GetParent(), bRepaintRow);
        }
    }

    private void UpdateParentStatus(boolean bRepaintRow) {
        int nNumOfChildren = this.getChildCount();
        STATUS nParentStatus = STATUS.PENDING;
        int nPending = 0;
        int nRunning = 0;
        int nWaiting = 0;
        int nPaused = 0;
        int nStopped = 0;
        int nSkipped = 0;
        int nCancelled = 0;
        int nError = 0;
        int nQuestion = 0;
        int nDoneGreen = 0;
        int nDoneYellow = 0;
        block13: for (int nIdx = 0; nIdx < nNumOfChildren; ++nIdx) {
            CTransferNode rChildNode = (CTransferNode)this.getChildAt(nIdx);
            if (rChildNode == null) continue;
            switch (rChildNode.GetThreadStatus()) {
                case PENDING: {
                    ++nPending;
                    continue block13;
                }
                case RUNNING: {
                    ++nRunning;
                    continue block13;
                }
                case WAITING: {
                    ++nWaiting;
                    continue block13;
                }
                case PAUSED: {
                    ++nPaused;
                    continue block13;
                }
                case STOPPED: {
                    ++nStopped;
                    continue block13;
                }
                case SKIPPED: {
                    ++nSkipped;
                    continue block13;
                }
                case CANCELLED: {
                    ++nCancelled;
                    continue block13;
                }
                case ERROR: {
                    ++nError;
                    continue block13;
                }
                case QUESTION: {
                    ++nQuestion;
                    continue block13;
                }
                case DONE_GREEN: {
                    ++nDoneGreen;
                    continue block13;
                }
                case DONE_YELLOW: {
                    ++nDoneYellow;
                    continue block13;
                }
            }
        }
        nParentStatus = nQuestion > 0 ? STATUS.QUESTION : (nError > 0 ? STATUS.ERROR : (nDoneGreen == nNumOfChildren ? STATUS.DONE_GREEN : (nCancelled == nNumOfChildren ? STATUS.CANCELLED : (nSkipped == nNumOfChildren ? STATUS.SKIPPED : (nStopped == nNumOfChildren ? STATUS.STOPPED : (nWaiting == nNumOfChildren ? STATUS.WAITING : (nPaused == nNumOfChildren ? STATUS.PAUSED : (nRunning == nNumOfChildren ? STATUS.RUNNING : (nPending == nNumOfChildren ? STATUS.PENDING : (nRunning > 0 ? STATUS.RUNNING : (nPending > 0 ? STATUS.PENDING : STATUS.DONE_YELLOW)))))))))));
        this.SetThreadStatus(nParentStatus, false);
        if (bRepaintRow) {
            this.Repaint();
        }
    }

    public boolean IsManualStart() {
        return this.m_bIsManualStart;
    }

    public void SetIsManualStart(boolean bIsManualStart) {
        this.m_bIsManualStart = bIsManualStart;
    }

    public boolean GetShowConfirmDlg(CConfirmDlg.TYPE nType) {
        boolean bRet = true;
        switch (nType) {
            case DELETE_FOLDER: {
                bRet = this.m_ConfirmDlg_DeleteFolder.GetShowConfirmDlg();
                break;
            }
            case DELETE_FILE: {
                bRet = this.m_ConfirmDlg_DeleteFile.GetShowConfirmDlg();
                break;
            }
            case DELETE_MULTI: {
                bRet = this.m_ConfirmDlg_MultiDelete.GetShowConfirmDlg();
                break;
            }
            case OVERWRITE_FILE: {
                bRet = this.m_ConfirmDlg_Overwrite.GetShowConfirmDlg();
                break;
            }
            case MERGE_FOLDER: {
                bRet = this.m_ConfirmDlg_MergeFolder.GetShowConfirmDlg();
                break;
            }
            case ERROR: {
                bRet = this.m_ConfirmDlg_Error.GetShowConfirmDlg();
                if (bRet || this.GetConfirmDlgResult(CConfirmDlg.TYPE.ERROR) != 0) break;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    private void SetShowConfirmDlg(CConfirmDlg.TYPE nDlgType, boolean bShowConfirmDlg) {
        switch (nDlgType) {
            case DELETE_FOLDER: {
                this.m_ConfirmDlg_DeleteFolder.SetShowConfirmDlg(bShowConfirmDlg);
                break;
            }
            case DELETE_FILE: {
                this.m_ConfirmDlg_DeleteFile.SetShowConfirmDlg(bShowConfirmDlg);
                break;
            }
            case DELETE_MULTI: {
                this.m_ConfirmDlg_MultiDelete.SetShowConfirmDlg(bShowConfirmDlg);
                break;
            }
            case OVERWRITE_FILE: {
                this.m_ConfirmDlg_Overwrite.SetShowConfirmDlg(bShowConfirmDlg);
                break;
            }
            case MERGE_FOLDER: {
                this.m_ConfirmDlg_MergeFolder.SetShowConfirmDlg(bShowConfirmDlg);
                break;
            }
            case ERROR: {
                this.SetShowErrorConfirmDlg(bShowConfirmDlg);
                break;
            }
        }
        CSUSourceMsg rMsg = this.GetTransferMsg();
        if (rMsg != null && rMsg.GetConfirmDlgType() == nDlgType) {
            rMsg.SetUserWantsConfirmDlg(bShowConfirmDlg);
        }
    }

    public void SetShowErrorConfirmDlg(boolean bShowConfirmDlg) {
        this.m_ConfirmDlg_Error.SetShowConfirmDlg(bShowConfirmDlg);
    }

    public int GetConfirmDlgResult(CConfirmDlg.TYPE nDlgType) {
        int nRet = -5;
        switch (nDlgType) {
            case DELETE_FOLDER: {
                nRet = this.m_ConfirmDlg_DeleteFolder.GetConfirmDlgResult();
                break;
            }
            case DELETE_FILE: {
                nRet = this.m_ConfirmDlg_DeleteFile.GetConfirmDlgResult();
                break;
            }
            case DELETE_MULTI: {
                nRet = this.m_ConfirmDlg_MultiDelete.GetConfirmDlgResult();
                break;
            }
            case OVERWRITE_FILE: {
                nRet = this.m_ConfirmDlg_Overwrite.GetConfirmDlgResult();
                break;
            }
            case MERGE_FOLDER: {
                nRet = this.m_ConfirmDlg_MergeFolder.GetConfirmDlgResult();
                break;
            }
            case ERROR: {
                nRet = this.m_ConfirmDlg_Error.GetConfirmDlgResult();
                break;
            }
        }
        return nRet;
    }

    private void SetConfirmDlgResult(CConfirmDlg.TYPE nDlgType, int nConfirmDlgResult) {
        switch (nDlgType) {
            case DELETE_FOLDER: {
                this.m_ConfirmDlg_DeleteFolder.SetConfirmDlgResult(nConfirmDlgResult);
                break;
            }
            case DELETE_FILE: {
                this.m_ConfirmDlg_DeleteFile.SetConfirmDlgResult(nConfirmDlgResult);
                break;
            }
            case DELETE_MULTI: {
                this.m_ConfirmDlg_MultiDelete.SetConfirmDlgResult(nConfirmDlgResult);
                break;
            }
            case OVERWRITE_FILE: {
                this.m_ConfirmDlg_Overwrite.SetConfirmDlgResult(nConfirmDlgResult);
                break;
            }
            case MERGE_FOLDER: {
                this.m_ConfirmDlg_MergeFolder.SetConfirmDlgResult(nConfirmDlgResult);
                break;
            }
            case ERROR: {
                this.m_ConfirmDlg_Error.SetConfirmDlgResult(nConfirmDlgResult);
                if (this.m_ConfirmDlg_Error.GetShowConfirmDlg() || this.GetThreadStatus() != STATUS.PENDING) break;
                STATUS nStatus = STATUS.CANCELLED;
                if (nConfirmDlgResult == 1) {
                    nStatus = STATUS.SKIPPED;
                }
                this.SetThreadStatus(nStatus, true);
                break;
            }
        }
        CSUSourceMsg rMsg = this.GetTransferMsg();
        if (rMsg != null && rMsg.GetConfirmDlgType() == nDlgType) {
            rMsg.SetUserConfirmDlgResult(nConfirmDlgResult);
        }
    }

    public void UpdateShowConfirmDlg(CTransferNode rNextNode, CConfirmDlg.TYPE nDlgType, boolean bShowConfirmDlg, int nConfirmDlgResult) {
        if (rNextNode != null) {
            if (rNextNode.getChildCount() > 0) {
                for (int nIdx = 0; nIdx < rNextNode.getChildCount(); ++nIdx) {
                    TreeNode rChild = rNextNode.getChildAt(nIdx);
                    if (!(rChild instanceof CTransferNode)) continue;
                    this.UpdateShowConfirmDlg((CTransferNode)rChild, nDlgType, bShowConfirmDlg, nConfirmDlgResult);
                }
            }
            rNextNode.SetShowConfirmDlg(nDlgType, bShowConfirmDlg);
            rNextNode.SetConfirmDlgResult(nDlgType, nConfirmDlgResult);
        }
    }

    public void UpdateShowConfirmDlg(CConfirmDlg.TYPE nDlgType, boolean bShowConfirmDlg, int nConfirmDlgResult) {
        this.UpdateShowConfirmDlg(this, nDlgType, bShowConfirmDlg, nConfirmDlgResult);
    }

    public void ResetShowConfirmDlgs(boolean bResetParentGroup) {
        CConfirmDlg.TYPE[] aTypes = CConfirmDlg.TYPE.values();
        for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
            CConfirmDlg.TYPE rType = aTypes[nIdx];
            if (rType == null) continue;
            if (bResetParentGroup && !this.IsParentGroup() && this.GetParentGroup() != null) {
                this.GetParentGroup().UpdateShowConfirmDlg(rType, true, -5);
            }
            this.UpdateShowConfirmDlg(rType, true, -5);
        }
    }

    private void CheckResetShowConfirmDlg() {
        if (this.GetParentGroup() != null) {
            CConfirmDlg.TYPE[] aTypes = CConfirmDlg.TYPE.values();
            for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
                CConfirmDlg.TYPE rType = aTypes[nIdx];
                if (rType == null) continue;
                if (rType == CConfirmDlg.TYPE.ERROR) {
                    this.UpdateShowConfirmDlg(rType, false, -5);
                    continue;
                }
                if (!this.GetParentGroup().GetShowConfirmDlg(rType)) continue;
                this.UpdateShowConfirmDlg(rType, true, -5);
            }
        }
    }

    protected void OnRecvThumbnail(CThumbnailMsg rThumbMsg) {
        if (rThumbMsg != null && this.GetAttrID() == rThumbMsg.GetUISourceAttrID_AfterThumb()) {
            CThumbnailMsg.AFTER_THUMB_ACTION nAction;
            String sMsgFilePath = rThumbMsg.GetSourcePath();
            String sSourcePath = this.GetSourcePath();
            String sTargetPath = this.GetTargetPath();
            if (sMsgFilePath != null && (sSourcePath != null && sMsgFilePath.equals(sSourcePath) || sTargetPath != null && sMsgFilePath.equals(sTargetPath)) && ((nAction = rThumbMsg.GetAfterThumbAction()) == CThumbnailMsg.AFTER_THUMB_ACTION.DELETE || nAction == CThumbnailMsg.AFTER_THUMB_ACTION.OVERWRITE)) {
                if (CRhinoOverwriteFileBtn.DEBUG_AFTER_ACTION_THUMB) {
                    CDebugLog.INFO("Perform after thumb action");
                }
                if (this.GetModel() != null) {
                    this.GetModel().OnConfirmDlgResult(0, this.GetTransferMsg(), false);
                }
            }
            rThumbMsg.RemoveSUConnection();
        }
    }

    protected boolean CheckNoMoreChildrenToProcess() {
        boolean bAllDoneProcessing = true;
        if (this.GetActiveChildCount() > 0) {
            bAllDoneProcessing = false;
        }
        return bAllDoneProcessing;
    }

    public STATUS GetAfterListingStatus() {
        return this.m_nAfterListingStatus;
    }

    private void SetAfterListingStatus(STATUS nStatus) {
        this.m_nAfterListingStatus = nStatus;
    }

    public void SetIsResume(boolean bIsResume) {
        CTransferNodeParentGroup rParentGroup;
        this.m_bIsResume = bIsResume;
        if (!this.IsParentGroup() && (rParentGroup = this.GetParentGroup()) != null && rParentGroup.GetChildCountTotal() == 1) {
            rParentGroup.SetIsResume(bIsResume);
        }
    }

    public boolean IsResume() {
        return this.m_bIsResume;
    }

    private void SetEnableBtnCount(int nIndex, int nValue) {
        if (this.m_anEnableBtns != null && nIndex > -1 && nIndex < this.m_anEnableBtns.length) {
            this.m_anEnableBtns[nIndex] = nValue;
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arguments.");
        }
    }

    private void IncEnableBtnCount(int nIndex) {
        if (this.m_anEnableBtns != null && nIndex < this.m_anEnableBtns.length) {
            if (this.m_anEnableBtns[nIndex] > -1) {
                int n = nIndex;
                this.m_anEnableBtns[n] = this.m_anEnableBtns[n] + 1;
            } else if (DEBUG) {
                CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, investigate this b/c the member variable is in an invalid state!");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arguments.");
        }
    }

    private void DecEnableBtnCount(int nIndex) {
        if (this.m_anEnableBtns != null && nIndex < this.m_anEnableBtns.length) {
            if (this.m_anEnableBtns[nIndex] > 0) {
                int n = nIndex;
                this.m_anEnableBtns[n] = this.m_anEnableBtns[n] - 1;
            } else if (DEBUG) {
                CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, investigate this b/c the member variable is in an invalid state!");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferNode.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arguments.");
        }
    }

    public int GetEnableConfirmDeleteFolders() {
        return this.m_anEnableBtns[0];
    }

    private void IncEnableConfirmDeleteFolders() {
        this.IncEnableBtnCount(0);
    }

    private void DecEnableConfirmDeleteFolders() {
        this.DecEnableBtnCount(0);
    }

    private void ResetEnableConfirmDeleteFolders() {
        this.SetEnableBtnCount(0, 0);
    }

    public int GetEnableConfirmDeleteFiles() {
        return this.m_anEnableBtns[1];
    }

    private void IncEnableConfirmDeleteFiles() {
        this.IncEnableBtnCount(1);
    }

    private void DecEnableConfirmDeleteFiles() {
        this.DecEnableBtnCount(1);
    }

    private void ResetEnableConfirmDeleteFiles() {
        this.SetEnableBtnCount(1, 0);
    }

    public int GetEnableConfirmOverwriteUploadFiles() {
        return this.m_anEnableBtns[2];
    }

    private void IncEnableConfirmOverwriteUploadFiles() {
        this.IncEnableBtnCount(2);
    }

    private void DecEnableConfirmOverwriteUploadFiles() {
        this.DecEnableBtnCount(2);
    }

    private void ResetEnableConfirmOverwriteUploadFiles() {
        this.SetEnableBtnCount(2, 0);
    }

    public int GetEnableConfirmOverwriteDownloadFiles() {
        return this.m_anEnableBtns[3];
    }

    private void IncEnableConfirmOverwriteDownloadFiles() {
        this.IncEnableBtnCount(3);
    }

    private void DecEnableConfirmOverwriteDownloadFiles() {
        this.DecEnableBtnCount(3);
    }

    private void ResetEnableConfirmOverwriteDownloadFiles() {
        this.SetEnableBtnCount(3, 0);
    }

    public int GetEnableStop() {
        return this.m_anEnableBtns[4];
    }

    private void IncEnableStop() {
        this.IncEnableBtnCount(4);
    }

    private void DecEnableStop() {
        this.DecEnableBtnCount(4);
    }

    private void ResetEnableStop() {
        this.SetEnableBtnCount(4, 0);
    }

    public int GetEnableSkip() {
        return this.m_anEnableBtns[5];
    }

    private void IncEnableSkip() {
        this.IncEnableBtnCount(5);
    }

    private void DecEnableSkip() {
        this.DecEnableBtnCount(5);
    }

    private void ResetEnableSkip() {
        this.SetEnableBtnCount(5, 0);
    }

    public int GetEnablePause() {
        return this.m_anEnableBtns[6];
    }

    private void IncEnablePause() {
        this.IncEnableBtnCount(6);
    }

    private void DecEnablePause() {
        this.DecEnableBtnCount(6);
    }

    private void ResetEnablePause() {
        this.SetEnableBtnCount(6, 0);
    }

    public int GetEnableResume() {
        return this.m_anEnableBtns[7];
    }

    private void IncEnableResume() {
        this.IncEnableBtnCount(7);
    }

    private void DecEnableResume() {
        this.DecEnableBtnCount(7);
    }

    private void ResetEnableResume() {
        this.SetEnableBtnCount(7, 0);
    }

    public int GetEnableStart() {
        return this.m_anEnableBtns[8];
    }

    private void IncEnableStart() {
        this.IncEnableBtnCount(8);
    }

    private void DecEnableStart() {
        this.DecEnableBtnCount(8);
    }

    private void ResetEnableStart() {
        this.SetEnableBtnCount(8, 0);
    }

    public int GetEnableRestart() {
        return this.m_anEnableBtns[9];
    }

    private void IncEnableRestart() {
        this.IncEnableBtnCount(9);
    }

    private void DecEnableRestart() {
        this.DecEnableBtnCount(9);
    }

    private void ResetEnableRestart() {
        this.SetEnableBtnCount(9, 0);
    }

    public int GetEnableCancel() {
        return this.m_anEnableBtns[10];
    }

    private void IncEnableCancel() {
        this.IncEnableBtnCount(10);
    }

    private void DecEnableCancel() {
        this.DecEnableBtnCount(10);
    }

    private void ResetEnableCancel() {
        this.SetEnableBtnCount(10, 0);
    }

    public int GetEnableRemove() {
        return this.m_anEnableBtns[11];
    }

    private void IncEnableRemove() {
        this.IncEnableBtnCount(11);
    }

    private void DecEnableRemove() {
        this.DecEnableBtnCount(11);
    }

    private void ResetEnableRemove() {
        this.SetEnableBtnCount(11, 0);
    }

    public int GetEnableRemoveAllCompleted() {
        return this.m_anEnableBtns[12];
    }

    private void IncEnableRemoveAllCompleted() {
        this.IncEnableBtnCount(12);
    }

    private void DecEnableRemoveAllCompleted() {
        this.DecEnableBtnCount(12);
    }

    public int GetEnableRemoveAllCancelled() {
        return this.m_anEnableBtns[13];
    }

    private void IncEnableRemoveAllCancelled() {
        this.IncEnableBtnCount(13);
    }

    private void DecEnableRemoveAllCancelled() {
        this.DecEnableBtnCount(13);
    }

    public int GetEnableRemoveAllSkipped() {
        return this.m_anEnableBtns[14];
    }

    private void IncEnableRemoveAllSkipped() {
        this.IncEnableBtnCount(14);
    }

    private void DecEnableRemoveAllSkipped() {
        this.DecEnableBtnCount(14);
    }

    public int GetEnableRemoveAllPaused() {
        return this.m_anEnableBtns[15];
    }

    private void IncEnableRemoveAllPaused() {
        this.IncEnableBtnCount(15);
    }

    private void DecEnableRemoveAllPaused() {
        this.DecEnableBtnCount(15);
    }

    public int GetEnableRemoveAllWaiting() {
        return this.m_anEnableBtns[16];
    }

    private void IncEnableRemoveAllWaiting() {
        this.IncEnableBtnCount(16);
    }

    private void DecEnableRemoveAllWaiting() {
        this.DecEnableBtnCount(16);
    }

    public int GetEnableRemoveAllStopped() {
        return this.m_anEnableBtns[17];
    }

    private void IncEnableRemoveAllStopped() {
        this.IncEnableBtnCount(17);
    }

    private void DecEnableRemoveAllStopped() {
        this.DecEnableBtnCount(17);
    }

    private void UpdateSelectionButtons(CRhinoTreeNode rRootNodeEx, STATUS nThreadStatus, boolean bIsSelected) {
        if (rRootNodeEx == this) {
            return;
        }
        CTransferNode rRootNode = null;
        if (rRootNodeEx != null && rRootNodeEx instanceof CTransferNode) {
            rRootNode = (CTransferNode)rRootNodeEx;
        }
        if (rRootNode == null) {
            return;
        }
        switch (nThreadStatus) {
            case PENDING: {
                if (bIsSelected) {
                    rRootNode.IncEnableStop();
                    rRootNode.IncEnableSkip();
                    rRootNode.IncEnableCancel();
                    rRootNode.IncEnableRemove();
                    break;
                }
                rRootNode.DecEnableStop();
                rRootNode.DecEnableSkip();
                rRootNode.DecEnableCancel();
                rRootNode.DecEnableRemove();
                break;
            }
            case WAITING: {
                if (bIsSelected) {
                    rRootNode.IncEnableStart();
                    rRootNode.IncEnableRestart();
                    rRootNode.IncEnableCancel();
                    rRootNode.IncEnableRemove();
                    break;
                }
                rRootNode.DecEnableStart();
                rRootNode.DecEnableRestart();
                rRootNode.DecEnableCancel();
                rRootNode.DecEnableRemove();
                break;
            }
            case RUNNING: {
                if (bIsSelected) {
                    rRootNode.IncEnableStop();
                    rRootNode.IncEnableSkip();
                    rRootNode.IncEnablePause();
                    rRootNode.IncEnableCancel();
                    break;
                }
                rRootNode.DecEnableStop();
                rRootNode.DecEnableSkip();
                rRootNode.DecEnablePause();
                rRootNode.DecEnableCancel();
                break;
            }
            case SKIPPED: 
            case PAUSED: 
            case STOPPED: {
                if (bIsSelected) {
                    if (this.GetFileRead() > 0L && this.GetFileRead() < this.GetFileTotal()) {
                        rRootNode.IncEnableResume();
                    }
                    rRootNode.IncEnableStart();
                    rRootNode.IncEnableRestart();
                    rRootNode.IncEnableCancel();
                    rRootNode.IncEnableRemove();
                    break;
                }
                if (this.GetFileRead() > 0L && this.GetFileRead() < this.GetFileTotal()) {
                    rRootNode.DecEnableResume();
                }
                rRootNode.DecEnableStart();
                rRootNode.DecEnableRestart();
                rRootNode.DecEnableCancel();
                rRootNode.DecEnableRemove();
                break;
            }
            case DONE_YELLOW: 
            case CANCELLED: 
            case ERROR: {
                if (bIsSelected) {
                    if (this.GetFileRead() > 0L && this.GetFileRead() < this.GetFileTotal()) {
                        rRootNode.IncEnableResume();
                    }
                    rRootNode.IncEnableStart();
                    rRootNode.IncEnableRestart();
                    rRootNode.IncEnableRemove();
                    break;
                }
                if (this.GetFileRead() > 0L && this.GetFileRead() < this.GetFileTotal()) {
                    rRootNode.DecEnableResume();
                }
                rRootNode.DecEnableStart();
                rRootNode.DecEnableRestart();
                rRootNode.DecEnableRemove();
                break;
            }
            case DONE_GREEN: {
                if (bIsSelected) {
                    rRootNode.IncEnableStart();
                    rRootNode.IncEnableRestart();
                    rRootNode.IncEnableRemove();
                    break;
                }
                rRootNode.DecEnableStart();
                rRootNode.DecEnableRestart();
                rRootNode.DecEnableRemove();
                break;
            }
        }
        CTransferNodeParentGroup rParentGroup = this.GetParentGroup();
        if (rParentGroup != null && rParentGroup != this) {
            if (this.IsDelete()) {
                if (this.GetSourceIsDir()) {
                    if (bIsSelected) {
                        super.IncEnableConfirmDeleteFolders();
                    } else {
                        super.DecEnableConfirmDeleteFolders();
                    }
                } else if (bIsSelected) {
                    super.IncEnableConfirmDeleteFiles();
                } else {
                    super.DecEnableConfirmDeleteFiles();
                }
            } else if (this.IsUpload()) {
                if (bIsSelected) {
                    super.IncEnableConfirmOverwriteUploadFiles();
                } else {
                    super.DecEnableConfirmOverwriteUploadFiles();
                }
            } else if (this.IsDownload()) {
                if (bIsSelected) {
                    super.IncEnableConfirmOverwriteDownloadFiles();
                } else {
                    super.DecEnableConfirmOverwriteDownloadFiles();
                }
            }
        }
        if (DEBUG_REPAINT_ROOT) {
            rRootNode.Repaint();
        }
    }

    private boolean IsSelected() {
        boolean bIsSelected = false;
        if (this.GetModel() != null) {
            bIsSelected = this.GetModel().IsSelected(this);
        }
        return bIsSelected;
    }

    private void DecRemoveAllButtons(CTransferNode rRootNode, STATUS nPrevThreadStatus) {
        if (rRootNode == this) {
            return;
        }
        switch (nPrevThreadStatus) {
            case WAITING: {
                rRootNode.DecEnableRemoveAllWaiting();
                break;
            }
            case PAUSED: {
                rRootNode.DecEnableRemoveAllPaused();
                break;
            }
            case STOPPED: {
                rRootNode.DecEnableRemoveAllStopped();
                break;
            }
            case CANCELLED: {
                rRootNode.DecEnableRemoveAllCancelled();
                break;
            }
            case SKIPPED: {
                rRootNode.DecEnableRemoveAllSkipped();
                break;
            }
            case DONE_GREEN: {
                rRootNode.DecEnableRemoveAllCompleted();
                break;
            }
        }
        if (DEBUG_REPAINT_ROOT) {
            rRootNode.Repaint();
        }
    }

    private void IncRemoveAllButtons(CTransferNode rRootNode, STATUS nNewThreadStatus) {
        if (rRootNode == this) {
            return;
        }
        switch (nNewThreadStatus) {
            case WAITING: {
                rRootNode.IncEnableRemoveAllWaiting();
                break;
            }
            case PAUSED: {
                rRootNode.IncEnableRemoveAllPaused();
                break;
            }
            case STOPPED: {
                rRootNode.IncEnableRemoveAllStopped();
                break;
            }
            case CANCELLED: {
                rRootNode.IncEnableRemoveAllCancelled();
                break;
            }
            case SKIPPED: {
                rRootNode.IncEnableRemoveAllSkipped();
                break;
            }
            case DONE_GREEN: {
                rRootNode.IncEnableRemoveAllCompleted();
                break;
            }
        }
        if (DEBUG_REPAINT_ROOT) {
            rRootNode.Repaint();
        }
    }

    private void UpdateDynamicButtons(CTransferNode rRootNode, STATUS nPrevThreadStatus, STATUS nNewThreadStatus) {
        if (rRootNode == this) {
            return;
        }
        if (this.IsSelected()) {
            this.UpdateSelectionButtons(rRootNode, nPrevThreadStatus, false);
            this.UpdateSelectionButtons(rRootNode, nNewThreadStatus, true);
        }
        this.DecRemoveAllButtons(rRootNode, nPrevThreadStatus);
        this.IncRemoveAllButtons(rRootNode, nNewThreadStatus);
    }

    @Override
    public void UpdateDynamicButtonsForSelModel(CRhinoTreeNode rRootNode, boolean bIsSelected) {
        if (rRootNode == this) {
            return;
        }
        super.UpdateDynamicButtonsForSelModel(rRootNode, bIsSelected);
        CTransferNode rNode = null;
        if (rRootNode != null && rRootNode instanceof CTransferNode) {
            rNode = (CTransferNode)rRootNode;
        }
        if (rNode == null) {
            return;
        }
        this.UpdateSelectionButtons(rRootNode, this.GetThreadStatus(), bIsSelected);
    }

    @Override
    public void ResetDynamicButtonsForSelModel() {
        super.ResetDynamicButtonsForSelModel();
        if (this != this.getRoot()) {
            return;
        }
        this.ResetEnableStop();
        this.ResetEnableSkip();
        this.ResetEnablePause();
        this.ResetEnableResume();
        this.ResetEnableStart();
        this.ResetEnableRestart();
        this.ResetEnableCancel();
        this.ResetEnableRemove();
        this.ResetEnableConfirmDeleteFolders();
        this.ResetEnableConfirmDeleteFiles();
        this.ResetEnableConfirmOverwriteUploadFiles();
        this.ResetEnableConfirmOverwriteDownloadFiles();
        for (int nIdx = 0; nIdx < this.getChildCount(); ++nIdx) {
            TreeNode rNode = this.getChildAt(nIdx);
            if (rNode == null || !(rNode instanceof CTransferNode)) continue;
            CTransferNode rTransferNode = (CTransferNode)rNode;
            rTransferNode.ResetEnableConfirmDeleteFolders();
            rTransferNode.ResetEnableConfirmDeleteFiles();
            rTransferNode.ResetEnableConfirmOverwriteUploadFiles();
            rTransferNode.ResetEnableConfirmOverwriteDownloadFiles();
        }
    }

    private void CancelWorkOrder(CTransferNode rNode) {
        if (rNode != null && rNode.GetTransferMsg() != null) {
            rNode.GetTransferMsg().SetCancel(true);
        }
    }

    @Override
    public String GetDisplayText() {
        String sRet = super.GetDisplayText();
        if (!this.IsDelete() && (this.GetSourceIsDir() || this.IsParentGroup())) {
            String sChildCountTotal = CString.FormatNumberForThousands(this.GetChildCountTotal());
            if (this.GetModel() != null && !this.GetModel().GetAutoRemoveCompletedTransfers()) {
                String sChildCountComplete = CString.FormatNumberForThousands(this.GetChildCountComplete());
                String sFmt = CString.LoadString("IDS_TRANSFERS_COMPLETE");
                sRet = String.format(sFmt, sRet, sChildCountComplete, sChildCountTotal);
            } else {
                String sFmt = CString.LoadString("IDS_TRANSFERS_PENDING");
                sRet = String.format(sFmt, sRet, sChildCountTotal);
            }
        }
        return sRet;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PERCENT_DONE_SHOW_BYTES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PERCENT_DONE_PRINT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_REMOVE_CHILD = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PARENT_CHILD_COUNT_TOTAL = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ADD_CHILD_AS_XFER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_INIT_XFER_MSG = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_FILE_READ = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_THREAD_ATTACH = false;
        boolean bl = DEBUG_REPAINT_ROOT = DEBUG;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_STAT_MSGS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_STAT_MSGS_RATE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ELAPSED = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ELAPSED_ENDED = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_BYTES_PER_SEC = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_STATS_PARENT = false;
    }

    private class CConfirmations {
        private boolean m_bShowConfirmDlg = true;
        private int m_nConfirmDlgResult = -5;

        public CConfirmations(boolean bShowConfirmDlg, int nConfirmDlgResult) {
            this.m_bShowConfirmDlg = bShowConfirmDlg;
            this.m_nConfirmDlgResult = nConfirmDlgResult;
        }

        public boolean GetShowConfirmDlg() {
            return this.m_bShowConfirmDlg;
        }

        public void SetShowConfirmDlg(boolean bShowConfirmDlg) {
            this.m_bShowConfirmDlg = bShowConfirmDlg;
        }

        public int GetConfirmDlgResult() {
            return this.m_nConfirmDlgResult;
        }

        public void SetConfirmDlgResult(int nConfirmDlgResult) {
            this.m_nConfirmDlgResult = nConfirmDlgResult;
        }
    }

    public static enum TYPE {
        UNKNOWN,
        UPLOAD,
        DOWNLOAD,
        DELETE;

    }

    public static enum STATUS {
        PENDING(0),
        WAITING(1),
        RUNNING(2),
        PAUSED(3),
        STOPPED(4),
        SKIPPED(5),
        CANCELLED(6),
        ERROR(7),
        QUESTION(8),
        DONE_GREEN(9),
        DONE_YELLOW(10);

        private int m_nValue = 0;

        private STATUS(int nVal) {
            this.m_nValue = nVal;
        }

        private int GetValue() {
            return this.m_nValue;
        }
    }
}

