/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.treetables;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableModel;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableMouseEvent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class CRhinoTreeTableTreeRenderer
extends JTree
implements TableCellRenderer {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_PAINT_SELECTION_BORDER;
    private static boolean DEBUG_EXPANDER_CALCS;
    private static boolean DEBUG_TREE_COLORS;
    protected int m_nVisibleRow;
    protected boolean m_bIsSelected;
    protected CRhinoTreeTable m_rTreeTable;

    public CRhinoTreeTableTreeRenderer(CRhinoTreeTableModel rModel, CRhinoTreeTable rTreeTable, int nRowHeight) {
        super(rModel);
        this.m_rTreeTable = rTreeTable;
        this.setRowHeight(nRowHeight);
    }

    protected CRhinoTreeTable GetTreeTable() {
        return this.m_rTreeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    @Override
    public void setRowHeight(int nRowHeight) {
        if (nRowHeight > 0) {
            super.setRowHeight(nRowHeight);
            if (this.m_rTreeTable != null) {
                this.m_rTreeTable.setRowHeight(nRowHeight);
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.m_rTreeTable.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void paint(Graphics g) {
        int nY = -this.m_nVisibleRow * this.getRowHeight();
        if (DEBUG_PAINT_SELECTION_BORDER) {
            System.out.printf("VisibleRow: %d | RowHeight: %d | Calc: %d\r\n", this.m_nVisibleRow, this.getRowHeight(), nY);
        }
        g.translate(0, nY);
        super.paint(g);
        if (this.m_rTreeTable != null) {
            Rectangle rRowBounds = this.getRowBounds(this.m_nVisibleRow);
            if (DEBUG_PAINT_SELECTION_BORDER) {
                System.out.printf("RowBounds: %s\r\n", rRowBounds.toString());
            }
            int nColIdxTree = 0;
            if (this.m_rTreeTable.GetModel() != null) {
                nColIdxTree = this.m_rTreeTable.GetModel().GetColIndexTree();
            }
            int nCol = this.m_rTreeTable.convertColumnIndexToView(nColIdxTree);
            Rectangle rCellRect = this.m_rTreeTable.getCellRect(this.m_nVisibleRow, nCol, false);
            if (DEBUG_PAINT_SELECTION_BORDER) {
                System.out.printf("CellBounds: %s\r\n", rCellRect.toString());
            }
            Color clrPrev = g.getColor();
            if (this.m_rTreeTable.getSelectionModel().getLeadSelectionIndex() == this.m_nVisibleRow) {
                Color clrBorder = this.m_rTreeTable.GetLeadSelectionColor();
                g.setColor(clrBorder);
                if (nCol == 0) {
                    g.drawRect(0, rRowBounds.y, rCellRect.width + 1, rRowBounds.height - 1);
                } else if (nCol == this.m_rTreeTable.getColumnCount() - 1) {
                    g.drawRect(-1, rRowBounds.y, rCellRect.width, rRowBounds.height - 1);
                } else {
                    g.drawRect(-1, rRowBounds.y, rCellRect.width + 1, rRowBounds.height - 1);
                }
            }
            g.setColor(clrPrev);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rValue, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        Color clrBack = rTable.getBackground();
        if (CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
            clrBack = UIManager.getColor("Label.background");
        }
        if (DEBUG_TREE_COLORS) {
            CDebugLog.INFO(String.format("Tree Graphic Back Color: %d,%d,%d %d\r\n", clrBack.getRed(), clrBack.getGreen(), clrBack.getBlue(), clrBack.getAlpha()));
        }
        if (bIsSelected) {
            clrBack = rTable.getSelectionBackground();
        } else if (this.GetTreeTable() != null && this.GetTreeTable().GetEnableRowColor()) {
            clrBack = nRow % 2 == 1 ? this.GetTreeTable().GetRowColorOdd() : this.GetTreeTable().GetRowColorEven();
        }
        this.setBackground(clrBack);
        nCol = rTable.convertColumnIndexToModel(nCol);
        this.m_nVisibleRow = nRow;
        this.m_bIsSelected = bIsSelected;
        return this;
    }

    public int[] GetExpanderInfo(int nRow) {
        int[] anExpanderInfo = new int[3];
        int nTreeCol = -1;
        if (this.GetTreeTable() != null) {
            for (int nColumn = this.m_rTreeTable.getColumnCount() - 1; nColumn >= 0; --nColumn) {
                if (this.m_rTreeTable.getColumnClass(nColumn) != CRhinoTreeTableTreeRenderer.class) continue;
                nTreeCol = nColumn;
                break;
            }
        }
        if (nTreeCol != -1) {
            TreePath rTreePath = this.getPathForRow(nRow);
            Rectangle rTreeCellBounds = this.getPathBounds(rTreePath);
            if (DEBUG_EXPANDER_CALCS) {
                System.out.printf("TreeCellBounds: X=%d | Y=%d | Width=%d | Height=%d\r\n", rTreeCellBounds.x, rTreeCellBounds.y, rTreeCellBounds.width, rTreeCellBounds.height);
            }
            Rectangle rTableCellBounds = this.m_rTreeTable.getCellRect(nRow, nTreeCol, true);
            if (DEBUG_EXPANDER_CALCS) {
                System.out.printf("TableCellBounds: X=%d | Y=%d | Width=%d | Height=%d\r\n", rTableCellBounds.x, rTableCellBounds.y, rTableCellBounds.width, rTableCellBounds.height);
            }
            if (nRow >= 0 && nRow < this.getRowCount() && rTreePath != null) {
                CRhinoTreeNode rNode = ((CRhinoTreeTableModel)this.getModel()).GetTreeNode(rTreePath);
                int nLevel = rNode.getLevel();
                if (DEBUG_EXPANDER_CALCS) {
                    System.out.printf("Level: %d | Depth: %d\r\n", rNode.getLevel(), rNode.getDepth());
                }
                int nNumOfPixelsForExpander = rTreeCellBounds.x;
                if (nLevel > 0) {
                    nNumOfPixelsForExpander = rTreeCellBounds.x / nLevel;
                }
                if (DEBUG_EXPANDER_CALCS) {
                    System.out.printf("Number of pixels for expander: %d\r\n", nNumOfPixelsForExpander);
                }
                int nExpanderRightEdge = rTableCellBounds.x + rTreeCellBounds.x;
                int nExpanderLeftEdge = nExpanderRightEdge - nNumOfPixelsForExpander;
                anExpanderInfo[0] = nNumOfPixelsForExpander;
                anExpanderInfo[1] = nExpanderRightEdge;
                anExpanderInfo[2] = nExpanderLeftEdge;
            }
        }
        return anExpanderInfo;
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3104: {
                    this.updateUI();
                    break;
                }
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent rEvent) {
        MouseEvent rMouseEvent;
        super.processEvent(rEvent);
        if (rEvent instanceof MouseEvent && !(rMouseEvent = (MouseEvent)rEvent).isConsumed() && rMouseEvent instanceof CRhinoTreeTableMouseEvent) {
            CRhinoTreeTableMouseEvent cRhinoTreeTableMouseEvent = (CRhinoTreeTableMouseEvent)rMouseEvent;
        }
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PAINT_SELECTION_BORDER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_EXPANDER_CALCS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TREE_COLORS = false;
    }
}

