/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.treetables;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableTreeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CRhinoTreeTableTreeNodeRenderer
extends DefaultTreeCellRenderer {
    public static boolean DEBUG = CAttr.DEBUG;
    private static boolean DEBUG_CELL_SIZE_BORDER;
    private JTree m_rTree;
    private CRhinoTreeTable m_rTreeTable;
    private boolean m_bGotExpander = false;

    public CRhinoTreeTableTreeNodeRenderer(JTree rTree, CRhinoTreeTable rTreeTable) {
        this.m_rTree = rTree;
        this.m_rTreeTable = rTreeTable;
    }

    protected CRhinoTreeTable GetTreeTable() {
        return this.m_rTreeTable;
    }

    private void CheckCellSize(int nLevel, TreePath rTreePath) {
        if (!this.m_bGotExpander) {
            if (DEBUG_CELL_SIZE_BORDER) {
                this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
            }
            if (nLevel < 1) {
                nLevel = 1;
            }
            if (this.m_rTreeTable != null) {
                TableColumn rCol;
                int nRenderCol = -1;
                for (int nCol = 0; nCol < this.m_rTreeTable.getColumnCount(); ++nCol) {
                    if (!(this.m_rTreeTable.getCellRenderer(0, nCol) instanceof CRhinoTreeTableTreeRenderer)) continue;
                    nRenderCol = nCol;
                    break;
                }
                if (nRenderCol != -1 && (rCol = this.m_rTreeTable.getColumnModel().getColumn(nRenderCol)) != null) {
                    int nWidth = rCol.getWidth();
                    Dimension dimPrefSize = this.getPreferredSize();
                    dimPrefSize.width = nWidth -= this.GetTreeGraphicWidth(nLevel, rTreePath);
                    this.setPreferredSize(dimPrefSize);
                    if (this.m_rTree.getUI() instanceof BasicTreeUI) {
                        BasicTreeUI rUI = (BasicTreeUI)this.m_rTree.getUI();
                        rUI.setLeftChildIndent(rUI.getLeftChildIndent());
                    }
                }
            }
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree rTree, Object rValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int nRow, boolean bHasFocus) {
        Font font;
        if (this.GetTreeTable() != null) {
            bIsSelected = this.GetTreeTable().isRowSelected(nRow);
        }
        super.getTreeCellRendererComponent(rTree, rValue, bIsSelected, bIsExpanded, bIsLeaf, nRow, bHasFocus);
        if (!bIsSelected && this.GetTreeTable() != null) {
            Color clrBack = this.GetTreeTable().getBackground();
            if (this.GetTreeTable().GetEnableRowColor()) {
                clrBack = this.GetTreeTable().GetRowColorEven();
                if (nRow % 2 == 1) {
                    clrBack = this.GetTreeTable().GetRowColorOdd();
                }
            }
            this.setBackgroundNonSelectionColor(clrBack);
            clrBack = this.GetTreeTable().getSelectionBackground();
            this.setBackgroundSelectionColor(clrBack);
        }
        if ((font = (Font)UIManager.get("List.font")) == null) {
            font = rTree.getFont();
        }
        rTree.setFont(font);
        TreePath rTreePath = null;
        int nLevel = 0;
        if (rValue instanceof CRhinoTreeNode) {
            CRhinoTreeNode rNode = (CRhinoTreeNode)rValue;
            this.setIcon(rNode.GetDisplayIcon());
            this.setText(rNode.GetDisplayText());
            nLevel = rNode.getLevel();
            rTreePath = rNode.GetTreePath();
        }
        this.CheckCellSize(nLevel, rTreePath);
        return this;
    }

    public int GetPreferredWidth(Object rValue) {
        int nWidth = 0;
        String sText = this.getText();
        if (this.m_rTreeTable != null && sText != null && !sText.isEmpty()) {
            FontRenderContext fFontContext;
            Font fFont = this.m_rTreeTable.getFont();
            Graphics2D g2d = (Graphics2D)this.m_rTreeTable.getGraphics();
            if (fFont != null && g2d != null && (fFontContext = g2d.getFontRenderContext()) != null) {
                Rectangle2D rStringBounds = fFont.getStringBounds(sText, fFontContext);
                nWidth += (int)rStringBounds.getWidth();
            }
            if (this.getIcon() != null) {
                nWidth += this.getIcon().getIconWidth();
                nWidth += this.getIconTextGap();
            }
            if (rValue instanceof CRhinoTreeNode) {
                CRhinoTreeNode rNode = (CRhinoTreeNode)rValue;
                nWidth += this.GetTreeGraphicWidth(rNode.getLevel(), rNode.GetTreePath());
            }
        }
        return nWidth;
    }

    private int GetTreeGraphicWidth(int nLevel, TreePath rTreePath) {
        int nWidth = 0;
        int nBorderWidth = 0;
        Insets rInsets = this.getInsets();
        if (rInsets != null) {
            nBorderWidth += rInsets.left + rInsets.right;
        }
        Rectangle rTreeCellBounds = null;
        if (rTreePath != null) {
            this.m_bGotExpander = true;
            rTreeCellBounds = this.m_rTree.getPathBounds(rTreePath);
            this.m_bGotExpander = false;
        }
        if (rTreeCellBounds != null) {
            int nNumOfPixelsForExpander = rTreeCellBounds.x;
            nWidth += nNumOfPixelsForExpander + nBorderWidth + 1;
        } else {
            Icon icoLeaf;
            Icon icoClosed;
            int nOpenWidth = 0;
            int nClosedWidth = 0;
            int nLeafWidth = 0;
            Icon icoOpen = this.getOpenIcon();
            if (icoOpen != null) {
                nOpenWidth = icoOpen.getIconWidth();
            }
            if ((icoClosed = this.getClosedIcon()) != null) {
                nClosedWidth = icoClosed.getIconWidth();
            }
            if ((icoLeaf = this.getLeafIcon()) != null) {
                nLeafWidth = icoLeaf.getIconWidth();
            }
            int nMaxWidth = Math.max(nOpenWidth, nClosedWidth);
            nMaxWidth = Math.max(nMaxWidth, nLeafWidth);
            nWidth += nMaxWidth * nLevel;
            nWidth += nBorderWidth;
            nWidth += 3 * nLevel + 1;
        }
        return nWidth;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_CELL_SIZE_BORDER = false;
    }
}

