/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.treetables;

import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CRhinoTreeTableProgressRenderer
extends JPanel
implements TableCellRenderer {
    protected int m_nVisibleRow;
    protected boolean m_bIsSelected;
    protected CRhinoTreeTable m_rTreeTable;
    private boolean m_bShowProgBar;
    protected JLabel m_ProgressIcon;
    protected JProgressBar m_ProgressBar;

    public CRhinoTreeTableProgressRenderer(CRhinoTreeTable rTreeTable, boolean bShowProgBar) {
        this.m_rTreeTable = rTreeTable;
        this.m_rTreeTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent rEvent) {
                CRhinoTreeTableProgressRenderer.this.OnUpdateSize();
            }
        });
        this.m_bShowProgBar = bShowProgBar;
        this.m_ProgressIcon = new JLabel();
        this.m_ProgressBar = new JProgressBar();
        this.m_ProgressBar.setIndeterminate(true);
        this.m_ProgressBar.setVisible(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(2).addComponent(this.m_ProgressIcon, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent(this.m_ProgressBar, -1, -2, Short.MAX_VALUE).addGap(2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(2).addGroup(layout.createParallelGroup().addComponent(this.m_ProgressIcon, -1, -2, Short.MAX_VALUE).addComponent(this.m_ProgressBar, -1, -2, Short.MAX_VALUE)).addGap(2));
    }

    private void OnUpdateSize() {
        if (this.m_rTreeTable != null) {
            TableColumn rCol;
            int nRenderCol = -1;
            for (int nCol = 0; nCol < this.m_rTreeTable.getColumnCount(); ++nCol) {
                if (this.m_rTreeTable.getCellRenderer(0, nCol) != this) continue;
                nRenderCol = nCol;
                break;
            }
            if (nRenderCol != -1 && (rCol = this.m_rTreeTable.getColumnModel().getColumn(nRenderCol)) != null) {
                int nWidth = rCol.getWidth();
                int nHeight = this.m_rTreeTable.getRowHeight() - this.m_rTreeTable.getIntercellSpacing().height;
                if (this.getBorder() != null && this.getBorder().getBorderInsets(this) != null) {
                    nHeight -= this.getBorder().getBorderInsets((Component)this).top + this.getBorder().getBorderInsets((Component)this).bottom;
                }
                this.m_ProgressIcon.setMinimumSize(new Dimension(nWidth - 1, nHeight));
            }
        }
    }

    public void SetShowProgBar(boolean bShowProgBar) {
        this.m_bShowProgBar = bShowProgBar;
    }

    protected boolean GetShowProgBar() {
        return this.m_bShowProgBar;
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rValue, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        Color clrBack = rTable.getBackground();
        if (bIsSelected) {
            this.m_ProgressIcon.setForeground(rTable.getSelectionForeground());
            clrBack = rTable.getSelectionBackground();
        } else {
            this.m_ProgressIcon.setForeground(rTable.getForeground());
            if (this.m_rTreeTable != null && this.m_rTreeTable.GetEnableRowColor()) {
                clrBack = nRow % 2 == 1 ? this.m_rTreeTable.GetRowColorOdd() : this.m_rTreeTable.GetRowColorEven();
            }
        }
        this.setBackground(clrBack);
        int nViewCol = nCol;
        nCol = rTable.convertColumnIndexToModel(nCol);
        this.m_nVisibleRow = nRow;
        this.m_bIsSelected = bIsSelected;
        Color clr = Color.DARK_GRAY;
        if (this.m_rTreeTable != null) {
            clr = this.m_rTreeTable.GetLeadSelectionColor();
        }
        Border rBorder = null;
        if (this.m_rTreeTable != null && nRow == this.m_rTreeTable.getSelectionModel().getLeadSelectionIndex()) {
            rBorder = BorderFactory.createLineBorder(clr, 1);
            if (nViewCol == 0) {
                Border rInsideBorder = BorderFactory.createEmptyBorder(0, 0, 0, 1);
                MatteBorder rOutsideBorder = BorderFactory.createMatteBorder(1, 1, 1, 0, clr);
                rBorder = BorderFactory.createCompoundBorder(rOutsideBorder, rInsideBorder);
            } else if (nViewCol == rTable.getColumnCount() - 1) {
                Border rInsideBorder = BorderFactory.createEmptyBorder(0, 1, 0, 0);
                MatteBorder rOutsideBorder = BorderFactory.createMatteBorder(1, 0, 1, 1, clr);
                rBorder = BorderFactory.createCompoundBorder(rOutsideBorder, rInsideBorder);
            } else {
                Border rInsideBorder = BorderFactory.createEmptyBorder(0, 1, 0, 1);
                MatteBorder rOutsideBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, clr);
                rBorder = BorderFactory.createCompoundBorder(rOutsideBorder, rInsideBorder);
            }
        } else {
            rBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        this.setBorder(rBorder);
        if (this.GetProgressIcon() != null) {
            this.GetProgressIcon().setVisible(!this.m_bShowProgBar);
        }
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setVisible(this.m_bShowProgBar);
        }
        return this;
    }

    protected JLabel GetProgressIcon() {
        return this.m_ProgressIcon;
    }

    protected JProgressBar GetProgressBar() {
        return this.m_ProgressBar;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimSize = super.getPreferredSize();
        if (!this.m_bShowProgBar) {
            if (this.GetProgressIcon() != null && this.GetProgressIcon().isVisible()) {
                dimSize = this.GetProgressIcon().getPreferredSize();
            }
        } else if (this.GetProgressBar() != null && this.GetProgressBar().isVisible()) {
            dimSize = this.GetProgressBar().getPreferredSize();
        }
        return dimSize;
    }
}

