/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.treetables;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoDestroy;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.dragdrop.CDndMsg;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CUpdateDynamicBtns;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.controls.treetables.CRhinoSharedSelectionModelList;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableTreeRenderer;
import com.rhinosoft.utils.CSpeedTest;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class CRhinoTreeTableModel
implements TableModel,
TreeModel,
TreeExpansionListener,
IRhinoOnMessage {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_DATA_UPDATES;
    public static boolean DEBUG_SPEED_REMOVE_NODES;
    public static final int COL_1 = 0;
    public static final int COL_2 = 1;
    public static final int COL_MAXIMUM = 2;
    private JTree m_rTree;
    protected CRhinoTreeNode m_RootNode;
    protected EventListenerList m_aListenerList;
    protected String[] m_asColHeaders;
    private CRhinoTreeTable m_rTreeTable;
    private CUpdateDynamicBtns m_rCurUpdateDynBtnMsg;

    public CRhinoTreeTableModel(CRhinoTreeTable rTreeTable) {
        this._CRhinoTreeTableModel(rTreeTable);
    }

    public CRhinoTreeTableModel(CRhinoTreeTable rTreeTable, JTree rTree) {
        this._CRhinoTreeTableModel(rTreeTable);
        this.SetTree(rTree);
    }

    private void _CRhinoTreeTableModel(CRhinoTreeTable rTreeTable) {
        this.m_rTreeTable = rTreeTable;
        this.m_aListenerList = new EventListenerList();
        this.InitTableHeaders();
    }

    public CRhinoTreeTable GetTreeTable() {
        return this.m_rTreeTable;
    }

    public void SetTree(JTree rTree) {
        if (this.m_rTree != null) {
            this.m_rTree.removeTreeExpansionListener(this);
        }
        this.m_rTree = rTree;
        this.m_rTree.addTreeExpansionListener(this);
    }

    public JTree GetTree() {
        return this.m_rTree;
    }

    public void SetRootNode(CRhinoTreeNode rRoot) {
        CRhinoTreeNode rOldRoot = this.m_RootNode = rRoot;
        this.m_RootNode = rRoot;
        if (rRoot == null && rOldRoot != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(rRoot);
        }
    }

    protected CRhinoTreeNode GetRootNode() {
        return this.m_RootNode;
    }

    @Override
    public synchronized int getRowCount() {
        int nRowCount = 0;
        if (this.GetTree() != null) {
            nRowCount = this.GetTree().getRowCount();
        }
        return nRowCount;
    }

    @Override
    public int getColumnCount() {
        int nColCount = 2;
        if (this.m_asColHeaders != null) {
            nColCount = this.m_asColHeaders.length;
        }
        return nColCount;
    }

    @Override
    public String getColumnName(int nColumnIndex) {
        return this.m_asColHeaders[nColumnIndex];
    }

    @Override
    public Class<?> getColumnClass(int nColumnIndex) {
        Class rRet = CRhinoTreeNode.class;
        if (nColumnIndex == this.GetColIndexTree()) {
            rRet = CRhinoTreeTableTreeRenderer.class;
        }
        return rRet;
    }

    @Override
    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        return this.GetTreeNode(nRowIndex);
    }

    @Override
    public void setValueAt(Object rValue, int nRowIndex, int nColumnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener rListener) {
        this.m_aListenerList.add(TableModelListener.class, rListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener rListener) {
        this.m_aListenerList.remove(TableModelListener.class, rListener);
    }

    protected void InitTableHeaders() {
        if (DEBUG) {
            CDebugLog.ASSERT(CRhinoTreeTableModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, you should derive and override!");
        }
        this.m_asColHeaders = new String[2];
        this.m_asColHeaders[this.GetColIndexTree()] = "<insert your column 1";
        this.m_asColHeaders[1] = "<insert your column 2";
    }

    protected int GetColIndexTree() {
        return 0;
    }

    public void fireTableDataChanged() {
        this.fireTableDataChanged(true);
    }

    protected void fireTableDataChanged(boolean bFireTreeEvent) {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableStructureChanged(true);
    }

    private void fireTableStructureChanged(boolean bFireTreeEvent) {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableRowsInserted(firstRow, lastRow, true);
    }

    private void fireTableRowsInserted(int firstRow, int lastRow, boolean bFireTreeEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableRowsUpdated(firstRow, lastRow, true);
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow, boolean bFireTreeEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableRowsDeleted(firstRow, lastRow, true);
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow, boolean bFireTreeEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableCellUpdated(row, column, true);
    }

    private void fireTableCellUpdated(int row, int column, boolean bFireTreeEvent) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.m_aListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    @Override
    public Object getRoot() {
        return this.m_RootNode;
    }

    @Override
    public Object getChild(Object rParent, int nIndex) {
        return ((TreeNode)rParent).getChildAt(nIndex);
    }

    @Override
    public int getChildCount(Object rParent) {
        return ((TreeNode)rParent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object rNode) {
        return ((TreeNode)rNode).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath rTreePath, Object rNewValue) {
        MutableTreeNode aNode = (MutableTreeNode)rTreePath.getLastPathComponent();
        aNode.setUserObject(rNewValue);
        this.nodeChanged(aNode);
    }

    @Override
    public int getIndexOfChild(Object rParent, Object rChild) {
        int nRet = -1;
        if (rParent != null && rChild != null) {
            nRet = ((TreeNode)rParent).getIndex((TreeNode)rChild);
        }
        return nRet;
    }

    @Override
    public void addTreeModelListener(TreeModelListener rListener) {
        this.m_aListenerList.add(TreeModelListener.class, rListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener rListener) {
        this.m_aListenerList.remove(TreeModelListener.class, rListener);
    }

    public void nodeChanged(TreeNode rNode) {
        if (this.m_aListenerList != null && rNode != null) {
            TreeNode rParent = rNode.getParent();
            if (rParent != null) {
                int anIndex = rParent.getIndex(rNode);
                if (anIndex != -1) {
                    int[] anIndexs = new int[]{anIndex};
                    this.nodesChanged(rParent, anIndexs);
                }
            } else if (rNode == this.getRoot()) {
                this.nodesChanged(rNode, null);
            }
        }
    }

    public void nodesChanged(TreeNode rNode, int[] anChildIndices) {
        if (rNode != null) {
            if (anChildIndices != null) {
                int nCount = anChildIndices.length;
                if (nCount > 0) {
                    Object[] aChildren = new Object[nCount];
                    for (int nCounter = 0; nCounter < nCount; ++nCounter) {
                        aChildren[nCounter] = rNode.getChildAt(anChildIndices[nCounter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(rNode), anChildIndices, aChildren);
                }
            } else if (rNode == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(rNode), null, null);
            }
        }
    }

    public TreeNode[] getPathToRoot(TreeNode rNode) {
        return this.getPathToRoot(rNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode rNode, int nDepth) {
        TreeNode[] arRetNodes;
        if (rNode == null) {
            if (nDepth == 0) {
                return null;
            }
            arRetNodes = new TreeNode[nDepth];
        } else {
            arRetNodes = rNode == this.m_RootNode ? new TreeNode[nDepth] : this.getPathToRoot(rNode.getParent(), ++nDepth);
            arRetNodes[arRetNodes.length - nDepth] = rNode;
        }
        return arRetNodes;
    }

    public CRhinoTreeNode GetTreeNode(int nRow) {
        TreePath rTreePath = this.GetTree().getPathForRow(nRow);
        CRhinoTreeNode rNode = this.GetTreeNode(rTreePath);
        return rNode;
    }

    public CRhinoTreeNode GetTreeNode(TreePath rTreePath) {
        Object rExpandedNode;
        CRhinoTreeNode rNode = null;
        if (rTreePath != null && (rExpandedNode = rTreePath.getLastPathComponent()) != null && rExpandedNode instanceof CRhinoTreeNode) {
            rNode = (CRhinoTreeNode)rExpandedNode;
        }
        return rNode;
    }

    private void FireTreeModelEvent(TREE_EVENT_TYPE nType, Object rSource, Object[] arPath, int[] anChildIndices, Object[] arChildren, boolean bFireTableEvent) {
        Object[] arListeners = this.m_aListenerList.getListenerList();
        TreeModelEvent rTreeEvent = null;
        block10: for (int nIdx = arListeners.length - 2; nIdx >= 0; nIdx -= 2) {
            if (arListeners[nIdx] != TreeModelListener.class) continue;
            if (rTreeEvent == null) {
                rTreeEvent = new TreeModelEvent(rSource, arPath, anChildIndices, arChildren);
            }
            switch (nType) {
                case NODES_CHANGED: {
                    ((TreeModelListener)arListeners[nIdx + 1]).treeNodesChanged(rTreeEvent);
                    continue block10;
                }
                case NODES_INSERTED: {
                    ((TreeModelListener)arListeners[nIdx + 1]).treeNodesInserted(rTreeEvent);
                    continue block10;
                }
                case NODES_REMOVED: {
                    ((TreeModelListener)arListeners[nIdx + 1]).treeNodesRemoved(rTreeEvent);
                    continue block10;
                }
                default: {
                    ((TreeModelListener)arListeners[nIdx + 1]).treeStructureChanged(rTreeEvent);
                }
            }
        }
        if (bFireTableEvent) {
            switch (nType) {
                case NODES_CHANGED: {
                    this.fireTableDataChanged(false);
                    break;
                }
                case NODES_INSERTED: {
                    this.fireTableDataChanged(false);
                    break;
                }
                case NODES_REMOVED: {
                    this.fireTableDataChanged(false);
                    break;
                }
                default: {
                    this.fireTableStructureChanged(false);
                }
            }
        }
    }

    protected void fireTreeNodesChanged(Object rSource, Object[] arPath, int[] anChildIndices, Object[] arChildren) {
        if (DEBUG_DATA_UPDATES) {
            System.out.println("CRhinoTreeTableModel - fireTreeNodesChanged");
        }
        this.FireTreeModelEvent(TREE_EVENT_TYPE.NODES_CHANGED, rSource, arPath, anChildIndices, arChildren, true);
    }

    protected void fireTreeNodesInserted(Object rSource, Object[] arPath, int[] anChildIndices, Object[] arChildren) {
        this.FireTreeModelEvent(TREE_EVENT_TYPE.NODES_INSERTED, rSource, arPath, anChildIndices, arChildren, true);
    }

    protected void fireTreeNodesRemoved(Object rSource, Object[] arPath, int[] anChildIndices, Object[] arChildren) {
        this.FireTreeModelEvent(TREE_EVENT_TYPE.NODES_REMOVED, rSource, arPath, anChildIndices, arChildren, true);
    }

    protected void fireTreeStructureChanged(Object rSource, Object[] arPath, int[] anChildIndices, Object[] arChildren) {
        this.FireTreeModelEvent(TREE_EVENT_TYPE.STRUCT_CHANGED, rSource, arPath, anChildIndices, arChildren, true);
    }

    protected void fireTreeStructureChanged(Object rSource, TreePath rTreePath) {
        this.fireTreeStructureChanged(rSource, rTreePath, true);
    }

    protected void fireTreeStructureChanged(Object rSource, TreePath rTreePath, boolean bFireTableEvent) {
        Object[] listeners = this.m_aListenerList.getListenerList();
        TreeModelEvent rTreeModelEvent = null;
        for (int nIdx = listeners.length - 2; nIdx >= 0; nIdx -= 2) {
            if (listeners[nIdx] != TreeModelListener.class) continue;
            if (rTreeModelEvent == null) {
                rTreeModelEvent = new TreeModelEvent(rSource, rTreePath);
            }
            ((TreeModelListener)listeners[nIdx + 1]).treeStructureChanged(rTreeModelEvent);
        }
        if (bFireTableEvent) {
            this.fireTableStructureChanged(false);
        }
    }

    public void nodeStructureChanged(TreeNode rNode) {
        if (rNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(rNode), null, null);
        }
    }

    public void insertNodeInto(CRhinoTreeNode rNewChild, CRhinoTreeNode rParent, int nIndex) {
        rParent.insert(rNewChild, nIndex);
        rNewChild.InitTreePath();
        int[] anNewIndexes = new int[]{nIndex};
        this.nodesWereInserted(rParent, anNewIndexes);
    }

    public void removeNodeFromParent(MutableTreeNode rNode) {
        CRhinoSharedSelectionModelList rSelModelTarget;
        CRhinoSharedSelectionModelList rSelModelSource;
        CSpeedTest sp;
        Object[] aRemovedArray;
        int[] anChildIndices;
        MutableTreeNode rParent;
        block10: {
            rParent = (MutableTreeNode)rNode.getParent();
            if (rParent == null) {
                throw new IllegalArgumentException("node does not have a parent.");
            }
            anChildIndices = new int[1];
            aRemovedArray = new Object[1];
            sp = null;
            if (DEBUG_SPEED_REMOVE_NODES) {
                sp = new CSpeedTest();
                sp.Start();
            }
            rSelModelSource = null;
            rSelModelTarget = null;
            try {
                rSelModelSource = this.GetTreeTable().GetListSelectionModel();
                rSelModelTarget = (CRhinoSharedSelectionModelList)rSelModelSource.clone();
            }
            catch (Exception e) {
                if (!DEBUG) break block10;
                e.printStackTrace();
            }
        }
        int nRemoveRow = -1;
        if (rNode instanceof CRhinoTreeNode) {
            nRemoveRow = this.GetRow((CRhinoTreeNode)rNode);
        }
        if (this.IsValidRow(nRemoveRow) && rSelModelTarget != null) {
            if (this.GetTreeTable().isRowSelected(nRemoveRow)) {
                rSelModelTarget.removeSelectionInterval(nRemoveRow, nRemoveRow);
            }
            rSelModelTarget.SetSkipUpdates(true);
            rSelModelTarget.removeIndexInterval(nRemoveRow, nRemoveRow);
            rSelModelTarget.SetSkipUpdates(false);
        }
        anChildIndices[0] = rParent.getIndex(rNode);
        rParent.remove(anChildIndices[0]);
        aRemovedArray[0] = rNode;
        rSelModelSource.LockUpdates();
        this.nodesWereRemoved(rParent, anChildIndices, aRemovedArray);
        rSelModelSource.UnlockUpdates();
        if (rNode instanceof IRhinoDestroy) {
            ((IRhinoDestroy)((Object)rNode)).Destroy();
        }
        if (this.GetTreeTable() != null && rSelModelTarget != null) {
            this.GetTreeTable().SetSelectionModel(rSelModelTarget);
        }
        if (DEBUG_SPEED_REMOVE_NODES) {
            sp.Stop();
            sp.PrintResults("removeNodeFromParent - redoing selection model");
        }
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.m_aListenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.fireTableDataChanged();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.fireTableDataChanged();
    }

    public boolean IsValidRow(int nRow) {
        return nRow >= 0 && nRow < this.getRowCount();
    }

    public void fireTreeNodesChanged(CRhinoTreeNode rNode) {
        this.fireTreeNodesChanged(this, this.getPathToRoot(rNode), null, null);
    }

    protected boolean AddChild(CRhinoTreeNode rParentNode, CRhinoTreeNode rChildNode, boolean bAppend) {
        boolean bAdded = false;
        if (rParentNode != null && rChildNode != null) {
            bAdded = rChildNode.Add(rParentNode, bAppend);
        }
        return bAdded;
    }

    protected boolean RemoveChild(CRhinoTreeNode rParentNode, CRhinoTreeNode rChildNode) {
        boolean bRemoved = false;
        if (rParentNode != null && rChildNode != null) {
            bRemoved = rChildNode.Remove(rParentNode);
        }
        return bRemoved;
    }

    protected void OnCreate() {
    }

    public void OnDestroy() {
    }

    protected void OnMessage(CAttrMsg rMsg, boolean bRelayToNodes) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4020: {
                    this.OnCreate();
                    break;
                }
                case 4021: {
                    this.OnDestroy();
                    break;
                }
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
                case 4500: {
                    CDndMsg rDndMsg = (CDndMsg)rMsg;
                    this.OnDnDInitDragData(rDndMsg);
                    bRelayToNodes = false;
                    break;
                }
                case 4501: {
                    CDndMsg rDndMsg = (CDndMsg)rMsg;
                    this.OnDnDInitDropData(rDndMsg);
                    bRelayToNodes = false;
                    break;
                }
                case 4502: {
                    CDndMsg rDndMsg = (CDndMsg)rMsg;
                    this.OnDnDImportDropData(rDndMsg);
                    bRelayToNodes = false;
                    break;
                }
            }
        }
        if (bRelayToNodes) {
            this.OnMessage(this.GetRootNode(), rMsg);
        }
    }

    protected IArchive GetArchive() {
        CRhinoArchive rArchive = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rArchive = CRhinoApp.GET_RHINO_APP().GetArchive();
        }
        return rArchive;
    }

    protected void OnLoadAttrs() {
    }

    protected void OnSaveAttrs() {
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        this.OnMessage(rMsg, true);
    }

    protected void OnMessage(CRhinoTreeNode rNode, CAttrMsg rMsg) {
        Object rNextTransferTreeNode = null;
        if (rNode != null) {
            rNode.OnMessage(rMsg);
            if (rNode.getChildCount() > 0) {
                for (int nIdx = 0; nIdx < rNode.getChildCount() && rNextTransferTreeNode == null; ++nIdx) {
                    CRhinoTreeNode rChild = (CRhinoTreeNode)rNode.getChildAt(nIdx);
                    this.OnMessage(rChild, rMsg);
                }
            }
        }
    }

    public int GetRow(CRhinoTreeNode rNode) {
        int nRow = -1;
        JTree rTree = this.GetTree();
        if (rTree != null && rNode != null) {
            nRow = rTree.getRowForPath(rNode.GetTreePath());
        }
        return nRow;
    }

    public void RepaintRow(CRhinoTreeNode rNode) {
        int nRow = this.GetRow(rNode);
        if (nRow >= 0) {
            this.fireTableRowsUpdated(nRow, nRow);
        }
    }

    public CUpdateDynamicBtns CreateUpdateDynamicBtnMsg() {
        return new CUpdateDynamicBtns(this.GetTreeTable());
    }

    public boolean InitUpdateDynamicBtnMsg(CUpdateDynamicBtns rMsg) {
        boolean bSomethingChanged = true;
        CUpdateDynamicBtns rPrevUpdateDynBtnMsg = this.m_rCurUpdateDynBtnMsg;
        this.m_rCurUpdateDynBtnMsg = rMsg;
        bSomethingChanged = !rMsg.IsMatch(rPrevUpdateDynBtnMsg);
        return bSomethingChanged;
    }

    public boolean IsSelected(CRhinoTreeNode rTreeNode) {
        boolean bIsSelected = false;
        if (this.GetTreeTable() != null) {
            bIsSelected = this.GetTreeTable().IsSelected(rTreeNode);
        }
        return bIsSelected;
    }

    public void StartRefreshTimer() {
        if (this.GetTreeTable() != null) {
            this.GetTreeTable().StartRefreshTimer();
        }
    }

    protected abstract void OnDnDInitDragData(CDndMsg var1);

    protected abstract boolean OnDnDInitDropData(CDndMsg var1);

    protected abstract boolean OnDnDImportDropData(CDndMsg var1);

    public void OnKeyDelete() {
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DATA_UPDATES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SPEED_REMOVE_NODES = false;
    }

    static enum TREE_EVENT_TYPE {
        NODES_CHANGED,
        NODES_INSERTED,
        NODES_REMOVED,
        STRUCT_CHANGED;

    }
}

