/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.treetables;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.archive.IArchive;
import com.rhinosoft.archive.IArchiveObj;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.attrs.CObjectAttr;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.dragdrop.CFilesDragDropHandler;
import com.rhinosoft.dragdrop.CRhinoDragDropHandler;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CCacheMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.messages.CUpdateDynamicBtns;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.applet.CRhinoApplet;
import com.rhinosoft.ui.controls.CTypeAhead;
import com.rhinosoft.ui.controls.grids.CRhinoTable;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.controls.treetables.CRhinoSharedSelectionModelList;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableCellRenderer;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableHeaderRenderer;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableModel;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableTreeNodeRenderer;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableTreeRenderer;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableViewport;
import com.rhinosoft.ui.controls.treetables.CTypeAhead_TreeTable;
import com.rhinosoft.utils.CSpeedTest;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

public abstract class CRhinoTreeTable
extends JTable
implements IRhinoOnMessage,
IArchiveObj,
ActionListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static boolean DEBUG = CAttr.DEBUG;
    private static boolean DEBUG_SELECTION_EVENTS;
    private static boolean DEBUG_LOAD_COLS;
    private static boolean DEBUG_COL_WIDTHS;
    public static boolean DEBUG_SPEED;
    public static boolean DEBUG_MOUSE_EVENT;
    private static boolean DEBUG_TRACK_DND_DRAG_EVENTS;
    private static boolean DEBUG_TRACK_IMPORT_DATA;
    protected static final int DEF_ROW_HEIGHT = 20;
    protected static final Color DEF_LEAD_SELECTION_COLOR;
    public static final int DEF_COL_WIDTH = 90;
    private boolean m_bDoLayoutValid = false;
    private boolean m_bUseOurPopupMenu = true;
    private CRhinoTreeTableModel m_Model;
    private CRhinoSharedSelectionModelList m_ListSelModel;
    private CRhinoTreeTableTreeRenderer m_TreeRenderer;
    private CRhinoTreeTableTreeNodeRenderer m_TreeNodeRenderer;
    private CRhinoTreeTableHeaderRenderer m_TableHeaderRenderer;
    private CRhinoTreeTableCellRenderer m_TableCellRenderer;
    private Color m_clrLeadSelection;
    private CObjectAttr m_ObjectAttr;
    private Timer m_SaveTimer;
    private Timer m_RefreshTimer;
    private Timer m_UpdateBtnTimer;
    private JPopupMenu m_cPopupMenu;
    private CRhinoTreeTableViewport m_rTreeTableViewport;
    private CRhinoDragDropHandler m_DragDropHandler;
    private MouseEvent m_FirstMouseEvent;
    private CTypeAhead m_TypeAhead;
    private int[] m_aStartupColWidths = null;
    private boolean m_bColWidthsAreSet = false;
    private CSpeedTest m_SpeedTest = new CSpeedTest();

    public CRhinoTreeTable() {
        this._CRhinoTreeTable();
    }

    public void _CRhinoTreeTable() {
        this.m_ObjectAttr = new CObjectAttr();
        this.m_ObjectAttr.SetObject(this);
        this.InitModel();
        this.InitHeaderRenderer();
        this.InitLeadSelectionColor();
        this.InitSaveTimer();
        this.InitRefreshTimer();
        this.InitUpdateBtnTimer();
        this.m_cPopupMenu = this.CreatePopupMenu();
        this.m_bUseOurPopupMenu = true;
        this.m_TypeAhead = this.CreateTypeAhead();
        this.addKeyListener(this);
        this.InitDragDrop();
        this.addMouseMotionListener(this);
    }

    protected CRhinoTreeTableHeaderRenderer CreateHeaderRenderer() {
        return new CRhinoTreeTableHeaderRenderer();
    }

    protected void InitHeaderRenderer() {
        JTableHeader rHeader;
        this.m_TableHeaderRenderer = this.CreateHeaderRenderer();
        if (this.m_TableHeaderRenderer != null && (rHeader = this.getTableHeader()) != null) {
            this.m_TableHeaderRenderer.UpdateUIRenderer();
            rHeader.setDefaultRenderer(this.m_TableHeaderRenderer);
            rHeader.addMouseListener(this);
        }
    }

    private void InitModel() {
        this.m_Model = this.CreateModel();
        if (this.GetModel() != null) {
            this.setModel(this.GetModel());
        }
        this.InitTree();
        this.InitSelectionModel();
        this.setAutoResizeMode(0);
    }

    protected abstract CRhinoTreeTableModel CreateModel();

    public CRhinoTreeTableModel GetModel() {
        return this.m_Model;
    }

    private void InitTree() {
        if (this.m_Model != null) {
            this.m_TreeRenderer = this.CreateTreeRenderer();
            this.m_Model.SetTree(this.m_TreeRenderer);
            this.setDefaultRenderer(CRhinoTreeTableTreeRenderer.class, this.m_TreeRenderer);
            this.m_TableCellRenderer = this.CreateTableCellRenderer();
            this.setDefaultRenderer(CRhinoTreeNode.class, this.m_TableCellRenderer);
            this.m_TreeNodeRenderer = this.CreateTreeNodeRenderer();
            this.m_TreeRenderer.setCellRenderer(this.m_TreeNodeRenderer);
        }
        if (this.GetTreeRenderer() != null) {
            this.GetTreeRenderer().setRowHeight(this.GetDefaultRowHeight());
        }
    }

    protected CRhinoTreeTableTreeRenderer CreateTreeRenderer() {
        return new CRhinoTreeTableTreeRenderer(this.m_Model, this, this.GetDefaultRowHeight());
    }

    protected CRhinoTreeTableTreeNodeRenderer CreateTreeNodeRenderer() {
        return new CRhinoTreeTableTreeNodeRenderer(this.GetTreeRenderer(), this);
    }

    protected CRhinoTreeTableTreeNodeRenderer GetTreeNodeRenderer() {
        return this.m_TreeNodeRenderer;
    }

    protected JViewport GetViewport() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
    }

    protected CRhinoTreeTableViewport GetTreeTableViewport() {
        return this.m_rTreeTableViewport;
    }

    protected void SetTreeTableViewport(CRhinoTreeTableViewport rViewport) {
        this.m_rTreeTableViewport = rViewport;
    }

    protected CRhinoTreeTableCellRenderer CreateTableCellRenderer() {
        return new CRhinoTreeTableCellRenderer(this);
    }

    protected CRhinoTreeTableCellRenderer GetTableCellRenderer() {
        return this.m_TableCellRenderer;
    }

    private void InitSelectionModel() {
        if (this.m_TreeRenderer != null) {
            this.m_TreeRenderer.setSelectionModel(null);
        }
        this.SetSelectionModel(new CRhinoSharedSelectionModelList(this.GetModel()));
    }

    public void SetSelectionModel(CRhinoSharedSelectionModelList rSelModel) {
        this.m_ListSelModel = rSelModel;
        this.setSelectionModel(this.m_ListSelModel);
    }

    protected CRhinoSharedSelectionModelList GetListSelectionModel() {
        return this.m_ListSelModel;
    }

    public CRhinoTreeTableTreeRenderer GetTreeRenderer() {
        return this.m_TreeRenderer;
    }

    @Override
    public void valueChanged(ListSelectionEvent rListSelectionEvent) {
        super.valueChanged(rListSelectionEvent);
        if (DEBUG_SELECTION_EVENTS) {
            int[] anSelRows = this.getSelectedRows();
            if (anSelRows != null && anSelRows.length > 0) {
                for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                    int nRow = anSelRows[nIdx];
                    if (this.GetModel() == null || !this.GetModel().IsValidRow(nRow)) continue;
                    System.out.printf("Row is selected: %d\r\n", nRow);
                }
            } else {
                System.out.println("No Rows are selected!");
            }
        }
        if (!rListSelectionEvent.getValueIsAdjusting()) {
            this.OnChangedSelection();
        }
    }

    protected void OnChangedSelection() {
        this.StartUpdateBtnTimer();
    }

    protected void SendUpdateDynamicBtns() {
        CUpdateDynamicBtns rMsg = null;
        if (this.GetModel() != null) {
            rMsg = this.GetModel().CreateUpdateDynamicBtnMsg();
            this.GetModel().InitUpdateDynamicBtnMsg(rMsg);
        }
        if (rMsg != null && CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().OnMessage(rMsg);
        }
    }

    protected int GetDefaultRowHeight() {
        return 20;
    }

    public void SetLeadSelectionColor(Color clr) {
        this.m_clrLeadSelection = clr;
    }

    public Color GetLeadSelectionColor() {
        return this.m_clrLeadSelection;
    }

    protected void InitLeadSelectionColor() {
        this.SetLeadSelectionColor(DEF_LEAD_SELECTION_COLOR);
    }

    @Override
    public void setIntercellSpacing(Dimension intercellSpacing) {
        super.setIntercellSpacing(intercellSpacing);
        this.RefreshRowHeight();
    }

    @Override
    public void setRowHeight(int nRowHeight) {
        Dimension dimIntercellSpacing = this.getIntercellSpacing();
        super.setRowHeight(nRowHeight + dimIntercellSpacing.height);
    }

    protected void RefreshRowHeight() {
        if (this.GetTreeRenderer() != null) {
            this.GetTreeRenderer().setRowHeight(this.getRowHeight());
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        CRhinoEvent rEvent;
        if (event instanceof CRhinoEvent && (rEvent = (CRhinoEvent)event).getSource() instanceof CAttrMsg) {
            CAttrMsg rMsg = (CAttrMsg)rEvent.getSource();
            this.OnMessage(rMsg);
        }
        super.processEvent(event);
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (this.GetModel() != null) {
            this.GetModel().OnMessage(rMsg);
        }
        if (this.GetTreeRenderer() != null) {
            this.GetTreeRenderer().OnMessage(rMsg);
        }
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4020: {
                    this.OnCreate();
                    break;
                }
                case 4022: {
                    this.OnInitialUpdate();
                    break;
                }
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
                case 4235: {
                    if (!(rMsg instanceof CCacheMsg)) break;
                    CCacheMsg rCacheMsg = (CCacheMsg)rMsg;
                    this.OnRecvCacheImage(rCacheMsg.GetFileName());
                    break;
                }
                case 4024: {
                    CUpdateDynamicBtns rBtnMsg = (CUpdateDynamicBtns)rMsg;
                    if (rBtnMsg.GetSource() != this) break;
                    this.OnUpdateDynamicBtns(rBtnMsg);
                    break;
                }
                case 3104: {
                    this.updateUI();
                    break;
                }
                case 3102: {
                    this.OnInvertSelection();
                    break;
                }
                case 8004: {
                    if (this.getTableHeader() == null) break;
                    this.getTableHeader().repaint();
                    break;
                }
                case 3494: {
                    if (rMsg instanceof CUIMessage) {
                        CUIMessage rUIMsg = (CUIMessage)rMsg;
                        if (rUIMsg.GetSource() != this) break;
                        if (rUIMsg.GetAttachedObject() instanceof Point) {
                            Point ptLoc = (Point)rUIMsg.GetAttachedObject();
                            this.LoadPopupMenu();
                            this.EndWaitCursor();
                            this.GetPopupMenu().show(this, ptLoc.x, ptLoc.y);
                            break;
                        }
                        if (!DEBUG) break;
                        CDebugLog.ASSERT(CRhinoTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                        break;
                    }
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CRhinoTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
                    break;
                }
            }
        }
    }

    protected void OnCreate() {
        this.InitColumnIdentifiers();
        if (this.GetViewport() != null) {
            this.GetViewport().addMouseListener(this);
        }
        this.addMouseListener(this);
        if (this.GetTreeTableViewport() != null) {
            this.GetTreeTableViewport().OnMessage(new CWorkerThreadMsg(3523));
        }
        this.SendUpdateDynamicBtns();
    }

    protected void InitColumnIdentifiers() {
        TableColumnModel rColModel = this.getColumnModel();
        if (rColModel != null) {
            if (rColModel.getColumnCount() != this.GetModel().getColumnCount() && DEBUG) {
                CDebugLog.ASSERT(CRhinoTreeTable.class.getName(), CDebugLog.GetLineNumber(), "These have to match in order for us to set the appropriate column identifiers");
            }
            for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                TableColumn rColumn = rColModel.getColumn(nIdx);
                if (rColumn == null) continue;
                rColumn.setIdentifier(nIdx);
            }
        }
    }

    protected void OnInitialUpdate() {
        if (DEBUG_COL_WIDTHS) {
            System.out.println("OnInitialUpdate -->");
        }
        if (DEBUG_COL_WIDTHS) {
            System.out.println("OnInitialUpdate <--");
        }
    }

    @Override
    public void OnLoadAttrs() {
        IArchive rArchive = this.GetArchive();
        if (rArchive != null) {
            this.LoadColIndices(rArchive);
            this.LoadColWidths(rArchive);
        }
    }

    @Override
    public void OnSaveAttrs() {
        IArchive rArchive;
        if (DEBUG_COL_WIDTHS) {
            System.out.println("OnSaveAttrs -->");
        }
        if ((rArchive = this.GetArchive()) != null) {
            if (DEBUG_COL_WIDTHS) {
                CDebugLog.INFO("m_bDoLayoutValid = " + Boolean.toString(this.m_bDoLayoutValid));
            }
            this.SaveColIndices(rArchive);
            this.SaveColWidths(rArchive);
        }
        if (DEBUG_COL_WIDTHS) {
            System.out.println("OnSaveAttrs <--");
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        this.StartSaveTimer();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        this.StartSaveTimer();
    }

    private void LoadColWidths(IArchive rArchive) {
        if (rArchive != null) {
            int nDefColWidth;
            String sAreSetKey = "TransferColWidthsAreSet";
            Boolean rbColWidthsAreSet = rArchive.GetValueBool(sAreSetKey, false);
            if (rbColWidthsAreSet != null) {
                this.m_bColWidthsAreSet = rbColWidthsAreSet;
            }
            if (this.getColumnModel() != null) {
                this.getColumnModel().removeColumnModelListener(this);
            }
            int nColCount = this.GetModel().getColumnCount();
            if (this.m_aStartupColWidths == null && nColCount > 0) {
                this.m_aStartupColWidths = new int[nColCount];
            }
            int nColWidth = nDefColWidth = this.GetDefColWidth(true);
            for (int nModelCol = 0; nModelCol < nColCount; ++nModelCol) {
                TableColumn rColumn;
                this.m_aStartupColWidths[nModelCol] = nColWidth = nDefColWidth;
                String sKey = this.GetKeyColWidth(nModelCol);
                Integer nStoredColWidth = rArchive.GetValueInt(sKey, nColWidth);
                if (nStoredColWidth != null) {
                    nColWidth = nStoredColWidth;
                }
                if ((rColumn = this.GetColumn(nModelCol)) == null) continue;
                rColumn.setPreferredWidth(nColWidth);
            }
            if (this.getColumnModel() != null) {
                this.getColumnModel().addColumnModelListener(this);
            }
        }
    }

    private void SaveColWidths(IArchive rArchive) {
        if (rArchive != null) {
            int nDefColWidth;
            boolean bCanSaveWidth = true;
            int nColWidth = nDefColWidth = this.GetDefColWidth(true);
            if (DEBUG_COL_WIDTHS) {
                System.out.println("SaveColWidths | Default ColWidth: " + nDefColWidth);
            }
            for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
                nColWidth = nDefColWidth;
                bCanSaveWidth = true;
                TableColumn rColumn = this.GetColumn(nModelCol);
                if (rColumn != null) {
                    nColWidth = rColumn.getWidth();
                }
                if (this.m_aStartupColWidths != null && this.m_aStartupColWidths.length == this.GetModel().getColumnCount() && nColWidth == this.m_aStartupColWidths[nModelCol]) {
                    bCanSaveWidth = false;
                }
                if (!bCanSaveWidth && this.m_bColWidthsAreSet) {
                    bCanSaveWidth = true;
                }
                if (!bCanSaveWidth) continue;
                String sAreSetKey = "TransferColWidthsAreSet";
                rArchive.SetValue(sAreSetKey, true, false);
                this.m_bColWidthsAreSet = true;
                String sKey = this.GetKeyColWidth(nModelCol);
                rArchive.SetValue(sKey, nColWidth, nDefColWidth);
            }
        }
    }

    private void LoadColIndices(IArchive rArchive) {
        if (rArchive != null) {
            if (this.getColumnModel() != null) {
                this.getColumnModel().removeColumnModelListener(this);
            }
            if (this.GetModel().getColumnCount() > 0) {
                int[] anViewIndices = new int[this.GetModel().getColumnCount()];
                for (int i = 0; i < anViewIndices.length; ++i) {
                    anViewIndices[i] = -1;
                }
                for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
                    String sKey = this.GetKeyColIndex(nModelCol);
                    Integer nStoredColIndex = rArchive.GetValueInt(sKey, nModelCol);
                    if (nStoredColIndex == null) continue;
                    if (nStoredColIndex < 0) {
                        nStoredColIndex = nModelCol;
                    }
                    anViewIndices[nModelCol] = nStoredColIndex;
                }
                int nSubtractHiddenCol = 0;
                int nMoveToColumn = 0;
                for (int nNextColumn = 0; nNextColumn < this.GetModel().getColumnCount(); ++nNextColumn) {
                    nMoveToColumn = nNextColumn;
                    int nModelIdx = -1;
                    for (int nNextIdx = 0; nNextIdx < anViewIndices.length && nModelIdx == -1; ++nNextIdx) {
                        int nNextViewIdx = anViewIndices[nNextIdx];
                        if (nNextViewIdx != nNextColumn) continue;
                        nModelIdx = nNextIdx;
                    }
                    int nCurViewColumn = this.convertColumnIndexToView(nModelIdx);
                    if (nCurViewColumn < 0 || nCurViewColumn > this.GetModel().getColumnCount() - 1) {
                        --nSubtractHiddenCol;
                    }
                    nMoveToColumn += nSubtractHiddenCol;
                    if (DEBUG_LOAD_COLS) {
                        System.out.printf("NextColumn: %d | ModelColumn: %d | CurViewColumn: %d | MoveToColumn: %d\r\n", nNextColumn, nModelIdx, nCurViewColumn, nMoveToColumn);
                    }
                    if (nCurViewColumn <= -1 || nCurViewColumn >= this.GetModel().getColumnCount() || nCurViewColumn == nMoveToColumn) continue;
                    try {
                        this.moveColumn(nCurViewColumn, nMoveToColumn);
                        continue;
                    }
                    catch (Exception e) {
                        if (!DEBUG) continue;
                        e.printStackTrace();
                    }
                }
            }
            if (this.getColumnModel() != null) {
                this.getColumnModel().addColumnModelListener(this);
            }
        }
    }

    private void SaveColIndices(IArchive rArchive) {
        if (rArchive != null) {
            for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
                int nDefColIndex = nModelCol;
                int nViewColIdx = -1;
                try {
                    nViewColIdx = this.convertColumnIndexToView(nModelCol);
                }
                catch (Exception e) {
                    nViewColIdx = nModelCol;
                }
                if (rArchive == null) continue;
                String sKey = this.GetKeyColIndex(nModelCol);
                rArchive.SetValue(sKey, nViewColIdx, nDefColIndex);
            }
        }
    }

    protected IArchive GetArchive() {
        CRhinoArchive rArchive = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rArchive = CRhinoApp.GET_RHINO_APP().GetArchive();
        }
        return rArchive;
    }

    protected String GetKeyColIndex(int nModelCol) {
        String sKey = null;
        return sKey;
    }

    protected String GetKeyColWidth(int nModelCol) {
        String sKey = null;
        return sKey;
    }

    private TableColumn GetColumn(int nColID) {
        TableColumn rColumn;
        block3: {
            rColumn = null;
            TableColumnModel rColModel = this.getColumnModel();
            if (rColModel != null) {
                try {
                    int nColIdx = rColModel.getColumnIndex(nColID);
                    rColumn = rColModel.getColumn(nColIdx);
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    CDebugLog.EXCEPTION(CRhinoTreeTable.class.getName(), CDebugLog.GetLineNumber(), String.format("Exception: %s\r\n", e.getMessage()), false);
                    e.printStackTrace();
                }
            }
        }
        return rColumn;
    }

    private int GetDefColWidth(boolean bUseAppletWidth) {
        int nColWidth = 90;
        int nDivideBy = this.GetModel().getColumnCount();
        TableColumnModel rColModel = this.getColumnModel();
        if (rColModel != null) {
            nDivideBy = rColModel.getColumnCount();
        }
        int nViewportWidth = this.GetTableViewportWidth(bUseAppletWidth);
        if (nDivideBy > 0) {
            nColWidth = nViewportWidth / nDivideBy;
        }
        if (nColWidth < 1) {
            nColWidth = 90;
        }
        return nColWidth;
    }

    private JScrollBar GetVerticalScrollBar() {
        JScrollBar rScrollBar = null;
        int nCompCount = this.getComponentCount();
        for (int nIdx = 0; nIdx < nCompCount && rScrollBar == null; ++nIdx) {
            JScrollBar rTempScrollBar;
            Component rNextComp = this.getComponent(nIdx);
            if (rNextComp == null || !(rNextComp instanceof JScrollBar) || (rTempScrollBar = (JScrollBar)rNextComp).getOrientation() != 1) continue;
            rScrollBar = rTempScrollBar;
        }
        return rScrollBar;
    }

    private int GetVerticalScrollBarWidth(boolean bGetUIDefaultValue) {
        int nWidth = 0;
        if (bGetUIDefaultValue) {
            try {
                Object objWidth = UIManager.getDefaults().get("ScrollBar.width");
                Integer nScrollBarWidth = (Integer)objWidth;
                nWidth = nScrollBarWidth;
            }
            catch (Exception exception) {}
        } else if (this.GetVerticalScrollBar() != null) {
            nWidth = this.GetVerticalScrollBar().getWidth();
        }
        return nWidth;
    }

    private boolean IsVerticalScrollBarVisible() {
        boolean bIsVisible = false;
        if (this.GetVerticalScrollBar() != null) {
            bIsVisible = this.GetVerticalScrollBar().isVisible();
        }
        return bIsVisible;
    }

    private int GetTableViewportWidth(boolean bUseAppletWidth) {
        int nWidth = 0;
        JViewport rViewport = this.GetViewport();
        if (rViewport != null) {
            nWidth = rViewport.getWidth();
        }
        if (DEBUG_COL_WIDTHS) {
            System.out.println("Viewport Width: " + nWidth);
        }
        int nAppletWidth = 0;
        JApplet rApplet = (JApplet)SwingUtilities.getAncestorOfClass(JApplet.class, this);
        if (rApplet == null) {
            rApplet = CRhinoApplet.GET_RHINO_APPLET();
        }
        if (rApplet != null) {
            nAppletWidth = rApplet.getWidth();
            if (DEBUG_COL_WIDTHS) {
                System.out.println("Applet Width: " + nAppletWidth);
            }
        }
        if (nWidth < 1 || bUseAppletWidth) {
            nWidth = nAppletWidth;
        }
        return nWidth -= this.GetVerticalScrollBarWidth(true);
    }

    private Timer GetSaveTimer() {
        return this.m_SaveTimer;
    }

    private void InitSaveTimer() {
        if (this.GetSaveTimer() == null) {
            this.m_SaveTimer = new Timer(1000, this);
            this.m_SaveTimer.setRepeats(false);
        }
    }

    private void StartSaveTimer() {
        if (this.GetSaveTimer() != null && this.m_bDoLayoutValid) {
            if (this.GetSaveTimer().isRunning()) {
                this.GetSaveTimer().restart();
            } else {
                this.GetSaveTimer().start();
            }
        }
    }

    @Override
    public void doLayout() {
        if (DEBUG_COL_WIDTHS) {
            System.out.println("doLayout -->");
        }
        super.doLayout();
        this.m_bDoLayoutValid = true;
        if (DEBUG_COL_WIDTHS) {
            System.out.println("doLayout <--");
        }
    }

    private Timer GetRefreshTimer() {
        return this.m_RefreshTimer;
    }

    private void InitRefreshTimer() {
        if (this.GetRefreshTimer() == null) {
            this.m_RefreshTimer = new Timer(100, this);
            this.m_RefreshTimer.setRepeats(false);
        }
    }

    public void StartRefreshTimer() {
        if (this.GetRefreshTimer() != null && !this.GetRefreshTimer().isRunning()) {
            this.GetRefreshTimer().start();
        }
    }

    private Timer GetUpdateBtnTimer() {
        return this.m_UpdateBtnTimer;
    }

    private void InitUpdateBtnTimer() {
        if (this.GetUpdateBtnTimer() == null) {
            this.m_UpdateBtnTimer = new Timer(250, this);
            this.m_UpdateBtnTimer.setRepeats(false);
        }
    }

    public void StartUpdateBtnTimer() {
        if (this.GetUpdateBtnTimer() != null) {
            if (this.GetUpdateBtnTimer().isRunning()) {
                this.GetUpdateBtnTimer().restart();
            } else {
                this.GetUpdateBtnTimer().start();
            }
        }
    }

    public void StopUpdateBtnTimer() {
        if (this.GetUpdateBtnTimer() != null && this.GetUpdateBtnTimer().isRunning()) {
            this.GetUpdateBtnTimer().stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent.getSource() == this.GetSaveTimer()) {
            this.OnSaveAttrs();
        } else if (rEvent.getSource() == this.GetRefreshTimer()) {
            this.repaint();
        } else if (rEvent.getSource() == this.GetUpdateBtnTimer()) {
            this.SendUpdateDynamicBtns();
        }
    }

    protected CBoolAttr GetAttr_EnableRowColors() {
        CBoolAttr rAttr = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rAttr = CRhinoApp.GET_RHINO_APP().GetAttr_TransferRowsEnableColor();
        }
        return rAttr;
    }

    public boolean GetEnableRowColor() {
        boolean bEnableRowClr = false;
        if (this.GetAttr_EnableRowColors() != null) {
            bEnableRowClr = this.GetAttr_EnableRowColors().GetValue();
        }
        return bEnableRowClr;
    }

    public void SetEnableRowColor(boolean bEnable) {
        if (this.GetAttr_EnableRowColors() != null) {
            this.GetAttr_EnableRowColors().SetValue(bEnable);
        }
    }

    protected CColorAttr GetAttr_OddRowColor() {
        CColorAttr rAttr = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rAttr = CRhinoApp.GET_RHINO_APP().GetAttr_TransferRowColorOdd();
        }
        return rAttr;
    }

    protected CColorAttr GetAttr_EvenRowColor() {
        CColorAttr rAttr = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rAttr = CRhinoApp.GET_RHINO_APP().GetAttr_TransferRowColorEven();
        }
        return rAttr;
    }

    public Color GetRowColorEven() {
        Color clrRow = UIManager.getColor("Table.background");
        if (clrRow == null) {
            clrRow = Color.WHITE;
        }
        if (this.GetAttr_EvenRowColor() != null) {
            clrRow = this.GetAttr_EvenRowColor().GetValue();
        }
        return clrRow;
    }

    public void SetRowColorEven(Color rClr) {
        if (this.GetAttr_EvenRowColor() != null) {
            this.GetAttr_EvenRowColor().SetValue(rClr);
        }
    }

    public Color GetRowColorOdd() {
        Color clrRow = UIManager.getColor("Table.background");
        if (clrRow == null) {
            clrRow = Color.WHITE;
        }
        if (this.GetAttr_OddRowColor() != null) {
            clrRow = this.GetAttr_OddRowColor().GetValue();
        }
        return clrRow;
    }

    public void SetRowColorOdd(Color rClr) {
        if (this.GetAttr_OddRowColor() != null) {
            this.GetAttr_OddRowColor().SetValue(rClr);
        }
    }

    @Override
    public void mouseClicked(MouseEvent rEvent) {
        if (rEvent != null) {
            Object objSource = rEvent.getSource();
            boolean bCtrlKeyDown = rEvent.isControlDown();
            boolean bShiftKeyDown = rEvent.isShiftDown();
            int nClickCount = rEvent.getClickCount();
            if (nClickCount == 2) {
                if (SwingUtilities.isLeftMouseButton(rEvent)) {
                    this.OnLeftDoubleClick(rEvent);
                }
            } else if (nClickCount == 1 && SwingUtilities.isLeftMouseButton(rEvent)) {
                this.OnLeftClick(rEvent);
            }
        }
    }

    protected void OnLeftClick(MouseEvent rEvent) {
        this.ForwardMouseEvents(rEvent, false);
    }

    private void ForwardMouseEvents(MouseEvent rMouseEvent, boolean bIsDoubleClick) {
        Point pt = rMouseEvent.getPoint();
        if (DEBUG_MOUSE_EVENT) {
            System.out.printf("MousePt: (%d, %d)\r\n", pt.x, pt.y);
        }
        Object objSource = rMouseEvent.getSource();
        JTableHeader rTableHeader = this.getTableHeader();
        if (rTableHeader != null && objSource == this.getTableHeader()) {
            if (bIsDoubleClick) {
                int nViewColToExpand = CRhinoTable.GetViewColToExpand(this, rMouseEvent.getPoint());
                this.ExpandViewCol(nViewColToExpand);
            }
            rMouseEvent.consume();
        } else {
            int nColumn = -1;
            for (int nColumnIdx = this.getColumnCount() - 1; nColumnIdx >= 0; --nColumnIdx) {
                if (this.getColumnClass(nColumnIdx) != CRhinoTreeTableTreeRenderer.class) continue;
                nColumn = nColumnIdx;
                break;
            }
            if (nColumn > -1) {
                TreePath rTreePath;
                CRhinoTreeTableTreeRenderer rTree = this.GetTreeRenderer();
                int nRow = this.rowAtPoint(pt);
                if (this.IsValidRow(nRow) && (rTreePath = rTree.getPathForRow(nRow)) != null) {
                    Rectangle rTreeCellBounds = rTree.getPathBounds(rTreePath);
                    Rectangle rTableCellBounds = this.getCellRect(nRow, nColumn, true);
                    if (rTreeCellBounds != null && rTableCellBounds != null) {
                        CRhinoTreeNode rNode;
                        Object rObj;
                        if (DEBUG_MOUSE_EVENT) {
                            System.out.printf("TreeCellBounds: X=%d | Y=%d | Width=%d | Height=%d\r\n", rTreeCellBounds.x, rTreeCellBounds.y, rTreeCellBounds.width, rTreeCellBounds.height);
                        }
                        if (DEBUG_MOUSE_EVENT) {
                            System.out.printf("TableCellBounds: X=%d | Y=%d | Width=%d | Height=%d\r\n", rTableCellBounds.x, rTableCellBounds.y, rTableCellBounds.width, rTableCellBounds.height);
                        }
                        boolean bForwardToTree = false;
                        int nTreeX = pt.x - rTableCellBounds.x;
                        if (bIsDoubleClick) {
                            bForwardToTree = true;
                        } else if (pt.x >= rTableCellBounds.x && pt.x <= rTableCellBounds.x + rTableCellBounds.width && nTreeX < rTreeCellBounds.x) {
                            bForwardToTree = true;
                        }
                        if (bForwardToTree && (rObj = rTreePath.getLastPathComponent()) instanceof CRhinoTreeNode && !(rNode = (CRhinoTreeNode)rObj).isLeaf()) {
                            if (rTree.isExpanded(rTreePath)) {
                                rTree.collapsePath(rTreePath);
                            } else {
                                rTree.expandPath(rTreePath);
                            }
                            rMouseEvent.consume();
                        }
                    }
                }
            }
        }
    }

    private void ExpandViewCol(int nViewCol) {
        DefaultTableColumnModel rColModel = (DefaultTableColumnModel)this.getColumnModel();
        if (rColModel != null) {
            TableColumn rColumn = rColModel.getColumn(nViewCol);
            int nColWidth = 0;
            int nMargin = 1;
            Component rComp = null;
            TableCellRenderer rColRenderer = rColumn.getHeaderRenderer();
            if (rColRenderer == null) {
                rColRenderer = this.getTableHeader().getDefaultRenderer();
            }
            if (rColRenderer != null && (rComp = rColRenderer.getTableCellRendererComponent(this, rColumn.getHeaderValue(), false, false, 0, 0)) != null && rComp.getPreferredSize() != null) {
                nColWidth = rComp.getPreferredSize().width;
            }
            for (int nRow = 0; nRow < this.getRowCount(); ++nRow) {
                Object rValue = this.getValueAt(nRow, nViewCol);
                rColRenderer = this.getCellRenderer(nRow, nViewCol);
                if (rColRenderer == this.m_TreeRenderer) {
                    rComp = this.m_TreeNodeRenderer.getTreeCellRendererComponent(this.m_TreeRenderer, rValue, false, false, false, nRow, false);
                    if (rComp == null) continue;
                    int nTreeNodeWidth = this.m_TreeNodeRenderer.GetPreferredWidth(rValue);
                    nColWidth = Math.max(nColWidth, nTreeNodeWidth);
                    continue;
                }
                rComp = rColRenderer.getTableCellRendererComponent(this, rValue, false, false, nRow, nViewCol);
                if (rComp == null || rComp.getPreferredSize() == null) continue;
                nColWidth = Math.max(nColWidth, rComp.getPreferredSize().width);
            }
            rColumn.setPreferredWidth(nColWidth += 2 * nMargin);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoTreeTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    private boolean IsValidRow(int nRow) {
        boolean bValid = false;
        if (nRow > -1 && nRow < this.GetModel().getRowCount()) {
            bValid = true;
        }
        return bValid;
    }

    protected void OnRightClick(MouseEvent rEvent) {
        Object objSource;
        if (rEvent != null && ((objSource = rEvent.getSource()) == this || objSource == this.GetViewport())) {
            Point pt = rEvent.getPoint();
            int nRow = this.rowAtPoint(pt);
            if (this.IsValidRow(nRow) && !this.GetListSelectionModel().isSelectedIndex(nRow)) {
                this.GetListSelectionModel().clearSelection();
                this.GetListSelectionModel().setSelectionInterval(nRow, nRow);
            }
            if (objSource instanceof Component) {
                pt = SwingUtilities.convertPoint((Component)objSource, pt, this);
            }
            if (!this.UseOurPopupMenu()) {
                JScrollPane rScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                if (rScrollPane != null) {
                    pt = SwingUtilities.convertPoint((Component)objSource, pt, rScrollPane);
                }
                if (CRhinoApp.GET_RHINO_APP() != null) {
                    CRhinoApp.GET_RHINO_APP().PostOnTreeTableRightClick(this, pt);
                }
            } else {
                this.PostLoadPopupMenu(pt);
            }
        }
    }

    private void PostLoadPopupMenu(Point ptLoc) {
        this.BeginWaitCursor();
        CUIMessage rUIMsg = new CUIMessage(3494, this, (Object)ptLoc);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rUIMsg);
        }
    }

    protected void OnLeftDoubleClick(MouseEvent rEvent) {
        this.ForwardMouseEvents(rEvent, true);
    }

    @Override
    public void mousePressed(MouseEvent rEvent) {
        this.m_FirstMouseEvent = rEvent;
    }

    @Override
    public void mouseReleased(MouseEvent rEvent) {
        this.m_FirstMouseEvent = null;
        if (rEvent != null) {
            Object objSource = rEvent.getSource();
            boolean bCtrlKeyDown = rEvent.isControlDown();
            boolean bShiftKeyDown = rEvent.isShiftDown();
            int nClickCount = rEvent.getClickCount();
            if (nClickCount == 1 && SwingUtilities.isRightMouseButton(rEvent)) {
                this.OnRightClick(rEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected JPopupMenu CreatePopupMenu() {
        return new JPopupMenu();
    }

    protected JPopupMenu GetPopupMenu() {
        return this.m_cPopupMenu;
    }

    protected void LoadPopupMenu() {
        this.SendUpdateDynamicBtns();
        JPopupMenu rPopupMenu = this.GetPopupMenu();
        if (rPopupMenu != null) {
            rPopupMenu.removeAll();
        }
    }

    @Override
    public void setBackground(Color clrBack) {
        super.setBackground(clrBack);
        if (this.GetTreeTableViewport() != null) {
            this.GetTreeTableViewport().OnMessage(new CWorkerThreadMsg(3523));
        }
    }

    @Override
    public void setGridColor(Color clrGrid) {
        super.setGridColor(clrGrid);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, clrGrid));
    }

    public void SetUseOurPopupMenu(boolean bUseOurPopupMenu) {
        this.m_bUseOurPopupMenu = bUseOurPopupMenu;
    }

    public boolean UseOurPopupMenu() {
        return this.m_bUseOurPopupMenu;
    }

    protected void OnRecvCacheImage(String sFileName) {
    }

    protected void OnUpdateDynamicBtns(CUpdateDynamicBtns rBtnMsg) {
    }

    protected CRhinoDragDropHandler CreateDragDropHandler() {
        return new CFilesDragDropHandler(this);
    }

    protected void InitDragDrop() {
        this.m_DragDropHandler = this.CreateDragDropHandler();
        if (this.m_DragDropHandler != null) {
            this.setTransferHandler(this.m_DragDropHandler);
            this.setDragEnabled(true);
            this.setDropMode(DropMode.USE_SELECTION);
        }
    }

    @Override
    public void keyTyped(KeyEvent rEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rEvent) {
        Object objSource = rEvent.getSource();
        int nKeyCode = rEvent.getKeyCode();
        block0 : switch (nKeyCode) {
            case 127: {
                if (!rEvent.isShiftDown()) break;
                this.OnKeyDelete();
                rEvent.consume();
                break;
            }
            case 38: 
            case 40: {
                if (this.GetModel() == null || this.GetListSelectionModel() == null) break;
                boolean bSelModKeyDown = rEvent.isControlDown();
                if (CLocalFileSystem.GetLocalFileSystem() != null && CLocalFileSystem.GetLocalFileSystem().IsMac()) {
                    bSelModKeyDown = rEvent.isAltDown();
                }
                if (!bSelModKeyDown) break;
                if (nKeyCode == 38) {
                    this.GetListSelectionModel().moveLeadSelectionIndex(this.GetListSelectionModel().getLeadSelectionIndex() - 1);
                } else {
                    this.GetListSelectionModel().moveLeadSelectionIndex(this.GetListSelectionModel().getLeadSelectionIndex() + 1);
                }
                this.EnsureVisible(this.GetListSelectionModel().getLeadSelectionIndex(), 0);
                rEvent.consume();
                break;
            }
            case 35: 
            case 36: {
                if (this.GetModel() != null && this.GetListSelectionModel() != null) {
                    if (rEvent.isShiftDown()) {
                        if (nKeyCode == 36) {
                            this.GetListSelectionModel().setSelectionInterval(this.GetListSelectionModel().getAnchorSelectionIndex(), 0);
                        } else {
                            this.GetListSelectionModel().setSelectionInterval(this.GetListSelectionModel().getAnchorSelectionIndex(), this.GetModel().getRowCount() - 1);
                        }
                    } else if (rEvent.isControlDown()) {
                        if (nKeyCode == 36) {
                            this.GetListSelectionModel().moveLeadSelectionIndex(0);
                        } else {
                            this.GetListSelectionModel().moveLeadSelectionIndex(this.GetModel().getRowCount() - 1);
                        }
                    } else if (nKeyCode == 36) {
                        this.GetListSelectionModel().setSelectionInterval(0, 0);
                    } else {
                        this.GetListSelectionModel().setSelectionInterval(this.GetModel().getRowCount() - 1, this.GetModel().getRowCount() - 1);
                    }
                    this.EnsureVisible(this.GetListSelectionModel().getLeadSelectionIndex(), 0);
                }
                rEvent.consume();
                break;
            }
            case 33: 
            case 34: {
                if (this.GetModel() == null || this.GetListSelectionModel() == null) break;
                boolean bUp = false;
                if (nKeyCode == 33) {
                    bUp = true;
                }
                boolean bHandled = false;
                bHandled = !bUp ? this.OnPageDownList(rEvent.isControlDown(), rEvent.isShiftDown()) : this.OnPageUpList(rEvent.isControlDown(), rEvent.isShiftDown());
                if (!bHandled) break;
                rEvent.consume();
                break;
            }
            default: {
                if (rEvent.isControlDown()) {
                    switch (nKeyCode) {
                        case 65: {
                            this.OnSelectAll();
                            rEvent.consume();
                            break block0;
                        }
                        case 73: {
                            this.OnInvertSelection();
                            rEvent.consume();
                            break block0;
                        }
                    }
                    break;
                }
                if (this.GetTypeAhead() == null || !this.GetTypeAhead().CanTypeAhead(rEvent)) break;
                this.GetTypeAhead().OnTypeAhead(rEvent.getKeyChar(), this.GetTypeAheadCol(), this, this.GetModel(), (ListSelectionModel)this.GetListSelectionModel());
                rEvent.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent rEvent) {
    }

    protected void EnsureVisible(int nRow, int nColumn) {
        Rectangle rRect = this.getCellRect(nRow, nColumn, true);
        this.scrollRectToVisible(rRect);
    }

    private void SetPageSelectionInterval(int nSelRow, boolean bIsCtrlDown, boolean bIsShiftDown) {
        if (this.GetModel() != null && this.GetListSelectionModel() != null && nSelRow >= 0 && nSelRow < this.GetModel().getRowCount()) {
            if (bIsCtrlDown) {
                this.GetListSelectionModel().moveLeadSelectionIndex(nSelRow);
            } else if (bIsShiftDown) {
                int nOldAnchorIdx = this.GetListSelectionModel().getAnchorSelectionIndex();
                int nOldLeadIdx = this.GetListSelectionModel().getLeadSelectionIndex();
                if (nOldLeadIdx > nOldAnchorIdx && nSelRow < nOldLeadIdx) {
                    this.GetListSelectionModel().removeSelectionInterval(nSelRow, nOldLeadIdx);
                } else if (nOldLeadIdx < nOldAnchorIdx && nSelRow > nOldLeadIdx) {
                    this.GetListSelectionModel().removeSelectionInterval(nOldLeadIdx, nSelRow);
                }
                this.GetListSelectionModel().addSelectionInterval(nOldAnchorIdx, nSelRow);
                this.GetListSelectionModel().moveLeadSelectionIndex(nSelRow);
                this.GetListSelectionModel().setAnchorSelectionIndex(nOldAnchorIdx);
            } else {
                this.GetListSelectionModel().setSelectionInterval(nSelRow, nSelRow);
            }
        }
    }

    private boolean OnPageAdjustList(boolean bHeadingUpTheList, boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = false;
        if (this.GetListSelectionModel() != null) {
            int nCurSelIndex = 0;
            if (this.GetListSelectionModel() != null) {
                nCurSelIndex = this.GetListSelectionModel().getLeadSelectionIndex();
            }
            Rectangle rVisibleRect = this.getVisibleRect();
            int nFirstRowLoc = rVisibleRect.y;
            Point pt = new Point(1, nFirstRowLoc + 1);
            int nFirstVisibleRow = this.rowAtPoint(pt);
            Rectangle rCellRect = this.getCellRect(nFirstVisibleRow, nFirstVisibleRow, true);
            if (rCellRect.y < rVisibleRect.y) {
                ++nFirstVisibleRow;
            }
            int nLeftMostVisibleCol = this.columnAtPoint(pt);
            rCellRect = this.getCellRect(nFirstVisibleRow, nLeftMostVisibleCol, true);
            if (rCellRect.x < rVisibleRect.x) {
                ++nLeftMostVisibleCol;
            }
            int nLastRowLoc = rVisibleRect.y + rVisibleRect.height;
            pt = new Point(1, nLastRowLoc - 1);
            int nLastVisibleRow = this.rowAtPoint(pt);
            rCellRect = this.getCellRect(nLastVisibleRow, nLastVisibleRow, true);
            if (rCellRect.y + rCellRect.height > rVisibleRect.y + rVisibleRect.height) {
                --nLastVisibleRow;
            }
            if (nFirstVisibleRow < 0 || nFirstVisibleRow > this.GetModel().getRowCount() - 1) {
                nFirstVisibleRow = 0;
            }
            if (nLastVisibleRow < 0 || nLastVisibleRow > this.GetModel().getRowCount() - 1) {
                nLastVisibleRow = this.GetModel().getRowCount() - 1;
            }
            if (DEBUG) {
                System.out.printf("Visible Row Range: %d - %d\r\n", nFirstVisibleRow, nLastVisibleRow);
            }
            if (bHeadingUpTheList) {
                if (nCurSelIndex > nFirstVisibleRow) {
                    this.SetPageSelectionInterval(nFirstVisibleRow, bIsCtrlDown, bIsShiftDown);
                } else {
                    int nScrollRow = nFirstVisibleRow - (nLastVisibleRow - nFirstVisibleRow);
                    if (nScrollRow < 0) {
                        nScrollRow = 0;
                    }
                    if (DEBUG) {
                        System.out.printf("ScrollToRow: %d\r\n", nScrollRow);
                    }
                    this.EnsureVisible(nScrollRow, nLeftMostVisibleCol);
                    this.SetPageSelectionInterval(nScrollRow, bIsCtrlDown, bIsShiftDown);
                }
                bHandled = true;
            } else {
                if (nCurSelIndex < nLastVisibleRow) {
                    this.SetPageSelectionInterval(nLastVisibleRow, bIsCtrlDown, bIsShiftDown);
                } else {
                    int nScrollRow = nLastVisibleRow + (nLastVisibleRow - nFirstVisibleRow);
                    if (nScrollRow > this.GetModel().getRowCount()) {
                        nScrollRow = this.GetModel().getRowCount() - 1;
                    }
                    if (DEBUG) {
                        System.out.printf("ScrollToRow: %d\r\n", nScrollRow);
                    }
                    this.EnsureVisible(nScrollRow, nLeftMostVisibleCol);
                    this.SetPageSelectionInterval(nScrollRow, bIsCtrlDown, bIsShiftDown);
                }
                bHandled = true;
            }
        }
        return bHandled;
    }

    private boolean OnPageDownList(boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = this.OnPageAdjustList(false, bIsCtrlDown, bIsShiftDown);
        return bHandled;
    }

    private boolean OnPageUpList(boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = this.OnPageAdjustList(true, bIsCtrlDown, bIsShiftDown);
        return bHandled;
    }

    private void OnSelectAll() {
        this.selectAll();
    }

    private void OnInvertSelection() {
        if (this.GetListSelectionModel() != null) {
            int nLeadIdx = this.GetListSelectionModel().getLeadSelectionIndex();
            for (int nRow = 0; nRow < this.getRowCount(); ++nRow) {
                if (this.GetListSelectionModel().isSelectedIndex(nRow)) {
                    this.GetListSelectionModel().removeSelectionInterval(nRow, nRow);
                    continue;
                }
                this.GetListSelectionModel().addSelectionInterval(nRow, nRow);
            }
            this.GetListSelectionModel().moveLeadSelectionIndex(nLeadIdx);
        }
    }

    private CTypeAhead GetTypeAhead() {
        return this.m_TypeAhead;
    }

    protected int GetTypeAheadCol() {
        return 0;
    }

    protected CTypeAhead CreateTypeAhead() {
        return new CTypeAhead_TreeTable();
    }

    @Override
    public void mouseDragged(MouseEvent rMouseEvent) {
        if (DEBUG_TRACK_DND_DRAG_EVENTS) {
            System.out.println("mouseDragged");
        }
        if (SwingUtilities.isRightMouseButton(rMouseEvent)) {
            int nRow;
            if (this.m_FirstMouseEvent != null && (!this.IsValidRow(nRow = this.rowAtPoint(this.m_FirstMouseEvent.getPoint())) || this.GetListSelectionModel() != null && !this.GetListSelectionModel().isSelectedIndex(nRow))) {
                if (DEBUG) {
                    System.out.println("Cancel drag b/c mousePressed row was not selected.");
                }
                return;
            }
            rMouseEvent.consume();
            Object rSourceObj = rMouseEvent.getSource();
            if (rSourceObj instanceof JComponent) {
                JComponent rSource = (JComponent)rSourceObj;
                if (this.m_FirstMouseEvent != null) {
                    int nAction = 1;
                    int dXExtent = Math.abs(rMouseEvent.getX() - this.m_FirstMouseEvent.getX());
                    int dYExtent = Math.abs(rMouseEvent.getY() - this.m_FirstMouseEvent.getY());
                    if (dXExtent > 5 || dYExtent > 5) {
                        rSource.putClientProperty("DndRightClick", true);
                        TransferHandler rHandler = rSource.getTransferHandler();
                        if (rHandler != null && CLocalFileSystem.GetLocalFileSystem() != null && !CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
                            rHandler.exportAsDrag(rSource, this.m_FirstMouseEvent, nAction);
                        }
                        this.m_FirstMouseEvent = null;
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent rEvent) {
    }

    private void OnKeyDelete() {
        if (this.GetModel() != null) {
            this.GetModel().OnKeyDelete();
        }
    }

    protected boolean IsSelected(CRhinoTreeNode rTreeNode) {
        boolean bIsSelected = false;
        if (rTreeNode != null && this.GetListSelectionModel() != null && this.GetModel() != null) {
            int nRow = this.GetModel().GetRow(rTreeNode);
            bIsSelected = this.GetListSelectionModel().isSelectedIndex(nRow);
        }
        return bIsSelected;
    }

    public void BeginWaitCursor() {
        if (this.GetTreeTableViewport() != null) {
            this.GetTreeTableViewport().BeginWaitCursor();
        }
    }

    public void EndWaitCursor() {
        if (this.GetTreeTableViewport() != null) {
            this.GetTreeTableViewport().EndWaitCursor();
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setCursor(cursor);
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SELECTION_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LOAD_COLS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_COL_WIDTHS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SPEED = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_MOUSE_EVENT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DND_DRAG_EVENTS = false;
        DEBUG_TRACK_IMPORT_DATA = CRhinoDragDropHandler.DEBUG_TRACK_IMPORT_DATA;
        DEF_LEAD_SELECTION_COLOR = Color.DARK_GRAY;
    }
}

