/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.treetables;

import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.files.CFile;
import com.rhinosoft.ui.controls.grids.CRhinoTable;
import com.rhinosoft.ui.controls.trees.CFileTreeNode;
import com.rhinosoft.ui.controls.treetables.CFileTreeTableModel;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTable;
import com.rhinosoft.ui.controls.treetables.CRhinoTreeTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;

public class CFileTreeTableCellRenderer
extends CRhinoTreeTableCellRenderer {
    public CFileTreeTableCellRenderer(CRhinoTreeTable rTreeTable) {
        super(rTreeTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        nCol = rTable.convertColumnIndexToModel(nCol);
        if (rVal instanceof CFileTreeNode) {
            CFileTreeNode rTreeNode;
            CFile fFile;
            String sText = null;
            Icon icoIcon = null;
            int nAlignHorz = 2;
            int nColIdxTree = 0;
            if (rTable.getModel() instanceof CFileTreeTableModel) {
                CFileTreeTableModel rModel = (CFileTreeTableModel)rTable.getModel();
                nColIdxTree = rModel.GetColIndexTree();
            }
            if ((fFile = (rTreeNode = (CFileTreeNode)rVal).GetSource()) != null) {
                if (nCol == nColIdxTree) {
                    icoIcon = fFile.GetIcon16();
                    sText = fFile.GetDisplayName();
                } else if (nCol == 1) {
                    nAlignHorz = 4;
                    if (!fFile.IsDirectory()) {
                        sText = CFile.FormatFileSize(fFile.GetSize());
                    }
                }
            }
            this.setText(sText);
            this.setIcon(icoIcon);
            this.setHorizontalAlignment(nAlignHorz);
        }
        return this;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, int nCol, JTable rTable, Component ... arComps) {
        Color clrTableFore = UIManager.getColor("Table.foreground");
        Color clrTableBack = UIManager.getColor("Table.background");
        Color clrTableForeSel = UIManager.getColor("Table.selectionForeground");
        Color clrTableBackSel = UIManager.getColor("Table.selectionBackground");
        Color clrFore = clrTableFore;
        Color clrBack = clrTableBack;
        if (bIsSelected) {
            CRhinoTable rRhinoTable;
            clrFore = clrTableForeSel;
            clrBack = clrTableBackSel;
            if (rTable instanceof CRhinoTable && !(rRhinoTable = (CRhinoTable)rTable).GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorAttr.IsADarkColor(clrFore) && !CColorAttr.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() < clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                } else if (CColorAttr.IsADarkColor(clrFore) && CColorAttr.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() > clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                }
            }
        } else {
            int nSortCol = rTable.convertColumnIndexToModel(nCol);
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackground(clrBack);
    }
}

