/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.trees;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CRhinoTreeNodeRenderer
extends DefaultTreeCellRenderer {
    public static boolean DEBUG = CAttr.DEBUG;
    public static final String KEY_DROP_TREEPATH = "DropTreePath";
    private boolean m_bHasFocusClrs = false;

    public boolean IsDropDir(JTree rTree, Object rValue, int nRow) {
        boolean bIsDropDir = false;
        if (rTree != null) {
            TreePath rDropTreePath;
            Object objDropTreePath = rTree.getClientProperty(KEY_DROP_TREEPATH);
            if (objDropTreePath instanceof TreePath && rTree.getRowForPath(rDropTreePath = (TreePath)objDropTreePath) == nRow) {
                bIsDropDir = true;
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoTreeNodeRenderer.class.getName(), CDebugLog.GetLineNumber(), "Programming error, rTable = null");
        }
        return bIsDropDir;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree rTree, Object rValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int nRow, boolean bHasFocus) {
        if (this.IsDropDir(rTree, rValue, nRow)) {
            bIsSelected = true;
        }
        super.getTreeCellRendererComponent(rTree, rValue, bIsSelected, bIsExpanded, bIsLeaf, nRow, bHasFocus);
        this.UpdateHasFocusColor(bIsSelected, rTree, this);
        if (rValue instanceof CRhinoTreeNode) {
            CRhinoTreeNode rNode = (CRhinoTreeNode)rValue;
            this.setIcon(rNode.GetDisplayIcon());
            this.setText(rNode.GetDisplayText());
        }
        return this;
    }

    public Rectangle GetEditorRect(JTree rTree, int nRow) {
        Rectangle rScreenCoords = new Rectangle(0, 0, 0, 0);
        if (rTree != null) {
            Icon rIcon;
            Insets rInsets;
            Point ptScreenLoc = new Point(0, 0);
            Rectangle rCellRect = rTree.getRowBounds(nRow);
            ptScreenLoc.setLocation(rCellRect.x, rCellRect.y);
            SwingUtilities.convertPointToScreen(ptScreenLoc, rTree);
            rScreenCoords.x = ptScreenLoc.x;
            rScreenCoords.y = ptScreenLoc.y;
            rScreenCoords.width = rCellRect.width;
            rScreenCoords.height = rCellRect.height;
            int x2 = rScreenCoords.x;
            int nWidth2 = rScreenCoords.width;
            Border rBorder = this.getBorder();
            if (rBorder != null && (rInsets = rBorder.getBorderInsets(this)) != null) {
                x2 += rInsets.left;
                nWidth2 -= rInsets.left;
            }
            if ((rIcon = this.getIcon()) != null) {
                int nImageWidth = rIcon.getIconWidth();
                x2 += nImageWidth;
                nWidth2 -= nImageWidth;
            }
            int nImageGap = 1;
            rScreenCoords.x = x2 += nImageGap;
            if ((nWidth2 -= nImageGap) > 0) {
                rScreenCoords.width = nWidth2;
            }
        }
        return rScreenCoords;
    }

    protected void UpdateHasFocusColor(boolean bIsSelected, JTree rTree, Component ... arComps) {
        Color clrTreeFore = UIManager.getColor("Tree.foreground");
        Color clrTreeBack = UIManager.getColor("Tree.background");
        Color clrTreeForeSel = UIManager.getColor("Tree.selectionForeground");
        Color clrTreeBackSel = UIManager.getColor("Tree.selectionBackground");
        Color clrFore = clrTreeFore;
        Color clrBack = clrTreeBack;
        if (bIsSelected) {
            clrFore = clrTreeForeSel;
            clrBack = clrTreeBackSel;
            if (!this.GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorAttr.IsADarkColor(clrFore) && !CColorAttr.IsADarkColor(clrBack)) {
                    clrFore = clrTreeFore.getRGB() < clrTreeForeSel.getRGB() ? clrTreeFore : clrTreeForeSel;
                } else if (CColorAttr.IsADarkColor(clrFore) && CColorAttr.IsADarkColor(clrBack)) {
                    clrFore = clrTreeFore.getRGB() > clrTreeForeSel.getRGB() ? clrTreeFore : clrTreeForeSel;
                }
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackgroundSelectionColor(clrBack);
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean GetHasFocusClrs() {
        return this.m_bHasFocusClrs;
    }
}

