/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.trees;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CObjectAttr;
import com.rhinosoft.attrs.IRhinoDestroy;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.utils.CNaturalSort;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CRhinoTreeNode
extends DefaultMutableTreeNode
implements IRhinoOnMessage,
IRhinoDestroy {
    public static boolean DEBUG = CAttr.DEBUG;
    private TreePath m_cTreePath;
    private CObjectAttr m_ObjectAttr;
    private String m_sDisplayText;
    private Locale m_Locale;
    private boolean m_bEnforceLeafsAfterBranches = false;

    protected CRhinoTreeNode() {
        this._CRhinoTreeNode();
    }

    public CRhinoTreeNode(Object rUserObj) {
        super(rUserObj);
        this._CRhinoTreeNode();
    }

    private void _CRhinoTreeNode() {
        this.m_ObjectAttr = new CObjectAttr();
        this.m_ObjectAttr.SetObject(this);
        this.m_sDisplayText = "<CRhinoTreeNode>";
        this.m_Locale = Locale.getDefault();
        this.EnforceLeafsAfterBranches(true);
    }

    @Override
    public void Destroy() {
        if (this.m_ObjectAttr != null) {
            this.m_ObjectAttr.Destroy();
        }
        this.m_ObjectAttr = null;
    }

    public TreePath GetTreePath() {
        return this.m_cTreePath;
    }

    private void SetTreePath(TreePath rTreePath) {
        this.m_cTreePath = rTreePath;
    }

    public void InitTreePath() {
        this.SetTreePath(new TreePath(this.getPath()));
    }

    public CRhinoTreeNode GetParent() {
        CRhinoTreeNode rParent = null;
        TreeNode rTemp = this.getParent();
        if (rTemp instanceof CRhinoTreeNode) {
            rParent = (CRhinoTreeNode)rTemp;
        }
        return rParent;
    }

    public Icon GetDisplayIcon() {
        return null;
    }

    public String GetDisplayText() {
        return this.m_sDisplayText;
    }

    public void SetDisplayText(String sDisplayText) {
        this.m_sDisplayText = sDisplayText;
    }

    @Override
    public String toString() {
        String sRet = super.toString();
        String sDisplayTxt = this.GetDisplayText();
        if (sDisplayTxt != null && !sDisplayTxt.isEmpty()) {
            sRet = sDisplayTxt;
        }
        return sRet;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                default: 
            }
        }
    }

    public long GetAttrID() {
        return this.m_ObjectAttr.GetUniqueID();
    }

    public boolean Add(CRhinoTreeNode rParent, boolean bAppend) {
        return false;
    }

    public boolean Remove(CRhinoTreeNode rParent) {
        return false;
    }

    protected int GetInsertIndex(CRhinoTreeNode rParentNode, CRhinoTreeNode rChildNode) {
        int nInsertAt = -1;
        if (rParentNode != null && rChildNode != null) {
            int nChildCount = rParentNode.getChildCount();
            String sDisplayName = rChildNode.GetDisplayText();
            boolean bIsLeaf = rChildNode.isLeaf();
            if (sDisplayName != null && !sDisplayName.isEmpty()) {
                for (int nIdx = 0; nIdx < rParentNode.getChildCount() && nInsertAt == -1; ++nIdx) {
                    int nCompare;
                    TreeNode rNext = rParentNode.getChildAt(nIdx);
                    if (!(rNext instanceof CRhinoTreeNode)) continue;
                    CRhinoTreeNode rNextNode = (CRhinoTreeNode)rNext;
                    String sNextName = rNextNode.GetDisplayText();
                    boolean bNextIsLeaf = rNextNode.isLeaf();
                    boolean bIgnoreCase = false;
                    if (CRhinoApp.GET_RHINO_APP() != null) {
                        boolean bl = bIgnoreCase = !CRhinoApp.GET_RHINO_APP().IsCaseSensitiveOS();
                    }
                    if (this.m_bEnforceLeafsAfterBranches) {
                        if (bIsLeaf == bNextIsLeaf) {
                            if (sNextName == null || sNextName.isEmpty() || (nCompare = this.Compare(true, sDisplayName, sNextName, bIgnoreCase)) >= 0) continue;
                            nInsertAt = nIdx;
                            continue;
                        }
                        if (bIsLeaf || !bNextIsLeaf) continue;
                        nInsertAt = nIdx;
                        continue;
                    }
                    if (sNextName == null || sNextName.isEmpty() || (nCompare = this.Compare(true, sDisplayName, sNextName, bIgnoreCase)) >= 0) continue;
                    nInsertAt = nIdx;
                }
            }
            if (nInsertAt == -1) {
                nInsertAt = nChildCount;
            }
        } else {
            nInsertAt = 0;
        }
        return nInsertAt;
    }

    protected int Compare(boolean bIsAscending, String sText1, String sText2, boolean bIgnoreCase) {
        return CNaturalSort.Sort(bIsAscending, sText1, sText2, bIgnoreCase, this.m_Locale);
    }

    protected Locale GetLocale() {
        return this.m_Locale;
    }

    public void OnUpdateLocale(String sLanguageCode, String sCountryCode) {
        this.m_Locale = new Locale(sLanguageCode, sCountryCode);
    }

    public void EnforceLeafsAfterBranches(boolean bEnforce) {
        this.m_bEnforceLeafsAfterBranches = bEnforce;
    }

    public void UpdateDynamicButtonsForSelModel(CRhinoTreeNode rRootNode, boolean bIsSelected) {
    }

    public void ResetDynamicButtonsForSelModel() {
    }
}

