/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.trees;

import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.ui.controls.trees.CFileTreeNode;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNodeRenderer;
import com.rhinosoft.ui.controls.trees.CSearchTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class CFileTreeNodeRenderer
extends CRhinoTreeNodeRenderer {
    private CFile GetFileFromTreePath(TreePath rTreePath) {
        Object rNode;
        CFile fRet = null;
        if (rTreePath != null && (rNode = rTreePath.getLastPathComponent()) != null && rNode instanceof CFileTreeNode) {
            CFileTreeNode rFileNode = (CFileTreeNode)rNode;
            fRet = rFileNode.GetSource();
        }
        return fRet;
    }

    @Override
    public boolean IsDropDir(JTree rTree, Object rValue, int nRow) {
        boolean bIsDropDir = false;
        if (rTree != null) {
            CFile fRowFile;
            TreePath rDropTreePath;
            Object objDropTreePath = rTree.getClientProperty("DropTreePath");
            if (objDropTreePath instanceof TreePath && rTree.getRowForPath(rDropTreePath = (TreePath)objDropTreePath) == nRow && (fRowFile = this.GetFileFromTreePath(rDropTreePath)) != null && fRowFile.IsDirectory() && !fRowFile.IsDrive()) {
                bIsDropDir = true;
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoTreeNodeRenderer.class.getName(), CDebugLog.GetLineNumber(), "Programming error, rTable = null");
        }
        return bIsDropDir;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree rTree, Object rValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int nRow, boolean bHasFocus) {
        CFileTreeNode rNode;
        CFile fFile;
        if (this.IsDropDir(rTree, rValue, nRow)) {
            bIsSelected = true;
        }
        super.getTreeCellRendererComponent(rTree, rValue, bIsSelected, bIsExpanded, bIsLeaf, nRow, bHasFocus);
        this.UpdateHasFocusColor(bIsSelected, rTree, this);
        if (rValue instanceof CSearchTreeNode) {
            CSearchTreeNode rNode2 = (CSearchTreeNode)rValue;
            this.setIcon(rNode2.GetDisplayIcon());
            this.setText(rNode2.GetDisplayText());
        } else if (rValue instanceof CFileTreeNode && (fFile = (rNode = (CFileTreeNode)rValue).GetSource()) != null) {
            this.setIcon(fFile.GetIcon16());
            this.setText(fFile.GetDisplayName());
        }
        return this;
    }
}

