/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.trees;

import com.rhinosoft.files.CFile;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class CFileTreeNode
extends CRhinoTreeNode {
    private CFile m_fSource;

    protected CFileTreeNode() {
    }

    public CFileTreeNode(CFile rFile) {
        super(rFile);
        this.SetSource(rFile);
    }

    @Override
    public void Destroy() {
        if (this.m_fSource != null) {
            this.m_fSource.Destroy();
        }
        this.m_fSource = null;
        super.Destroy();
    }

    public CFile GetSource() {
        return this.m_fSource;
    }

    protected final void SetSource(CFile rSource) {
        if (this.m_fSource != rSource) {
            if (this.m_fSource != null) {
                this.m_fSource.Destroy();
            }
            this.m_fSource = rSource;
        }
    }

    @Override
    public boolean isLeaf() {
        boolean bIsLeaf = true;
        if (bIsLeaf) {
            boolean bl = bIsLeaf = !this.GetSourceIsDir();
        }
        if (bIsLeaf) {
            bIsLeaf = super.isLeaf();
        }
        return bIsLeaf;
    }

    public boolean IsRoot() {
        return false;
    }

    @Override
    public Icon GetDisplayIcon() {
        Icon icoIcon = super.GetDisplayIcon();
        if (this.GetSource() != null) {
            icoIcon = this.GetSource().GetIcon16();
        }
        return icoIcon;
    }

    @Override
    public String GetDisplayText() {
        String sRet = super.GetDisplayText();
        if (this.GetSource() != null) {
            sRet = this.GetSource().GetDisplayName();
        }
        return sRet;
    }

    public String GetSourcePath() {
        String sAbsPath = null;
        if (this.GetSource() != null) {
            sAbsPath = this.GetSource().GetAbsPath();
        }
        return sAbsPath;
    }

    public boolean GetSourceIsLocal() {
        boolean bIsLocal = false;
        if (this.GetSource() != null) {
            bIsLocal = this.GetSource().IsLocal();
        }
        return bIsLocal;
    }

    public boolean GetSourceIsDir() {
        boolean bIsDir = false;
        if (this.GetSource() != null) {
            bIsDir = this.GetSource().IsDirectory();
        }
        return bIsDir;
    }

    @Override
    public CFileTreeNode GetParent() {
        CFileTreeNode rParent = null;
        CRhinoTreeNode rTemp = super.GetParent();
        if (rTemp instanceof CFileTreeNode) {
            rParent = (CFileTreeNode)rTemp;
        }
        return rParent;
    }

    public boolean Matches(String sPath) {
        String sFilePath;
        boolean bMatches = false;
        if (sPath != null && !sPath.isEmpty() && this.GetSource() != null && (sFilePath = this.GetSource().GetAbsPath()) != null && !sFilePath.isEmpty() && sPath.equals(sFilePath)) {
            bMatches = true;
        }
        return bMatches;
    }

    public CFileTreeNode GetChildNode(String sChildPath) {
        CFileTreeNode rNode = null;
        if (sChildPath != null) {
            for (int nIdx = 0; nIdx < this.getChildCount() && rNode == null; ++nIdx) {
                CFileTreeNode rChildNode;
                TreeNode rNextNode = this.getChildAt(nIdx);
                if (!(rNextNode instanceof CFileTreeNode) || !(rChildNode = (CFileTreeNode)rNextNode).Matches(sChildPath)) continue;
                rNode = rChildNode;
            }
        }
        return rNode;
    }
}

