/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.trees;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.threads.CFileSystem;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.controls.trees.CFileTreeNode;
import com.rhinosoft.ui.controls.trees.CRhinoTreeModel;
import com.rhinosoft.ui.controls.trees.CRhinoTreeNode;
import com.rhinosoft.ui.controls.trees.CSearchTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CFileTreeModel
extends CRhinoTreeModel {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_SEARCH_EXCEPTIONS;
    private CFileTreeNode m_RootNode;
    private CSearchTreeNode m_SearchNode;

    public CFileTreeModel() {
        this._CFileTreeModel();
    }

    private void _CFileTreeModel() {
        this.m_RootNode = null;
        this.m_SearchNode = new CSearchTreeNode();
    }

    public void AddChildNode(CFile fParent, CFile fChild) {
        CFileTreeNode rParentNode;
        if (fParent != null && fChild != null && (rParentNode = this.FindNode(fParent)) != null) {
            this.AddChild(rParentNode, fChild, false);
        }
    }

    public void UpdateChildNode(CFile fParent, CFile fChild) {
        CFileTreeNode rParentNode;
        if (fParent != null && fChild != null && (rParentNode = this.FindNode(fParent)) != null) {
            this.UpdateChild(rParentNode, fChild, false);
        }
    }

    public CFileTreeNode FindNode(CFile fFile, String sAbsPath) {
        CFileTreeNode rNode = null;
        if (sAbsPath != null && !sAbsPath.isEmpty() && this.GetRootNode() != null) {
            int nMaxDepth = this.GetMaxDepth(fFile);
            rNode = this.GetNode(this.GetRootNode(), sAbsPath, 0, nMaxDepth);
        }
        return rNode;
    }

    public CFileTreeNode FindNode(CFile fFile) {
        CFileTreeNode rNode = null;
        if (fFile != null && this.GetRootNode() != null) {
            int nMaxDepth = this.GetMaxDepth(fFile);
            rNode = this.GetNode(this.GetRootNode(), fFile.GetAbsPath(), 0, nMaxDepth);
        }
        return rNode;
    }

    private CFileTreeNode AddChild(CFileTreeNode rParentNode, CFile fChild, boolean bAppend) {
        CFileTreeNode rChildNode = null;
        if (rParentNode != null && fChild != null && rParentNode.GetChildNode(fChild.GetAbsPath()) == null) {
            rChildNode = new CFileTreeNode(fChild);
            int nInsertIndex = rParentNode.getChildCount();
            if (!bAppend) {
                nInsertIndex = this.GetInsertIndex(rParentNode, rChildNode);
            }
            this.insertNodeInto(rChildNode, rParentNode, nInsertIndex);
        }
        return rChildNode;
    }

    private CFileTreeNode UpdateChild(CFileTreeNode rParentNode, CFile fChild, boolean bAppend) {
        CFileTreeNode rChildNode = null;
        if (rParentNode != null && fChild != null && (rChildNode = rParentNode.GetChildNode(fChild.GetAbsPath())) != null) {
            this.nodeChanged(rChildNode);
        }
        return rChildNode;
    }

    public void RemoveChildNode(CFile fParent, CFile fChild) {
        CFileTreeNode rChildNode;
        if (fParent != null && fChild != null && (rChildNode = this.FindNode(fChild)) != null) {
            this.removeNodeFromParent(rChildNode);
        }
    }

    public void RenameChildNode(CFile fParent, CFile fChild) {
        if (fParent != null && fChild != null) {
            String sChildPath = fChild.GetAbsPath();
            CFileTreeNode rParentNode = this.FindNode(fParent);
            CFileTreeNode rChildNode = this.FindNode(fChild, sChildPath);
            if (rParentNode != null && rChildNode != null) {
                this.nodeChanged(rChildNode);
            }
        }
    }

    public boolean IsSameFileSystem(CFile fFile) {
        CFile fRoot;
        boolean bIsSameFileSystem = false;
        if (this.GetRootNode() != null && fFile != null && (fRoot = this.GetRootNode().GetSource()) != null && (fRoot.IsLocal() && fFile.IsLocal() || !fRoot.IsLocal() && !fFile.IsLocal())) {
            bIsSameFileSystem = true;
        }
        return bIsSameFileSystem;
    }

    @Override
    protected CFileTreeNode GetRootNode() {
        return (CFileTreeNode)super.GetRootNode();
    }

    public void SetRootNode(CFile fRoot) {
        this.m_RootNode = new CFileTreeNode(fRoot);
        this.setRoot(this.m_RootNode);
        this.AddAllChildren(this.m_RootNode);
    }

    private void AddAllChildren(CFileTreeNode rParentNode) {
        CFile fParent;
        if (rParentNode != null && (fParent = rParentNode.GetSource()) != null) {
            for (int nIdx = 0; nIdx < fParent.GetNumOfChildFiles(); ++nIdx) {
                CFile fChild = fParent.GetFile(nIdx);
                if (fChild == null) continue;
                CFileTreeNode rChildNode = this.AddChild(rParentNode, fChild, true);
                if (fChild.GetNumOfChildFiles() <= 0) continue;
                this.AddAllChildren(rChildNode);
            }
        }
    }

    private CFileTreeNode GetNode(CFileTreeNode rParent, String sChildPath, int nCurDepth, int nMaxDepth) {
        CFileTreeNode rNode = null;
        if (sChildPath != null && rParent != null && nCurDepth < nMaxDepth) {
            if (rParent.Matches(sChildPath)) {
                rNode = rParent;
            } else {
                for (int nIdx = 0; nIdx < rParent.getChildCount() && rNode == null; ++nIdx) {
                    TreeNode rNextNode = rParent.getChildAt(nIdx);
                    if (!(rNextNode instanceof CFileTreeNode)) continue;
                    CFileTreeNode rChildNode = (CFileTreeNode)rNextNode;
                    rNode = this.GetNode(rChildNode, sChildPath, nCurDepth + 1, nMaxDepth);
                }
            }
        }
        return rNode;
    }

    public int GetMaxDepth(CFile fFile) {
        int nMaxDepth = 1;
        if (fFile != null) {
            nMaxDepth = CFileSystem.GetMaxDepth(fFile.GetAbsPath(), fFile.GetFileSeparator());
            if (fFile instanceof CLocalFile && CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
                nMaxDepth += 3;
            }
        }
        return nMaxDepth;
    }

    private int GetInsertIndex(CFileTreeNode rParentNode, CFileTreeNode rChildNode) {
        int nInsertAt = -1;
        if (rParentNode != null) {
            int nChildCount;
            nInsertAt = rChildNode != null ? rParentNode.GetInsertIndex(rParentNode, rChildNode) : (nChildCount = rParentNode.getChildCount());
        }
        return nInsertAt;
    }

    public CSearchTreeNode GetSearchNode() {
        return this.m_SearchNode;
    }

    public void SetSearchNodeVisible(boolean bVisible) {
        if (bVisible) {
            this.ShowSearchNode();
        } else {
            this.HideSearchNode();
        }
    }

    private void ShowSearchNode() {
        int nIdx;
        if (this.GetRootNode() != null && ((nIdx = this.getIndexOfChild(this.GetRootNode(), this.GetSearchNode())) <= 0 || nIdx >= this.GetRootNode().getChildCount())) {
            int nInsertIndex = this.GetRootNode().getChildCount();
            this.insertNodeInto(this.GetSearchNode(), this.GetRootNode(), nInsertIndex);
        }
    }

    private void HideSearchNode() {
        block2: {
            try {
                this.removeNodeFromParent(this.GetSearchNode());
            }
            catch (Exception e) {
                if (!DEBUG_SEARCH_EXCEPTIONS) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public CFileTreeNode GetTreeNode(TreePath rTreePath) {
        CFileTreeNode rNode = null;
        CRhinoTreeNode rRhinoNode = super.GetTreeNode(rTreePath);
        if (rRhinoNode instanceof CFileTreeNode) {
            rNode = (CFileTreeNode)rRhinoNode;
        }
        return rNode;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SEARCH_EXCEPTIONS = false;
    }
}

