/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.ui.controls.grids.CRhinoTable;
import com.rhinosoft.ui.controls.grids.CRhinoViewport;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class CRhinoViewportTable
extends CRhinoViewport
implements ChangeListener,
TableColumnModelListener {
    private int m_nModelCol;
    private JTable m_Table;
    private Color m_clrSort;

    public CRhinoViewportTable(JTable rTable) {
        super(rTable);
        this._CRhinoViewportTable();
    }

    private void _CRhinoViewportTable() {
        this.m_nModelCol = -1;
        if (this.GetTable() != null) {
            TableColumnModel rColModel = this.GetTable().getColumnModel();
            rColModel.addColumnModelListener(this);
        }
    }

    public CRhinoTable GetTable() {
        return (CRhinoTable)this.GetEmbeddedComp();
    }

    @Override
    protected void OnCreate() {
        super.OnCreate();
        this.addChangeListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        int nWidth = this.getWidth();
        int nHeight = this.getHeight();
        Color clrBackground = (Color)UIManager.get("Table.background");
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, clrBackground, nWidth, nHeight, clrBackground, true);
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, nWidth, nHeight);
        CRhinoTable rTable = this.GetTable();
        if (rTable != null) {
            int[] nXLocs = this.GetTable().GetColXLocs(this.m_nModelCol);
            Point ptLeft = new Point(nXLocs[0], 0);
            SwingUtilities.convertPointToScreen(ptLeft, rTable);
            Point ptRight = new Point(nXLocs[1], 0);
            SwingUtilities.convertPointToScreen(ptRight, rTable);
            SwingUtilities.convertPointFromScreen(ptLeft, this);
            SwingUtilities.convertPointFromScreen(ptRight, this);
            if (ptLeft.x < 0) {
                ptLeft.x = 0;
            }
            if (ptRight.x < 0) {
                ptRight.x = 0;
            }
            if (ptLeft.x < ptRight.x) {
                this.m_clrSort = CRhinoTable.GetSortColor(clrBackground, 10);
                g2d.setPaint(this.m_clrSort);
                g2d.fillRect(ptLeft.x, 0, ptRight.x - ptLeft.x, nHeight);
            }
        }
        g2d.setPaint(oldPaint);
    }

    public Color GetSortColor() {
        return this.m_clrSort;
    }

    public void SetModelCol(int nModelCol) {
        this.m_nModelCol = nModelCol;
    }

    public int GetModelCol() {
        return this.m_nModelCol;
    }

    @Override
    public void stateChanged(ChangeEvent rChangeEvent) {
        if (rChangeEvent.getSource() == this) {
            this.repaint();
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

