/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.CRhinoHourGlassInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class CRhinoViewport
extends JViewport
implements MouseListener,
IRhinoOnMessage {
    public static boolean DEBUG = CAttr.DEBUG;
    private JComponent m_rEmbeddedComp;
    private CRhinoHourGlassInfo m_HourGlassInfo;

    public CRhinoViewport(JComponent rEmbeddedComp) {
        this._CRhinoViewport(rEmbeddedComp);
    }

    private void _CRhinoViewport(JComponent rEmbeddedComp) {
        this.m_rEmbeddedComp = rEmbeddedComp;
        this.m_HourGlassInfo = new CRhinoHourGlassInfo(this);
    }

    protected void OnCreate() {
        if (this.GetEmbeddedComp() != null) {
            this.setView(this.GetEmbeddedComp());
            this.setDropTarget(this.GetEmbeddedComp().getDropTarget());
            this.setTransferHandler(this.GetEmbeddedComp().getTransferHandler());
            this.MatchBackgroundColors();
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoViewport.class.getName(), CDebugLog.GetLineNumber(), "ASSERT:  Programming error, GetEmbeddedComp() = null");
        }
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent rMouseEvent) {
        if (this.GetEmbeddedComp() != null) {
            if (SwingUtilities.isLeftMouseButton(rMouseEvent)) {
                if (this.GetEmbeddedComp() instanceof JTable) {
                    ((JTable)this.GetEmbeddedComp()).clearSelection();
                } else if (this.GetEmbeddedComp() instanceof JList) {
                    ((JList)this.GetEmbeddedComp()).clearSelection();
                }
                rMouseEvent.consume();
            } else {
                this.GetEmbeddedComp().dispatchEvent(rMouseEvent);
            }
            this.GetEmbeddedComp().requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    public JComponent GetEmbeddedComp() {
        return this.m_rEmbeddedComp;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        CRhinoEvent rEvent;
        if (event instanceof CRhinoEvent && (rEvent = (CRhinoEvent)event).getSource() instanceof CAttrMsg) {
            CAttrMsg rMsg = (CAttrMsg)rEvent.getSource();
            this.OnMessage(rMsg);
        }
        super.processEvent(event);
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4020: {
                    this.OnCreate();
                    break;
                }
                case 3523: {
                    this.MatchBackgroundColors();
                    break;
                }
                case 3490: {
                    if (CRhinoApp.GET_RHINO_APP() == null) break;
                    CRhinoApp.GET_RHINO_APP().SetCursor(rMsg, this);
                    break;
                }
            }
        }
        for (int nIdx = 0; nIdx < this.getComponentCount(); ++nIdx) {
            Component rNextComp = this.getComponent(nIdx);
            if (rNextComp == null) continue;
            rNextComp.dispatchEvent(new CRhinoEvent(rMsg));
        }
        if (this.m_HourGlassInfo != null) {
            this.m_HourGlassInfo.OnMessage(rMsg);
        }
    }

    private void MatchBackgroundColors() {
        if (this.GetEmbeddedComp() != null) {
            this.setBackground(this.GetEmbeddedComp().getBackground());
        }
    }

    public void BeginWaitCursor() {
        if (this.m_HourGlassInfo != null) {
            this.m_HourGlassInfo.PostBeginWaitCursor();
        }
    }

    public void EndWaitCursor() {
        if (this.m_HourGlassInfo != null) {
            this.m_HourGlassInfo.PostEndWaitCursor();
        }
    }
}

