/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.controls.grids.CRhinoModel;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CRhinoTableHeaderRenderer
extends DefaultTableCellRenderer {
    public static boolean DEBUG = CAttr.DEBUG;
    public static final int HEADER_LABEL_ICON_GAP = 4;
    private TableCellRenderer m_LnFCellRenderer;
    private HashMap<String, TableCellRenderer> m_aLnFCellRenderers = new HashMap();
    private CRhinoModel m_rSorter;

    public CRhinoTableHeaderRenderer(CRhinoModel rSorter) {
        this.m_rSorter = rSorter;
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rValObj, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        return this.FormatLnFCell(rTable, rValObj, bIsSelected, bHasFocus, nRow, nCol);
    }

    public void UpdateUIRenderer() {
        String sKey = UIManager.getLookAndFeel().getClass().toString();
        TableCellRenderer rRenderer = this.m_aLnFCellRenderers.get(sKey);
        if (rRenderer == null) {
            JTable rTable = new JTable();
            JTableHeader rHeader = rTable.getTableHeader();
            rRenderer = rHeader.getDefaultRenderer();
            this.m_aLnFCellRenderers.put(sKey, rRenderer);
        }
        this.m_LnFCellRenderer = rRenderer;
    }

    protected Component FormatLnFCell(JTable rTable, Object rValObj, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        Component rRenderedCell = this.m_LnFCellRenderer.getTableCellRendererComponent(rTable, rValObj, bIsSelected, bHasFocus, nRow, nCol);
        if (rRenderedCell instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer rDefCell = (DefaultTableCellRenderer)rRenderedCell;
            int nModelCol = rTable.convertColumnIndexToModel(nCol);
            rDefCell.setHorizontalTextPosition(2);
            int nAlignHorz = 2;
            rDefCell.setHorizontalAlignment(nAlignHorz);
            rDefCell.setHorizontalTextPosition(2);
            rDefCell.setIconTextGap(4);
            if (this.m_rSorter != null) {
                ImageIcon icoIcon = this.GetSortIcon(this.m_rSorter.GetSortDirection(), nModelCol, rTable);
                rDefCell.setIcon(icoIcon);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoTableHeaderRenderer.class.getName(), CDebugLog.GetLineNumber(), "Programming error, m_rSorter is null");
            }
        }
        return rRenderedCell;
    }

    private ImageIcon GetSortIcon(int nSortDirection, int nModelColToRender, JTable rTable) {
        ImageIcon icoSortArrow = null;
        boolean bGetSortIcon = false;
        if (nModelColToRender == this.m_rSorter.GetSortModelCol()) {
            bGetSortIcon = true;
        }
        if (bGetSortIcon) {
            icoSortArrow = this.GetSortIcon(nSortDirection, rTable);
        }
        return icoSortArrow;
    }

    private ImageIcon GetSortIcon(int nSortDirection, JTable rTable) {
        ImageIcon icoSortArrow = null;
        if (rTable != null) {
            if (nSortDirection == 1) {
                icoSortArrow = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_SORT_UP_ARROW_PNG.GetFileName());
            } else if (nSortDirection == 2) {
                icoSortArrow = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_SORT_DOWN_ARROW_PNG.GetFileName());
            }
        }
        return icoSortArrow;
    }
}

