/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.ui.controls.CRhinoBorderSolid;
import com.rhinosoft.ui.controls.grids.CRhinoTable;
import com.rhinosoft.ui.controls.grids.CRhinoViewportTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class CRhinoTableCellRenderer
extends DefaultTableCellRenderer {
    public static boolean DEBUG = CAttr.DEBUG;
    private JTable m_rTable;
    private JViewport m_rViewport;
    private boolean m_bHasFocusClrs;
    private CRhinoBorderSolid m_CellBorder;
    private boolean m_bUseManualHasFocusClr = false;

    public CRhinoTableCellRenderer(JTable rTable, JViewport rViewport) {
        this.m_rTable = rTable;
        this.m_rViewport = rViewport;
        if (rTable != null) {
            rTable.setShowGrid(false);
            rTable.setIntercellSpacing(new Dimension(0, 0));
            rTable.setRowHeight(17);
            rTable.setAutoResizeMode(0);
        }
    }

    protected JTable GetTable() {
        return this.m_rTable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        this.UpdateHasFocusColor(bIsSelected, nCol, rTable, this);
        nCol = rTable.convertColumnIndexToModel(nCol);
        Font font = (Font)UIManager.get("List.font");
        if (font == null) {
            font = rTable.getFont();
        }
        rTable.setFont(font);
        Border rCellBorder = this.GetCellBorder(rTable, bIsSelected, nRow, nCol);
        this.setBorder(rCellBorder);
        int nAlignHorz = 2;
        this.setHorizontalAlignment(nAlignHorz);
        return this;
    }

    protected Border GetCellBorder(JTable jTable, boolean bIsSelected, int nRow, int nCol) {
        Border jCellBorder = null;
        int nLeadRow = -1;
        ListSelectionModel jSelModel = jTable.getSelectionModel();
        if (jSelModel != null) {
            nLeadRow = jSelModel.getLeadSelectionIndex();
        }
        int nTop = 1;
        int nBtm = 1;
        int nLeft = 0;
        int nRight = 0;
        int nViewCol = jTable.convertColumnIndexToView(nCol);
        if (nViewCol == 0) {
            nLeft = 1;
        } else if (nViewCol == jTable.getColumnCount() - 1) {
            nRight = 1;
        }
        if (nRow == nLeadRow) {
            if (this.m_CellBorder == null) {
                this.m_CellBorder = new CRhinoBorderSolid(nTop, nLeft, nBtm, nRight, Color.DARK_GRAY);
            } else {
                this.m_CellBorder.SetTop(nTop);
                this.m_CellBorder.SetLeft(nLeft);
                this.m_CellBorder.SetBottom(nBtm);
                this.m_CellBorder.SetRight(nRight);
            }
            jCellBorder = this.m_CellBorder;
        } else {
            jCellBorder = BorderFactory.createEmptyBorder(nTop, nLeft, nBtm, nRight);
        }
        jCellBorder = BorderFactory.createCompoundBorder(jCellBorder, BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jCellBorder;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, int nCol, JTable rTable, Component ... arComps) {
        Color clrTableFore = UIManager.getColor("Table.foreground");
        Color clrTableBack = UIManager.getColor("Table.background");
        Color clrTableForeSel = UIManager.getColor("Table.selectionForeground");
        Color clrTableBackSel = UIManager.getColor("Table.selectionBackground");
        Color clrFore = clrTableFore;
        Color clrBack = clrTableBack;
        if (bIsSelected) {
            CRhinoTable rRhinoTable;
            clrFore = clrTableForeSel;
            clrBack = clrTableBackSel;
            if (rTable instanceof CRhinoTable && !(rRhinoTable = (CRhinoTable)rTable).GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorAttr.IsADarkColor(clrFore) && !CColorAttr.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() < clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                } else if (CColorAttr.IsADarkColor(clrFore) && CColorAttr.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() > clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                }
            }
        } else if (this.GetViewport() instanceof CRhinoViewportTable) {
            CRhinoViewportTable rViewport = (CRhinoViewportTable)this.GetViewport();
            int nSortCol = rTable.convertColumnIndexToModel(nCol);
            if (rViewport.GetModelCol() == nSortCol) {
                clrBack = rViewport.GetSortColor();
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackground(clrBack);
    }

    private JViewport GetViewport() {
        return this.m_rViewport;
    }
}

