/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.controls.grids.CRhinoModel;
import com.rhinosoft.ui.controls.grids.CRhinoTableCellRenderer;
import com.rhinosoft.ui.controls.grids.CRhinoTableHeaderRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CRhinoTable
extends JTable
implements IRhinoOnMessage {
    public static boolean DEBUG = CAttr.DEBUG;
    public static final int SORT_CLR_OFFSET = 10;
    public static final int AXIS_BOTH = 0;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    private CRhinoModel m_Model;
    private CRhinoTableHeaderRenderer m_HeaderRenderer;
    private CRhinoTableCellRenderer m_CellRenderer;
    private boolean m_bHasFocusClrs;
    private boolean m_bUseManualHasFocusClr;

    public CRhinoTable() {
        this._CRhinoTable();
    }

    public CRhinoTable(String[][] asRows, String[] asCols) {
        super(asRows, asCols);
        this._CRhinoTable();
    }

    public CRhinoTable(CRhinoModel rModel) {
        super(rModel);
        this._CRhinoTable();
    }

    public void _CRhinoTable() {
        this.m_bHasFocusClrs = true;
        this.m_bUseManualHasFocusClr = true;
        this.InitModel();
        this.InitHeaderRenderer();
        this.InitCellRenderer();
    }

    @Override
    public CRhinoModel getModel() {
        return this.m_Model;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        CRhinoEvent rEvent;
        if (event instanceof CRhinoEvent && (rEvent = (CRhinoEvent)event).getSource() instanceof CAttrMsg) {
            CAttrMsg rMsg = (CAttrMsg)rEvent.getSource();
            this.OnMessage(rMsg);
        }
        super.processEvent(event);
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4020: {
                    this.OnCreate();
                    break;
                }
            }
        }
        if (this.getModel() instanceof IRhinoOnMessage) {
            this.getModel().OnMessage(rMsg);
        }
    }

    protected void OnCreate() {
        if (DEBUG) {
            CDebugLog.ENTERING(CRhinoTable.class.getName(), "OnCreate");
        }
        if (DEBUG) {
            CDebugLog.EXITING(CRhinoTable.class.getName(), "OnCreate");
        }
    }

    public int[] GetColXLocs(int nModelCol) {
        return CRhinoTable.GetColXLocs(this, nModelCol);
    }

    public static int[] GetColXLocs(JTable jTable, int nModelCol) {
        JTableHeader jHeader;
        int[] nXLocs = new int[]{0, 0};
        if (nModelCol >= 0 && nModelCol < jTable.getColumnCount() && (jHeader = jTable.getTableHeader()) != null) {
            TableCellRenderer jHeaderRenderer = jHeader.getDefaultRenderer();
            nXLocs = CRhinoTable.GetColXLocs(jTable, jHeaderRenderer, jTable.convertColumnIndexToView(nModelCol));
        }
        return nXLocs;
    }

    private static int[] GetColXLocs(JTable jTable, TableCellRenderer jHeaderRenderer, int nViewCol) {
        int[] nXLocs = new int[]{0, 0};
        if (jTable != null) {
            TableColumnModel jColModel;
            TableModel jModel = jTable.getModel();
            JTableHeader jHeader = jTable.getTableHeader();
            if (jHeader != null && (jColModel = jHeader.getColumnModel()) != null) {
                int nTableColCount = jTable.getColumnCount();
                int[] naColWidths = new int[nTableColCount];
                for (int nColIdx = 0; nColIdx < nTableColCount; ++nColIdx) {
                    TableColumn jNextCol = jColModel.getColumn(nColIdx);
                    if (jNextCol == null) continue;
                    naColWidths[nColIdx] = jNextCol.getWidth();
                }
                for (int nIdx = 0; nIdx < nViewCol; ++nIdx) {
                    nXLocs[0] = nXLocs[0] + naColWidths[nIdx];
                }
                nXLocs[1] = nXLocs[0] + naColWidths[nViewCol];
                naColWidths = null;
            }
        }
        return nXLocs;
    }

    public static Color GetSortColor(Color rBackClr, int nOffset) {
        Color clrRet = Color.DARK_GRAY;
        boolean bMakeBrighter = CColorAttr.IsADarkColor(rBackClr);
        if (rBackClr != null) {
            int nBlue;
            int nRed = bMakeBrighter ? rBackClr.getRed() + nOffset : rBackClr.getRed() - nOffset;
            int nGreen = bMakeBrighter ? rBackClr.getGreen() + nOffset : rBackClr.getGreen() - nOffset;
            int n = nBlue = bMakeBrighter ? rBackClr.getBlue() + nOffset : rBackClr.getBlue() - nOffset;
            if (nRed < 0 || nRed > 255) {
                nRed = rBackClr.getRed();
            }
            if (nGreen < 0 || nGreen > 255) {
                nGreen = rBackClr.getGreen();
            }
            if (nBlue < 0 || nBlue > 255) {
                nBlue = rBackClr.getBlue();
            }
            if (nRed < 11 && nGreen < 11 && nBlue < 11) {
                nRed = 30;
                nGreen = 30;
                nBlue = 30;
            }
            clrRet = new Color(nRed, nGreen, nBlue);
        }
        return clrRet;
    }

    public static boolean IsPointInRect(Point pt, Rectangle rect, int nTestAxis) {
        boolean bRet = false;
        boolean bInX = false;
        boolean bInY = false;
        if (pt.x >= rect.x && pt.x <= rect.x + rect.width) {
            bInX = true;
        }
        if (pt.y >= rect.y && pt.y <= rect.y + rect.height) {
            bInY = true;
        }
        bRet = nTestAxis == 1 ? bInX : (nTestAxis == 2 ? bInY : bInX && bInY);
        return bRet;
    }

    public static int GetModelColFromPoint(JTable jTable, Point pt) {
        int nModelCol = -1;
        JTableHeader jHeader = jTable.getTableHeader();
        for (int nCol = 0; nCol < jTable.getColumnCount(); ++nCol) {
            int nViewCol = jTable.convertColumnIndexToView(nCol);
            Rectangle rCell = jHeader.getHeaderRect(nViewCol);
            if (!CRhinoTable.IsPointInRect(pt, rCell, 1)) continue;
            nModelCol = nCol;
            break;
        }
        return nModelCol;
    }

    public static int GetViewColToExpand(JTable rTable, Point pt) {
        int nRetViewCol = -1;
        JTableHeader rTableHeader = rTable.getTableHeader();
        int nCursorType = rTableHeader.getCursor().getType();
        if (nCursorType == 11 || nCursorType == 10) {
            int nModelCol = CRhinoTable.GetModelColFromPoint(rTable, pt);
            int nViewCol = rTable.convertColumnIndexToView(nModelCol);
            Rectangle rCell = rTableHeader.getHeaderRect(nViewCol);
            int nMidPt = rCell.x + rCell.width / 2;
            if (pt.x >= nMidPt) {
                nRetViewCol = nViewCol;
            } else if (nViewCol - 1 > -1) {
                nRetViewCol = nViewCol - 1;
            }
        }
        return nRetViewCol;
    }

    protected CRhinoModel CreateModel() {
        return null;
    }

    protected void InitModel() {
        this.m_Model = this.CreateModel();
        if (this.m_Model != null) {
            this.setModel(this.m_Model);
        }
    }

    protected CRhinoTableHeaderRenderer CreateHeaderRenderer() {
        return new CRhinoTableHeaderRenderer(this.getModel());
    }

    protected void InitHeaderRenderer() {
        JTableHeader rHeader;
        this.m_HeaderRenderer = this.CreateHeaderRenderer();
        if (this.m_HeaderRenderer != null && (rHeader = this.getTableHeader()) != null) {
            this.m_HeaderRenderer.UpdateUIRenderer();
            rHeader.setDefaultRenderer(this.m_HeaderRenderer);
        }
    }

    protected CRhinoTableCellRenderer CreateCellRenderer() {
        return new CRhinoTableCellRenderer(this, this.GetViewport());
    }

    protected void InitCellRenderer() {
        this.m_CellRenderer = this.CreateCellRenderer();
        if (this.m_CellRenderer != null) {
            TableColumnModel rColModel = this.getColumnModel();
            if (rColModel != null && this.getModel() != null) {
                if (rColModel.getColumnCount() != this.getModel().getColumnCount()) {
                    JOptionPane.showConfirmDialog(null, "These have to match in order for us to set the appropriate column identifiers");
                }
                for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                    TableColumn rColumn = rColModel.getColumn(nIdx);
                    if (rColumn == null) continue;
                    rColumn.setCellRenderer(this.m_CellRenderer);
                    rColumn.setIdentifier(nIdx);
                }
                rColModel.addColumnModelListener(this);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoTable.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
            }
        }
    }

    protected JViewport GetViewport() {
        JViewport rViewport = null;
        Container rParent = this.getParent();
        while (rParent != null && rViewport == null) {
            if (rParent instanceof JViewport) {
                rViewport = (JViewport)rParent;
            }
            rParent.getParent();
        }
        return rViewport;
    }

    public boolean GetHasFocusClrs() {
        boolean bHasFocusClrs = this.m_bHasFocusClrs;
        if (!this.UseManualHasFocusClrFlag()) {
            Container rParent;
            bHasFocusClrs = false;
            for (rParent = this.getParent(); rParent != null && !bHasFocusClrs; rParent = rParent.getParent()) {
            }
            if (!bHasFocusClrs) {
                for (rParent = this.getParent(); rParent != null && !bHasFocusClrs; rParent = rParent.getParent()) {
                }
            }
            if (DEBUG) {
                CDebugLog.INFO(String.format("IsActiveFrame: %s", Boolean.toString(bHasFocusClrs)));
            }
        }
        return bHasFocusClrs;
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean UseManualHasFocusClrFlag() {
        return this.m_bUseManualHasFocusClr;
    }

    protected boolean IsAParent(Component rComp) {
        boolean bIsParent = false;
        if (rComp != null) {
            for (Container rParent = this.getParent(); rParent != null && !bIsParent; rParent = rParent.getParent()) {
                bIsParent = rParent == rComp;
            }
        }
        return bIsParent;
    }
}

