/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.controls.grids.CRhinoViewport;
import java.awt.AWTEvent;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public abstract class CRhinoScrollPane
extends JScrollPane
implements IRhinoOnMessage {
    public static boolean DEBUG = CAttr.DEBUG;
    private CRhinoViewport m_Viewport;

    public CRhinoScrollPane() {
        this._CRhinoScrollPane();
    }

    public CRhinoScrollPane(JComponent rComponent) {
        super(rComponent);
        this._CRhinoScrollPane();
    }

    private void _CRhinoScrollPane() {
    }

    protected abstract CRhinoViewport CreateViewport();

    protected CRhinoViewport GetViewport() {
        return this.m_Viewport;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        CRhinoEvent rEvent;
        if (event instanceof CRhinoEvent && (rEvent = (CRhinoEvent)event).getSource() instanceof CAttrMsg) {
            CAttrMsg rMsg = (CAttrMsg)rEvent.getSource();
            this.OnMessage(rMsg);
        }
        super.processEvent(event);
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4020: {
                    this.OnCreate();
                    break;
                }
                case 4022: {
                    this.OnInitialUpdate();
                    break;
                }
                case 3490: {
                    if (CRhinoApp.GET_RHINO_APP() == null) break;
                    CRhinoApp.GET_RHINO_APP().SetCursor(rMsg, this);
                    break;
                }
            }
        }
        for (int nIdx = 0; nIdx < this.getComponentCount(); ++nIdx) {
            Component rNextComp = this.getComponent(nIdx);
            if (rNextComp == null) continue;
            rNextComp.dispatchEvent(new CRhinoEvent(rMsg));
        }
    }

    protected void OnCreate() {
        this.InitViewport();
    }

    protected void InitViewport() {
        this.m_Viewport = this.CreateViewport();
        this.setViewport(this.GetViewport());
    }

    protected void OnInitialUpdate() {
    }
}

