/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls.grids;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.ui.controls.grids.CRhinoModelItem;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class CRhinoModel
implements ListModel,
TableModel,
IRhinoOnMessage,
Comparator<CRhinoModelItem> {
    protected static boolean DEBUG = CAttr.DEBUG;
    protected static boolean DEBUG_TRACE_METHODS;
    public static final int COL_1 = 0;
    public static final int COL_2 = 1;
    public static final int SORT_OFF = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    private HashMap<CAttr, CRhinoModelItem> m_aItemMap;
    private Vector<CRhinoModelItem> m_aItems;
    protected EventListenerList m_aListenerList;
    protected String[] m_asColHeaders;
    private int m_nSortModelCol;
    private int m_nSortDirection;

    public CRhinoModel() {
        this._CRhinoModel();
    }

    private void _CRhinoModel() {
        this.m_aItemMap = new HashMap();
        this.m_aItems = new Vector();
        this.m_aListenerList = new EventListenerList();
        this.InitTableHeaders();
        this.m_nSortModelCol = -1;
        this.m_nSortDirection = 0;
    }

    protected void InitTableHeaders() {
        if (DEBUG) {
            CDebugLog.ASSERT(CRhinoModel.class.getName(), CDebugLog.GetLineNumber(), "Programming error, you should derive and override!");
        }
        this.m_asColHeaders = new String[2];
        this.m_asColHeaders[0] = "<insert your column 1";
        this.m_asColHeaders[1] = "<insert your column 2";
    }

    @Override
    public int getSize() {
        return this.m_aItems.size();
    }

    public CRhinoModelItem getElementAt(int nIndex) {
        return this.m_aItems.get(nIndex);
    }

    @Override
    public void addListDataListener(ListDataListener rListener) {
        this.m_aListenerList.add(ListDataListener.class, rListener);
    }

    @Override
    public void removeListDataListener(ListDataListener rListener) {
        this.m_aListenerList.remove(ListDataListener.class, rListener);
    }

    @Override
    public int getRowCount() {
        return this.getSize();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int nColumnIndex) {
        return this.m_asColHeaders[nColumnIndex];
    }

    @Override
    public Class<?> getColumnClass(int nColumnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    @Override
    public CRhinoModelItem getValueAt(int nRowIndex, int nColumnIndex) {
        return this.getElementAt(nRowIndex);
    }

    @Override
    public void setValueAt(Object rValue, int nRowIndex, int nColumnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener rListener) {
        this.m_aListenerList.add(TableModelListener.class, rListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener rListener) {
        this.m_aListenerList.remove(TableModelListener.class, rListener);
    }

    private CRhinoModelItem WrapAttr(CAttr rAttr) {
        return new CRhinoModelItem(rAttr);
    }

    private void AddItem(CRhinoModelItem rItem) {
        this.InsertItem(rItem, -1);
    }

    private void InsertItem(CRhinoModelItem rItem, int nIndex) {
        if (this.IsValidIndex(nIndex)) {
            this.m_aItems.insertElementAt(rItem, nIndex);
        } else {
            this.m_aItems.add(rItem);
            nIndex = this.m_aItems.size() - 1;
        }
        this.m_aItemMap.put(rItem.GetAttr(), rItem);
        this.fireTableRowsInserted(nIndex, nIndex, true);
    }

    private boolean RemoveItem(CRhinoModelItem rItem) {
        int nIndex;
        boolean bRemoved = false;
        if (rItem != null && this.IsValidIndex(nIndex = this.m_aItems.indexOf(rItem))) {
            bRemoved = this.m_aItems.remove(rItem);
            this.m_aItemMap.remove(rItem.GetAttr());
            this.fireTableRowsDeleted(nIndex, nIndex);
        }
        return bRemoved;
    }

    public void AddItem(CAttr rAttr) {
        this.AddItem(this.WrapAttr(rAttr));
    }

    public boolean InsertItemAfter(CAttr rInsertAttr, CAttr rInsertAfterAttr) {
        boolean bInserted = false;
        CRhinoModelItem rInsertAfterItem = this.FindItem(rInsertAfterAttr);
        if (rInsertAttr != null && rInsertAfterItem != null) {
            int nIndex = this.FindIndex(rInsertAfterItem);
            this.InsertItem(this.WrapAttr(rInsertAttr), ++nIndex);
            bInserted = true;
        }
        return bInserted;
    }

    public CRhinoModelItem FindItem(CAttr rAttr) {
        return this.m_aItemMap.get(rAttr);
    }

    public int FindIndex(CRhinoModelItem rItem) {
        return this.m_aItems.indexOf(rItem);
    }

    public boolean IsValidIndex(int nIndex) {
        return nIndex >= 0 && nIndex < this.getRowCount();
    }

    public void RemoveItem(CAttr rAttr) {
        CRhinoModelItem rRemoveItem = this.FindItem(rAttr);
        if (rRemoveItem != null && this.RemoveItem(rRemoveItem)) {
            rRemoveItem = null;
        }
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4004: {
                    this.OnLoadAttrs();
                    break;
                }
                case 4005: {
                    this.OnSaveAttrs();
                    break;
                }
            }
        }
        for (CRhinoModelItem rItem : this.m_aItems) {
            CAttr rAttr;
            if (rItem == null || (rAttr = rItem.GetAttr()) == null) continue;
            rAttr.OnMessage(rMsg);
        }
    }

    public void fireTableDataChanged() {
        this.fireTableDataChanged(true);
    }

    protected void fireTableDataChanged(boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this));
        if (bFireListEvent) {
            this.fireContentsChanged(this, 0, this.getSize(), false);
        }
    }

    public void fireTableStructureChanged() {
        this.fireTableStructureChanged(true);
    }

    private void fireTableStructureChanged(boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, -1));
        if (bFireListEvent) {
            this.fireContentsChanged(this, 0, this.getSize(), false);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableRowsInserted(firstRow, lastRow, true);
    }

    private void fireTableRowsInserted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
        if (bFireListEvent) {
            this.fireIntervalAdded(this, firstRow, lastRow, false);
        }
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableRowsUpdated(firstRow, lastRow, true);
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
        if (bFireListEvent) {
            this.fireContentsChanged(this, firstRow, lastRow, false);
        }
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableRowsDeleted(firstRow, lastRow, true);
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
        if (bFireListEvent) {
            this.fireIntervalRemoved(this, firstRow, lastRow, false);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableCellUpdated(row, column, true);
    }

    private void fireTableCellUpdated(int row, int column, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
        if (bFireListEvent) {
            this.fireContentsChanged(this, row, row, false);
        }
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.m_aListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.fireContentsChanged(source, index0, index1, true);
    }

    protected void fireContentsChanged(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 0, index0, index1));
        if (bFireTableEvent) {
            this.fireTableStructureChanged(false);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.fireIntervalAdded(source, index0, index1, true);
    }

    private void fireIntervalAdded(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 1, index0, index1));
        if (bFireTableEvent) {
            this.fireTableRowsInserted(index0, index1, false);
        }
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.fireIntervalRemoved(source, index0, index1, true);
    }

    private void fireIntervalRemoved(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 2, index0, index1));
        if (bFireTableEvent) {
            this.fireTableRowsDeleted(index0, index1, false);
        }
    }

    private void fireListEvent(ListDataEvent jEvent) {
        Object[] listeners = this.m_aListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (jEvent.getType() == 0) {
                ((ListDataListener)listeners[i + 1]).contentsChanged(jEvent);
                continue;
            }
            if (jEvent.getType() == 1) {
                ((ListDataListener)listeners[i + 1]).intervalAdded(jEvent);
                continue;
            }
            if (jEvent.getType() != 2) continue;
            ((ListDataListener)listeners[i + 1]).intervalRemoved(jEvent);
        }
    }

    public final int GetSortModelCol() {
        return this.m_nSortModelCol;
    }

    public boolean SetSortModelCol(int nSortModelCol) {
        boolean bDirty = false;
        if (this.m_nSortModelCol != nSortModelCol) {
            bDirty = true;
            this.m_nSortModelCol = nSortModelCol;
        }
        return bDirty;
    }

    public boolean IsAscending() {
        return this.m_nSortDirection == 1;
    }

    public boolean IsDescending() {
        return this.m_nSortDirection == 2;
    }

    public int GetSortDirection() {
        return this.m_nSortDirection;
    }

    public boolean SetSortDirection(int nSortDirection) {
        boolean bDirty = false;
        if (this.m_nSortDirection != nSortDirection) {
            bDirty = true;
            this.m_nSortDirection = nSortDirection;
        }
        return bDirty;
    }

    @Override
    public int compare(CRhinoModelItem rItem1, CRhinoModelItem rItem2) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFileTableSorter.compare -->");
        }
        int nRet = 0;
        if (rItem1 != null && rItem2 != null) {
            int nSortCol = this.GetSortModelCol();
        }
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFileTableSorter.compare <--");
        }
        return nRet;
    }

    protected void SendModelItemRemoved(CRhinoModelItem rModelItem) {
        if (rModelItem != null) {
            CUIMessage rUIMsg = new CUIMessage(4070, this);
            rModelItem.OnMessage(rUIMsg);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoModel.class.getName(), CDebugLog.GetLineNumber(), "Programming Error:  invalid object");
        }
    }

    protected void OnLoadAppProps() {
    }

    protected void OnSaveAttrs() {
    }

    protected void OnLoadAttrs() {
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
    }
}

