/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.ui.controls.ITypeAhead;
import com.rhinosoft.ui.controls.trees.CFileTreeModel;
import com.rhinosoft.ui.controls.trees.CFileTreeNode;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class CTypeAhead {
    protected static boolean DEBUG = CAttr.DEBUG;
    protected static boolean DEBUG_CHANGE_TYPE_AHEAD;
    private long m_nDateLastSearch;
    private String m_sSearchStr;

    public CTypeAhead() {
        this._CTypeAhead();
    }

    private void _CTypeAhead() {
        this.m_nDateLastSearch = 0L;
        this.m_sSearchStr = "";
    }

    public boolean CanTypeAhead(KeyEvent rEvent) {
        boolean bCanTypeAhead = false;
        if (rEvent != null && !rEvent.isAltDown()) {
            bCanTypeAhead = true;
            int[] anExcludeInSearch = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 155, 127, 36, 35, 33, 34, 37, 39, 38, 40, 10, 8, 20, 9, 27, 154, 145, 19, 144, Integer.MIN_VALUE};
            for (int nIdx = 0; nIdx < anExcludeInSearch.length; ++nIdx) {
                int nExcludedKeyCode = anExcludeInSearch[nIdx];
                if (nExcludedKeyCode != rEvent.getKeyCode() && nExcludedKeyCode != Integer.MIN_VALUE) continue;
                if (nExcludedKeyCode != rEvent.getKeyCode()) break;
                bCanTypeAhead = false;
                break;
            }
        }
        return bCanTypeAhead;
    }

    public void OnTypeAhead(char chKeyChar, int nSortCol, JTable rTable, TableModel rModel, ListSelectionModel rSelModel) {
        String sSearchChar = Character.toString(chKeyChar);
        this.OnTypeAheadEx(sSearchChar, nSortCol, rTable, null, rModel, rSelModel);
    }

    public void OnTypeAhead(char chKeyChar, int nSortCol, JList rList, ListModel rModel, ListSelectionModel rSelModel) {
        String sSearchChar = Character.toString(chKeyChar);
        this.OnTypeAheadEx(sSearchChar, nSortCol, rList, rModel, null, rSelModel);
    }

    private void OnTypeAhead(String sSearchChar, JTree rTree, CFileTreeModel rModel, TreeSelectionModel rSelModel, ITypeAhead rTypeAheadComp) {
        if (sSearchChar != null && !sSearchChar.isEmpty() && sSearchChar.length() == 1 && rTree != null && rModel != null && rSelModel != null && rTypeAheadComp != null) {
            sSearchChar = sSearchChar.toLowerCase();
            StringBuilder sbTemp = new StringBuilder();
            sbTemp.append(sSearchChar);
            String sKey = sbTemp.toString();
            long nDateNow = System.currentTimeMillis();
            if (sKey != null && !sKey.isEmpty()) {
                int nStartIdx = rTree.getLeadSelectionRow();
                if (nDateNow - this.m_nDateLastSearch > 750L) {
                    this.m_sSearchStr = sKey;
                    if (nStartIdx >= 0) {
                        ++nStartIdx;
                    }
                } else {
                    this.m_sSearchStr = this.m_sSearchStr + sKey;
                }
                this.m_nDateLastSearch = nDateNow;
                if (this.m_sSearchStr != null) {
                    TreePath rNextMatch;
                    rTypeAheadComp.SetIsTypeAhead(true);
                    if (nStartIdx >= rTree.getRowCount()) {
                        nStartIdx = 0;
                    }
                    if ((rNextMatch = rTree.getNextMatch(this.m_sSearchStr, nStartIdx, Position.Bias.Forward)) == null) {
                        rNextMatch = rTree.getNextMatch(this.m_sSearchStr, 0, Position.Bias.Forward);
                    }
                    rTypeAheadComp.SetIsTypeAhead(false);
                    if (rNextMatch != null) {
                        if (DEBUG_CHANGE_TYPE_AHEAD) {
                            System.out.printf("Looking for: %s | ", this.m_sSearchStr);
                            Object objLast = rNextMatch.getLastPathComponent();
                            if (objLast instanceof CFileTreeNode) {
                                CFileTreeNode rNode = (CFileTreeNode)objLast;
                                System.out.printf("Next match: %s\r\n", rNode.GetSourcePath());
                            } else {
                                System.out.printf("Next match: %s\r\n", rNextMatch.toString());
                            }
                        }
                        rTypeAheadComp.StartChangeTimer(rTypeAheadComp.GetTypeAheadChangeTimerDuration());
                        this.EnsureVisible(rTree, rNextMatch);
                        rTree.setSelectionPath(rNextMatch);
                    }
                }
            } else {
                this.m_sSearchStr = "";
                this.m_nDateLastSearch = 0L;
            }
        }
    }

    private void OnTypeAheadEx(String sSearchChar, int nSortCol, Component rComp, ListModel rListModel, TableModel rTableModel, ListSelectionModel rSelModel) {
        if (sSearchChar != null && !sSearchChar.isEmpty() && sSearchChar.length() == 1 && rComp != null && rSelModel != null) {
            sSearchChar = sSearchChar.toLowerCase();
            StringBuilder sbTemp = new StringBuilder();
            sbTemp.append(sSearchChar);
            String sKey = sbTemp.toString();
            long nDateNow = System.currentTimeMillis();
            if (sKey != null && !sKey.isEmpty() && nSortCol >= 0) {
                int nStartIdx = rSelModel.getLeadSelectionIndex();
                boolean bFound = false;
                String sTemp = "";
                if (nDateNow - this.m_nDateLastSearch > 750L) {
                    this.m_sSearchStr = sKey;
                    if (nStartIdx >= 0) {
                        ++nStartIdx;
                    }
                } else {
                    this.m_sSearchStr = this.m_sSearchStr + sKey;
                }
                this.m_nDateLastSearch = nDateNow;
                int nStopIdx = 0;
                if (rListModel != null) {
                    nStopIdx = rListModel.getSize();
                } else if (rTableModel != null) {
                    nStopIdx = rTableModel.getRowCount();
                }
                if (!this.ItemSearch(this.m_sSearchStr, nSortCol, nStartIdx, nStopIdx, rComp, rListModel, rTableModel, rSelModel) && nStartIdx > 0) {
                    this.ItemSearch(this.m_sSearchStr, nSortCol, 0, nStartIdx, rComp, rListModel, rTableModel, rSelModel);
                }
            } else {
                this.m_sSearchStr = "";
                this.m_nDateLastSearch = 0L;
            }
        }
    }

    protected String GetItemSearchText(ListModel rListModel, TableModel rTableModel, int nRow, int nCol) {
        String sText = null;
        Object rItem = null;
        if (rListModel != null && nRow >= 0 && nRow < rListModel.getSize()) {
            rItem = rListModel.getElementAt(nRow);
        } else if (rTableModel != null && nRow >= 0 && nRow < rTableModel.getRowCount()) {
            rItem = rTableModel.getValueAt(nRow, nCol);
        }
        if (rItem != null) {
            sText = rItem.toString();
        }
        return sText;
    }

    private boolean ItemSearch(String sSearchStr, int nSortCol, int nStartIdx, int nStopIdx, Component rComp, ListModel rListModel, TableModel rTableModel, ListSelectionModel rSelModel) {
        boolean bFound = false;
        if (rComp != null && rSelModel != null) {
            for (int nIdx = nStartIdx; nIdx < nStopIdx; ++nIdx) {
                String sTemp = this.GetItemSearchText(rListModel, rTableModel, nIdx, nSortCol);
                if (sTemp == null || sTemp.isEmpty()) continue;
                if (sTemp.length() > sSearchStr.length()) {
                    sTemp = sTemp.substring(0, sSearchStr.length());
                }
                if (sTemp.isEmpty()) continue;
                sTemp = sTemp.toLowerCase();
                if (DEBUG_CHANGE_TYPE_AHEAD) {
                    System.out.printf("Looking for: %s | ", sSearchStr);
                    System.out.printf("Next match: %s\r\n", sTemp);
                }
                if (!sTemp.equals(sSearchStr)) continue;
                rSelModel.setSelectionInterval(nIdx, nIdx);
                this.EnsureVisible(rComp, nIdx, nSortCol);
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    protected void EnsureVisible(Component rComp, int nRow, int nCol) {
        if (rComp != null) {
            if (rComp instanceof JTable) {
                this.EnsureVisible((JTable)rComp, nRow, nCol);
            } else if (rComp instanceof JList) {
                this.EnsureVisible((JList)rComp, nRow, nCol);
            } else if (rComp instanceof JTree) {
                this.EnsureVisible((JTree)rComp, nRow, nCol);
            }
        }
    }

    private void EnsureVisible(JTable rTable, int nRow, int nCol) {
        if (rTable != null) {
            Rectangle rRect = rTable.getCellRect(nRow, nCol, true);
            rTable.scrollRectToVisible(rRect);
        }
    }

    private void EnsureVisible(JList rList, int nRow, int nCol) {
        Rectangle rRect;
        if (rList != null && (rRect = rList.getCellBounds(nRow, nRow)) != null) {
            rList.scrollRectToVisible(rRect);
        }
    }

    protected void EnsureVisible(JTree rTree, TreePath rTreePath) {
        if (rTree != null && rTreePath != null) {
            rTree.scrollPathToVisible(rTreePath);
            rTree.requestFocusInWindow();
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_CHANGE_TYPE_AHEAD = false;
    }
}

