/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls;

import com.rhinosoft.attrs.CColorAttr;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class CTwoToneLabel
extends JLabel {
    private Color m_clrUpper;
    private Color m_clrLower;

    public CTwoToneLabel() {
        this.InitVars();
        this.OnCreate();
    }

    private void InitVars() {
        this.m_clrUpper = Color.DARK_GRAY;
        this.m_clrLower = Color.LIGHT_GRAY;
    }

    protected void OnCreate() {
        this.setAlignmentY(0.5f);
        Color clrBack = this.getBackground();
        int nRedUpper = clrBack.getRed() + 48;
        int nGreenUpper = clrBack.getGreen() + 56;
        int nBlueUpper = clrBack.getBlue() + 56;
        int nRedLower = clrBack.getRed() - 48;
        int nGreenLower = clrBack.getGreen() - 56;
        int nBlueLower = clrBack.getBlue() - 56;
        if (!CColorAttr.IsADarkColor(clrBack)) {
            nRedUpper = clrBack.getRed() - 48;
            nGreenUpper = clrBack.getGreen() - 56;
            nBlueUpper = clrBack.getBlue() - 56;
            nRedLower = clrBack.getRed() + 48;
            nGreenLower = clrBack.getGreen() + 56;
            nBlueLower = clrBack.getBlue() + 56;
        }
        nRedUpper = this.MakeValid(nRedUpper);
        nGreenUpper = this.MakeValid(nGreenUpper);
        nBlueUpper = this.MakeValid(nBlueUpper);
        nRedLower = this.MakeValid(nRedLower);
        nGreenLower = this.MakeValid(nGreenLower);
        nBlueLower = this.MakeValid(nBlueLower);
        this.m_clrUpper = new Color(nRedUpper, nGreenUpper, nBlueUpper);
        this.m_clrLower = new Color(nRedLower, nGreenLower, nBlueLower);
    }

    private int MakeValid(int nClr) {
        if (nClr < 0 || nClr > 255) {
            nClr = nClr < 128 ? 0 : 255;
        }
        return nClr;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g != null && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = new Font("Arial Bold", 2, 18);
            g2.setFont(font);
            String sText = this.getText();
            FontMetrics metrics = g2.getFontMetrics(font);
            int nBaseLineX = 3;
            int nBaseLineY = this.getHeight() - metrics.getMaxDescent();
            g2.setPaint(this.m_clrLower);
            g2.drawString(sText, nBaseLineX, nBaseLineY);
            g2.setPaint(this.m_clrUpper);
            g2.drawString(sText, --nBaseLineX, --nBaseLineY);
        }
    }

    public int GetNormalHeight() {
        return 22;
    }
}

