/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.controls.CTreeCtrlModel;
import com.rhinosoft.ui.controls.CTreeCtrlRenderer;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class CTreeCtrl
extends JTree
implements TreeSelectionListener {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_EXPAND_NODE;
    public static boolean DEBUG_SELECTION_PATH;
    public static final String DEFAULT_ROOT_LABEL = "DEFAULT_ROOT";
    public static final String DATA_KEY_STARTUP_TREE_PATH = "StartupTreePath";
    private CTreeCtrlModel m_jModel;
    private CTreeCtrlRenderer m_jRenderer;
    private String m_sStartupPath;

    public CTreeCtrl(boolean bShowRoot) {
        this(bShowRoot, DEFAULT_ROOT_LABEL);
    }

    public CTreeCtrl(boolean bShowRoot, String sRootLabel) {
        this.InitModel(sRootLabel);
        this.InitRenderer();
        this.setRootVisible(bShowRoot);
        this.setShowsRootHandles(true);
    }

    private void InitModel(String sRootLabel) {
        this.m_jModel = new CTreeCtrlModel(new DefaultMutableTreeNode(sRootLabel));
        this.setModel(this.m_jModel);
    }

    private void InitRenderer() {
        this.m_jRenderer = new CTreeCtrlRenderer();
        this.setCellRenderer(this.m_jRenderer);
    }

    public String GetCurSelTreePath() {
        TreePath jTreePath = this.getSelectionPath();
        return this.FormatTreePath(jTreePath);
    }

    public String FormatTreePath(TreePath jTreePath) {
        CTreeCtrlModel jModel;
        String sTreePath = null;
        if (jTreePath != null) {
            sTreePath = jTreePath.toString();
        }
        if ((jModel = this.GetModel()) != null) {
            sTreePath = jModel.FormatTreePath(sTreePath);
        }
        return sTreePath;
    }

    public boolean AddNode(String sTreePath, Icon rNodeIcon) {
        boolean bAdded = false;
        String sCurPath = this.GetCurSelTreePath();
        TreeSelectionListener[] aListeners = this.getTreeSelectionListeners();
        for (int nIdx = aListeners.length - 1; nIdx >= 0; --nIdx) {
            this.removeTreeSelectionListener(aListeners[nIdx]);
        }
        CTreeCtrlModel jModel = this.GetModel();
        if (jModel != null) {
            bAdded = jModel.AddNode(sTreePath, rNodeIcon);
        }
        this.SetSelectionPath(sCurPath);
        for (int nIdx = 0; nIdx < aListeners.length; ++nIdx) {
            this.addTreeSelectionListener(aListeners[nIdx]);
        }
        return bAdded;
    }

    public boolean RemoveNode(TreePath jRemoveTreePath) {
        return this.RemoveNode(jRemoveTreePath.toString());
    }

    public boolean RemoveNode(String sRemoveTreePath) {
        boolean bRemoved = false;
        CTreeCtrlModel jModel = this.GetModel();
        if (jModel != null) {
            bRemoved = jModel.RemoveNode(sRemoveTreePath);
        }
        return bRemoved;
    }

    public DefaultMutableTreeNode GetNode(String sTreePath) {
        DefaultMutableTreeNode jTreeNode = null;
        CTreeCtrlModel jModel = this.GetModel();
        if (jModel != null) {
            jTreeNode = jModel.GetNode(sTreePath);
        }
        return jTreeNode;
    }

    private TreePath GetTreePath(String sDelimitedPath) {
        TreePath jTreePath = null;
        int nRowCount = this.getRowCount();
        if (nRowCount > 0 && sDelimitedPath != null && sDelimitedPath.length() > 0) {
            int nRow = 0;
            String[] sNodes = sDelimitedPath.split(",");
            for (int nIdx = 0; nIdx < sNodes.length; ++nIdx) {
                String sNode = sNodes[nIdx];
                if (sNode == null || (jTreePath = this.getNextMatch(sNode = sNode.trim(), nRow, Position.Bias.Forward)) == null) continue;
                this.expandPath(jTreePath);
                nRow = this.getRowForPath(jTreePath);
            }
        }
        return jTreePath;
    }

    protected CTreeCtrlModel GetModel() {
        return this.m_jModel;
    }

    protected CTreeCtrlRenderer GetRenderer() {
        return this.m_jRenderer;
    }

    @Override
    public void valueChanged(TreeSelectionEvent jEvent) {
        TreePath jOldTreePath = jEvent.getOldLeadSelectionPath();
        TreePath jNewTreePath = jEvent.getNewLeadSelectionPath();
        if (jNewTreePath != null) {
            this.m_sStartupPath = this.FormatTreePath(jNewTreePath);
        }
    }

    public void SetStartupPath(String sTreePath) {
        this.m_sStartupPath = sTreePath;
    }

    public String GetStartupPath() {
        return this.m_sStartupPath;
    }

    public void ExpandNode(String sTreePath) {
        TreePath rPath = this.GetTreePath(sTreePath);
        if (rPath != null) {
            this.expandPath(rPath);
        } else if (DEBUG_EXPAND_NODE) {
            System.out.println("ASSERT:  Programming error, rPath == null");
        }
    }

    public void SetSelectionPath(String sTreePath) {
        TreePath rPath = this.GetTreePath(sTreePath);
        if (rPath != null) {
            this.setSelectionPath(rPath);
        } else if (DEBUG_SELECTION_PATH) {
            System.out.println("ASSERT:  Programming error, rPath == null");
        }
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    SwingUtilities.updateComponentTreeUI(this);
                    this.repaint();
                    this.paintImmediately(this.getBounds());
                    break;
                }
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_EXPAND_NODE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SELECTION_PATH = false;
    }
}

