/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;

public class CRhinoBorderDotDash
extends AbstractBorder {
    public static final int[] DOT = new int[]{1, 1};
    public static final int[] DASH_SHORT = new int[]{4, 4};
    public static final int[] DASH_LONG = new int[]{10, 10};
    public static final int[] DASH_LONG_SHORT = new int[]{6, 3, 3, 3};
    public static final int[] DASH_LONG_SHORT_SHORT = new int[]{6, 3, 3, 3, 3, 3};
    protected int[] m_anPattern = DOT;
    protected int m_nThickness = 1;
    protected Color m_clrFG = null;
    protected Color m_clrBG = null;
    protected boolean m_bThicken = false;
    protected boolean m_bPaintLeftEdge = true;
    protected boolean m_bPaintRightEdge = true;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Editable Tree");
        JPanel rMainPanel = new JPanel();
        rMainPanel.setLayout(new BoxLayout(rMainPanel, 1));
        rMainPanel.setBackground(Color.BLACK);
        frame.setContentPane(rMainPanel);
        rMainPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel panel = new JPanel();
        panel.setBorder(new CRhinoBorderDotDash(DOT, Color.RED));
        panel.setBackground(Color.BLACK);
        rMainPanel.add(panel);
        rMainPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel = new JPanel();
        panel.setBorder(new CRhinoBorderDotDash(DASH_SHORT, Color.BLUE));
        panel.setBackground(Color.BLACK);
        rMainPanel.add(panel);
        rMainPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel = new JPanel();
        panel.setBorder(new CRhinoBorderDotDash(DASH_LONG, Color.CYAN));
        panel.setBackground(Color.BLACK);
        rMainPanel.add(panel);
        rMainPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel = new JPanel();
        panel.setBorder(new CRhinoBorderDotDash(DASH_LONG_SHORT, Color.ORANGE));
        panel.setBackground(Color.BLACK);
        rMainPanel.add(panel);
        rMainPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel = new JPanel();
        panel.setBorder(new CRhinoBorderDotDash(DASH_LONG_SHORT_SHORT, Color.YELLOW));
        panel.setBackground(Color.BLACK);
        rMainPanel.add(panel);
        rMainPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        frame.setSize(300, 150);
        frame.setVisible(true);
    }

    public CRhinoBorderDotDash(int[] anPattern, Color clrFG) {
        this(anPattern, 1, clrFG, null);
    }

    public CRhinoBorderDotDash(int[] anPattern, int nThickness) {
        this(anPattern, nThickness, null, null);
    }

    public CRhinoBorderDotDash(int[] anPattern, int nThickness, Color clrFG) {
        this(anPattern, nThickness, clrFG, null);
    }

    public CRhinoBorderDotDash(int[] anPattern, int nThickness, Color clrFG, Color clrBG) {
        for (int i = 0; i < anPattern.length; ++i) {
            if (anPattern[i] > 0) continue;
            throw new IllegalArgumentException("Pattern cannot have values <= 0.");
        }
        this.m_anPattern = anPattern;
        if (nThickness <= 0) {
            throw new IllegalArgumentException("Thickness cannot be <= 0.");
        }
        this.m_nThickness = nThickness;
        this.m_clrFG = clrFG;
        this.m_clrBG = clrBG;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.m_nThickness, this.m_nThickness, this.m_nThickness, this.m_nThickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return new Insets(this.m_nThickness, this.m_nThickness, this.m_nThickness, this.m_nThickness);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public boolean IsThickenPattern() {
        return this.m_bThicken;
    }

    public void SetThickenPattern(boolean bThicken) {
        this.m_bThicken = bThicken;
    }

    @Override
    public void paintBorder(Component rComp, Graphics graphics, int nX, int nY, int nWidth, int nHeight) {
        int i;
        Color clrFGX = rComp.getBackground();
        if (this.m_clrFG != null) {
            clrFGX = this.m_clrFG;
        }
        Color clrBGX = rComp.getBackground();
        if (this.m_clrBG != null) {
            clrBGX = this.m_clrBG;
        }
        graphics.setColor(clrFGX);
        graphics.fillRect(nX, nX, nWidth, this.m_nThickness);
        graphics.fillRect(nX, nY + nHeight - this.m_nThickness, nWidth, this.m_nThickness);
        if (this.GetPaintLeftEdge()) {
            graphics.fillRect(nX, nY, this.m_nThickness, nHeight);
        }
        if (this.GetPaintRightEdge()) {
            graphics.fillRect(nX + nWidth - this.m_nThickness, nY, this.m_nThickness, nHeight);
        }
        graphics.setColor(clrBGX);
        int cx = 0;
        int[] anRealPattern = new int[this.m_anPattern.length];
        for (i = 0; i < this.m_anPattern.length; ++i) {
            anRealPattern[i] = this.m_bThicken ? this.m_anPattern[i] * this.m_nThickness : this.m_anPattern[i];
        }
        i = 0;
        int j = 0;
        while (i < nWidth) {
            if (j >= anRealPattern.length) {
                j = 0;
            }
            graphics.fillRect(cx += anRealPattern[j], nY, anRealPattern[j + 1], this.m_nThickness);
            graphics.fillRect(cx, nY + nHeight - this.m_nThickness, anRealPattern[j + 1], this.m_nThickness);
            cx += anRealPattern[j + 1];
            ++i;
            j += 2;
        }
        int cy = 0;
        int i2 = 0;
        int j2 = 0;
        while (i2 < nHeight) {
            if (j2 >= anRealPattern.length) {
                j2 = 0;
            }
            cy += anRealPattern[j2];
            if (this.GetPaintLeftEdge()) {
                graphics.fillRect(nX, cy, this.m_nThickness, anRealPattern[j2 + 1]);
            }
            if (this.GetPaintRightEdge()) {
                graphics.fillRect(nX + nWidth - this.m_nThickness, cy, this.m_nThickness, anRealPattern[j2 + 1]);
            }
            cy += anRealPattern[j2 + 1];
            ++i2;
            j2 += 2;
        }
    }

    public void SetPaintLeftEdge(boolean bPaintEdge) {
        this.m_bPaintLeftEdge = bPaintEdge;
    }

    public boolean GetPaintLeftEdge() {
        return this.m_bPaintLeftEdge;
    }

    public void SetPaintRightEdge(boolean bPaintEdge) {
        this.m_bPaintRightEdge = bPaintEdge;
    }

    public boolean GetPaintRightEdge() {
        return this.m_bPaintRightEdge;
    }
}

